/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.engine;

import com.intellij.database.DataBus;
import com.intellij.database.SimpleRequestBroker;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.jpa.engine.JakartaConnectionManager;
import com.intellij.jpa.engine.JakartaEngine;
import com.intellij.jpa.engine.JpaConsoleBase;
import com.intellij.jpa.ql.JpqlLanguage;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.persistence.model.PersistencePackagePointer;
import icons.J2EEIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JakartaConsole
extends JpaConsoleBase {
    public static final String CONSOLE_TOOLWINDOW_ID = "JPA Console";

    @NotNull
    public static JpaConsoleBase.Builder<JakartaConsole> newConsole(@NotNull PersistencePackagePointer unitFile) {
        if (unitFile == null) {
            JakartaConsole.$$$reportNull$$$0(0);
        }
        return new JpaConsoleBase.Builder<JakartaConsole>(unitFile){

            @Override
            public JakartaConsole build() {
                SimpleRequestBroker broker = SimpleRequestBroker.newInstance((Project)this.getProject(), (String)this.myUnitFile.getElementName());
                JakartaConsole console = new JakartaConsole(this.myUnitFile, this.myConfiguration, (DataBus.Consuming)broker, this.myQuery);
                JakartaEngine engine = new JakartaEngine((DataBus.Producing)broker, this.myUnitFile, this.myConfiguration);
                Disposer.register((Disposable)console, (Disposable)engine);
                return console;
            }
        };
    }

    private JakartaConsole(@NotNull PersistencePackagePointer unitFile, @NotNull ConsoleRunConfiguration configuration, @NotNull DataBus.Consuming messageBus, @Nullable String query) {
        if (unitFile == null) {
            JakartaConsole.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            JakartaConsole.$$$reportNull$$$0(2);
        }
        if (messageBus == null) {
            JakartaConsole.$$$reportNull$$$0(3);
        }
        super(unitFile, configuration, messageBus, "jpaql", JakartaConsole.getInitialLanguage(unitFile), query);
        this.getLanguageConsole().setPrompt("jpa-ql> ");
    }

    public static List<JakartaConsole> getActiveConsoles(Project project) {
        return JakartaConsole.getActiveSessions(project, CONSOLE_TOOLWINDOW_ID);
    }

    private static Language getInitialLanguage(PersistencePackagePointer file) {
        boolean isHibernate = JpaUtil.isHibernateProvider(file.getPersistenceFacet(), file.findElement());
        boolean isEql = JpaUtil.isEclipseLinkProvider(file.getPersistenceFacet(), file.findElement());
        return isHibernate ? JpqlLanguage.HQL : (isEql ? JpqlLanguage.EQL : JpqlLanguage.JPQL);
    }

    @Override
    @NotNull
    public String getToolWindowId() {
        return CONSOLE_TOOLWINDOW_ID;
    }

    @Override
    @NotNull
    public Icon getToolWindowIcon() {
        Icon icon = J2EEIcons.JpaConsoleToolWindow;
        if (icon == null) {
            JakartaConsole.$$$reportNull$$$0(4);
        }
        return icon;
    }

    protected String getHelpID() {
        return "tool.window.reference.jpa.console";
    }

    @Override
    public boolean isStarted() {
        return JakartaConnectionManager.getInstance(this.getProject()).getActiveConfigurations((PersistencePackagePointer)this.getTarget()).contains(this.getConfiguration());
    }

    @Override
    public void terminate() {
        JakartaConnectionManager.getInstance(this.getProject()).releaseConnection((PersistencePackagePointer)this.getTarget(), this.getConfiguration());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unitFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/engine/JakartaConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/engine/JakartaConsole";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindowIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newConsole";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

