/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.actions;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseDataKeysCore;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.highlighting.JpaHighlightingMessages;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.PersistenceDataKeys;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.util.UnitSettingMapConfigurable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ui.JBColor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssignDataSourcesAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        PersistenceFacet facet;
        if (e == null) {
            AssignDataSourcesAction.$$$reportNull$$$0(0);
        }
        boolean enabled = (facet = (PersistenceFacet)e.getData(PersistenceDataKeys.PERSISTENCE_FACET)) != null;
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        PersistenceFacet facet;
        if (e == null) {
            AssignDataSourcesAction.$$$reportNull$$$0(1);
        }
        if ((facet = (PersistenceFacet)e.getData(PersistenceDataKeys.PERSISTENCE_FACET)) == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)facet.getModule().getProject()).commitAllDocuments();
        AssignDataSourcesAction.showUnitDataSourceMappingDialog(facet);
    }

    public static void showUnitDataSourceMappingDialog(@NotNull PersistenceFacet facet) {
        if (facet == null) {
            AssignDataSourcesAction.$$$reportNull$$$0(2);
        }
        ShowSettingsUtil.getInstance().editConfigurable(facet.getModule().getProject(), (Configurable)new MyComponent(facet));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jpa/actions/AssignDataSourcesAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showUnitDataSourceMappingDialog";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyComponent
    extends UnitSettingMapConfigurable<PersistenceFacet, DasDataSource>
    implements DataProvider {
        private final DbPsiFacade myManager;
        private final DasDataSource myMissingValue = MyComponent.createFakeDs(JpaMessages.message((String)"jpa.missing.datasource", (Object[])new Object[0]));

        MyComponent(PersistenceFacet facet) {
            super(facet);
            this.myManager = DbPsiFacade.getInstance((Project)this.myFacet.getModule().getProject());
            DataManager.registerDataProvider((JComponent)this.getComponent(), (DataProvider)this);
            List dataSources = DbPsiFacade.getInstance((Project)this.myFacet.getModule().getProject()).getDataSources();
            if (dataSources.isEmpty()) {
                JLabel messageLabel = new JLabel(JpaMessages.message((String)"jpa.no.data.sources", (Object[])new Object[0]));
                messageLabel.setIcon(AllIcons.General.Warning);
                messageLabel.setBorder((Border)JBUI.Borders.emptyBottom((int)5));
                this.getComponent().add((Component)messageLabel, "North");
            }
            int headerHeight = dataSources.isEmpty() ? 75 : 50;
            this.getComponent().setPreferredSize((Dimension)new JBDimension(640, this.myView.getRowHeight() * 4 + headerHeight));
        }

        @NotNull
        private static DasDataSource createFakeDs(String name) {
            LocalDataSource ds = LocalDataSource.temporary();
            ds.setName(name);
            LocalDataSource localDataSource = ds;
            if (localDataSource == null) {
                MyComponent.$$$reportNull$$$0(0);
            }
            return localDataSource;
        }

        protected UnitSettingMapConfigurable.MyRenderer createComboBoxTableRenderer() {
            ArrayList<DasDataSource> copy = new ArrayList<DasDataSource>(DbPsiFacade.getInstance((Project)this.myFacet.getModule().getProject()).getDataSources());
            copy.sort((o1, o2) -> StringUtil.naturalCompare((String)o1.getName(), (String)o2.getName()));
            final DasDataSource nullValue = MyComponent.createFakeDs("");
            copy.add(0, nullValue);
            UnitSettingMapConfigurable.MyRenderer renderer = new UnitSettingMapConfigurable.MyRenderer(copy.toArray(new DasDataSource[0])){

                public String getTextFor(@NotNull DasDataSource value) {
                    if (value == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return value == nullValue ? JpaMessages.message((String)"default.or.no.data.source", (Object[])new Object[0]) : value.getName();
                }

                protected Icon getIconFor(@NotNull DasDataSource value) {
                    if (value == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (value == myMissingValue) {
                        return AllIcons.Ide.Statusbar_arrows;
                    }
                    return value instanceof DbDataSource ? ((DbDataSource)value).getIcon() : EmptyIcon.ICON_16;
                }

                protected void customizeComponent(DasDataSource value, JTable table, boolean isSelected) {
                    super.customizeComponent((Object)value, table, isSelected);
                    if (value == null || value.getName().isEmpty()) {
                        this.setText(JpaMessages.message((String)"jpa.click.to.select.datasource", (Object[])new Object[0]));
                        this.setIcon(AllIcons.Ide.Statusbar_arrows);
                    }
                    if (value == myMissingValue) {
                        this.setForeground((Color)JBColor.RED);
                    } else if (!isSelected && !(value instanceof DbDataSource)) {
                        this.setForeground(UIUtil.getComboBoxDisabledForeground());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "value";
                    objectArray2[1] = "com/intellij/jpa/actions/AssignDataSourcesAction$MyComponent$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getTextFor";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getIconFor";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            renderer.setFont(StartupUiUtil.getLabelFont());
            return renderer;
        }

        public void apply() throws ConfigurationException {
            super.apply();
            Project project = this.myFacet.getModule().getProject();
            DomElementAnnotationsManager.getInstance((Project)project).dropAnnotationsCache();
            DaemonCodeAnalyzer.getInstance((Project)project).restart();
        }

        @NotNull
        protected String getValueColumnName() {
            String string = DatabaseBundle.message((String)"default.datasource.name", (Object[])new Object[0]);
            if (string == null) {
                MyComponent.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        protected DasDataSource getSettingValue(PersistencePackage unit) {
            String id = this.myFacet.getDataSourceId(unit);
            DbDataSource result = this.myManager.findDataSource(id);
            return result == null && id != null ? this.myMissingValue : result;
        }

        protected void setSettingValue(PersistencePackage unit, DasDataSource value) {
            this.myFacet.setDataSourceId(unit, value instanceof DbDataSource ? value.getUniqueId() : null);
        }

        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            if (dataId == null) {
                MyComponent.$$$reportNull$$$0(2);
            }
            if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                DasDataSource value = (DasDataSource)this.getSelectedValue();
                return ObjectUtils.tryCast((Object)value, DbDataSource.class);
            }
            if (DatabaseDataKeysCore.DB_PSI_FACADE.is(dataId)) {
                return this.myManager;
            }
            return null;
        }

        @Nls
        public String getDisplayName() {
            return JpaHighlightingMessages.message("fix.edit.unit.datasource.name", new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jpa/actions/AssignDataSourcesAction$MyComponent";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createFakeDs";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValueColumnName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jpa/actions/AssignDataSourcesAction$MyComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

