/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa;

import com.intellij.javaee.model.xml.persistence.mapping.RelationAttributeBase;
import com.intellij.jpa.AbstractQlModel;
import com.intellij.jpa.ql.model.QlEntity;
import com.intellij.jpa.ql.model.ScopeQlModel;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.util.JavaTypeInfo;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.xml.DomElement;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class JpaScopeModel
extends ScopeQlModel {
    private final Object myElement;
    private AbstractQlModel.MappingQlEntity myPersistenceEntity;
    NotNullLazyValue<Pair<PersistenceModelBrowser, List<PersistentAttribute>>> myAttributes;

    public JpaScopeModel(PsiMember element) {
        this.myElement = element;
        this.myAttributes = NotNullLazyValue.volatileLazy(() -> {
            if (this.myElement instanceof RelationAttributeBase) {
                return Pair.create((Object)PersistenceCommonUtil.createSameUnitsModelBrowser((DomElement)((DomElement)this.myElement)), Collections.singletonList((PersistentAttribute)this.myElement));
            }
            PersistenceModelBrowser browser = PersistenceCommonUtil.createSameUnitsModelBrowser((PsiElement)((PsiMember)this.myElement));
            return Pair.create((Object)browser, (Object)browser.getPersistenceAttributes((PsiMember)this.myElement));
        });
    }

    public JpaScopeModel(RelationAttributeBase element) {
        this.myElement = element;
        this.myAttributes = NotNullLazyValue.volatileLazy(() -> {
            if (this.myElement == null) {
                PersistenceModelBrowser browser = PersistenceCommonUtil.createSameUnitsModelBrowser((PsiElement)((PsiMember)this.myElement));
                return Pair.create((Object)browser, (Object)browser.getPersistenceAttributes((PsiMember)this.myElement));
            }
            return Pair.create((Object)PersistenceCommonUtil.createSameUnitsModelBrowser((DomElement)((DomElement)this.myElement)), Collections.singletonList((PersistentAttribute)this.myElement));
        });
    }

    @Override
    @Nullable
    public QlEntity getScopeEntity() {
        if (this.myPersistenceEntity == null) {
            for (PersistentAttribute attribute : this.getAttributes()) {
                PersistentObject firstObject;
                PersistenceModelBrowser browser;
                JavaTypeInfo typeInfo = JpaUtil.getSubstitutedTypeInfo(attribute, browser = this.getBrowser(), false);
                if (typeInfo == null || (firstObject = (PersistentObject)browser.queryPersistentObjects(PsiTypesUtil.getPsiClass((PsiType)typeInfo.getValueType())).findFirst()) == null) continue;
                this.myPersistenceEntity = new AbstractQlModel.MappingQlEntity(firstObject, browser, false);
                break;
            }
        }
        return this.myPersistenceEntity;
    }

    private PersistenceModelBrowser getBrowser() {
        return (PersistenceModelBrowser)((Pair)this.myAttributes.getValue()).first;
    }

    private List<PersistentAttribute> getAttributes() {
        return (List)((Pair)this.myAttributes.getValue()).second;
    }

    @Override
    public boolean isEmptyModel() {
        return this.getAttributes().isEmpty();
    }
}

