/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.database.script.QueryParametersProvider;
import com.intellij.jam.JamAttributeElement;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.JpaQueryReferenceProvider;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.jpa.util.UastJpaQueryParameterResolverHelper;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.uast.UExpressionPattern;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.persistence.model.PersistenceQuery;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.UastInjectionHostReferenceProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public final class JpaQueryParameterReferenceProvider
extends UastInjectionHostReferenceProvider {
    private static final UExpressionPattern<UExpression, ?> QUERY_PATTERN = UastPatterns.injectionHostUExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("setParameter")).definedInClass("javax.persistence.Query"));
    private static final UExpressionPattern<UExpression, ?> HIBERNATE_QUERY_PATTERN = UastPatterns.injectionHostUExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName((ElementPattern)StandardPatterns.string().oneOf(new String[]{"setParameter", "setParameterList", "setProperties", "setString", "setCharacter", "setBoolean", "setByte", "setShort", "setInteger", "setLong", "setFloat", "setDouble", "setBinary", "setText", "setSerializable", "setLocale", "setBigDecimal", "setBigInteger", "setDate", "setTime", "setTimestamp", "setCalendar", "setCalendarDate", "setEntity"}))).definedInClass("org.hibernate.Query"));
    private static final UExpressionPattern<UExpression, ?> HIBERNATE3_OPERATIONS__PATTERN = UastPatterns.injectionHostUExpression().methodCallParameter(1, (ElementPattern)PsiJavaPatterns.psiMethod().definedInClass("org.springframework.orm.hibernate3.HibernateOperations").withName((ElementPattern)StandardPatterns.string().oneOf(new String[]{"findByNamedQueryAndNamedParam", "findByNamedParam"})));
    private static final UExpressionPattern<UExpression, ?> HIBERNATE4_OPERATIONS__PATTERN = UastPatterns.injectionHostUExpression().methodCallParameter(1, (ElementPattern)PsiJavaPatterns.psiMethod().definedInClass("org.springframework.orm.hibernate4.HibernateOperations").withName((ElementPattern)StandardPatterns.string().oneOf(new String[]{"findByNamedQueryAndNamedParam", "findByNamedParam"})));
    private static final UExpressionPattern<UExpression, ?> HIBERNATE5_OPERATIONS__PATTERN = UastPatterns.injectionHostUExpression().methodCallParameter(1, (ElementPattern)PsiJavaPatterns.psiMethod().definedInClass("org.springframework.orm.hibernate5.HibernateOperations").withName((ElementPattern)StandardPatterns.string().oneOf(new String[]{"findByNamedQueryAndNamedParam", "findByNamedParam"})));
    private static final UExpressionPattern<UExpression, ?> PREPARED_STATEMENT_PATTERN = UastPatterns.injectionHostUExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName((ElementPattern)StandardPatterns.string().oneOf(new String[]{"setNull", "setBoolean", "setByte", "setShort", "setInt", "setLong", "setFloat", "setDouble", "setBigDecimal", "setString", "setBytes", "setDate", "setTime", "setTimestamp", "setAsciiStream", "setUnicodeStream", "setBinaryStream", "setObject", "setCharacterStream", "setRef", "setBlob", "setClob", "setArray", "setDate", "setTime", "setTimestamp", "setNull", "setURL", "setRowId", "setNString", "setNCharacterStream", "setNClob", "setClob", "setBlob", "setNClob", "setSQLXML"}))).definedInClass("java.sql.PreparedStatement"));
    private static final UExpressionPattern<UExpression, ?> HIBERNATE_REACTIVE_QUERY_PATTERN = UastPatterns.injectionHostUExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("setParameter")).definedInClass((ElementPattern)PsiJavaPatterns.psiClass().withQualifiedName((ElementPattern)StandardPatterns.string().oneOf(new String[]{"org.hibernate.reactive.mutiny.Mutiny.Query", "org.hibernate.reactive.stage.Stage.Query"}))));
    private static final UExpressionPattern<UExpression, ?> R2DBC_BIND_PATTERN = UastPatterns.injectionHostUExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName(new String[]{"bind", "bindNull"})).definedInClass((ElementPattern)PsiJavaPatterns.psiClass().withQualifiedName((ElementPattern)StandardPatterns.string().oneOf(new String[]{"io.r2dbc.spi.Statement", "org.springframework.r2dbc.core.DatabaseClient.GenericExecuteSpec"}))));
    public static final ElementPattern<UElement> ALL_PATTERNS = StandardPatterns.or((ElementPattern[])new ElementPattern[]{QUERY_PATTERN, HIBERNATE_QUERY_PATTERN, HIBERNATE3_OPERATIONS__PATTERN, HIBERNATE4_OPERATIONS__PATTERN, HIBERNATE5_OPERATIONS__PATTERN, PREPARED_STATEMENT_PATTERN, HIBERNATE_REACTIVE_QUERY_PATTERN, R2DBC_BIND_PATTERN});
    private final ResolveHelper myHelper = new ResolveHelper();

    public PsiReference @NotNull [] getReferencesForInjectionHost(@NotNull UExpression uExpression, @NotNull PsiLanguageInjectionHost host, @NotNull ProcessingContext context) {
        if (uExpression == null) {
            JpaQueryParameterReferenceProvider.$$$reportNull$$$0(0);
        }
        if (host == null) {
            JpaQueryParameterReferenceProvider.$$$reportNull$$$0(1);
        }
        if (context == null) {
            JpaQueryParameterReferenceProvider.$$$reportNull$$$0(2);
        }
        Object parameterExprValue = uExpression.evaluate();
        String parameterName = String.valueOf(parameterExprValue);
        if (JpaQueryParameterReferenceProvider.isInsideR2dbcBindCall(host)) {
            PsiType expressionType = uExpression.getExpressionType();
            if (expressionType != null && parameterExprValue instanceof Integer) {
                parameterName = String.valueOf((Integer)parameterExprValue + 1);
            } else {
                parameterName = StringsKt.removePrefix((String)parameterName, (CharSequence)"$");
                parameterName = StringsKt.removePrefix((String)parameterName, (CharSequence)"@");
            }
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new QueryParameterReference((PsiElement)host, parameterName, this.myHelper)};
        if (psiReferenceArray == null) {
            JpaQueryParameterReferenceProvider.$$$reportNull$$$0(3);
        }
        return psiReferenceArray;
    }

    private static boolean isInsideR2dbcBindCall(@NotNull PsiLanguageInjectionHost host) {
        UElement uHost;
        if (host == null) {
            JpaQueryParameterReferenceProvider.$$$reportNull$$$0(4);
        }
        if ((uHost = UastContextKt.toUElement((PsiElement)host)) == null) {
            return false;
        }
        UCallExpression expression = UastUtils.getUCallExpression((UElement)uHost, (int)2);
        if (expression == null) {
            return false;
        }
        String methodName = expression.getMethodName();
        if (!"bind".equals(methodName) && !"bindNull".equals(methodName)) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)host);
        return JpaUtil.isR2dbcAvailable(module);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uExpression";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/JpaQueryParameterReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/JpaQueryParameterReferenceProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesForInjectionHost";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesForInjectionHost";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isInsideR2dbcBindCall";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class QueryParameterReference
    extends JpaQueryReferenceProvider.QueryRelatedReference {
        private final String myParameterName;
        private final ResolveHelper myHelper;
        private List<Map<String, PsiElement>> myMapList;
        private boolean myUnparsable;

        public QueryParameterReference(PsiElement element, String parameterName, ResolveHelper helper) {
            super(element);
            this.myParameterName = parameterName;
            this.myHelper = helper;
        }

        private synchronized void initMapList() {
            if (this.myMapList == null) {
                this.myMapList = new ArrayList<Map<String, PsiElement>>(0);
                Ref ref = Ref.create(null);
                this.myHelper.processPossibleQueryElementsByParameter(CompletionUtil.getOriginalOrSelf((PsiElement)this.getElement()), this.myMapList, (Ref<Boolean>)ref);
                this.myUnparsable = Boolean.TRUE.equals(ref.get());
            }
        }

        public PsiElement resolve() {
            this.initMapList();
            if (this.myMapList.isEmpty()) {
                return this.getElement();
            }
            if (StringUtil.isEmpty((String)this.myParameterName)) {
                return null;
            }
            for (Map<String, PsiElement> map : this.myMapList) {
                PsiElement element = map.get(this.myParameterName);
                if (element == null) continue;
                return element;
            }
            return this.myUnparsable ? this.getElement() : null;
        }

        public Object @NotNull [] getVariants() {
            this.initMapList();
            if (this.myMapList.isEmpty()) {
                if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                    QueryParameterReference.$$$reportNull$$$0(0);
                }
                return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
            }
            HashMap<String, PsiElement> result = new HashMap<String, PsiElement>(this.myMapList.get(0));
            for (Map<String, PsiElement> map : this.myMapList) {
                result.keySet().retainAll(map.keySet());
            }
            Object[] objectArray = ContainerUtil.mapNotNull(result.keySet(), s -> {
                if (StringUtil.parseInt((String)s, (int)-1) != -1) {
                    return null;
                }
                return LookupElementBuilder.create((String)s).withIcon(((PsiElement)result.get(s)).getIcon(0));
            }).toArray();
            if (objectArray == null) {
                QueryParameterReference.$$$reportNull$$$0(1);
            }
            return objectArray;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = JpaMessages.message((String)"cannot.resolve.query.parameter.0", (Object[])new Object[0]);
            if (string == null) {
                QueryParameterReference.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/jpa/JpaQueryParameterReferenceProvider$QueryParameterReference";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class ResolveHelper
    extends UastJpaQueryParameterResolverHelper {
        @Override
        protected boolean addParamMap(@NotNull PsiFile file, List<Map<String, PsiElement>> result, Ref<Boolean> context) {
            QueryParametersProvider provider;
            if (file == null) {
                ResolveHelper.$$$reportNull$$$0(0);
            }
            if ((provider = (QueryParametersProvider)QueryParametersProvider.EXTENSION.forLanguage(file.getLanguage())) == null) {
                return false;
            }
            ContainerUtil.addIfNotNull(result, (Object)provider.getParameters(file));
            if (context.isNull()) {
                context.set((Object)((Boolean)file.getUserData(InjectedLanguageManager.FRANKENSTEIN_INJECTION)));
                if (PsiTreeUtil.hasErrorElements((PsiElement)file)) {
                    context.set((Object)true);
                }
            }
            return true;
        }

        @Override
        public boolean processPossibleQueryElementsByParameter(@NotNull PsiElement paramElement, @NotNull List<Map<String, PsiElement>> result, @NotNull Ref<Boolean> context) {
            UCallExpression callExpression;
            if (paramElement == null) {
                ResolveHelper.$$$reportNull$$$0(1);
            }
            if (result == null) {
                ResolveHelper.$$$reportNull$$$0(2);
            }
            if (context == null) {
                ResolveHelper.$$$reportNull$$$0(3);
            }
            if ((callExpression = (UCallExpression)UastUtils.findContaining((PsiElement)paramElement, UCallExpression.class)) == null) {
                return false;
            }
            List args = callExpression.getValueArguments();
            UExpression firstItem = (UExpression)ContainerUtil.getFirstItem((List)args);
            if (firstItem != null && !Objects.equals(firstItem, UastContextKt.toUElement((PsiElement)paramElement)) && this.processPossibleQueryElement(((UExpression)args.get(0)).getSourcePsi(), result, ResolveHelper.initialVisitedElements(paramElement), context)) {
                return true;
            }
            return super.processPossibleQueryElementsByParameter(paramElement, result, context);
        }

        @Override
        protected boolean processPossibleQueryElement(PsiElement element, List<Map<String, PsiElement>> result, Collection<PsiElement> visitedElements, Ref<Boolean> context) {
            if (element instanceof XmlElement) {
                return this.addParamMapsByQueryElement(element, result, context);
            }
            return super.processPossibleQueryElementsByParameter(element, result, context);
        }

        @Override
        protected boolean addParamMapsByQueryElement(@NotNull PsiElement expression, List<Map<String, PsiElement>> result, Ref<Boolean> context) {
            GenericValue queryValue;
            JpaQueryReferenceProvider.QueryReference reference;
            if (expression == null) {
                ResolveHelper.$$$reportNull$$$0(4);
            }
            PersistenceQuery query = (reference = JpaUtil.findReferenceOfType(expression.getReferences(), JpaQueryReferenceProvider.QueryReference.class)) == null ? null : reference.resolveQuery();
            GenericValue genericValue = queryValue = query == null ? null : query.getQuery();
            if (queryValue instanceof JamAttributeElement) {
                PsiLiteralExpression literal;
                PsiAnnotationMemberValue value = ((JamAttributeElement)queryValue).getPsiElement();
                if (value instanceof PsiReferenceExpression) {
                    this.addParameterMapsByQueryReference((PsiReferenceExpression)value, result, ResolveHelper.initialVisitedElements(expression), context);
                } else if (value instanceof PsiExpression && (literal = ResolveHelper.getFirstLiteral((PsiExpression)value)) != null) {
                    this.addParamMapsByQueryElement((PsiElement)literal, result, context);
                }
                return true;
            }
            if (queryValue instanceof DomElement) {
                XmlElement element = ((DomElement)queryValue).getXmlElement();
                if (element != null) {
                    super.addParamMapsByQueryElement((PsiElement)element, result, context);
                }
                return true;
            }
            return super.addParamMapsByQueryElement(expression, result, context);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "paramElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/jpa/JpaQueryParameterReferenceProvider$ResolveHelper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addParamMap";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processPossibleQueryElementsByParameter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addParamMapsByQueryElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

