/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.javaee.model.xml.persistence.Persistence;
import com.intellij.javaee.model.xml.persistence.PersistenceUnit;
import com.intellij.jpa.facet.JpaFacet;
import com.intellij.jpa.facet.JpaFacetConfiguration;
import com.intellij.jpa.ql.JpqlLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LanguageSubstitutor;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ObjectUtils;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpaQueryLanguageSubstitutor
extends LanguageSubstitutor {
    @NotNull
    private static Pair<Language, Integer> SQL_LANGUAGE = Pair.create(null, (Object)0);

    @Nullable
    private static Language getSqlLanguage() {
        Collection languages = Language.getRegisteredLanguages();
        if (languages.size() == ((Integer)JpaQueryLanguageSubstitutor.SQL_LANGUAGE.second).intValue()) {
            return (Language)JpaQueryLanguageSubstitutor.SQL_LANGUAGE.first;
        }
        Language sql = Language.findLanguageByID((String)"SQL");
        SQL_LANGUAGE = Pair.create((Object)(sql == null ? PlainTextLanguage.INSTANCE : sql), (Object)languages.size());
        return (Language)JpaQueryLanguageSubstitutor.SQL_LANGUAGE.first;
    }

    @Nullable
    private static XmlTag getInjectionHost(VirtualFile file) {
        PsiLanguageInjectionHost host = InjectedLanguageUtil.findInjectionHost((VirtualFile)file);
        return host instanceof XmlElement ? (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)host, XmlTag.class) : null;
    }

    public Language getLanguage(@NotNull VirtualFile file, @NotNull Project project) {
        XmlTag parentTag;
        XmlTag host;
        if (file == null) {
            JpaQueryLanguageSubstitutor.$$$reportNull$$$0(0);
        }
        if (project == null) {
            JpaQueryLanguageSubstitutor.$$$reportNull$$$0(1);
        }
        if ((host = JpaQueryLanguageSubstitutor.getInjectionHost(file)) != null && (parentTag = host.getParentTag()) != null && "named-native-query".equals(parentTag.getName())) {
            Language sqlLanguage = JpaQueryLanguageSubstitutor.getSqlLanguage();
            return sqlLanguage != null ? LanguageSubstitutors.getInstance().substituteLanguage(sqlLanguage, file, project) : null;
        }
        VirtualFile realFile = file instanceof VirtualFileWindow ? ((VirtualFileWindow)file).getDelegate() : file;
        realFile = realFile instanceof LightVirtualFile ? (VirtualFile)ObjectUtils.notNull((Object)((LightVirtualFile)realFile).getOriginalFile(), (Object)realFile) : realFile;
        return JpaQueryLanguageSubstitutor.chooseLanguage(project, realFile);
    }

    @Nullable
    public static Language chooseLanguage(@NotNull Project project, @NotNull VirtualFile file) {
        Module module;
        if (project == null) {
            JpaQueryLanguageSubstitutor.$$$reportNull$$$0(2);
        }
        if (file == null) {
            JpaQueryLanguageSubstitutor.$$$reportNull$$$0(3);
        }
        if ((module = ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(file)) == null) {
            return null;
        }
        List facets = PersistenceCommonUtil.getAllPersistenceFacetsWithDependencies((Module)module);
        if (facets.isEmpty()) {
            return null;
        }
        for (PersistenceFacet facet : facets) {
            if (facet instanceof JpaFacet) {
                String providerName = JpaQueryLanguageSubstitutor.getProviderName((JpaFacet)facet);
                if (!StringUtil.isNotEmpty((String)providerName)) continue;
                if (providerName.startsWith("org.hibernate.")) {
                    return JpqlLanguage.HQL;
                }
                if (!providerName.startsWith("org.eclipse.persistence.")) continue;
                return JpqlLanguage.EQL;
            }
            if (!((Object)((Object)JpqlLanguage.HQL)).equals(facet.getQlLanguage())) continue;
            return JpqlLanguage.HQL;
        }
        return null;
    }

    @Nullable
    public static String getProviderName(@NotNull JpaFacet facet) {
        Persistence persistenceRoot;
        if (facet == null) {
            JpaQueryLanguageSubstitutor.$$$reportNull$$$0(4);
        }
        if ((persistenceRoot = facet.getMergedPersistenceRoot()) != null) {
            for (PersistenceUnit unit : persistenceRoot.getPersistenceUnits()) {
                String providerName = unit.getProvider().getStringValue();
                if (!StringUtil.isNotEmpty((String)providerName)) continue;
                return providerName;
            }
        }
        return ((JpaFacetConfiguration)facet.getConfiguration()).getDefaultJPAProviderName();
    }

    private static boolean hasProviderClass(@NotNull Module module, String ... providerClasses) {
        if (module == null) {
            JpaQueryLanguageSubstitutor.$$$reportNull$$$0(5);
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesScope((Module)module);
        for (String aClass : providerClasses) {
            if (JavaPsiFacade.getInstance((Project)module.getProject()).findClass(aClass, scope) == null) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jpa/JpaQueryLanguageSubstitutor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLanguage";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "chooseLanguage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getProviderName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "hasProviderClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class Ejbql
    extends LanguageSubstitutor {
        public Language getLanguage(@NotNull VirtualFile file, @NotNull Project project) {
            XmlTag host;
            if (file == null) {
                Ejbql.$$$reportNull$$$0(0);
            }
            if (project == null) {
                Ejbql.$$$reportNull$$$0(1);
            }
            if ((host = JpaQueryLanguageSubstitutor.getInjectionHost(file)) == null) {
                return null;
            }
            if ("http://java.sun.com/xml/ns/javaee".equals(host.getNamespace())) {
                return JpqlLanguage.EJBQL;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "com/intellij/jpa/JpaQueryLanguageSubstitutor$Ejbql";
            objectArray[2] = "getLanguage";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

