/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa;

import com.intellij.credentialStore.Credentials;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.javaee.model.xml.persistence.PersistenceUnit;
import com.intellij.jpa.JpaImplementationProvider;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.model.PersistencePackage;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JpaImplementationProviderBase
implements JpaImplementationProvider {
    @NonNls
    private final String myDisplayName;
    private final String myProviderClassName;
    private final String myPropertyDriver;
    private final String myPropertyUrl;
    private final String myPropertyUser;
    private final String myPropertyPassword;

    protected JpaImplementationProviderBase(@NotNull @NonNls String displayName, @NotNull String providerClass, @NotNull String driver, @NotNull String url, @NotNull String user, @NotNull String password) {
        if (displayName == null) {
            JpaImplementationProviderBase.$$$reportNull$$$0(0);
        }
        if (providerClass == null) {
            JpaImplementationProviderBase.$$$reportNull$$$0(1);
        }
        if (driver == null) {
            JpaImplementationProviderBase.$$$reportNull$$$0(2);
        }
        if (url == null) {
            JpaImplementationProviderBase.$$$reportNull$$$0(3);
        }
        if (user == null) {
            JpaImplementationProviderBase.$$$reportNull$$$0(4);
        }
        if (password == null) {
            JpaImplementationProviderBase.$$$reportNull$$$0(5);
        }
        this.myDisplayName = displayName;
        this.myProviderClassName = providerClass;
        this.myPropertyDriver = driver;
        this.myPropertyUrl = url;
        this.myPropertyUser = user;
        this.myPropertyPassword = password;
    }

    @NotNull
    @NonNls
    public String getProviderName() {
        String string = this.myDisplayName;
        if (string == null) {
            JpaImplementationProviderBase.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NonNls
    public String getProviderClassName(@Nullable Module module) {
        return this.myProviderClassName;
    }

    public boolean isConfiguredFor(@NotNull PersistencePackage unit) {
        if (unit == null) {
            JpaImplementationProviderBase.$$$reportNull$$$0(7);
        }
        return JpaUtil.findPersistenceUnitProperty(unit, this.myPropertyUrl, null) != null;
    }

    public void setConnectionProperties(@NotNull Project project, @NotNull PersistenceUnit unit, @NotNull RawConnectionConfig info, @Nullable Credentials credentials) {
        if (project == null) {
            JpaImplementationProviderBase.$$$reportNull$$$0(8);
        }
        if (unit == null) {
            JpaImplementationProviderBase.$$$reportNull$$$0(9);
        }
        if (info == null) {
            JpaImplementationProviderBase.$$$reportNull$$$0(10);
        }
        JpaUtil.setPersistenceUnitProperty(unit, this.myPropertyUrl, this.getPropertyAlias(this.myPropertyUrl), DataSourceUtil.getEffectiveUrl((Project)project, (RawConnectionConfig)info));
        JpaUtil.setPersistenceUnitProperty(unit, this.myPropertyDriver, this.getPropertyAlias(this.myPropertyDriver), info.getDriverClass());
        if (credentials != null) {
            JpaUtil.setPersistenceUnitProperty(unit, this.myPropertyUser, this.getPropertyAlias(this.myPropertyUser), credentials.getUserName());
            JpaUtil.setPersistenceUnitProperty(unit, this.myPropertyPassword, this.getPropertyAlias(this.myPropertyPassword), credentials.getPasswordAsString());
        }
    }

    @Nullable
    protected String getPropertyAlias(String propertyName) {
        return null;
    }

    public void setDefaultProperties(@NotNull PersistenceUnit unit) {
        if (unit == null) {
            JpaImplementationProviderBase.$$$reportNull$$$0(11);
        }
        unit.getProvider().setStringValue(this.myProviderClassName);
        JpaUtil.setPersistenceUnitProperty(unit, this.myPropertyUrl, null, "");
        JpaUtil.setPersistenceUnitProperty(unit, this.myPropertyDriver, null, "");
        JpaUtil.setPersistenceUnitProperty(unit, this.myPropertyUser, null, "");
        JpaUtil.setPersistenceUnitProperty(unit, this.myPropertyPassword, null, "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "user";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "password";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/JpaImplementationProviderBase";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/JpaImplementationProviderBase";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviderName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isConfiguredFor";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setConnectionProperties";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

