/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa;

import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.jpa.actions.AssignDataSourcesAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistencePackagePointer;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JpaConsoleUtils {
    public static boolean suggestAssignDatasourceIfNeeded(@NotNull PersistencePackagePointer unitPointer) {
        boolean hasAssignedDatasource;
        if (unitPointer == null) {
            JpaConsoleUtils.$$$reportNull$$$0(0);
        }
        PersistencePackage unit = unitPointer.findElement();
        PersistenceFacet facet = unitPointer.getPersistenceFacet();
        if (facet == null || unit == null || !unit.isValid()) {
            Logger.getInstance(JpaConsoleUtils.class).warn("No Persistence facet found in data context, can not open console");
            return false;
        }
        if (facet.getDataSourceId(unit) == null) {
            DbDataSource dataSource;
            List availableDataSources = DbPsiFacade.getInstance((Project)facet.getModule().getProject()).getDataSources();
            if (availableDataSources.size() == 1 && (dataSource = (DbDataSource)ContainerUtil.getFirstItem((List)availableDataSources)) != null) {
                facet.setDataSourceId(unit, dataSource.getUniqueId());
                Logger.getInstance(JpaConsoleUtils.class).warn("Automatically assigned the only available datasource with id: " + dataSource.getUniqueId());
            }
            AssignDataSourcesAction.showUnitDataSourceMappingDialog(facet);
        }
        boolean bl = hasAssignedDatasource = facet.getDataSourceId(unit) != null;
        if (!hasAssignedDatasource) {
            Logger.getInstance(JpaConsoleUtils.class).warn("No datasource is assigned, so console can not be correctly set up and will not be launched. To enable console assign datasource first");
        }
        return hasAssignedDatasource;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unitPointer", "com/intellij/jpa/JpaConsoleUtils", "suggestAssignDatasourceIfNeeded"));
    }
}

