/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.impl.source.xml.XmlStubBasedTagBase;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.testFramework.FlakyTestLogger;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartFMap;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.AnnotatedElement;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.ConverterManager;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomNameStrategy;
import com.intellij.util.xml.DomResolveConverter;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.DummyEvaluatedXmlName;
import com.intellij.util.xml.ElementPresentation;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.ElementPresentationTemplate;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.JavaMethodSignature;
import com.intellij.util.xml.Required;
import com.intellij.util.xml.Resolve;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.events.DomEvent;
import com.intellij.util.xml.impl.AbstractCollectionChildDescription;
import com.intellij.util.xml.impl.AbstractDomChildDescriptionImpl;
import com.intellij.util.xml.impl.AttributeChildDescriptionImpl;
import com.intellij.util.xml.impl.AttributeChildInvocationHandler;
import com.intellij.util.xml.impl.CollectionChildDescriptionImpl;
import com.intellij.util.xml.impl.CollectionElementInvocationHandler;
import com.intellij.util.xml.impl.ConvertAnnotationImpl;
import com.intellij.util.xml.impl.CustomDomChildrenDescriptionImpl;
import com.intellij.util.xml.impl.DomChildDescriptionImpl;
import com.intellij.util.xml.impl.DomCreator;
import com.intellij.util.xml.impl.DomGenericInfoEx;
import com.intellij.util.xml.impl.DomImplUtil;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.DomParentStrategy;
import com.intellij.util.xml.impl.DynamicGenericInfo;
import com.intellij.util.xml.impl.FixedChildDescriptionImpl;
import com.intellij.util.xml.impl.GetInvocation;
import com.intellij.util.xml.impl.IndexedElementInvocationHandler;
import com.intellij.util.xml.impl.Invocation;
import com.intellij.util.xml.impl.InvocationCache;
import com.intellij.util.xml.impl.PhysicalDomParentStrategy;
import com.intellij.util.xml.impl.SetInvocation;
import com.intellij.util.xml.impl.StaticGenericInfo;
import com.intellij.util.xml.impl.VirtualDomParentStrategy;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import com.intellij.util.xml.stubs.AttributeStub;
import com.intellij.util.xml.stubs.DomStub;
import com.intellij.util.xml.stubs.ElementStub;
import com.intellij.util.xml.stubs.StubParentStrategy;
import com.intellij.util.xml.stubs.XIncludeStub;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import net.sf.cglib.proxy.AdvancedProxy;
import net.sf.cglib.proxy.InvocationHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DomInvocationHandler
extends UserDataHolderBase
implements InvocationHandler,
DomElement {
    private static final Logger LOG = Logger.getInstance(DomInvocationHandler.class);
    public static final Method ACCEPT_METHOD = ReflectionUtil.getMethod(DomElement.class, (String)"accept", (Class[])new Class[]{DomElementVisitor.class});
    public static final Method ACCEPT_CHILDREN_METHOD = ReflectionUtil.getMethod(DomElement.class, (String)"acceptChildren", (Class[])new Class[]{DomElementVisitor.class});
    private static final JavaMethod ourGetValue = JavaMethod.getMethod(GenericValue.class, (JavaMethodSignature)new JavaMethodSignature("getValue", new Class[0]));
    private final Type myType;
    private final DomManagerImpl myManager;
    private final EvaluatedXmlName myTagName;
    private final AbstractDomChildDescriptionImpl myChildDescription;
    private DomParentStrategy myParentStrategy;
    private volatile long myLastModCount;
    private volatile DomElement myProxy;
    private DomGenericInfoEx myGenericInfo;
    private final InvocationCache myInvocationCache;
    private volatile Converter myScalarConverter;
    private volatile SmartFMap<Method, Invocation> myAccessorInvocations;
    @Nullable
    protected DomStub myStub;

    protected DomInvocationHandler(Type type, DomParentStrategy parentStrategy, @NotNull EvaluatedXmlName tagName, AbstractDomChildDescriptionImpl childDescription, DomManagerImpl manager, boolean dynamic, @Nullable DomStub stub) {
        if (tagName == null) {
            DomInvocationHandler.$$$reportNull$$$0(0);
        }
        this.myScalarConverter = null;
        this.myAccessorInvocations = SmartFMap.emptyMap();
        this.myManager = manager;
        this.myParentStrategy = parentStrategy;
        this.myTagName = tagName;
        this.myChildDescription = childDescription;
        this.myStub = stub;
        this.myLastModCount = manager.getPsiModificationCount();
        this.myType = this.narrowType(type);
        this.myInvocationCache = manager.getApplicationComponent().getInvocationCache(this.getRawType());
        this.refreshGenericInfo(dynamic);
        if (stub != null) {
            stub.setHandler(this);
        }
    }

    protected Type narrowType(@NotNull Type nominalType) {
        if (nominalType == null) {
            DomInvocationHandler.$$$reportNull$$$0(1);
        }
        return nominalType;
    }

    @Nullable
    public DomElement getParent() {
        DomInvocationHandler handler = this.getParentHandler();
        return handler == null ? null : handler.getProxy();
    }

    protected final void assertValid() {
        String s = this.checkValidity();
        if (s != null) {
            throw new AssertionError((Object)(this.myType.toString() + " @" + this.hashCode() + "\nclass=" + ((Object)((Object)this)).getClass() + "\nxml=" + this.getXmlElement() + "; " + s));
        }
    }

    @Nullable
    final DomInvocationHandler getParentHandler() {
        return this.getParentStrategy().getParentHandler();
    }

    @Nullable
    public DomStub getStub() {
        return this.myStub;
    }

    @NotNull
    public final Type getDomElementType() {
        Type type = this.myType;
        if (type == null) {
            DomInvocationHandler.$$$reportNull$$$0(2);
        }
        return type;
    }

    @Nullable
    protected String getValue() {
        XmlTag tag = this.getXmlTag();
        return tag == null ? null : DomInvocationHandler.getTagValue(tag);
    }

    protected void setValue(@Nullable String value) {
        XmlTag tag = this.ensureTagExists();
        this.myManager.runChange(() -> DomInvocationHandler.setTagValue(tag, value));
        this.myManager.fireEvent(new DomEvent(this.getProxy(), false));
    }

    public void copyFrom(DomElement other) {
        if (other == this.getProxy()) {
            return;
        }
        assert (other.getDomElementType().equals(this.myType)) : "Can't copy from " + other.getDomElementType() + " to " + this.myType;
        if (other.getXmlElement() == null) {
            this.undefine();
            return;
        }
        this.myManager.performAtomicChange(() -> {
            this.ensureXmlElementExists();
            DomInvocationHandler otherInvocationHandler = DomManagerImpl.getDomInvocationHandler(other);
            assert (otherInvocationHandler != null) : other;
            DomGenericInfoEx genericInfo = otherInvocationHandler.getGenericInfo();
            for (AttributeChildDescriptionImpl description : genericInfo.getAttributeChildrenDescriptions()) {
                description.getDomAttributeValue(this).setStringValue(description.getDomAttributeValue(other).getRawText());
            }
            for (AttributeChildDescriptionImpl description : genericInfo.getFixedChildrenDescriptions()) {
                List list = description.getValues(this.getProxy());
                List otherValues = description.getValues(other);
                for (int i = 0; i < list.size(); ++i) {
                    DomElement otherValue = (DomElement)otherValues.get(i);
                    DomElement value = (DomElement)list.get(i);
                    if (!DomUtil.hasXml((DomElement)otherValue)) {
                        value.undefine();
                        continue;
                    }
                    value.copyFrom(otherValue);
                }
            }
            for (AttributeChildDescriptionImpl description : genericInfo.getCollectionChildrenDescriptions()) {
                for (DomElement value : description.getValues(this.getProxy())) {
                    value.undefine();
                }
                for (DomElement otherValue : description.getValues(other)) {
                    description.addValue(this.getProxy(), otherValue.getDomElementType()).copyFrom(otherValue);
                }
            }
            String stringValue = otherInvocationHandler.getValue();
            if (StringUtil.isNotEmpty((String)stringValue)) {
                this.setValue(stringValue);
            }
        });
        if (!this.myManager.isInsideAtomicChange()) {
            this.myManager.fireEvent(new DomEvent(this.getProxy(), false));
        }
    }

    public <T extends DomElement> T createStableCopy() {
        XmlTag tag = this.getXmlTag();
        if (tag != null && tag.isPhysical()) {
            DomInvocationHandler existing = this.myManager.getDomHandler((XmlElement)tag);
            if (!this.equals((Object)existing)) {
                throw new IllegalStateException(this + " != " + existing);
            }
            SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)this.myManager.getProject()).createSmartPsiElementPointer((PsiElement)tag);
            return this.myManager.createStableValue(new StableCopyFactory((SmartPsiElementPointer<? extends XmlTag>)pointer, this.myType, ((Object)((Object)this)).getClass()));
        }
        return (T)this.createPathStableCopy();
    }

    protected DomElement createPathStableCopy() {
        throw new UnsupportedOperationException();
    }

    public final <T extends DomElement> T createMockCopy(boolean physical) {
        Object copy = this.myManager.createMockElement(this.getRawType(), this.getProxy().getModule(), physical);
        copy.copyFrom(this.getProxy());
        return (T)copy;
    }

    @NotNull
    public String getXmlElementNamespace() {
        DomInvocationHandler parent = this.getParentHandler();
        assert (parent != null) : "this operation should be performed on the DOM having a physical parent, your DOM may be not very fresh";
        XmlElement element = parent.getXmlElement();
        assert (element != null);
        String string = this.getXmlName().getNamespace(element, this.getFile());
        if (string == null) {
            DomInvocationHandler.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public String getXmlElementNamespaceKey() {
        return this.getXmlName().getXmlName().getNamespaceKey();
    }

    public final Module getModule() {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getFile());
        return module != null ? module : (Module)DomUtil.getFile((DomElement)this).getUserData(DomManager.MOCK_ELEMENT_MODULE);
    }

    public XmlTag ensureTagExists() {
        this.assertValid();
        XmlTag tag = this.getXmlTag();
        if (tag != null) {
            return tag;
        }
        tag = this.setEmptyXmlTag();
        this.setXmlElement((XmlElement)tag);
        DomElement element = this.getProxy();
        this.myManager.fireEvent(new DomEvent(element, true));
        this.addRequiredChildren();
        return this.getXmlTag();
    }

    public XmlElement getXmlElement() {
        return this.getParentStrategy().getXmlElement();
    }

    public boolean exists() {
        return this.getParentStrategy().isPhysical();
    }

    private DomParentStrategy getParentStrategy() {
        this.myParentStrategy = this.myParentStrategy.refreshStrategy(this);
        return this.myParentStrategy;
    }

    public XmlElement ensureXmlElementExists() {
        return this.ensureTagExists();
    }

    protected final XmlTag createChildTag(EvaluatedXmlName tagName) {
        String localName = tagName.getXmlName().getLocalName();
        if (localName.contains(":")) {
            try {
                return XmlElementFactory.getInstance((Project)this.myManager.getProject()).createTagFromText((CharSequence)("<" + localName + "/>"));
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        XmlElement element = this.getXmlElement();
        assert (element != null);
        return this.getXmlTag().createChildTag(localName, tagName.getNamespace(element, this.getFile()), null, false);
    }

    public final boolean isValid() {
        return this.checkValidity() == null;
    }

    String toStringEx() {
        return this.myType.toString() + " @" + this.hashCode() + "&handler=" + super.toString() + "&cd=" + this.myChildDescription + "&ps=" + this.myParentStrategy;
    }

    @Nullable
    protected String checkValidity() {
        ProgressManager.checkCanceled();
        DomParentStrategy parentStrategy = this.getParentStrategy();
        String error = parentStrategy.checkValidity();
        if (error != null) {
            return "Strategy: " + error;
        }
        long modCount = this.myManager.getPsiModificationCount();
        if (this.myLastModCount == modCount) {
            return null;
        }
        XmlElement xmlElement = parentStrategy.getXmlElement();
        if (xmlElement != null) {
            DomInvocationHandler actual = this.myManager.getDomHandler(xmlElement);
            if (!this.equals((Object)actual)) {
                return "element changed: " + this.toStringEx() + "!=" + (actual == null ? null : actual.toStringEx());
            }
            this.myLastModCount = modCount;
            return null;
        }
        DomInvocationHandler parent = this.getParentHandler();
        if (parent == null) {
            return "no parent: " + this.getDomElementType();
        }
        error = parent.checkValidity();
        if (error != null) {
            return "parent: " + error;
        }
        this.myLastModCount = modCount;
        return null;
    }

    @NotNull
    public final DomGenericInfoEx getGenericInfo() {
        DomGenericInfoEx domGenericInfoEx = this.myGenericInfo;
        if (domGenericInfoEx == null) {
            DomInvocationHandler.$$$reportNull$$$0(4);
        }
        return domGenericInfoEx;
    }

    protected abstract void undefineInternal();

    public final void undefine() {
        this.undefineInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void deleteTag(XmlTag tag) {
        boolean changing = this.myManager.setChanging(true);
        try {
            tag.delete();
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        finally {
            this.myManager.setChanging(changing);
        }
    }

    protected final void fireUndefinedEvent() {
        this.myManager.fireEvent(new DomEvent(this.getProxy(), false));
    }

    protected abstract XmlTag setEmptyXmlTag();

    protected void addRequiredChildren() {
        for (AbstractDomChildrenDescription description : this.getGenericInfo().getChildrenDescriptions()) {
            if (description instanceof DomAttributeChildDescription) {
                Required required = (Required)description.getAnnotation(Required.class);
                if (required == null || !required.value()) continue;
                ((DomElement)description.getValues(this.getProxy()).get(0)).ensureXmlElementExists();
                continue;
            }
            if (!(description instanceof DomFixedChildDescription)) continue;
            DomFixedChildDescription childDescription = (DomFixedChildDescription)description;
            List values = null;
            int count = childDescription.getCount();
            for (int i = 0; i < count; ++i) {
                Required required = (Required)childDescription.getAnnotation(i, Required.class);
                if (required == null || !required.value()) continue;
                if (values == null) {
                    values = description.getValues(this.getProxy());
                }
                ((DomElement)values.get(i)).ensureTagExists();
            }
        }
    }

    @NotNull
    public final String getXmlElementName() {
        String string = this.myTagName.getXmlName().getLocalName();
        if (string == null) {
            DomInvocationHandler.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public final EvaluatedXmlName getXmlName() {
        EvaluatedXmlName evaluatedXmlName = this.myTagName;
        if (evaluatedXmlName == null) {
            DomInvocationHandler.$$$reportNull$$$0(6);
        }
        return evaluatedXmlName;
    }

    public void accept(DomElementVisitor visitor) {
        ProgressManager.checkCanceled();
        this.myManager.getApplicationComponent().getVisitorDescription(visitor.getClass()).acceptElement(visitor, this.getProxy());
    }

    public void acceptChildren(DomElementVisitor visitor) {
        ProgressManager.checkCanceled();
        DomElement element = this.getProxy();
        List descriptions = this.getGenericInfo().getChildrenDescriptions();
        int descriptionsSize = descriptions.size();
        for (int i = 0; i < descriptionsSize; ++i) {
            AbstractDomChildrenDescription description = (AbstractDomChildrenDescription)descriptions.get(i);
            List values = description.getValues(element);
            int valuesSize = values.size();
            for (int j = 0; j < valuesSize; ++j) {
                DomElement value = (DomElement)values.get(j);
                value.accept(visitor);
            }
        }
    }

    @NotNull
    protected final Converter getScalarConverter() {
        Converter converter = this.myScalarConverter;
        if (converter == null) {
            this.myScalarConverter = converter = this.createConverter(ourGetValue);
        }
        Converter converter2 = converter;
        if (converter2 == null) {
            DomInvocationHandler.$$$reportNull$$$0(7);
        }
        return converter2;
    }

    @NotNull
    private Converter createConverter(final JavaMethod method) {
        Converter converter;
        Type returnType = method.getGenericReturnType();
        Type type = returnType == Void.TYPE ? method.getGenericParameterTypes()[0] : returnType;
        Class parameter = DomUtil.substituteGenericType((Type)type, (Type)this.myType);
        if (parameter == null) {
            LOG.error(type + " " + this.myType);
        }
        if ((converter = this.getConverter(new AnnotatedElement(){

            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                return DomInvocationHandler.this.myInvocationCache.getMethodAnnotation(method, annotationClass);
            }
        }, parameter)) == null && type instanceof TypeVariable) {
            converter = this.getConverter((AnnotatedElement)this, DomUtil.getGenericValueParameter((Type)this.myType));
        }
        if (converter == null) {
            converter = this.myManager.getConverterManager().getConverterByClass(parameter);
        }
        if (converter == null) {
            throw new AssertionError((Object)("No converter specified: String<->" + parameter.getName() + "; method=" + method + "; place=" + this.myChildDescription));
        }
        Converter converter2 = converter;
        if (converter2 == null) {
            DomInvocationHandler.$$$reportNull$$$0(8);
        }
        return converter2;
    }

    public AbstractDomChildDescriptionImpl getChildDescription() {
        return this.myChildDescription;
    }

    @Nullable
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        Annotation annotation;
        AbstractDomChildDescriptionImpl childDescription = this.getChildDescription();
        if (childDescription != null && (annotation = childDescription.getAnnotation(annotationClass)) != null) {
            return (T)annotation;
        }
        return this.getClassAnnotation(annotationClass);
    }

    protected <T extends Annotation> T getClassAnnotation(Class<T> annotationClass) {
        return this.myInvocationCache.getClassAnnotation(annotationClass);
    }

    @Nullable
    private Converter getConverter(AnnotatedElement annotationProvider, Class parameter) {
        Resolve resolveAnnotation = (Resolve)annotationProvider.getAnnotation(Resolve.class);
        if (resolveAnnotation != null) {
            Class aClass = resolveAnnotation.value();
            if (!DomElement.class.equals((Object)aClass)) {
                return DomResolveConverter.createConverter((Class)aClass);
            }
            LOG.assertTrue(parameter != null, (Object)"You should specify @Resolve#value() parameter");
            return DomResolveConverter.createConverter((Class)parameter);
        }
        ConverterManager converterManager = this.myManager.getConverterManager();
        Convert convertAnnotation = (Convert)annotationProvider.getAnnotation(Convert.class);
        if (convertAnnotation != null) {
            if (convertAnnotation instanceof ConvertAnnotationImpl) {
                return ((ConvertAnnotationImpl)convertAnnotation).getConverter();
            }
            return converterManager.getConverterInstance(convertAnnotation.value());
        }
        return null;
    }

    @NotNull
    public final DomElement getProxy() {
        DomElement proxy = this.myProxy;
        if (proxy == null) {
            Class[] classArray;
            Class<?> rawType = this.getRawType();
            Class<Object> implementation = this.myManager.getApplicationComponent().getImplementation(rawType);
            boolean isInterface = rawType.isInterface();
            if (implementation == null && !isInterface) {
                implementation = rawType;
            }
            if (isInterface) {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = rawType;
            } else {
                classArray = ArrayUtil.EMPTY_CLASS_ARRAY;
            }
            this.myProxy = proxy = (DomElement)AdvancedProxy.createProxy((InvocationHandler)this, implementation, (Class[])classArray);
        }
        DomElement domElement = proxy;
        if (domElement == null) {
            DomInvocationHandler.$$$reportNull$$$0(9);
        }
        return domElement;
    }

    @NotNull
    public final XmlFile getFile() {
        XmlFile xmlFile = this.getParentStrategy().getContainingFile(this);
        if (xmlFile == null) {
            DomInvocationHandler.$$$reportNull$$$0(10);
        }
        return xmlFile;
    }

    @NotNull
    public DomNameStrategy getNameStrategy() {
        Class<?> rawType = this.getRawType();
        DomNameStrategy strategy = DomImplUtil.getDomNameStrategy(rawType, this.isAttribute());
        if (strategy != null) {
            DomNameStrategy domNameStrategy = strategy;
            if (domNameStrategy == null) {
                DomInvocationHandler.$$$reportNull$$$0(11);
            }
            return domNameStrategy;
        }
        DomInvocationHandler handler = this.getParentHandler();
        DomNameStrategy domNameStrategy = handler == null ? DomNameStrategy.HYPHEN_STRATEGY : handler.getNameStrategy();
        if (domNameStrategy == null) {
            DomInvocationHandler.$$$reportNull$$$0(12);
        }
        return domNameStrategy;
    }

    protected boolean isAttribute() {
        return false;
    }

    @NotNull
    public ElementPresentation getPresentation() {
        ElementPresentationTemplate template = this.getChildDescription().getPresentationTemplate();
        if (template != null) {
            ElementPresentation elementPresentation = template.createPresentation(this.getProxy());
            if (elementPresentation == null) {
                DomInvocationHandler.$$$reportNull$$$0(13);
            }
            return elementPresentation;
        }
        return new ElementPresentation(){

            public String getElementName() {
                return ElementPresentationManager.getElementName((Object)DomInvocationHandler.this.getProxy());
            }

            public String getTypeName() {
                return ElementPresentationManager.getTypeNameForObject((Object)DomInvocationHandler.this.getProxy());
            }

            public Icon getIcon() {
                return ElementPresentationManager.getIconOld((Object)DomInvocationHandler.this.getProxy());
            }
        };
    }

    public final GlobalSearchScope getResolveScope() {
        return DomUtil.getFile((DomElement)this).getResolveScope();
    }

    private static <T extends DomElement> T _getParentOfType(Class<T> requiredClass, DomElement element) {
        while (element != null && !requiredClass.isInstance(element)) {
            element = element.getParent();
        }
        return (T)element;
    }

    public final <T extends DomElement> T getParentOfType(Class<T> requiredClass, boolean strict) {
        return DomInvocationHandler._getParentOfType(requiredClass, strict ? this.getParent() : this.getProxy());
    }

    @NotNull
    final DomInvocationHandler getFixedChild(Pair<? extends FixedChildDescriptionImpl, Integer> info) {
        List<XmlTag> tags;
        FixedChildDescriptionImpl description = (FixedChildDescriptionImpl)info.first;
        XmlName xmlName = description.getXmlName();
        EvaluatedXmlName evaluatedXmlName = this.createEvaluatedXmlName(xmlName);
        if (this.myStub != null && description.isStubbed()) {
            List<DomStub> stubs = this.myStub.getChildrenByName(xmlName);
            DomStub stub = stubs.isEmpty() ? null : stubs.get(0);
            StubParentStrategy strategy = stub == null ? new StubParentStrategy.Empty(this.myStub) : new StubParentStrategy(stub);
            return new IndexedElementInvocationHandler(evaluatedXmlName, description, 0, strategy, this.myManager, (ElementStub)stub);
        }
        XmlTag tag = this.getXmlTag();
        int index = (Integer)info.second;
        if (tag != null && (tags = DomImplUtil.findSubTags(tag.getSubTags(), evaluatedXmlName, this.getFile())).size() > index) {
            XmlTag child = tags.get(index);
            DomInvocationHandler handler = this.myManager.getDomHandler((XmlElement)child);
            if (!(handler instanceof IndexedElementInvocationHandler)) {
                DomInvocationHandler take2 = this.myManager.getDomHandler((XmlElement)child);
                throw new AssertionError((Object)("Expected indexed DOM, but got " + handler + ". Parent=" + tag + "; child=" + child + "; index=" + index + "; second attempt=" + take2));
            }
            DomInvocationHandler domInvocationHandler = handler;
            if (domInvocationHandler == null) {
                DomInvocationHandler.$$$reportNull$$$0(14);
            }
            return domInvocationHandler;
        }
        return new IndexedElementInvocationHandler(evaluatedXmlName, description, index, new VirtualDomParentStrategy(this), this.myManager, null);
    }

    @NotNull
    final DomInvocationHandler getAttributeChild(AttributeChildDescriptionImpl description) {
        EvaluatedXmlName evaluatedXmlName = this.createEvaluatedXmlName(description.getXmlName());
        if (this.myStub != null && description.isStubbed()) {
            AttributeStub stub = this.myStub.getAttributeStub(description.getXmlName());
            StubParentStrategy strategy = StubParentStrategy.createAttributeStrategy(stub, this.myStub);
            return new AttributeChildInvocationHandler(evaluatedXmlName, description, this.myManager, strategy, stub);
        }
        XmlTag tag = this.getXmlTag();
        if (tag != null) {
            String ns = evaluatedXmlName.getNamespace((XmlElement)tag, this.getFile());
            XmlAttribute attribute = tag.getAttribute(description.getXmlName().getLocalName(), ns.equals(tag.getNamespace()) ? null : ns);
            if (attribute != null) {
                PsiUtilCore.ensureValid((PsiElement)attribute);
                DomInvocationHandler handler = this.myManager.getDomHandler((XmlElement)attribute);
                if (!(handler instanceof AttributeChildInvocationHandler)) {
                    throw new AssertionError((Object)("Expected indexed DOM, but got " + handler + "; ns=" + ns + "; description=" + description + "; attribute=" + attribute.getName() + "; XML consistent=" + (PhysicalDomParentStrategy.getParentTag((XmlElement)attribute) == tag) + "; DOM consistent =" + this.equals((Object)DomCreator.getParentDom(tag)) + "; re-creation=" + DomCreator.createAttributeHandler(attribute)));
                }
                DomInvocationHandler domInvocationHandler = handler;
                if (domInvocationHandler == null) {
                    DomInvocationHandler.$$$reportNull$$$0(15);
                }
                return domInvocationHandler;
            }
        }
        return new AttributeChildInvocationHandler(evaluatedXmlName, description, this.myManager, new VirtualDomParentStrategy(this), null);
    }

    @Nullable
    public final Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Invocation invocation = this.findInvocation(method);
            Object r = invocation.invoke(this, args);
            FlakyTestLogger log = FlakyTestLogger.get();
            if (log != null && method.getName().equals("exists")) {
                log.append("Invocation: for '" + method + "' is '" + invocation + " of " + invocation.getClass() + "' handler = '" + this + " of " + ((Object)((Object)this)).getClass() + "' r = " + r + " of " + ObjectUtils.doIfNotNull((Object)r, Object::getClass));
                if (this instanceof IndexedElementInvocationHandler) {
                    log.append(((IndexedElementInvocationHandler)this).created);
                }
            }
            return r;
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
    }

    @NotNull
    private Invocation findInvocation(Method method) {
        Invocation invocation = (Invocation)this.myAccessorInvocations.get((Object)method);
        if (invocation != null) {
            Invocation invocation2 = invocation;
            if (invocation2 == null) {
                DomInvocationHandler.$$$reportNull$$$0(16);
            }
            return invocation2;
        }
        invocation = this.myInvocationCache.getInvocation(method);
        if (invocation != null) {
            Invocation invocation3 = invocation;
            if (invocation3 == null) {
                DomInvocationHandler.$$$reportNull$$$0(17);
            }
            return invocation3;
        }
        invocation = this.createAccessorInvocation(method);
        this.myAccessorInvocations = this.myAccessorInvocations.plus((Object)method, (Object)invocation);
        Invocation invocation4 = invocation;
        if (invocation4 == null) {
            DomInvocationHandler.$$$reportNull$$$0(18);
        }
        return invocation4;
    }

    @NotNull
    private Invocation createAccessorInvocation(Method method) {
        Invocation invocation;
        JavaMethod javaMethod = this.myInvocationCache.getInternedMethod(method);
        if (this.myInvocationCache.isTagValueGetter(javaMethod)) {
            invocation = new GetInvocation(this.createConverter(javaMethod));
        } else if (this.myInvocationCache.isTagValueSetter(javaMethod)) {
            invocation = new SetInvocation(this.createConverter(javaMethod));
        } else {
            throw new RuntimeException("No implementation for method " + method.toString() + " in class " + this.myType);
        }
        GetInvocation getInvocation = invocation;
        if (getInvocation == null) {
            DomInvocationHandler.$$$reportNull$$$0(19);
        }
        return getInvocation;
    }

    private static void setTagValue(XmlTag tag, String value) {
        tag.getValue().setText(value);
    }

    private static String getTagValue(XmlTag tag) {
        return tag.getValue().getTrimmedText();
    }

    public final String toString() {
        if (ReflectionUtil.isAssignable(GenericValue.class, this.getRawType())) {
            return ((GenericValue)this.getProxy()).getStringValue();
        }
        return this.myType.toString() + " @" + this.hashCode();
    }

    public final Class<?> getRawType() {
        return ReflectionUtil.getRawType((Type)this.myType);
    }

    @Nullable
    public XmlTag getXmlTag() {
        return (XmlTag)this.getXmlElement();
    }

    @Nullable
    protected XmlElement recomputeXmlElement(@NotNull DomInvocationHandler parentHandler) {
        if (parentHandler == null) {
            DomInvocationHandler.$$$reportNull$$$0(20);
        }
        return null;
    }

    protected final void detach() {
        this.setXmlElement(null);
    }

    protected final void setXmlElement(XmlElement element) {
        this.refreshGenericInfo(element != null && !this.isAttribute());
        this.myStub = null;
        this.myParentStrategy = element == null ? this.myParentStrategy.clearXmlElement() : this.myParentStrategy.setXmlElement(element);
    }

    private void refreshGenericInfo(boolean dynamic) {
        StaticGenericInfo staticInfo = this.myManager.getApplicationComponent().getStaticGenericInfo(this.myType);
        this.myGenericInfo = dynamic ? new DynamicGenericInfo(this, staticInfo) : staticInfo;
    }

    @NotNull
    public final DomManagerImpl getManager() {
        DomManagerImpl domManagerImpl = this.myManager;
        if (domManagerImpl == null) {
            DomInvocationHandler.$$$reportNull$$$0(21);
        }
        return domManagerImpl;
    }

    public final DomElement addCollectionChild(CollectionChildDescriptionImpl description, Type type, int index) throws IncorrectOperationException {
        EvaluatedXmlName name = this.createEvaluatedXmlName(description.getXmlName());
        XmlTag tag = this.addEmptyTag(name, index);
        CollectionElementInvocationHandler handler = new CollectionElementInvocationHandler(type, tag, description, this, null);
        this.myManager.fireEvent(new DomEvent(this.getProxy(), false));
        this.getManager().getTypeChooserManager().getTypeChooser(description.getType()).distinguishTag(tag, type);
        handler.addRequiredChildren();
        return handler.getProxy();
    }

    protected final void createFixedChildrenTags(EvaluatedXmlName tagName, FixedChildDescriptionImpl description, int count) {
        XmlTag tag = this.ensureTagExists();
        List<XmlTag> subTags = DomImplUtil.findSubTags(tag, tagName, this.getFile());
        if (subTags.size() < count) {
            this.getFixedChild((Pair<? extends FixedChildDescriptionImpl, Integer>)Pair.create((Object)description, (Object)(count - 1))).ensureTagExists();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XmlTag addEmptyTag(EvaluatedXmlName tagName, int index) throws IncorrectOperationException {
        XmlTag tag = this.ensureTagExists();
        List<XmlTag> subTags = DomImplUtil.findSubTags(tag, tagName, this.getFile());
        if (subTags.size() < index) {
            index = subTags.size();
        }
        boolean changing = this.myManager.setChanging(true);
        try {
            XmlTag newTag = this.createChildTag(tagName);
            if (index == 0) {
                if (subTags.isEmpty()) {
                    XmlTag xmlTag = (XmlTag)tag.add((PsiElement)newTag);
                    return xmlTag;
                }
                XmlTag xmlTag = (XmlTag)tag.addBefore((PsiElement)newTag, (PsiElement)subTags.get(0));
                return xmlTag;
            }
            XmlTag xmlTag = (XmlTag)tag.addAfter((PsiElement)newTag, (PsiElement)subTags.get(index - 1));
            return xmlTag;
        }
        finally {
            this.myManager.setChanging(changing);
        }
    }

    @NotNull
    public final EvaluatedXmlName createEvaluatedXmlName(XmlName xmlName) {
        EvaluatedXmlName evaluatedXmlName = this.getXmlName().evaluateChildName(xmlName);
        if (evaluatedXmlName == null) {
            DomInvocationHandler.$$$reportNull$$$0(22);
        }
        return evaluatedXmlName;
    }

    public List<? extends DomElement> getCollectionChildren(AbstractCollectionChildDescription description) {
        return this.getCollectionChildren(description, XmlStubBasedTagBase.shouldProcessIncludesNow());
    }

    public List<? extends DomElement> getCollectionChildren(AbstractCollectionChildDescription description, boolean processIncludes) {
        XmlTag tag;
        if (this.myStub != null && description.isStubbed()) {
            if (description instanceof DomChildDescriptionImpl) {
                XmlName xmlName = ((DomChildDescriptionImpl)((Object)description)).getXmlName();
                SmartList result = new SmartList();
                List stubs = this.myStub.getChildrenStubs();
                for (Stub stub2 : stubs) {
                    if (stub2 instanceof DomStub && ((DomStub)stub2).matches(xmlName)) {
                        result.add((Object)((DomStub)stub2).getOrCreateHandler((DomChildDescriptionImpl)((Object)description), this.myManager).getProxy());
                        continue;
                    }
                    if (!processIncludes || !(stub2 instanceof XIncludeStub)) continue;
                    ((XIncludeStub)stub2).resolve(this, (List<DomElement>)result, xmlName);
                }
                return result;
            }
            if (description instanceof CustomDomChildrenDescriptionImpl) {
                List stubs = this.myStub.getChildrenStubs();
                return ContainerUtil.mapNotNull((Collection)stubs, (Function)((NullableFunction)stub -> {
                    if (stub instanceof ElementStub && ((ElementStub)((Object)stub)).isCustom()) {
                        DummyEvaluatedXmlName name = new DummyEvaluatedXmlName(((ElementStub)((Object)stub)).getName(), "");
                        return new CollectionElementInvocationHandler((EvaluatedXmlName)name, (CustomDomChildrenDescriptionImpl)description, this.myManager, (ElementStub)((Object)stub)).getProxy();
                    }
                    return null;
                }));
            }
        }
        if ((tag = this.getXmlTag()) == null) {
            return Collections.emptyList();
        }
        List<XmlTag> subTags = this.getCollectionSubTags(description, tag, processIncludes);
        if (subTags.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DomElement> elements = new ArrayList<DomElement>(subTags.size());
        for (XmlTag subTag : subTags) {
            DomInvocationHandler handler = this.myManager.getDomHandler((XmlElement)subTag);
            if (handler == null) {
                String msg = "No child for subTag '" + subTag.getName() + "' in tag '" + tag.getName() + "'; subtag count=" + subTags.size() + ", description=" + description + ", subtag.class=" + subTag.getClass().getName();
                DomInvocationHandler anyDom = this.myManager.getDomHandler((XmlElement)subTag);
                if (anyDom != null) {
                    msg = msg + "\n sub-dom=" + anyDom + " with " + anyDom.getChildDescription();
                }
                throw new AssertionError((Object)msg);
            }
            elements.add(handler.getProxy());
        }
        return Collections.unmodifiableList(elements);
    }

    private List<XmlTag> getCollectionSubTags(@NotNull AbstractCollectionChildDescription description, @NotNull XmlTag tag, boolean processIncludes) {
        if (description == null) {
            DomInvocationHandler.$$$reportNull$$$0(23);
        }
        if (tag == null) {
            DomInvocationHandler.$$$reportNull$$$0(24);
        }
        if (description instanceof CollectionChildDescriptionImpl) {
            return ((CollectionChildDescriptionImpl)description).getCollectionSubTags(this, tag, processIncludes);
        }
        return DomImplUtil.getCustomSubTags(this, tag.getSubTags(), this.getFile());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !o.getClass().equals(((Object)((Object)this)).getClass())) {
            return false;
        }
        DomInvocationHandler that = (DomInvocationHandler)((Object)o);
        if (!this.myChildDescription.equals(that.myChildDescription)) {
            return false;
        }
        return this.getParentStrategy().equals(that.getParentStrategy());
    }

    public int hashCode() {
        return this.myChildDescription.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nominalType";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/impl/DomInvocationHandler";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentHandler";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/impl/DomInvocationHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDomElementType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getXmlElementNamespace";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getXmlElementName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getXmlName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getScalarConverter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createConverter";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProxy";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameStrategy";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixedChild";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeChild";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findInvocation";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createAccessorInvocation";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getManager";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createEvaluatedXmlName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "narrowType";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "recomputeXmlElement";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getCollectionSubTags";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class StableCopyFactory<T extends DomElement>
    implements NullableFactory<T> {
        private final SmartPsiElementPointer<? extends XmlTag> myPointer;
        private final Type myType;
        private final Class<? extends DomInvocationHandler> myHandlerClass;

        StableCopyFactory(SmartPsiElementPointer<? extends XmlTag> pointer, Type type, Class<? extends DomInvocationHandler> aClass) {
            this.myPointer = pointer;
            this.myType = type;
            this.myHandlerClass = aClass;
        }

        public T create() {
            XmlTag tag = (XmlTag)this.myPointer.getElement();
            if (tag == null || !tag.isValid()) {
                return null;
            }
            DomElement element = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag);
            if (element == null || !element.getDomElementType().equals(this.myType)) {
                return null;
            }
            DomInvocationHandler handler = DomManagerImpl.getDomInvocationHandler(element);
            if (handler == null || !((Object)((Object)handler)).getClass().equals(this.myHandlerClass)) {
                return null;
            }
            return (T)element;
        }
    }
}

