/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NavigationGutterIconRenderer
extends GutterIconRenderer
implements GutterIconNavigationHandler<PsiElement>,
DumbAware {
    protected final @NlsContexts.PopupTitle String myPopupTitle;
    private final @NlsContexts.PopupContent String myEmptyText;
    protected final Computable<? extends PsiElementListCellRenderer> myCellRenderer;
    private final NotNullLazyValue<? extends List<SmartPsiElementPointer<?>>> myPointers;
    private final boolean myComputeTargetsInBackground;

    protected NavigationGutterIconRenderer(@NlsContexts.PopupTitle String popupTitle, @NlsContexts.PopupContent String emptyText, @NotNull Computable<? extends PsiElementListCellRenderer<?>> cellRenderer, @NotNull NotNullLazyValue<? extends List<SmartPsiElementPointer<?>>> pointers) {
        if (cellRenderer == null) {
            NavigationGutterIconRenderer.$$$reportNull$$$0(0);
        }
        if (pointers == null) {
            NavigationGutterIconRenderer.$$$reportNull$$$0(1);
        }
        this(popupTitle, emptyText, cellRenderer, pointers, true);
    }

    protected NavigationGutterIconRenderer(@NlsContexts.PopupTitle String popupTitle, @NlsContexts.PopupContent String emptyText, Computable<? extends PsiElementListCellRenderer> cellRenderer, NotNullLazyValue<? extends List<SmartPsiElementPointer<?>>> pointers, boolean computeTargetsInBackground) {
        this.myPopupTitle = popupTitle;
        this.myEmptyText = emptyText;
        this.myCellRenderer = cellRenderer;
        this.myPointers = pointers;
        this.myComputeTargetsInBackground = computeTargetsInBackground;
    }

    public boolean isNavigateAction() {
        return true;
    }

    @NotNull
    public List<PsiElement> getTargetElements() {
        List pointers = (List)this.myPointers.getValue();
        if (pointers.isEmpty()) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                NavigationGutterIconRenderer.$$$reportNull$$$0(2);
            }
            return list;
        }
        Project project = ((SmartPsiElementPointer)pointers.get(0)).getProject();
        DumbService dumbService = DumbService.getInstance((Project)project);
        List list = (List)dumbService.computeWithAlternativeResolveEnabled(() -> ContainerUtil.mapNotNull((Collection)pointers, smartPsiElementPointer -> smartPsiElementPointer.getElement()));
        if (list == null) {
            NavigationGutterIconRenderer.$$$reportNull$$$0(3);
        }
        return list;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        NavigationGutterIconRenderer renderer = (NavigationGutterIconRenderer)((Object)o);
        if (this.myEmptyText != null ? !this.myEmptyText.equals(renderer.myEmptyText) : renderer.myEmptyText != null) {
            return false;
        }
        if (!((List)this.myPointers.getValue()).equals(renderer.myPointers.getValue())) {
            return false;
        }
        return !(this.myPopupTitle != null ? !this.myPopupTitle.equals(renderer.myPopupTitle) : renderer.myPopupTitle != null);
    }

    public int hashCode() {
        int result = this.myPopupTitle != null ? this.myPopupTitle.hashCode() : 0;
        result = 31 * result + (this.myEmptyText != null ? this.myEmptyText.hashCode() : 0);
        result = 31 * result + ((List)this.myPointers.getValue()).hashCode();
        return result;
    }

    @Nullable
    public AnAction getClickAction() {
        return new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                NavigationGutterIconRenderer.this.navigate((MouseEvent)e.getInputEvent(), null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/navigation/NavigationGutterIconRenderer$1", "actionPerformed"));
            }
        };
    }

    public void navigate(@Nullable MouseEvent event, @Nullable PsiElement elt) {
        if (event != null && this.myComputeTargetsInBackground && event.getComponent() != null) {
            this.navigateTargetsAsync(event);
        } else {
            this.navigateTargets(event, this.getTargetElements());
        }
    }

    private void navigateTargetsAsync(@NotNull MouseEvent event) {
        Component component;
        if (event == null) {
            NavigationGutterIconRenderer.$$$reportNull$$$0(4);
        }
        Runnable loadingRemover = (component = event.getComponent()) instanceof EditorGutterComponentEx ? ((EditorGutterComponentEx)component).setLoadingIconForCurrentGutterMark() : null;
        AppExecutorUtil.getAppExecutorService().execute(() -> ProgressManager.getInstance().computePrioritized(() -> {
            ProgressManager.getInstance().executeProcessUnderProgress(() -> {
                Ref targets = Ref.create();
                boolean success = ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> targets.set(this.getTargetElements()));
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (loadingRemover != null) {
                        loadingRemover.run();
                    }
                    if (success) {
                        this.navigateTargets(event, (List)targets.get());
                    }
                });
            }, (ProgressIndicator)new EmptyProgressIndicator());
            return null;
        }));
    }

    private void navigateTargets(@Nullable MouseEvent event, List<PsiElement> targets) {
        if (targets.isEmpty()) {
            if (this.myEmptyText != null && event != null) {
                JComponent label = HintUtil.createErrorLabel((String)this.myEmptyText);
                label.setBorder((Border)JBUI.Borders.empty((int)2, (int)7));
                JBPopupFactory.getInstance().createBalloonBuilder(label).setFadeoutTime(3000L).setFillColor(HintUtil.getErrorColor()).createBalloon().show(new RelativePoint(event), Balloon.Position.above);
            }
        } else {
            this.navigateToItems(event);
        }
    }

    protected void navigateToItems(@Nullable MouseEvent event) {
        ArrayList navigatables = new ArrayList();
        for (SmartPsiElementPointer pointer : (List)this.myPointers.getValue()) {
            ContainerUtil.addIfNotNull(navigatables, (Object)NavigationGutterIconRenderer.getNavigatable(pointer));
        }
        if (navigatables.size() == 1) {
            ((Navigatable)navigatables.get(0)).navigate(true);
        } else if (event != null) {
            PsiElement[] elements = PsiUtilCore.toPsiElementArray(this.getTargetElements());
            JBPopup popup = NavigationUtil.getPsiElementPopup((PsiElement[])elements, (PsiElementListCellRenderer)((PsiElementListCellRenderer)this.myCellRenderer.compute()), (String)this.myPopupTitle);
            popup.show(new RelativePoint(event));
        }
    }

    @Nullable
    private static Navigatable getNavigatable(SmartPsiElementPointer<?> pointer) {
        Navigatable element = NavigationGutterIconRenderer.getNavigationElement(pointer);
        if (element != null) {
            return element;
        }
        VirtualFile virtualFile = pointer.getVirtualFile();
        Segment actualRange = pointer.getRange();
        if (virtualFile != null && actualRange != null && virtualFile.isValid() && actualRange.getStartOffset() >= 0) {
            return new OpenFileDescriptor(pointer.getProject(), virtualFile, actualRange.getStartOffset());
        }
        return null;
    }

    @Nullable
    private static Navigatable getNavigationElement(SmartPsiElementPointer<?> pointer) {
        PsiElement element = pointer.getElement();
        if (element == null) {
            return null;
        }
        PsiElement navigationElement = element.getNavigationElement();
        return navigationElement instanceof Navigatable ? (Navigatable)navigationElement : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellRenderer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointers";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/navigation/NavigationGutterIconRenderer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/navigation/NavigationGutterIconRenderer";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "navigateTargetsAsync";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

