/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.navigation.DomGotoRelatedItem;
import com.intellij.codeInsight.navigation.NavigationGutterIconRenderer;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NotNullFactory;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavigationGutterIconBuilder<T> {
    @NonNls
    private static final String PATTERN = "&nbsp;&nbsp;&nbsp;&nbsp;{0}";
    protected static final NotNullFunction<PsiElement, Collection<? extends PsiElement>> DEFAULT_PSI_CONVERTOR = ContainerUtil::createMaybeSingletonList;
    protected final Icon myIcon;
    private final NotNullFunction<? super T, ? extends Collection<? extends PsiElement>> myConverter;
    protected NotNullLazyValue<Collection<? extends T>> myTargets;
    protected boolean myLazy;
    protected @NlsContexts.Tooltip String myTooltipText;
    protected @NlsContexts.PopupTitle String myPopupTitle;
    protected @NlsContexts.PopupContent String myEmptyText;
    protected @NlsContexts.PopupTitle String myTooltipTitle;
    protected GutterIconRenderer.Alignment myAlignment;
    private Computable<PsiElementListCellRenderer<?>> myCellRenderer;
    @NotNull
    private NullableFunction<? super T, String> myNamer;
    private final NotNullFunction<? super T, ? extends Collection<? extends GotoRelatedItem>> myGotoRelatedItemProvider;
    public static final NotNullFunction<DomElement, Collection<? extends PsiElement>> DEFAULT_DOM_CONVERTOR = o -> ContainerUtil.createMaybeSingletonList((Object)o.getXmlElement());
    public static final NotNullFunction<DomElement, Collection<? extends GotoRelatedItem>> DOM_GOTO_RELATED_ITEM_PROVIDER = dom -> {
        if (dom.getXmlElement() != null) {
            return Collections.singletonList(new DomGotoRelatedItem(dom));
        }
        return Collections.emptyList();
    };
    protected static final NotNullFunction<PsiElement, Collection<? extends GotoRelatedItem>> PSI_GOTO_RELATED_ITEM_PROVIDER = dom -> Collections.singletonList(new GotoRelatedItem(dom, InspectionsBundle.message((String)"xml.goto.group", (Object[])new Object[0])));

    protected NavigationGutterIconBuilder(@NotNull Icon icon, @NotNull NotNullFunction<? super T, ? extends Collection<? extends PsiElement>> converter) {
        if (icon == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(0);
        }
        if (converter == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(1);
        }
        this(icon, converter, null);
    }

    protected NavigationGutterIconBuilder(@NotNull Icon icon, @NotNull NotNullFunction<? super T, ? extends Collection<? extends PsiElement>> converter, @Nullable NotNullFunction<? super T, ? extends Collection<? extends GotoRelatedItem>> gotoRelatedItemProvider) {
        if (icon == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(2);
        }
        if (converter == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(3);
        }
        this.myAlignment = GutterIconRenderer.Alignment.CENTER;
        this.myNamer = ElementPresentationManager.namer();
        this.myIcon = icon;
        this.myConverter = converter;
        this.myGotoRelatedItemProvider = gotoRelatedItemProvider;
    }

    @NotNull
    public static NavigationGutterIconBuilder<PsiElement> create(@NotNull Icon icon) {
        if (icon == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(4);
        }
        return NavigationGutterIconBuilder.create(icon, DEFAULT_PSI_CONVERTOR, PSI_GOTO_RELATED_ITEM_PROVIDER);
    }

    @NotNull
    public static <T> NavigationGutterIconBuilder<T> create(@NotNull Icon icon, @NotNull NotNullFunction<? super T, ? extends Collection<? extends PsiElement>> converter) {
        if (icon == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(5);
        }
        if (converter == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(6);
        }
        return NavigationGutterIconBuilder.create(icon, converter, null);
    }

    @NotNull
    public static <T> NavigationGutterIconBuilder<T> create(@NotNull Icon icon, @NotNull NotNullFunction<? super T, ? extends Collection<? extends PsiElement>> converter, @Nullable NotNullFunction<? super T, ? extends Collection<? extends GotoRelatedItem>> gotoRelatedItemProvider) {
        if (icon == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(7);
        }
        if (converter == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(8);
        }
        return new NavigationGutterIconBuilder<T>(icon, converter, gotoRelatedItemProvider);
    }

    @NotNull
    public NavigationGutterIconBuilder<T> setTarget(@Nullable T target) {
        NavigationGutterIconBuilder<T> navigationGutterIconBuilder = this.setTargets(ContainerUtil.createMaybeSingletonList(target));
        if (navigationGutterIconBuilder == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(9);
        }
        return navigationGutterIconBuilder;
    }

    @SafeVarargs
    @NotNull
    public final NavigationGutterIconBuilder<T> setTargets(T ... targets) {
        if (targets == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(10);
        }
        NavigationGutterIconBuilder<T> navigationGutterIconBuilder = this.setTargets((Collection<? extends T>)Arrays.asList(targets));
        if (navigationGutterIconBuilder == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(11);
        }
        return navigationGutterIconBuilder;
    }

    @NotNull
    public NavigationGutterIconBuilder<T> setTargets(@NotNull NotNullLazyValue<Collection<? extends T>> targets) {
        if (targets == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(12);
        }
        this.myTargets = targets;
        this.myLazy = true;
        NavigationGutterIconBuilder navigationGutterIconBuilder = this;
        if (navigationGutterIconBuilder == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(13);
        }
        return navigationGutterIconBuilder;
    }

    @NotNull
    public NavigationGutterIconBuilder<T> setTargets(@NotNull Collection<? extends T> targets) {
        if (targets == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(14);
        }
        if (ContainerUtil.containsIdentity(targets, null)) {
            throw new IllegalArgumentException("Must not pass collection with null target but got: " + targets);
        }
        this.myTargets = NotNullLazyValue.createConstantValue(targets);
        NavigationGutterIconBuilder navigationGutterIconBuilder = this;
        if (navigationGutterIconBuilder == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(15);
        }
        return navigationGutterIconBuilder;
    }

    @NotNull
    public NavigationGutterIconBuilder<T> setTooltipText(@NotNull @NlsContexts.Tooltip String tooltipText) {
        if (tooltipText == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(16);
        }
        this.myTooltipText = tooltipText;
        NavigationGutterIconBuilder navigationGutterIconBuilder = this;
        if (navigationGutterIconBuilder == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(17);
        }
        return navigationGutterIconBuilder;
    }

    @NotNull
    public NavigationGutterIconBuilder<T> setAlignment(@NotNull GutterIconRenderer.Alignment alignment) {
        if (alignment == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(18);
        }
        this.myAlignment = alignment;
        NavigationGutterIconBuilder navigationGutterIconBuilder = this;
        if (navigationGutterIconBuilder == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(19);
        }
        return navigationGutterIconBuilder;
    }

    @NotNull
    public NavigationGutterIconBuilder<T> setPopupTitle(@NotNull @NlsContexts.PopupTitle String popupTitle) {
        if (popupTitle == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(20);
        }
        this.myPopupTitle = popupTitle;
        NavigationGutterIconBuilder navigationGutterIconBuilder = this;
        if (navigationGutterIconBuilder == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(21);
        }
        return navigationGutterIconBuilder;
    }

    @NotNull
    public NavigationGutterIconBuilder<T> setEmptyPopupText(@NotNull @NlsContexts.PopupContent String emptyText) {
        if (emptyText == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(22);
        }
        this.myEmptyText = emptyText;
        NavigationGutterIconBuilder navigationGutterIconBuilder = this;
        if (navigationGutterIconBuilder == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(23);
        }
        return navigationGutterIconBuilder;
    }

    @NotNull
    public NavigationGutterIconBuilder<T> setTooltipTitle(@NotNull @NlsContexts.PopupTitle String tooltipTitle) {
        if (tooltipTitle == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(24);
        }
        this.myTooltipTitle = tooltipTitle;
        NavigationGutterIconBuilder navigationGutterIconBuilder = this;
        if (navigationGutterIconBuilder == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(25);
        }
        return navigationGutterIconBuilder;
    }

    @NotNull
    public NavigationGutterIconBuilder<T> setNamer(@NotNull NullableFunction<? super T, String> namer) {
        if (namer == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(26);
        }
        this.myNamer = namer;
        NavigationGutterIconBuilder navigationGutterIconBuilder = this;
        if (navigationGutterIconBuilder == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(27);
        }
        return navigationGutterIconBuilder;
    }

    @NotNull
    public NavigationGutterIconBuilder<T> setCellRenderer(@NotNull PsiElementListCellRenderer cellRenderer) {
        if (cellRenderer == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(28);
        }
        this.myCellRenderer = new Computable.PredefinedValueComputable((Object)cellRenderer);
        NavigationGutterIconBuilder navigationGutterIconBuilder = this;
        if (navigationGutterIconBuilder == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(29);
        }
        return navigationGutterIconBuilder;
    }

    @Nullable
    public Annotation install(@NotNull DomElementAnnotationHolder holder, @Nullable DomElement element) {
        if (holder == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(30);
        }
        if (!this.myLazy && ((Collection)this.myTargets.getValue()).isEmpty() || element == null) {
            return null;
        }
        return this.doInstall(holder.createAnnotation(element, HighlightSeverity.INFORMATION, null), element.getManager().getProject());
    }

    @Deprecated
    @Nullable
    public Annotation install(@NotNull AnnotationHolder holder, @Nullable PsiElement element) {
        if (holder == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(31);
        }
        if (!this.myLazy && ((Collection)this.myTargets.getValue()).isEmpty() || element == null) {
            return null;
        }
        return this.doInstall(holder.createInfoAnnotation(element, null), element.getProject());
    }

    public void createGutterIcon(@NotNull AnnotationHolder holder, @Nullable PsiElement element) {
        if (holder == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(32);
        }
        if (!this.myLazy && ((Collection)this.myTargets.getValue()).isEmpty() || element == null) {
            return;
        }
        holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(element).gutterIconRenderer((GutterIconRenderer)this.createGutterIconRenderer(element.getProject())).needsUpdateOnTyping(false).create();
    }

    @NotNull
    private Annotation doInstall(@NotNull Annotation annotation, @NotNull Project project) {
        if (annotation == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(33);
        }
        if (project == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(34);
        }
        NavigationGutterIconRenderer renderer = this.createGutterIconRenderer(project);
        annotation.setGutterIconRenderer((GutterIconRenderer)renderer);
        annotation.setNeedsUpdateOnTyping(false);
        Annotation annotation2 = annotation;
        if (annotation2 == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(35);
        }
        return annotation2;
    }

    @NotNull
    public RelatedItemLineMarkerInfo<PsiElement> createLineMarkerInfo(@NotNull PsiElement element) {
        NavigationGutterIconRenderer renderer;
        if (element == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(36);
        }
        RelatedItemLineMarkerInfo<PsiElement> relatedItemLineMarkerInfo = this.createLineMarkerInfo(element, (renderer = this.createGutterIconRenderer(element.getProject())).isNavigateAction() ? renderer : null);
        if (relatedItemLineMarkerInfo == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(37);
        }
        return relatedItemLineMarkerInfo;
    }

    @NotNull
    public RelatedItemLineMarkerInfo<PsiElement> createLineMarkerInfo(@NotNull PsiElement element, @Nullable GutterIconNavigationHandler<PsiElement> navigationHandler) {
        if (element == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(38);
        }
        NavigationGutterIconRenderer renderer = this.createGutterIconRenderer(element.getProject());
        String tooltip = renderer.getTooltipText();
        return new RelatedItemLineMarkerInfo(element, element.getTextRange(), renderer.getIcon(), (Function)(tooltip == null ? null : new ConstantFunction((Object)tooltip)), navigationHandler, renderer.getAlignment(), () -> this.computeGotoTargets());
    }

    @NotNull
    protected Collection<GotoRelatedItem> computeGotoTargets() {
        if (this.myTargets == null || this.myGotoRelatedItemProvider == null) {
            List<GotoRelatedItem> list = Collections.emptyList();
            if (list == null) {
                NavigationGutterIconBuilder.$$$reportNull$$$0(39);
            }
            return list;
        }
        NotNullFactory<Collection<? extends T>> factory = NavigationGutterIconBuilder.evaluateAndForget(this.myTargets);
        List list = ContainerUtil.concat((Iterable)((Iterable)factory.create()), this.myGotoRelatedItemProvider);
        if (list == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(40);
        }
        return list;
    }

    private void checkBuilt() {
        assert (this.myTargets != null) : "Must have called .setTargets() before calling create()";
    }

    @NotNull
    private static <T> NotNullFactory<T> evaluateAndForget(@NotNull NotNullLazyValue<T> lazyValue) {
        if (lazyValue == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(41);
        }
        final Ref ref = Ref.create(lazyValue);
        return new NotNullFactory<T>(){
            volatile T value;

            @NotNull
            public T create() {
                Object result = this.value;
                if (result == null) {
                    this.value = result = ((NotNullLazyValue)ref.get()).getValue();
                    ref.set(null);
                }
                Object t = result;
                if (t == null) {
                    1.$$$reportNull$$$0(0);
                }
                return t;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder$1", "create"));
            }
        };
    }

    @NotNull
    protected NavigationGutterIconRenderer createGutterIconRenderer(@NotNull Project project) {
        if (project == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(42);
        }
        this.checkBuilt();
        NotNullFactory<Collection<? extends T>> factory = NavigationGutterIconBuilder.evaluateAndForget(this.myTargets);
        NotNullLazyValue<List<SmartPsiElementPointer<?>>> pointers = NavigationGutterIconBuilder.createPointersThunk(this.myLazy, project, factory, this.myConverter);
        boolean empty = this.isEmpty();
        if (this.myTooltipText == null && !this.myLazy) {
            TreeSet<String> names = new TreeSet<String>();
            for (Object t : (Collection)this.myTargets.getValue()) {
                String text = (String)this.myNamer.fun(t);
                if (text == null) continue;
                names.add(MessageFormat.format(PATTERN, text));
            }
            @Nls StringBuilder sb = new StringBuilder("<html><body>");
            if (this.myTooltipTitle != null) {
                sb.append(this.myTooltipTitle).append("<br>");
            }
            for (String name : names) {
                sb.append(name).append("<br>");
            }
            sb.append("</body></html>");
            this.myTooltipText = sb.toString();
        }
        Computable<PsiElementListCellRenderer<?>> renderer = this.myCellRenderer == null ? DefaultPsiElementCellRenderer::new : this.myCellRenderer;
        NavigationGutterIconRenderer navigationGutterIconRenderer = this.createGutterIconRenderer(pointers, renderer, empty);
        if (navigationGutterIconRenderer == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(43);
        }
        return navigationGutterIconRenderer;
    }

    @NotNull
    protected NavigationGutterIconRenderer createGutterIconRenderer(@NotNull NotNullLazyValue<List<SmartPsiElementPointer<?>>> pointers, @NotNull Computable<PsiElementListCellRenderer<?>> renderer, boolean empty) {
        if (pointers == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(44);
        }
        if (renderer == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(45);
        }
        return new MyNavigationGutterIconRenderer(this, this.myAlignment, this.myIcon, this.myTooltipText, pointers, renderer, empty);
    }

    @NotNull
    protected NavigationGutterIconRenderer createLazyGutterIconRenderer(@NotNull NotNullLazyValue<List<SmartPsiElementPointer<?>>> pointers, @NotNull Computable<PsiElementListCellRenderer<?>> renderer, boolean empty) {
        if (pointers == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(46);
        }
        if (renderer == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(47);
        }
        return new MyNavigationGutterIconRenderer(this, this.myAlignment, this.myIcon, this.myTooltipText, pointers, renderer, empty, true);
    }

    @NotNull
    private static <T> NotNullLazyValue<List<SmartPsiElementPointer<?>>> createPointersThunk(boolean lazy, Project project, NotNullFactory<? extends Collection<? extends T>> targets, NotNullFunction<? super T, ? extends Collection<? extends PsiElement>> converter) {
        if (!lazy) {
            NotNullLazyValue notNullLazyValue = NotNullLazyValue.createConstantValue(NavigationGutterIconBuilder.calcPsiTargets(project, (Collection)targets.create(), converter));
            if (notNullLazyValue == null) {
                NavigationGutterIconBuilder.$$$reportNull$$$0(48);
            }
            return notNullLazyValue;
        }
        NotNullLazyValue notNullLazyValue = NotNullLazyValue.lazy(() -> NavigationGutterIconBuilder.calcPsiTargets(project, (Collection)targets.create(), converter));
        if (notNullLazyValue == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(49);
        }
        return notNullLazyValue;
    }

    @NotNull
    private static <T> List<SmartPsiElementPointer<?>> calcPsiTargets(@NotNull Project project, @NotNull Collection<? extends T> targets, @NotNull NotNullFunction<? super T, ? extends Collection<? extends PsiElement>> converter) {
        if (project == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(50);
        }
        if (targets == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(51);
        }
        if (converter == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(52);
        }
        SmartPointerManager manager = SmartPointerManager.getInstance((Project)project);
        HashSet<PsiElement> elements = new HashSet<PsiElement>();
        ArrayList list = new ArrayList(targets.size());
        for (T target : targets) {
            for (PsiElement psiElement : (Collection)converter.fun(target)) {
                if (psiElement == null) {
                    throw new IllegalArgumentException(converter + " returned null element");
                }
                if (!elements.add(psiElement) || !psiElement.isValid()) continue;
                list.add(manager.createSmartPsiElementPointer(psiElement));
            }
        }
        ArrayList arrayList = list;
        if (arrayList == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(53);
        }
        return arrayList;
    }

    private boolean isEmpty() {
        if (this.myLazy) {
            return false;
        }
        HashSet<PsiElement> elements = new HashSet<PsiElement>();
        Collection targets = (Collection)this.myTargets.getValue();
        for (Object target : targets) {
            for (PsiElement psiElement : (Collection)this.myConverter.fun(target)) {
                if (!elements.add(psiElement)) continue;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 43: 
            case 48: 
            case 49: 
            case 53: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 43: 
            case 48: 
            case 49: 
            case 53: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 43: 
            case 48: 
            case 49: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltipText";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alignment";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupTitle";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyText";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltipTitle";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namer";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellRenderer";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 34: 
            case 42: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lazyValue";
                break;
            }
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointers";
                break;
            }
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "setTarget";
                break;
            }
            case 11: 
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "setTargets";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "setTooltipText";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "setAlignment";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "setPopupTitle";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "setEmptyPopupText";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "setTooltipTitle";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "setNamer";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "setCellRenderer";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "doInstall";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "createLineMarkerInfo";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "computeGotoTargets";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "createGutterIconRenderer";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointersThunk";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "calcPsiTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 43: 
            case 48: 
            case 49: 
            case 53: {
                break;
            }
            case 10: 
            case 12: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setTargets";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setTooltipText";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setAlignment";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setPopupTitle";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setEmptyPopupText";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setTooltipTitle";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setNamer";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setCellRenderer";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createGutterIcon";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "doInstall";
                break;
            }
            case 36: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createLineMarkerInfo";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "evaluateAndForget";
                break;
            }
            case 42: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createGutterIconRenderer";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "createLazyGutterIconRenderer";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "calcPsiTargets";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 43: 
            case 48: 
            case 49: 
            case 53: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyNavigationGutterIconRenderer
    extends NavigationGutterIconRenderer {
        private final GutterIconRenderer.Alignment myAlignment;
        private final Icon myIcon;
        private final @NlsContexts.Tooltip String myTooltipText;
        private final boolean myEmpty;

        MyNavigationGutterIconRenderer(@NotNull NavigationGutterIconBuilder<?> builder, @NotNull GutterIconRenderer.Alignment alignment, Icon icon, @Nullable @NlsContexts.Tooltip String tooltipText, @NotNull NotNullLazyValue<List<SmartPsiElementPointer<?>>> pointers, @NotNull Computable<PsiElementListCellRenderer<?>> cellRenderer, boolean empty) {
            if (builder == null) {
                MyNavigationGutterIconRenderer.$$$reportNull$$$0(0);
            }
            if (alignment == null) {
                MyNavigationGutterIconRenderer.$$$reportNull$$$0(1);
            }
            if (pointers == null) {
                MyNavigationGutterIconRenderer.$$$reportNull$$$0(2);
            }
            if (cellRenderer == null) {
                MyNavigationGutterIconRenderer.$$$reportNull$$$0(3);
            }
            super(builder.myPopupTitle, builder.myEmptyText, cellRenderer, pointers);
            this.myAlignment = alignment;
            this.myIcon = icon;
            this.myTooltipText = tooltipText;
            this.myEmpty = empty;
        }

        MyNavigationGutterIconRenderer(@NotNull NavigationGutterIconBuilder<?> builder, @NotNull GutterIconRenderer.Alignment alignment, Icon icon, @Nullable @NlsContexts.Tooltip String tooltipText, @NotNull NotNullLazyValue<List<SmartPsiElementPointer<?>>> pointers, @NotNull Computable<PsiElementListCellRenderer<?>> cellRenderer, boolean empty, boolean computeTargetsInBackground) {
            if (builder == null) {
                MyNavigationGutterIconRenderer.$$$reportNull$$$0(4);
            }
            if (alignment == null) {
                MyNavigationGutterIconRenderer.$$$reportNull$$$0(5);
            }
            if (pointers == null) {
                MyNavigationGutterIconRenderer.$$$reportNull$$$0(6);
            }
            if (cellRenderer == null) {
                MyNavigationGutterIconRenderer.$$$reportNull$$$0(7);
            }
            super(builder.myPopupTitle, builder.myEmptyText, cellRenderer, pointers, computeTargetsInBackground);
            this.myAlignment = alignment;
            this.myIcon = icon;
            this.myTooltipText = tooltipText;
            this.myEmpty = empty;
        }

        @Override
        public boolean isNavigateAction() {
            return !this.myEmpty;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = this.myIcon;
            if (icon == null) {
                MyNavigationGutterIconRenderer.$$$reportNull$$$0(8);
            }
            return icon;
        }

        @Nullable
        public String getTooltipText() {
            return this.myTooltipText;
        }

        @NotNull
        public GutterIconRenderer.Alignment getAlignment() {
            GutterIconRenderer.Alignment alignment = this.myAlignment;
            if (alignment == null) {
                MyNavigationGutterIconRenderer.$$$reportNull$$$0(9);
            }
            return alignment;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!super.equals(o)) {
                return false;
            }
            MyNavigationGutterIconRenderer that = (MyNavigationGutterIconRenderer)((Object)o);
            if (this.myAlignment != that.myAlignment) {
                return false;
            }
            if (this.myIcon != null ? !this.myIcon.equals(that.myIcon) : that.myIcon != null) {
                return false;
            }
            return !(this.myTooltipText != null ? !this.myTooltipText.equals(that.myTooltipText) : that.myTooltipText != null);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.myAlignment != null ? this.myAlignment.hashCode() : 0);
            result = 31 * result + (this.myIcon != null ? this.myIcon.hashCode() : 0);
            result = 31 * result + (this.myTooltipText != null ? this.myTooltipText.hashCode() : 0);
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "alignment";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pointers";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cellRenderer";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder$MyNavigationGutterIconRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder$MyNavigationGutterIconRenderer";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAlignment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 8: 
                case 9: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

