/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.console;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KotlinIdeaReplBundle;
import org.jetbrains.kotlin.console.CommandHistory;
import org.jetbrains.kotlin.console.KotlinConsoleRunner;
import org.jetbrains.kotlin.console.ReplColors;
import org.jetbrains.kotlin.console.ReplOutputProcessor;
import org.jetbrains.kotlin.console.ReplOutputProcessor$WhenMappings;
import org.jetbrains.kotlin.console.SeverityDetails;
import org.jetbrains.kotlin.console.actions.RunExecuteActionsKt;
import org.jetbrains.kotlin.console.gutter.ConsoleErrorRenderer;
import org.jetbrains.kotlin.console.gutter.ConsoleIndicatorRenderer;
import org.jetbrains.kotlin.console.gutter.IconWithTooltip;
import org.jetbrains.kotlin.console.gutter.ReplIcons;
import org.jetbrains.kotlin.diagnostics.Severity;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u001bH\u0002J\u0014\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fJ\u0006\u0010!\u001a\u00020\u001dJ\u000e\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020$J\u000e\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020$J$\u0010)\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020,2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010.H\u0002J\u000e\u0010/\u001a\u00020\u001d2\u0006\u00100\u001a\u00020$J\u000e\u00101\u001a\u00020\u001d2\u0006\u00102\u001a\u00020$J\u000e\u00103\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020$J\u0018\u00104\u001a\u00020\u001d2\u0006\u00105\u001a\u00020$2\u0006\u00106\u001a\u000207H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/console/ReplOutputProcessor;", "", "runner", "Lorg/jetbrains/kotlin/console/KotlinConsoleRunner;", "(Lorg/jetbrains/kotlin/console/KotlinConsoleRunner;)V", "consoleView", "Lcom/intellij/execution/console/LanguageConsoleImpl;", "historyDocument", "Lcom/intellij/openapi/editor/ex/DocumentEx;", "Lorg/jetbrains/annotations/NotNull;", "historyEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "historyMarkup", "Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "project", "Lcom/intellij/openapi/project/Project;", "getAttributesForSeverity", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "infoType", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfoType;", "severity", "Lcom/intellij/lang/annotation/HighlightSeverity;", "insightColors", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "start", "", "end", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "highlightCompilerErrors", "", "compilerMessages", "", "Lorg/jetbrains/kotlin/console/SeverityDetails;", "printBuildInfoWarningIfNeeded", "printHelp", "help", "", "printInitialPrompt", "command", "printInternalErrorMessage", "internalErrorText", "printOutput", "output", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "iconWithTooltip", "Lorg/jetbrains/kotlin/console/gutter/IconWithTooltip;", "printResultWithGutterIcon", "result", "printRuntimeError", "errorText", "printUserOutput", "printWarningMessage", "message", "isAddHyperlink", "", "kotlin.repl"})
public final class ReplOutputProcessor {
    private final Project project;
    private final LanguageConsoleImpl consoleView;
    private final EditorEx historyEditor;
    private final DocumentEx historyDocument;
    private final MarkupModelEx historyMarkup;
    private final KotlinConsoleRunner runner;

    private final void printOutput(String output, ConsoleViewContentType contentType, IconWithTooltip iconWithTooltip) {
        this.consoleView.flushDeferredText();
        int startOffset = this.historyDocument.getTextLength();
        this.consoleView.print(output, contentType);
        this.consoleView.flushDeferredText();
        int endOffset = this.historyDocument.getTextLength();
        if (iconWithTooltip == null) {
            return;
        }
        RangeHighlighter rangeHighlighter = this.historyMarkup.addRangeHighlighter(startOffset, endOffset, 6000, null, HighlighterTargetArea.EXACT_RANGE);
        boolean bl = false;
        boolean bl2 = false;
        RangeHighlighter $this$apply = rangeHighlighter;
        boolean bl3 = false;
        $this$apply.setGutterIconRenderer((GutterIconRenderer)new ConsoleIndicatorRenderer(iconWithTooltip));
    }

    static /* synthetic */ void printOutput$default(ReplOutputProcessor replOutputProcessor, String string, ConsoleViewContentType consoleViewContentType, IconWithTooltip iconWithTooltip, int n, Object object) {
        if ((n & 4) != 0) {
            iconWithTooltip = null;
        }
        replOutputProcessor.printOutput(string, consoleViewContentType, iconWithTooltip);
    }

    private final void printWarningMessage(String message, boolean isAddHyperlink) {
        WriteCommandAction.runWriteCommandAction((Project)this.project, (Runnable)new Runnable(this, message, isAddHyperlink){
            final /* synthetic */ ReplOutputProcessor this$0;
            final /* synthetic */ String $message;
            final /* synthetic */ boolean $isAddHyperlink;

            public final void run() {
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
                Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"ConsoleViewContentType.NORMAL_OUTPUT");
                ReplOutputProcessor.printOutput$default(this.this$0, "\n", consoleViewContentType, null, 4, null);
                ReplOutputProcessor.access$printOutput(this.this$0, this.$message, ReplColors.INSTANCE.getWARNING_INFO_CONTENT_TYPE(), ReplIcons.INSTANCE.getBUILD_WARNING_INDICATOR());
                if (this.$isAddHyperlink) {
                    LanguageConsoleImpl languageConsoleImpl = ReplOutputProcessor.access$getConsoleView$p(this.this$0);
                    Object[] objectArray = new Object[1];
                    String string = ReplOutputProcessor.access$getRunner$p(this.this$0).getModule().getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"runner.module.name");
                    objectArray[0] = string;
                    languageConsoleImpl.printHyperlink(KotlinIdeaReplBundle.message("build.module.0.and.restart1", objectArray), new HyperlinkInfo(this){
                        final /* synthetic */ printWarningMessage.1 this$0;

                        public final void navigate(@NotNull Project it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            ReplOutputProcessor.access$getRunner$p(this.this$0.this$0).getCompilerHelper().compileModule();
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                ConsoleViewContentType consoleViewContentType2 = ConsoleViewContentType.NORMAL_OUTPUT;
                Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType2, (String)"ConsoleViewContentType.NORMAL_OUTPUT");
                ReplOutputProcessor.printOutput$default(this.this$0, "\n\n", consoleViewContentType2, null, 4, null);
            }
            {
                this.this$0 = replOutputProcessor;
                this.$message = string;
                this.$isAddHyperlink = bl;
            }
        });
    }

    public final void printBuildInfoWarningIfNeeded() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            return;
        }
        if (this.runner.getPreviousCompilationFailed$kotlin_repl()) {
            Object[] objectArray = new Object[1];
            String string = this.runner.getModule().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"runner.module.name");
            objectArray[0] = string;
            this.printWarningMessage(KotlinIdeaReplBundle.message("there.were.compilation.errors.in.module.0", objectArray), false);
            return;
        }
        if (this.runner.getCompilerHelper().moduleIsUpToDate()) {
            return;
        }
        String compilerWarningMessage = KotlinIdeaReplBundle.message("you.re.running.the.repl.with.outdated.classes", new Object[0]);
        this.printWarningMessage(compilerWarningMessage, true);
    }

    public final void printInitialPrompt(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        this.consoleView.print(command, ReplColors.INSTANCE.getINITIAL_PROMPT_CONTENT_TYPE());
    }

    public final void printHelp(@NotNull String help) {
        Intrinsics.checkNotNullParameter((Object)help, (String)"help");
        WriteCommandAction.runWriteCommandAction((Project)this.project, (Runnable)new Runnable(this, help){
            final /* synthetic */ ReplOutputProcessor this$0;
            final /* synthetic */ String $help;

            public final void run() {
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.SYSTEM_OUTPUT;
                Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"ConsoleViewContentType.SYSTEM_OUTPUT");
                ReplOutputProcessor.access$printOutput(this.this$0, this.$help, consoleViewContentType, ReplIcons.INSTANCE.getSYSTEM_HELP());
            }
            {
                this.this$0 = replOutputProcessor;
                this.$help = string;
            }
        });
    }

    public final void printUserOutput(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        WriteCommandAction.runWriteCommandAction((Project)this.project, (Runnable)new Runnable(this, command){
            final /* synthetic */ ReplOutputProcessor this$0;
            final /* synthetic */ String $command;

            public final void run() {
                ReplOutputProcessor.access$getConsoleView$p(this.this$0).print(this.$command, ReplColors.INSTANCE.getUSER_OUTPUT_CONTENT_TYPE());
            }
            {
                this.this$0 = replOutputProcessor;
                this.$command = string;
            }
        });
    }

    public final void printResultWithGutterIcon(@NotNull String result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        WriteCommandAction.runWriteCommandAction((Project)this.project, (Runnable)new Runnable(this, result){
            final /* synthetic */ ReplOutputProcessor this$0;
            final /* synthetic */ String $result;

            public final void run() {
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
                Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"ConsoleViewContentType.NORMAL_OUTPUT");
                ReplOutputProcessor.access$printOutput(this.this$0, this.$result, consoleViewContentType, ReplIcons.INSTANCE.getRESULT());
            }
            {
                this.this$0 = replOutputProcessor;
                this.$result = string;
            }
        });
    }

    public final void highlightCompilerErrors(@NotNull List<SeverityDetails> compilerMessages) {
        Intrinsics.checkNotNullParameter(compilerMessages, (String)"compilerMessages");
        WriteCommandAction.runWriteCommandAction((Project)this.project, (Runnable)new Runnable(this, compilerMessages){
            final /* synthetic */ ReplOutputProcessor this$0;
            final /* synthetic */ List $compilerMessages;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                RangeHighlighter $this$mapTo$iv$iv;
                void $this$map$iv;
                Object $this$getOrPut$iv$iv$iv;
                Object message;
                void $this$groupByTo$iv$iv;
                Iterable $this$groupBy$iv;
                void $this$filterTo$iv$iv;
                RangeHighlighter element$iv;
                int lastCommandStartLine;
                int lastCommandStartOffset;
                block11: {
                    CommandHistory commandHistory = ReplOutputProcessor.access$getRunner$p(this.this$0).getCommandHistory();
                    CommandHistory.Entry entry = commandHistory.lastUnprocessedEntry();
                    if (entry == null) {
                        RunExecuteActionsKt.logError$default(ReplOutputProcessor.class, "Processed more commands than were sent. Sent commands: " + commandHistory.getSize() + ". Processed: " + commandHistory.getProcessedEntriesCount(), null, 4, null);
                        return;
                    }
                    CommandHistory.Entry lastUnprocessedHistoryEntry = entry;
                    lastCommandStartOffset = lastUnprocessedHistoryEntry.getRangeInHistoryDocument().getStartOffset();
                    lastCommandStartLine = ReplOutputProcessor.access$getHistoryDocument$p(this.this$0).getLineNumber(lastCommandStartOffset);
                    RangeHighlighter[] rangeHighlighterArray = ReplOutputProcessor.access$getHistoryMarkup$p(this.this$0).getAllHighlighters();
                    Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterArray, (String)"historyMarkup.allHighlighters");
                    RangeHighlighter[] $this$first$iv = rangeHighlighterArray;
                    boolean $i$f$first = false;
                    RangeHighlighter[] rangeHighlighterArray2 = $this$first$iv;
                    int n = rangeHighlighterArray2.length;
                    for (int i = 0; i < n; ++i) {
                        RangeHighlighter it = element$iv = rangeHighlighterArray2[i];
                        boolean bl = false;
                        DocumentEx documentEx = ReplOutputProcessor.access$getHistoryDocument$p(this.this$0);
                        RangeHighlighter rangeHighlighter = it;
                        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"it");
                        if (!(documentEx.getLineNumber(rangeHighlighter.getStartOffset()) == lastCommandStartLine && it.getGutterIconRenderer() != null)) {
                            continue;
                        }
                        break block11;
                    }
                    throw (Throwable)new NoSuchElementException("Array contains no element matching the predicate.");
                }
                RangeHighlighter historyCommandRunIndicator = element$iv;
                Iterable $this$filter$iv = this.$compilerMessages;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Object destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    SeverityDetails it = (SeverityDetails)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getSeverity() == Severity.ERROR || it.getSeverity() == Severity.WARNING)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$groupBy = false;
                $this$filterTo$iv$iv = $this$groupBy$iv;
                destination$iv$iv = new LinkedHashMap<K, V>();
                boolean $i$f$groupByTo = false;
                for (T element$iv$iv : $this$groupByTo$iv$iv) {
                    Object object;
                    message = (SeverityDetails)element$iv$iv;
                    boolean bl = false;
                    int cmdStart = lastCommandStartOffset + ((SeverityDetails)message).getRange().getStartOffset();
                    Integer key$iv$iv = ReplOutputProcessor.access$getHistoryEditor$p(this.this$0).getDocument().getLineNumber(cmdStart);
                    $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl2 = false;
                        List answer$iv$iv$iv = new ArrayList<E>();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object;
                    list$iv$iv.add(element$iv$iv);
                }
                $this$groupBy$iv = destination$iv$iv.values();
                boolean $i$f$map = false;
                $this$groupByTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void $this$mapTo$iv$iv2;
                    void messages;
                    message = (List)item$iv$iv;
                    Object object = destination$iv$iv;
                    boolean bl = false;
                    Iterable $this$map$iv2 = (Iterable)messages;
                    boolean $i$f$map2 = false;
                    $this$getOrPut$iv$iv$iv = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (T item$iv$iv2 : $this$mapTo$iv$iv2) {
                        void message2;
                        SeverityDetails severityDetails = (SeverityDetails)item$iv$iv2;
                        Collection collection = destination$iv$iv2;
                        boolean bl3 = false;
                        int cmdStart = lastCommandStartOffset + message2.getRange().getStartOffset();
                        int n = message2.getRange().getEndOffset();
                        int n2 = message2.getRange().getStartOffset() + 1;
                        boolean bl4 = false;
                        int cmdEnd = lastCommandStartOffset + Math.max(n, n2);
                        TextAttributes textAttributes = ReplOutputProcessor.access$getAttributesForSeverity(this.this$0, cmdStart, cmdEnd, message2.getSeverity());
                        RangeHighlighter rangeHighlighter = ReplOutputProcessor.access$getHistoryMarkup$p(this.this$0).addRangeHighlighter(cmdStart, cmdEnd, 6000, textAttributes, HighlighterTargetArea.EXACT_RANGE);
                        collection.add(rangeHighlighter);
                    }
                    List highlighters = (List)destination$iv$iv2;
                    Pair pair = new Pair(CollectionsKt.first((List)highlighters), (Object)messages);
                    object.add(pair);
                }
                List highlighterAndMessagesByLine = (List)destination$iv$iv;
                for (Pair pair : highlighterAndMessagesByLine) {
                    void highlighter;
                    $this$mapTo$iv$iv = (RangeHighlighter)pair.component1();
                    List messages = (List)pair.component2();
                    DocumentEx documentEx = ReplOutputProcessor.access$getHistoryDocument$p(this.this$0);
                    void v6 = highlighter;
                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"highlighter");
                    if (documentEx.getLineNumber(v6.getStartOffset()) == lastCommandStartLine) {
                        RangeHighlighter rangeHighlighter = historyCommandRunIndicator;
                        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"historyCommandRunIndicator");
                        rangeHighlighter.setGutterIconRenderer((GutterIconRenderer)new ConsoleErrorRenderer(messages));
                        continue;
                    }
                    highlighter.setGutterIconRenderer((GutterIconRenderer)new ConsoleErrorRenderer(messages));
                }
            }
            {
                this.this$0 = replOutputProcessor;
                this.$compilerMessages = list;
            }
        });
    }

    public final void printRuntimeError(@NotNull String errorText) {
        Intrinsics.checkNotNullParameter((Object)errorText, (String)"errorText");
        WriteCommandAction.runWriteCommandAction((Project)this.project, (Runnable)new Runnable(this, errorText){
            final /* synthetic */ ReplOutputProcessor this$0;
            final /* synthetic */ String $errorText;

            public final void run() {
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.ERROR_OUTPUT;
                Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"ConsoleViewContentType.ERROR_OUTPUT");
                ReplOutputProcessor.access$printOutput(this.this$0, this.$errorText, consoleViewContentType, ReplIcons.INSTANCE.getRUNTIME_EXCEPTION());
            }
            {
                this.this$0 = replOutputProcessor;
                this.$errorText = string;
            }
        });
    }

    public final void printInternalErrorMessage(@NotNull String internalErrorText) {
        Intrinsics.checkNotNullParameter((Object)internalErrorText, (String)"internalErrorText");
        WriteCommandAction.runWriteCommandAction((Project)this.project, (Runnable)new Runnable(this, internalErrorText){
            final /* synthetic */ ReplOutputProcessor this$0;
            final /* synthetic */ String $internalErrorText;

            public final void run() {
                String promptText = KotlinIdeaReplBundle.message("internal.error.occurred.please.send.report.to.developers", new Object[0]);
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.ERROR_OUTPUT;
                Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"ConsoleViewContentType.ERROR_OUTPUT");
                ReplOutputProcessor.access$printOutput(this.this$0, promptText, consoleViewContentType, ReplIcons.INSTANCE.getRUNTIME_EXCEPTION());
                RunExecuteActionsKt.logError$default(this.this$0.getClass(), this.$internalErrorText, null, 4, null);
            }
            {
                this.this$0 = replOutputProcessor;
                this.$internalErrorText = string;
            }
        });
    }

    private final TextAttributes getAttributesForSeverity(int start, int end, Severity severity) {
        TextAttributes textAttributes;
        switch (ReplOutputProcessor$WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
            case 1: {
                HighlightInfoType highlightInfoType = HighlightInfoType.ERROR;
                Intrinsics.checkNotNullExpressionValue((Object)highlightInfoType, (String)"HighlightInfoType.ERROR");
                HighlightSeverity highlightSeverity = HighlightSeverity.ERROR;
                Intrinsics.checkNotNullExpressionValue((Object)highlightSeverity, (String)"HighlightSeverity.ERROR");
                TextAttributesKey textAttributesKey = CodeInsightColors.ERRORS_ATTRIBUTES;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"CodeInsightColors.ERRORS_ATTRIBUTES");
                textAttributes = this.getAttributesForSeverity(highlightInfoType, highlightSeverity, textAttributesKey, start, end);
                break;
            }
            case 2: {
                HighlightInfoType highlightInfoType = HighlightInfoType.WARNING;
                Intrinsics.checkNotNullExpressionValue((Object)highlightInfoType, (String)"HighlightInfoType.WARNING");
                HighlightSeverity highlightSeverity = HighlightSeverity.WARNING;
                Intrinsics.checkNotNullExpressionValue((Object)highlightSeverity, (String)"HighlightSeverity.WARNING");
                TextAttributesKey textAttributesKey = CodeInsightColors.WARNINGS_ATTRIBUTES;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"CodeInsightColors.WARNINGS_ATTRIBUTES");
                textAttributes = this.getAttributesForSeverity(highlightInfoType, highlightSeverity, textAttributesKey, start, end);
                break;
            }
            case 3: {
                HighlightInfoType highlightInfoType = HighlightInfoType.WEAK_WARNING;
                Intrinsics.checkNotNullExpressionValue((Object)highlightInfoType, (String)"HighlightInfoType.WEAK_WARNING");
                HighlightSeverity highlightSeverity = HighlightSeverity.WEAK_WARNING;
                Intrinsics.checkNotNullExpressionValue((Object)highlightSeverity, (String)"HighlightSeverity.WEAK_WARNING");
                TextAttributesKey textAttributesKey = CodeInsightColors.WEAK_WARNING_ATTRIBUTES;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"CodeInsightColors.WEAK_WARNING_ATTRIBUTES");
                textAttributes = this.getAttributesForSeverity(highlightInfoType, highlightSeverity, textAttributesKey, start, end);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return textAttributes;
    }

    private final TextAttributes getAttributesForSeverity(HighlightInfoType infoType, HighlightSeverity severity, TextAttributesKey insightColors, int start, int end) {
        HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)infoType).range(start, end).severity(severity).textAttributes(insightColors).create();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.project);
        EditorEx editorEx = this.consoleView.getConsoleEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"consoleView.consoleEditor");
        PsiFile psiFile = psiDocumentManager.getPsiFile((Document)editorEx.getDocument());
        EditorEx editorEx2 = this.consoleView.getConsoleEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editorEx2, (String)"consoleView.consoleEditor");
        EditorColorsScheme editorColorsScheme = editorEx2.getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"consoleView.consoleEditor.colorsScheme");
        EditorColorsScheme colorScheme = editorColorsScheme;
        HighlightInfo highlightInfo2 = highlightInfo;
        if (highlightInfo2 == null || (highlightInfo2 = highlightInfo2.getTextAttributes((PsiElement)psiFile, colorScheme)) == null) {
            highlightInfo2 = new TextAttributes();
        }
        return highlightInfo2;
    }

    public ReplOutputProcessor(@NotNull KotlinConsoleRunner runner) {
        Intrinsics.checkNotNullParameter((Object)((Object)runner), (String)"runner");
        this.runner = runner;
        Project project = this.runner.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"runner.project");
        this.project = project;
        LanguageConsoleView languageConsoleView = this.runner.getConsoleView();
        if (languageConsoleView == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.execution.console.LanguageConsoleImpl");
        }
        this.consoleView = (LanguageConsoleImpl)languageConsoleView;
        EditorEx editorEx = this.consoleView.getHistoryViewer();
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"consoleView.historyViewer");
        this.historyEditor = editorEx;
        DocumentEx documentEx = this.historyEditor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"historyEditor.document");
        this.historyDocument = documentEx;
        MarkupModelEx markupModelEx = this.historyEditor.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModelEx, (String)"historyEditor.markupModel");
        this.historyMarkup = markupModelEx;
    }

    public static final /* synthetic */ void access$printOutput(ReplOutputProcessor $this, String output, ConsoleViewContentType contentType, IconWithTooltip iconWithTooltip) {
        $this.printOutput(output, contentType, iconWithTooltip);
    }

    public static final /* synthetic */ LanguageConsoleImpl access$getConsoleView$p(ReplOutputProcessor $this) {
        return $this.consoleView;
    }

    public static final /* synthetic */ KotlinConsoleRunner access$getRunner$p(ReplOutputProcessor $this) {
        return $this.runner;
    }

    public static final /* synthetic */ DocumentEx access$getHistoryDocument$p(ReplOutputProcessor $this) {
        return $this.historyDocument;
    }

    public static final /* synthetic */ MarkupModelEx access$getHistoryMarkup$p(ReplOutputProcessor $this) {
        return $this.historyMarkup;
    }

    public static final /* synthetic */ EditorEx access$getHistoryEditor$p(ReplOutputProcessor $this) {
        return $this.historyEditor;
    }

    public static final /* synthetic */ TextAttributes access$getAttributesForSeverity(ReplOutputProcessor $this, int start, int end, Severity severity) {
        return $this.getAttributesForSeverity(start, end, severity);
    }
}

