/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.console;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.repl.ReplUtilKt;
import org.jetbrains.kotlin.console.KotlinConsoleRunner;
import org.jetbrains.kotlin.console.ReplOutputHandler$WhenMappings;
import org.jetbrains.kotlin.console.ReplOutputProcessor;
import org.jetbrains.kotlin.console.SeverityDetails;
import org.jetbrains.kotlin.console.actions.RunExecuteActionsKt;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.utils.repl.ReplEscapeType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\b\u0010\u001c\u001a\u00020\u0010H\u0016J\u001c\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00072\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001fH\u0016J\u001a\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00072\b\b\u0002\u0010#\u001a\u00020$H\u0002J\f\u0010%\u001a\u00020&*\u00020\u0007H\u0002R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\rj\u0002`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/console/ReplOutputHandler;", "Lcom/intellij/execution/process/OSProcessHandler;", "runner", "Lorg/jetbrains/kotlin/console/KotlinConsoleRunner;", "process", "Ljava/lang/Process;", "commandLine", "", "(Lorg/jetbrains/kotlin/console/KotlinConsoleRunner;Ljava/lang/Process;Ljava/lang/String;)V", "factory", "Ljavax/xml/parsers/DocumentBuilderFactory;", "kotlin.jvm.PlatformType", "inputBuffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "isBuildInfoChecked", "", "outputProcessor", "Lorg/jetbrains/kotlin/console/ReplOutputProcessor;", "buildWarningIfNeededBeforeInit", "", "content", "createCompilerMessages", "", "Lorg/jetbrains/kotlin/console/SeverityDetails;", "runtimeErrorsReport", "handleReplMessage", "text", "isSilentlyDestroyOnClose", "notifyTextAvailable", "key", "Lcom/intellij/openapi/util/Key;", "strToSource", "Lorg/xml/sax/InputSource;", "s", "encoding", "Ljava/nio/charset/Charset;", "toSeverity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "kotlin.repl"})
public final class ReplOutputHandler
extends OSProcessHandler {
    private boolean isBuildInfoChecked;
    private final DocumentBuilderFactory factory;
    private final ReplOutputProcessor outputProcessor;
    private final StringBuilder inputBuffer;
    private final KotlinConsoleRunner runner;

    public boolean isSilentlyDestroyOnClose() {
        return true;
    }

    public void notifyTextAvailable(@NotNull String text, @NotNull Key<?> key) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        if (StringsKt.startsWith$default((String)text, (String)"warning: classpath entry points to a non-existent location", (boolean)false, (int)2, null)) {
            return;
        }
        if (Intrinsics.areEqual(key, (Object)ProcessOutputTypes.STDOUT)) {
            this.inputBuffer.append(text);
            String string = this.inputBuffer.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"inputBuffer.toString()");
            String resultingText = string;
            if (StringsKt.endsWith$default((String)resultingText, (String)"\n", (boolean)false, (int)2, null)) {
                this.handleReplMessage(resultingText);
                this.inputBuffer.setLength(0);
            }
        } else {
            super.notifyTextAvailable(text, key);
        }
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void handleReplMessage(String text) {
        if (StringsKt.isBlank((CharSequence)text)) {
            return;
        }
        try {
            var3_2 = this.factory.newDocumentBuilder().parse(ReplOutputHandler.strToSource$default(this, text, null, 2, null));
        }
        catch (Exception e) {
            RunExecuteActionsKt.logError(ReplOutputHandler.class, "Couldn't parse REPL output: " + text, e);
            return;
        }
        v0 = output = var3_2;
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"output");
        v1 = v0.getFirstChild();
        if (v1 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.w3c.dom.Element");
        }
        root = (Element)v1;
        v2 = root.getAttribute("type");
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"root.getAttribute(\"type\")");
        outputType = ReplEscapeType.Companion.valueOfOrNull(v2);
        v3 = root.getTextContent();
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"root.textContent");
        content = ReplUtilKt.replNormalizeLineBreaks((String)ReplUtilKt.replUnescapeLineBreaks((String)v3));
        v4 = outputType;
        if (v4 == null) {
            RunExecuteActionsKt.logError$default(ReplOutputHandler.class, "Unexpected output type:\n" + outputType, null, 4, null);
            ** break;
        }
        switch (ReplOutputHandler$WhenMappings.$EnumSwitchMapping$0[v4.ordinal()]) {
            case 1: {
                this.buildWarningIfNeededBeforeInit(content);
                break;
            }
            case 2: {
                this.outputProcessor.printHelp(content);
                break;
            }
            case 3: {
                this.outputProcessor.printUserOutput(content);
                break;
            }
            case 4: {
                this.outputProcessor.printResultWithGutterIcon(content);
                break;
            }
            case 5: {
                this.runner.setReadLineMode(true);
                break;
            }
            case 6: {
                this.runner.setReadLineMode(false);
                break;
            }
            case 7: 
            case 8: {
                this.outputProcessor.highlightCompilerErrors(this.createCompilerMessages(content));
                break;
            }
            case 9: {
                var6_7 = content;
                var7_9 = false;
                v5 = var6_7;
                if (v5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                this.outputProcessor.printRuntimeError(StringsKt.trim((CharSequence)v5).toString() + '\n');
                break;
            }
            case 10: {
                this.outputProcessor.printInternalErrorMessage(content);
                break;
            }
            case 11: {
                v6 = this.runner.getCommandHistory().lastUnprocessedEntry();
                if (v6 == null || (v6 = v6.getEntryText()) == null) break;
                var6_8 = v6;
                var7_10 = false;
                var8_11 = false;
                it = var6_8;
                $i$a$-let-ReplOutputHandler$handleReplMessage$1 = false;
                this.runner.successfulLine((String)it);
                break;
            }
        }
lbl69:
        // 13 sources

        if (CollectionsKt.contains((Iterable)SetsKt.setOf((Object[])new ReplEscapeType[]{ReplEscapeType.SUCCESS, ReplEscapeType.COMPILE_ERROR, ReplEscapeType.INTERNAL_ERROR, ReplEscapeType.RUNTIME_ERROR, ReplEscapeType.READLINE_END}), (Object)outputType)) {
            this.runner.getCommandHistory().entryProcessed();
        }
    }

    private final void buildWarningIfNeededBeforeInit(String content) {
        if (!this.isBuildInfoChecked) {
            this.outputProcessor.printBuildInfoWarningIfNeeded();
            this.isBuildInfoChecked = true;
        }
        this.outputProcessor.printInitialPrompt(content);
    }

    private final InputSource strToSource(String s, Charset encoding) {
        String string = s;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(encoding);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return new InputSource(new ByteArrayInputStream(byArray));
    }

    static /* synthetic */ InputSource strToSource$default(ReplOutputHandler replOutputHandler, String string, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        return replOutputHandler.strToSource(string, charset);
    }

    /*
     * WARNING - void declaration
     */
    private final List<SeverityDetails> createCompilerMessages(String runtimeErrorsReport) {
        boolean bl = false;
        ArrayList<SeverityDetails> compilerMessages = new ArrayList<SeverityDetails>();
        Document report = this.factory.newDocumentBuilder().parse(this.strToSource(runtimeErrorsReport, Charsets.UTF_16));
        NodeList entries = report.getElementsByTagName("reportEntry");
        int n = 0;
        NodeList nodeList = entries;
        Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"entries");
        int n2 = nodeList.getLength();
        while (n < n2) {
            String description;
            String string;
            String string2;
            void i;
            Node node = entries.item((int)i);
            if (node == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.w3c.dom.Element");
            }
            Element reportEntry = (Element)node;
            String string3 = reportEntry.getAttribute("severity");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"reportEntry.getAttribute(\"severity\")");
            Severity severityLevel = this.toSeverity(string3);
            Intrinsics.checkNotNullExpressionValue((Object)reportEntry.getAttribute("rangeStart"), (String)"reportEntry.getAttribute(\"rangeStart\")");
            boolean bl2 = false;
            int rangeStart = Integer.parseInt(string2);
            Intrinsics.checkNotNullExpressionValue((Object)reportEntry.getAttribute("rangeEnd"), (String)"reportEntry.getAttribute(\"rangeEnd\")");
            boolean bl3 = false;
            int rangeEnd = Integer.parseInt(string);
            String string4 = description = reportEntry.getTextContent();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"description");
            compilerMessages.add(new SeverityDetails(severityLevel, string4, new TextRange(rangeStart, rangeEnd)));
            ++i;
        }
        return compilerMessages;
    }

    private final Severity toSeverity(String $this$toSeverity) {
        Severity severity;
        switch ($this$toSeverity) {
            case "ERROR": {
                severity = Severity.ERROR;
                break;
            }
            case "WARNING": {
                severity = Severity.WARNING;
                break;
            }
            case "INFO": {
                severity = Severity.INFO;
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Unsupported Severity: '" + $this$toSeverity + '\'');
            }
        }
        return severity;
    }

    public ReplOutputHandler(@NotNull KotlinConsoleRunner runner, @NotNull Process process, @NotNull String commandLine) {
        Intrinsics.checkNotNullParameter((Object)((Object)runner), (String)"runner");
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        super(process, commandLine);
        this.runner = runner;
        this.factory = DocumentBuilderFactory.newInstance();
        this.outputProcessor = new ReplOutputProcessor(this.runner);
        this.inputBuffer = new StringBuilder();
    }
}

