/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.module.view.web.viewlets;

import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.javaee.DeploymentDescriptorsConstants;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.module.view.J2EEGeneralModuleViewlets;
import com.intellij.javaee.web.facet.WebFacetConfigurationImpl;
import com.intellij.javaee.web.facet.WebFacetImpl;
import com.intellij.javaee.web.module.view.web.WebFacetWebRootsPanel;
import com.intellij.javaee.web.module.view.web.viewlets.WebResourceDirectoriesInfo;
import com.intellij.javaee.web.module.view.web.viewlets.WebSourceRootsConfigurable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;

public class ConfigureWebGeneralModuleViewlets
extends J2EEGeneralModuleViewlets {
    @NonNls
    private static final String WEB_INF = "WEB-INF";
    @NonNls
    private static final String RESOURCES = "/web";
    private WebFacetWebRootsPanel myWebFacetWebRootsPanel;
    private final WebSourceRootsConfigurable mySourceRootsConfigurable;

    public ConfigureWebGeneralModuleViewlets(JavaeeFacet facet, FacetEditorContext context) {
        super(facet, context);
        this.mySourceRootsConfigurable = new WebSourceRootsConfigurable(context, (WebFacetConfigurationImpl)facet.getConfiguration());
        this.mySourceRootsConfigurable.reset();
    }

    protected JComponent createSouthPanel() {
        VirtualFile[] contentRoots;
        WebFacetImpl facet = (WebFacetImpl)this.getFacet();
        WebFacetConfigurationImpl configuration = (WebFacetConfigurationImpl)facet.getConfiguration();
        boolean defaultRootsAdded = false;
        FacetEditorContext context = this.getContext();
        if (context.isNewFacet() && facet.getWebRoots().isEmpty() && (contentRoots = ModuleRootManager.getInstance((Module)facet.getModule()).getContentRoots()).length > 0) {
            int dot;
            String directory;
            String directoryName;
            WebResourceDirectoriesInfo directoriesInfo = WebResourceDirectoriesInfo.getDirectoriesInfo(context);
            String url = this.myDescriptorsOwner.getDescriptorUrl(DeploymentDescriptorsConstants.WEB_XML_META_DATA);
            if (url != null && WEB_INF.equals(directoryName = (directory = url.substring(0, url.lastIndexOf(47))).substring((dot = directory.lastIndexOf(47)) + 1)) && dot != -1) {
                String parentDirectory = directory.substring(0, dot);
                facet.addWebRootNoFire(parentDirectory, "/");
                directoriesInfo.put(parentDirectory, (FacetConfiguration)configuration);
            }
            if (facet.getWebRoots().isEmpty()) {
                facet.addWebRootNoFire(directoriesInfo.suggestUrl(contentRoots[0].getUrl() + RESOURCES, configuration), "/");
            }
            defaultRootsAdded = true;
        }
        this.myWebFacetWebRootsPanel = new WebFacetWebRootsPanel(facet.getModule(), facet, !defaultRootsAdded);
        JPanel rootsPanels = new JPanel(new BorderLayout());
        JComponent webResourceDirectories = this.myWebFacetWebRootsPanel.getComponent();
        UIUtil.addBorder((JComponent)webResourceDirectories, (Border)IdeBorderFactory.createTitledBorder((String)J2EEBundle.message((String)"border.edit.web.module.web.resource.directories", (Object[])new Object[0]), (boolean)false));
        rootsPanels.add((Component)webResourceDirectories, "Center");
        rootsPanels.add((Component)this.mySourceRootsConfigurable.createComponent(), "South");
        return rootsPanels;
    }

    public void saveData() {
        super.saveData();
        this.mySourceRootsConfigurable.apply();
        if (this.myWebFacetWebRootsPanel != null) {
            this.myWebFacetWebRootsPanel.saveData();
            this.myWebFacetWebRootsPanel.createDirectories();
        }
    }

    public boolean isEditing() {
        return this.myWebFacetWebRootsPanel != null && this.myWebFacetWebRootsPanel.isEditing();
    }

    public boolean isModified() {
        return super.isModified() || this.myWebFacetWebRootsPanel.isModified() || this.mySourceRootsConfigurable.isModified();
    }

    public void dispose() {
        super.dispose();
        this.mySourceRootsConfigurable.disposeUIResources();
    }
}

