/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.module.view.web;

import com.intellij.codeInsight.daemon.GutterName;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.javaee.web.WebBundle;
import com.intellij.javaee.web.WebCommonClassNames;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import icons.JavaUltimateIcons;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastUtils;

public final class WebClassesLineMarkerProvider
extends LineMarkerProviderDescriptor {
    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            WebClassesLineMarkerProvider.$$$reportNull$$$0(0);
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result) {
        if (elements == null) {
            WebClassesLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            WebClassesLineMarkerProvider.$$$reportNull$$$0(2);
        }
        if (elements.isEmpty()) {
            return;
        }
        Project project = elements.get(0).getProject();
        if (!WebClassesLineMarkerProvider.isToolWindowAvailable(project)) {
            return;
        }
        for (PsiElement psiElement : elements) {
            ProgressManager.checkCanceled();
            WebClassesLineMarkerProvider.annotate(project, psiElement, result);
        }
    }

    @GutterName
    @NotNull
    public String getName() {
        String string = WebBundle.message("web.gutter.name", new Object[0]);
        if (string == null) {
            WebClassesLineMarkerProvider.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = JavaUltimateIcons.Web.WebModule;
        if (icon == null) {
            WebClassesLineMarkerProvider.$$$reportNull$$$0(4);
        }
        return icon;
    }

    private static void annotate(Project project, PsiElement element, @NotNull Collection<? super LineMarkerInfo<?>> result) {
        boolean isWebImplementation;
        UElement uParent;
        if (result == null) {
            WebClassesLineMarkerProvider.$$$reportNull$$$0(5);
        }
        if (!((uParent = UastUtils.getUParentForIdentifier((PsiElement)element)) instanceof UClass)) {
            return;
        }
        UClass uClass = (UClass)uParent;
        if (uClass.isAnnotationType() || uClass.isInterface()) {
            return;
        }
        UElement anchor = uClass.getUastAnchor();
        if (anchor == null) {
            return;
        }
        PsiElement sourcePsi = anchor.getSourcePsi();
        if (sourcePsi == null) {
            return;
        }
        PsiClass classJavaPsi = uClass.getJavaPsi();
        if (classJavaPsi.isEnum() || classJavaPsi.isRecord()) {
            return;
        }
        PsiClass superClass = classJavaPsi.getSuperClass();
        if (superClass != null && classJavaPsi.getImplementsListTypes().length == 0 && "java.lang.Object".equals(superClass.getQualifiedName())) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module != null) {
            isWebImplementation = WebClassesLineMarkerProvider.isImplementation(classJavaPsi, WebCommonClassNames.SERVLET, module) || WebClassesLineMarkerProvider.isImplementation(classJavaPsi, WebCommonClassNames.SERVLET_FILTER, module) || WebClassesLineMarkerProvider.isImplementation(classJavaPsi, WebCommonClassNames.SERVLET_CONTEXT_LISTENER, module) || WebClassesLineMarkerProvider.isImplementation(classJavaPsi, WebCommonClassNames.HTTP_SESSION_LISTENER, module) || WebClassesLineMarkerProvider.isImplementation(classJavaPsi, WebCommonClassNames.HTTP_SESSION_ATTRIBUTE_LISTENER, module);
        } else {
            String className = StringUtil.notNullize((String)uClass.getName());
            boolean bl = isWebImplementation = className.endsWith("Servlet") && WebClassesLineMarkerProvider.isImplementation(classJavaPsi, WebCommonClassNames.SERVLET, project) || className.endsWith("Filter") && WebClassesLineMarkerProvider.isImplementation(classJavaPsi, WebCommonClassNames.SERVLET_FILTER, project) || className.endsWith("Listener") && WebClassesLineMarkerProvider.isWebListenerImplementation(project, classJavaPsi);
        }
        if (isWebImplementation) {
            result.add(WebClassesLineMarkerProvider.createLineMarker(sourcePsi, project));
        }
    }

    private static boolean isWebListenerImplementation(Project project, PsiClass classJavaPsi) {
        return WebClassesLineMarkerProvider.isImplementation(classJavaPsi, WebCommonClassNames.SERVLET_CONTEXT_LISTENER, project) || WebClassesLineMarkerProvider.isImplementation(classJavaPsi, WebCommonClassNames.HTTP_SESSION_LISTENER, project) || WebClassesLineMarkerProvider.isImplementation(classJavaPsi, WebCommonClassNames.HTTP_SESSION_ATTRIBUTE_LISTENER, project);
    }

    @NotNull
    public static LineMarkerInfo<PsiElement> createLineMarker(PsiElement sourcePsi, Project project) {
        return new LineMarkerInfo(sourcePsi, sourcePsi.getTextRange(), JavaUltimateIcons.Web.Gutter.WebModule, el -> WebBundle.message("web.open.tool.window", new Object[0]), (e, elt) -> {
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Web");
            if (toolWindow != null) {
                toolWindow.activate(null);
            }
        }, GutterIconRenderer.Alignment.RIGHT, WebBundle.messagePointer("web.open.tool.window", new Object[0]));
    }

    private static boolean isImplementation(PsiClass classJavaPsi, JavaeeClass javaeeClass, Project project) {
        GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)project);
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        for (String fqn : javaeeClass.all()) {
            for (PsiClass aClass : javaPsiFacade.findClasses(fqn, allScope)) {
                if (!classJavaPsi.isInheritor(aClass, true)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isImplementation(PsiClass classJavaPsi, JavaeeClass javaeeClass, Module module) {
        PsiClass interfaceClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(javaeeClass.fqn(module), GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
        if (interfaceClass == null) {
            return false;
        }
        return classJavaPsi.isInheritor(interfaceClass, true);
    }

    public static boolean isToolWindowAvailable(Project project) {
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
        ToolWindow toolWindow = toolWindowManager.getToolWindow("Web");
        return toolWindow != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/web/module/view/web/WebClassesLineMarkerProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/web/module/view/web/WebClassesLineMarkerProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

