/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.javaee.web.CommonFilter;
import com.intellij.javaee.web.CommonServlet;
import com.intellij.javaee.web.WebBundle;
import com.intellij.javaee.web.model.xml.Filter;
import com.intellij.javaee.web.model.xml.FilterMapping;
import com.intellij.javaee.web.model.xml.Servlet;
import com.intellij.javaee.web.model.xml.ServletMapping;
import com.intellij.javaee.web.model.xml.WebApp;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import java.util.HashMap;
import java.util.List;

public final class ServletWithoutMappingInspection
extends DomElementsInspection<WebApp> {
    public ServletWithoutMappingInspection() {
        super(WebApp.class, new Class[0]);
    }

    public void checkFileElement(DomFileElement<WebApp> webAppDomFileElement, DomElementAnnotationHolder holder) {
        WebApp webApp = (WebApp)webAppDomFileElement.getRootElement();
        ServletWithoutMappingInspection.checkServlets(webApp, holder);
        ServletWithoutMappingInspection.checkFilters(webApp, holder);
    }

    private static void checkServlets(WebApp webApp, DomElementAnnotationHolder holder) {
        List servlets = webApp.getServlets();
        List mappings = webApp.getServletMappings();
        if (servlets.isEmpty()) {
            return;
        }
        HashMap<CommonServlet, ServletMapping> map = new HashMap<CommonServlet, ServletMapping>(mappings.size());
        for (ServletMapping mapping : mappings) {
            CommonServlet servlet = (CommonServlet)mapping.getServlet();
            if (servlet == null) continue;
            map.put(servlet, mapping);
        }
        for (Servlet servlet : servlets) {
            if (map.containsKey(servlet) || servlet.getServletName().getXmlElement() == null) continue;
            holder.createProblem((DomElement)servlet.getServletName(), WebBundle.message("servlet.should.have.a.mapping", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static void checkFilters(WebApp webApp, DomElementAnnotationHolder holder) {
        List servlets = webApp.getFilters();
        List mappings = webApp.getFilterMappings();
        if (servlets.isEmpty()) {
            return;
        }
        HashMap<CommonFilter, FilterMapping> map = new HashMap<CommonFilter, FilterMapping>();
        for (FilterMapping mapping : mappings) {
            CommonFilter servlet = (CommonFilter)mapping.getFilterName().getValue();
            if (servlet == null) continue;
            map.put(servlet, mapping);
        }
        for (Filter servlet : servlets) {
            if (map.containsKey(servlet) || servlet.getFilterName().getXmlElement() == null) continue;
            holder.createProblem((DomElement)servlet.getFilterName(), WebBundle.message("filter.should.have.a.mapping", new Object[0]), new LocalQuickFix[0]);
        }
    }
}

