/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.javaee.web.WebBundle;
import com.intellij.javaee.web.model.xml.MimeMapping;
import com.intellij.javaee.web.model.xml.WebApp;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;

public final class MimeTypeInspection
extends DomElementsInspection<WebApp> {
    @NonNls
    private final Pattern myPattern = Pattern.compile("[^\\p{Cc}^\\s]+/[^\\p{Cc}^\\s]+");

    public MimeTypeInspection() {
        super(WebApp.class, new Class[0]);
    }

    public void checkFileElement(DomFileElement<WebApp> domFileElement, DomElementAnnotationHolder holder) {
        for (MimeMapping mapping : ((WebApp)domFileElement.getRootElement()).getMimeMappings()) {
            GenericDomValue mimeType = mapping.getMimeType();
            String stringValue = mimeType.getStringValue();
            if (stringValue == null || this.myPattern.matcher(stringValue).matches()) continue;
            holder.createProblem((DomElement)mimeType, WebBundle.message("inspection.javaee.web.xml.mime.type.message", stringValue), new LocalQuickFix[0]);
        }
    }
}

