/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.framework;

import com.intellij.framework.FrameworkTypeEx;
import com.intellij.framework.FrameworkVersion;
import com.intellij.framework.addSupport.FrameworkSupportInModuleConfigurable;
import com.intellij.framework.addSupport.FrameworkVersionListener;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.newProjectWizard.impl.FrameworkSupportModelBase;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.javaee.DeploymentDescriptorsConstants;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetType;
import com.intellij.javaee.facet.JavaeeFrameworkSupportInfoCollector;
import com.intellij.javaee.framework.JavaeeFrameworkSupportProviderBase;
import com.intellij.javaee.framework.JavaeeFrameworkVersionBase;
import com.intellij.javaee.ui.packaging.ExplodedWarArtifactType;
import com.intellij.javaee.ui.packaging.JavaeeArtifactTypeBase;
import com.intellij.javaee.web.WebBundle;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.artifact.WebArtifactUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.facet.WebFacetImpl;
import com.intellij.javaee.web.facet.WebFacetType;
import com.intellij.javaee.web.framework.WebFrameworkType;
import com.intellij.javaee.web.framework.WebFrameworkVersion;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFileVersion;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class WebFrameworkSupportProvider
extends JavaeeFrameworkSupportProviderBase<WebFacet> {
    private static final Logger LOG = Logger.getInstance(WebFrameworkSupportProvider.class);

    public WebFrameworkSupportProvider() {
        super((JavaeeFacetType)WebFacetType.getInstance(), DeploymentDescriptorsConstants.WEB_XML_META_DATA, "/web");
    }

    @NotNull
    public FrameworkTypeEx getFrameworkType() {
        WebFrameworkType webFrameworkType = WebFrameworkType.getInstance();
        if (webFrameworkType == null) {
            WebFrameworkSupportProvider.$$$reportNull$$$0(0);
        }
        return webFrameworkType;
    }

    @NotNull
    public FrameworkSupportInModuleConfigurable createConfigurable(@NotNull FrameworkSupportModel model) {
        if (model == null) {
            WebFrameworkSupportProvider.$$$reportNull$$$0(1);
        }
        return new WebFrameworkSupportConfigurable(model);
    }

    public boolean isEnabledForModuleBuilder(@NotNull ModuleBuilder builder) {
        if (builder == null) {
            WebFrameworkSupportProvider.$$$reportNull$$$0(2);
        }
        return super.isEnabledForModuleBuilder(builder) || "LegacySpring".equals(builder.getBuilderId());
    }

    @NotNull
    public String getPresentableName() {
        String string = WebBundle.message("web.application", new Object[0]);
        if (string == null) {
            WebFrameworkSupportProvider.$$$reportNull$$$0(3);
        }
        return string;
    }

    public String getVersionLabel() {
        return WebBundle.message("specification.version", new Object[0]);
    }

    protected void setupConfiguration(WebFacet facet, ModifiableRootModel rootModel, ConfigFileVersion configFileVersion) {
        super.setupConfiguration((JavaeeFacet)facet, rootModel, configFileVersion);
        @NonNls String webDirUrl = rootModel.getContentRootUrls()[0] + "/web";
        facet.addWebRoot(webDirUrl, "/");
        WebFacetImpl webFacet = (WebFacetImpl)facet;
        webFacet.getWebConfiguration().setSourceRoots(Arrays.asList(rootModel.getSourceRootUrls(false)));
    }

    protected void createFiles(WebFacet facet, JavaeeFrameworkSupportInfoCollector collector) {
        List webRoots = facet.getWebRoots();
        if (webRoots.isEmpty()) {
            return;
        }
        String webRootUrl = ((WebRoot)webRoots.get(0)).getDirectoryUrl();
        try {
            File ioFile = new File(FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)webRootUrl)), "index.jsp");
            if (ioFile.exists()) {
                return;
            }
            FileUtil.createIfDoesntExist((File)ioFile);
            VirtualFile indexFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(ioFile);
            Project project = facet.getModule().getProject();
            FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)project).getJ2eeTemplate("Jsp File.jsp");
            assert (indexFile != null);
            VfsUtil.saveText((VirtualFile)indexFile, (String)fileTemplate.getText(FileTemplateManager.getInstance((Project)project).getDefaultProperties()));
            collector.setIndexJsp(indexFile);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    public void processAddedLibraries(Module module, List<Library> addedLibraries) {
        WebFacet webFacet = (WebFacet)ContainerUtil.getFirstItem((Collection)WebFacet.getInstances((Module)module), null);
        if (webFacet != null) {
            Collection artifacts = JavaeeArtifactUtil.getInstance().getArtifactsContainingFacet((JavaeeFacet)webFacet, (ArtifactType)ExplodedWarArtifactType.getInstance());
            for (Artifact artifact : artifacts) {
                for (Library library : addedLibraries) {
                    if (JavaeeArtifactTypeBase.isStandardJavaeeLibrary((Library)library)) continue;
                    WebArtifactUtil.getInstance().addLibrary(library, artifact, module.getProject());
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/web/framework/WebFrameworkSupportProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworkType";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/web/framework/WebFrameworkSupportProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledForModuleBuilder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class WebFrameworkSupportConfigurable
    extends JavaeeFrameworkSupportProviderBase.JavaeeFrameworkSupportConfigurable {
        private final JPanel myPanel;
        private final JCheckBox myCreateWebXmlBox;
        private boolean myCreateWebXml;

        public WebFrameworkSupportConfigurable(FrameworkSupportModel model) {
            super((JavaeeFrameworkSupportProviderBase)WebFrameworkSupportProvider.this, model);
            this.myPanel = new JPanel(new BorderLayout());
            this.myCreateWebXmlBox = new JCheckBox(J2EEBundle.message((String)"web.facet.create.web.xml", (Object[])new Object[0]));
            this.myCreateWebXml = true;
            this.myPanel.add((Component)this.myCreateWebXmlBox, "Center");
            this.myCreateWebXmlBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WebFrameworkSupportConfigurable.this.myCreateWebXml = WebFrameworkSupportConfigurable.this.myCreateWebXmlBox.isSelected();
                }
            });
            ((FrameworkSupportModelBase)model).addFrameworkVersionListener(new FrameworkVersionListener(){

                public void versionChanged(FrameworkVersion version) {
                    if (version instanceof WebFrameworkVersion) {
                        WebFrameworkSupportConfigurable.this.updateCheckBox();
                    }
                }
            }, (Disposable)this);
        }

        @Nullable
        protected ConfigFileVersion getVersionToCreate(JavaeeFrameworkVersionBase frameworkVersion) {
            if (!this.myCreateWebXmlBox.isSelected()) {
                return null;
            }
            return super.getVersionToCreate(frameworkVersion);
        }

        private void updateCheckBox() {
            FrameworkVersion version = ((FrameworkSupportModelBase)this.myModel).getSelectedVersion(WebFrameworkType.getInstance().getId());
            boolean isWebXmlOptional = version instanceof WebFrameworkVersion && ((WebFrameworkVersion)version).isWebXmlOptional();
            this.myCreateWebXmlBox.setSelected(!isWebXmlOptional || this.myCreateWebXml);
            this.myCreateWebXmlBox.setVisible(isWebXmlOptional);
        }

        @Nullable
        public JComponent createComponent() {
            this.updateCheckBox();
            return this.myPanel;
        }

        @TestOnly
        public JCheckBox getCheckBox() {
            return this.myCreateWebXmlBox;
        }
    }
}

