/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.debugger.impl;

import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetUtil;
import com.intellij.javaee.web.DeployedFileUrlConverter;
import com.intellij.javaee.web.WebDirectoryElement;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.deployment.JspDeploymentManager;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.psi.jsp.WebDirectoryUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.jsp.JspFile;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.Nullable;

public class JspDeploymentManagerImpl
extends JspDeploymentManager {
    private static final Logger LOG = Logger.getInstance(JspDeploymentManagerImpl.class);

    @Nullable
    public PsiFile getDeployedJspSource(String relPath, Project project) {
        return this.getDeployedJspSource(relPath, project, JavaeeFacetUtil.getInstance().getAllJavaeeFacets(project));
    }

    @Nullable
    public PsiFile getDeployedJspSource(String relPath, Project project, JavaeeFacet[] facets) {
        JavaeeFacet[] allFacets;
        WebDirectoryUtil webDirectoryUtil = WebDirectoryUtil.getWebDirectoryUtil(project);
        HashSet<JavaeeFacet> processed = new HashSet<JavaeeFacet>();
        for (JavaeeFacet facet : facets) {
            PsiFile sourceFile = JspDeploymentManagerImpl.getSourceFile(relPath, webDirectoryUtil, facet);
            if (sourceFile != null) {
                return sourceFile;
            }
            processed.add(facet);
        }
        for (JavaeeFacet facet : allFacets = JavaeeFacetUtil.getInstance().getAllJavaeeFacets(project)) {
            PsiFile sourceFile;
            if (processed.contains(facet) || (sourceFile = JspDeploymentManagerImpl.getSourceFile(relPath, webDirectoryUtil, facet)) == null) continue;
            return sourceFile;
        }
        return null;
    }

    @Nullable
    private static PsiFile getSourceFile(String relPath, WebDirectoryUtil webDirectoryUtil, JavaeeFacet javaeeFacet) {
        if (!(javaeeFacet instanceof WebFacet)) {
            return null;
        }
        PsiFileSystemItem file = webDirectoryUtil.findFileByPath(relPath, (WebFacet)javaeeFacet);
        if (file instanceof WebDirectoryElement) {
            return ((WebDirectoryElement)file).getOriginalFile();
        }
        if (file instanceof PsiFile) {
            return (PsiFile)file;
        }
        LOG.assertTrue(file == null);
        return null;
    }

    public String getSourceJspDeployment(PsiFile file) {
        FileType fileType = file.getFileType();
        if (!fileType.equals(StdFileTypes.JSP) && !fileType.equals(StdFileTypes.JSPX)) {
            return null;
        }
        JspFile jspFile = JspPsiUtil.getJspFile((PsiElement)file);
        LOG.assertTrue(jspFile != null);
        WebDirectoryElement parentWebDirectory = WebUtil.getWebUtil().getParentWebDirectory((PsiFile)jspFile);
        if (parentWebDirectory == null) {
            return null;
        }
        Object path = parentWebDirectory.getPath();
        if (!StringUtil.endsWithChar((CharSequence)path, (char)'/')) {
            path = (String)path + "/";
        }
        return (String)path + jspFile.getVirtualFile().getName();
    }

    @Nullable
    public String computeRelativeTargetPath(PsiFile file, WebFacet webFacet) {
        for (DeployedFileUrlConverter converter : (DeployedFileUrlConverter[])DeployedFileUrlConverter.EP_NAME.getExtensions()) {
            Collection<String> path = converter.getTargetPaths(file, webFacet);
            if (path == null || path.isEmpty()) continue;
            return path.iterator().next();
        }
        return null;
    }
}

