/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web;

import com.intellij.facet.FacetConfiguration;
import com.intellij.javaee.model.JavaeeModelElement;
import com.intellij.javaee.web.CommonServletMapping;
import com.intellij.javaee.web.ServletMappingInfo;
import com.intellij.javaee.web.ServletMappingType;
import com.intellij.javaee.web.WebDirectoryElement;
import com.intellij.javaee.web.WebModel;
import com.intellij.javaee.web.WebModelBase;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.facet.WebFacetConfigurationImpl;
import com.intellij.javaee.web.facet.WebRootData;
import com.intellij.javaee.web.model.xml.Servlet;
import com.intellij.javaee.web.model.xml.WebApp;
import com.intellij.javaee.web.psi.jsp.WebDirectoryUtil;
import com.intellij.javaee.web.psi.jsp.impl.WebDirectoryElementImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebUtilImpl
extends WebUtil {
    public static boolean isWebFacetConfigurationContainingFiles(FacetConfiguration configuration, Set<? extends VirtualFile> files) {
        if (!(configuration instanceof WebFacetConfigurationImpl)) {
            return false;
        }
        VirtualFile file = (VirtualFile)ContainerUtil.getFirstItem(files);
        if (file == null) {
            return false;
        }
        WebFacetConfigurationImpl webConfiguration = (WebFacetConfigurationImpl)configuration;
        return WebUtilImpl.isInsideWebRootsInternal(file, webConfiguration.getWebRoots()) || WebUtilImpl.isUnderSourceRoots(file, webConfiguration.getSourceRoots());
    }

    private static boolean isInsideWebRootsInternal(VirtualFile source, List<? extends WebRootData> webRoots) {
        for (WebRootData webRootData : webRoots) {
            VirtualFile root = webRootData.findFile();
            if (root == null || !VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)source, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public WebDirectoryElement createWebDirectoryElement(WebFacet webFacet, @NotNull String path, boolean isDirectory) {
        if (path == null) {
            WebUtilImpl.$$$reportNull$$$0(0);
        }
        return new WebDirectoryElementImpl(webFacet, path, isDirectory);
    }

    public WebModel getLocalWebModel(@NotNull XmlFile file) {
        Module module;
        if (file == null) {
            WebUtilImpl.$$$reportNull$$$0(1);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file)) == null) {
            return null;
        }
        final DomFileElement element = DomManager.getDomManager((Project)file.getProject()).getFileElement(file, WebApp.class);
        return element == null ? null : new WebModelBase(){

            @Override
            @NotNull
            protected Module getModule() {
                Module module2 = module;
                if (module2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return module2;
            }

            @Override
            protected Collection<WebApp> getApps() {
                return Collections.singleton((WebApp)element.getRootElement());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/WebUtilImpl$1", "getModule"));
            }
        };
    }

    @Nullable
    public WebDirectoryElement findWebDirectoryByFile(@NotNull VirtualFile file, @NotNull WebFacet webFacet) {
        if (file == null) {
            WebUtilImpl.$$$reportNull$$$0(2);
        }
        if (webFacet == null) {
            WebUtilImpl.$$$reportNull$$$0(3);
        }
        return WebDirectoryUtil.getWebDirectoryUtil(webFacet.getModule().getProject()).findWebDirectoryByFile(file, webFacet);
    }

    @Nullable
    public JspFile getJspFile(Servlet servlet) {
        String jspFileName = (String)servlet.getJspFile().getValue();
        if (jspFileName == null) {
            return null;
        }
        WebFacet webFacet = WebUtilImpl.getWebFacet((JavaeeModelElement)servlet);
        if (webFacet == null) {
            return null;
        }
        WebDirectoryUtil webDirectoryUtil = WebDirectoryUtil.getWebDirectoryUtil(webFacet.getModule().getProject());
        PsiFileSystemItem psiElement = webDirectoryUtil.findFileByPath(jspFileName, webFacet);
        if (psiElement == null) {
            return null;
        }
        return JspPsiUtil.getJspFile((PsiElement)psiElement);
    }

    private static boolean isUnderSourceRoots(VirtualFile file, List<String> urls) {
        for (String url : urls) {
            VirtualFile root = VirtualFileManager.getInstance().findFileByUrl(url);
            if (root == null || !VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static ServletMappingInfo resolveServletMappingInfo(@NotNull String url, @NotNull WebFacet webFacet) {
        if (url == null) {
            WebUtilImpl.$$$reportNull$$$0(4);
        }
        if (webFacet == null) {
            WebUtilImpl.$$$reportNull$$$0(5);
        }
        ServletMappingInfo result = null;
        int urlLength = url.length();
        for (CommonServletMapping mapping : webFacet.getWebModel().getServletMappings()) {
            for (GenericValue value : mapping.getUrlPatterns()) {
                String urlPattern = (String)value.getValue();
                if (urlPattern == null) continue;
                ServletMappingType patternType = ServletMappingType.getPatternType((String)urlPattern);
                switch (patternType) {
                    case EXACT: {
                        if (!url.equals(urlPattern) && (!urlPattern.startsWith("/") || !urlPattern.substring(1).equals(url))) break;
                        return patternType.createMappingInfo(urlPattern, mapping);
                    }
                    case EXTENSION: {
                        int patternLength = urlPattern.length();
                        if (urlLength < patternLength || !url.regionMatches(urlLength - patternLength + 1, urlPattern, 1, patternLength - 1) || result != null && urlPattern.length() <= result.getUrlPattern().length()) break;
                        result = patternType.createMappingInfo(urlPattern, mapping);
                        break;
                    }
                    case PATH: {
                        int urlOffset;
                        int n = urlOffset = url.startsWith("/") ? 1 : 0;
                        if (!url.regionMatches(urlOffset, urlPattern, 1, urlPattern.length() - 2) || result != null && urlPattern.length() <= result.getUrlPattern().length()) break;
                        result = patternType.createMappingInfo(urlPattern, mapping);
                        break;
                    }
                    case DEFAULT: {
                        if (result != null) break;
                        result = patternType.createMappingInfo(urlPattern, mapping);
                    }
                }
            }
        }
        return result;
    }

    @Nullable
    public WebDirectoryElement getParentWebDirectory(@NotNull PsiFile file) {
        VirtualFile virtualFile;
        if (file == null) {
            WebUtilImpl.$$$reportNull$$$0(6);
        }
        if ((virtualFile = file.getOriginalFile().getVirtualFile()) == null) {
            return null;
        }
        return WebDirectoryUtil.findParentWebDirectory(file.getProject(), virtualFile);
    }

    @Nullable
    public String getWebPath(PsiFile file) {
        return WebUtilImpl.getWebPath(this.getParentWebDirectory(file), file.getName());
    }

    @Nullable
    public String getWebPath(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            WebUtilImpl.$$$reportNull$$$0(7);
        }
        if (file == null) {
            WebUtilImpl.$$$reportNull$$$0(8);
        }
        return WebUtilImpl.getWebPath(WebDirectoryUtil.findParentWebDirectory(project, file), file.getName());
    }

    private static String getWebPath(@Nullable WebDirectoryElement parent, @NotNull String fileName) {
        if (fileName == null) {
            WebUtilImpl.$$$reportNull$$$0(9);
        }
        if (parent != null) {
            String parentPath = parent.getPath();
            return parentPath.endsWith("/") ? parentPath + fileName : parentPath + "/" + fileName;
        }
        return null;
    }

    @Nullable
    public WebDirectoryElement findWebDirectoryElement(@NotNull @NonNls String path, @NotNull WebFacet facet) {
        if (path == null) {
            WebUtilImpl.$$$reportNull$$$0(10);
        }
        if (facet == null) {
            WebUtilImpl.$$$reportNull$$$0(11);
        }
        return WebDirectoryUtil.resolveAbsolutePath(path, facet);
    }

    public void visitAllFacets(@NotNull Module thisModule, Consumer<? super WebFacet> visitor) {
        if (thisModule == null) {
            WebUtilImpl.$$$reportNull$$$0(12);
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)thisModule);
        Object[] dependencies = moduleRootManager.getDependencies();
        ArrayList<Module> modules = new ArrayList<Module>(dependencies.length + 1);
        modules.add(thisModule);
        ContainerUtil.addAll(modules, (Object[])dependencies);
        for (Module module : modules) {
            Collection facets = WebFacet.getInstances((Module)module);
            for (WebFacet facet : facets) {
                visitor.consume((Object)facet);
            }
        }
    }

    public Collection<PsiFileSystemItem> getContextsByPath(String path, @NotNull Module module) {
        if (module == null) {
            WebUtilImpl.$$$reportNull$$$0(13);
        }
        ArrayList<PsiFileSystemItem> list = new ArrayList<PsiFileSystemItem>();
        WebUtil.getWebUtil().visitAllFacets(module, webFacet -> {
            WebDirectoryElement element = WebDirectoryUtil.getWebDirectoryUtil(module.getProject()).findWebDirectoryElementByPath(path, (WebFacet)webFacet);
            if (element != null) {
                list.add((PsiFileSystemItem)element);
            }
        });
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "webFacet";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisModule";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javaee/web/WebUtilImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createWebDirectoryElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getLocalWebModel";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findWebDirectoryByFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveServletMappingInfo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getParentWebDirectory";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getWebPath";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "findWebDirectoryElement";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "visitAllFacets";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getContextsByPath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

