/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.starter;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.ide.starters.JavaStartersBundle;
import com.intellij.ide.starters.remote.WebStarterContext;
import com.intellij.ide.starters.remote.WebStarterContextProvider;
import com.intellij.ide.starters.remote.WebStarterDependency;
import com.intellij.ide.starters.remote.WebStarterDependencyCategory;
import com.intellij.ide.starters.remote.WebStarterFrameworkVersion;
import com.intellij.ide.starters.remote.WebStarterModuleBuilder;
import com.intellij.ide.starters.remote.WebStarterServerOptions;
import com.intellij.ide.starters.remote.WebStarterSettings;
import com.intellij.ide.starters.remote.wizard.WebStarterLibrariesStep;
import com.intellij.ide.starters.shared.CustomizedMessages;
import com.intellij.ide.starters.shared.LibraryLink;
import com.intellij.ide.starters.shared.LibraryLinkType;
import com.intellij.ide.starters.shared.StarterAppType;
import com.intellij.ide.starters.shared.StarterLanguage;
import com.intellij.ide.starters.shared.StarterLanguageLevel;
import com.intellij.ide.starters.shared.StarterProjectType;
import com.intellij.ide.starters.shared.StarterTestRunner;
import com.intellij.micronaut.MicronautBundle;
import com.intellij.micronaut.MicronautIcons;
import com.intellij.micronaut.starter.MicronautModuleBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.io.HttpRequests;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002BCB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0014J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0014J\b\u0010\u0019\u001a\u00020\nH\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0014J\b\u0010 \u001a\u00020!H\u0014J\b\u0010\"\u001a\u00020\nH\u0016J\b\u0010#\u001a\u00020\nH\u0016J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\n0\u0017H\u0014J\b\u0010%\u001a\u00020\nH\u0016J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020!0\u0017H\u0014J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u0017H\u0014J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020\nH\u0016J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u0017H\u0014J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u0017H\u0014J\u0018\u00100\u001a\u0002012\u0006\u0010\t\u001a\u00020\n2\u0006\u00102\u001a\u000203H\u0002J&\u00104\u001a\b\u0012\u0004\u0012\u000206052\u0006\u0010\t\u001a\u00020\n2\u0006\u00107\u001a\u00020\n2\u0006\u00108\u001a\u000209H\u0002J\u0010\u0010:\u001a\u0002012\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010;\u001a\u00020\n2\u0006\u0010<\u001a\u00020\nH\u0002J\u0018\u0010=\u001a\u00020\n2\u0006\u0010>\u001a\u00020\n2\u0006\u0010?\u001a\u00020\nH\u0002J\b\u0010@\u001a\u00020AH\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/intellij/micronaut/starter/MicronautModuleBuilder;", "Lcom/intellij/ide/starters/remote/WebStarterModuleBuilder;", "()V", "INVALID_ARTIFACT_SYMBOL_PATTERN", "Lkotlin/text/Regex;", "composeEndpointUrl", "Lcom/intellij/util/Url;", "starterContext", "Lcom/intellij/ide/starters/remote/WebStarterContext;", "serverUrl", "", "endpoint", "composeGeneratorUrl", "createLibrariesStep", "Lcom/intellij/ide/starters/remote/wizard/WebStarterLibrariesStep;", "contextProvider", "Lcom/intellij/ide/starters/remote/WebStarterContextProvider;", "extractGeneratorResult", "", "tempZipFile", "Ljava/io/File;", "contentEntryDir", "getApplicationTypes", "", "Lcom/intellij/ide/starters/shared/StarterAppType;", "getBuilderId", "getCategoryPriority", "", "category", "Lcom/intellij/micronaut/starter/MicronautModuleBuilder$MicronautFeatureCategory;", "getCustomizedMessages", "Lcom/intellij/ide/starters/shared/CustomizedMessages;", "getDefaultLanguageLevel", "Lcom/intellij/ide/starters/shared/StarterLanguageLevel;", "getDefaultServerUrl", "getDescription", "getFilePathsToOpen", "getHelpId", "getLanguageLevels", "getLanguages", "Lcom/intellij/ide/starters/shared/StarterLanguage;", "getNodeIcon", "Ljavax/swing/Icon;", "getPresentableName", "getProjectTypes", "Lcom/intellij/ide/starters/shared/StarterProjectType;", "getTestFrameworks", "Lcom/intellij/ide/starters/shared/StarterTestRunner;", "handleOptionsJson", "Lcom/intellij/ide/starters/remote/WebStarterServerOptions;", "optionsJson", "Lcom/google/gson/JsonObject;", "loadFeatures", "", "Lcom/intellij/ide/starters/remote/WebStarterDependencyCategory;", "appTypeId", "descriptionLinkPattern", "Ljava/util/regex/Pattern;", "loadServerOptions", "sanitizeArtifact", "input", "suggestBasePackage", "group", "artifact", "validateOptions", "Lcom/intellij/micronaut/starter/MicronautModuleBuilder$ValidationResult;", "MicronautFeatureCategory", "ValidationResult", "intellij.micronaut"})
public final class MicronautModuleBuilder
extends WebStarterModuleBuilder {
    private final Regex INVALID_ARTIFACT_SYMBOL_PATTERN = new Regex("[^a-zA-Z0-9_.-]");

    @NotNull
    public String getDefaultServerUrl() {
        return "https://launch.micronaut.io";
    }

    @NotNull
    public String getBuilderId() {
        return "micronaut";
    }

    @NotNull
    public Icon getNodeIcon() {
        Icon icon = MicronautIcons.MicronautLogo;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"MicronautIcons.MicronautLogo");
        return icon;
    }

    @NotNull
    public String getPresentableName() {
        return "Micronaut";
    }

    @NotNull
    public String getDescription() {
        return MicronautBundle.message("micronaut.starter.description.for.micronaut.project.starter", new Object[0]);
    }

    @NotNull
    public String getHelpId() {
        return "micronaut.project";
    }

    @NotNull
    protected List<StarterProjectType> getProjectTypes() {
        return CollectionsKt.listOf((Object[])new StarterProjectType[]{new StarterProjectType("MAVEN", "Maven", null, 4, null), new StarterProjectType("GRADLE", "Gradle", null, 4, null)});
    }

    @NotNull
    protected List<StarterLanguage> getLanguages() {
        return CollectionsKt.listOf((Object[])new StarterLanguage[]{new StarterLanguage("JAVA", "Java", "JAVA", false, null, 24, null), new StarterLanguage("KOTLIN", "Kotlin", "kotlin", false, null, 24, null), new StarterLanguage("GROOVY", "Groovy", "Groovy", false, null, 24, null)});
    }

    @NotNull
    protected List<StarterTestRunner> getTestFrameworks() {
        return CollectionsKt.listOf((Object[])new StarterTestRunner[]{new StarterTestRunner("JUNIT", "JUnit"), new StarterTestRunner("KOTLINTEST", "Kotest"), new StarterTestRunner("SPOCK", "Spock")});
    }

    @NotNull
    protected List<StarterAppType> getApplicationTypes() {
        return CollectionsKt.listOf((Object[])new StarterAppType[]{new StarterAppType("DEFAULT", "Application"), new StarterAppType("CLI", "CLI Application"), new StarterAppType("FUNCTION", "Serverless Function"), new StarterAppType("GRPC", "gRPC Application"), new StarterAppType("MESSAGING", "Messaging Application")});
    }

    @NotNull
    protected StarterLanguageLevel getDefaultLanguageLevel() {
        return new StarterLanguageLevel("JDK_11", "11", "11");
    }

    @NotNull
    protected List<StarterLanguageLevel> getLanguageLevels() {
        return CollectionsKt.listOf((Object[])new StarterLanguageLevel[]{new StarterLanguageLevel("JDK_15", "15", "15"), new StarterLanguageLevel("JDK_11", "11", "11"), new StarterLanguageLevel("JDK_8", "8", "8")});
    }

    @NotNull
    protected List<String> getFilePathsToOpen() {
        return CollectionsKt.listOf((Object)"README.md");
    }

    @NotNull
    protected CustomizedMessages getCustomizedMessages() {
        CustomizedMessages customizedMessages = new CustomizedMessages();
        boolean bl = false;
        boolean bl2 = false;
        CustomizedMessages $this$apply = customizedMessages;
        boolean bl3 = false;
        $this$apply.setProjectTypeLabel(JavaStartersBundle.message((String)"title.project.build.system.label", (Object[])new Object[0]));
        $this$apply.setDependenciesLabel(MicronautBundle.message("micronaut.starter.features.label", new Object[0]));
        $this$apply.setSelectedDependenciesLabel(MicronautBundle.message("micronaut.starter.selected.features.label", new Object[0]));
        $this$apply.setNoDependenciesSelectedLabel(MicronautBundle.message("micronaut.starter.select.features.hint", new Object[0]));
        $this$apply.setServerUrlDialogTitle(MicronautBundle.message("micronaut.starter.server.url.label", new Object[0]));
        $this$apply.setFrameworkVersionLabel(MicronautBundle.message("micronaut.starter.version.label", new Object[0]));
        return customizedMessages;
    }

    @NotNull
    protected WebStarterServerOptions loadServerOptions(@NotNull String serverUrl) {
        JsonObject json;
        Intrinsics.checkNotNullParameter((Object)serverUrl, (String)"serverUrl");
        JsonObject jsonObject = json = WebStarterModuleBuilder.loadJsonData$default((WebStarterModuleBuilder)this, (String)(StringsKt.removeSuffix((String)serverUrl, (CharSequence)"/") + "/select-options"), null, (int)2, null).getAsJsonObject();
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"json");
        return this.handleOptionsJson(serverUrl, jsonObject);
    }

    /*
     * WARNING - void declaration
     */
    private final WebStarterServerOptions handleOptionsJson(String serverUrl, JsonObject optionsJson) {
        JsonArray jdkNodes;
        void $this$flatMapTo$iv$iv;
        StarterAppType starterAppType;
        Collection collection;
        void $this$mapTo$iv$iv;
        JsonElement jsonElement = optionsJson.get("type");
        if (jsonElement == null || (jsonElement = jsonElement.getAsJsonObject()) == null || (jsonElement = jsonElement.get("options")) == null || (jsonElement = jsonElement.getAsJsonArray()) == null) {
            throw (Throwable)new IOException("Unable to read application types");
        }
        JsonElement typesNode = jsonElement;
        Iterable $this$map$iv = (Iterable)typesNode;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Iterator it;
            JsonElement jsonElement2 = (JsonElement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
            JsonObject typeObject = v1.getAsJsonObject();
            JsonElement jsonElement3 = typeObject.get("name");
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement3, (String)"typeObject.get(\"name\")");
            String id = jsonElement3.getAsString();
            JsonElement jsonElement4 = typeObject.get("title");
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement4, (String)"typeObject.get(\"title\")");
            String string = jsonElement4.getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"typeObject.get(\"title\").asString");
            String title = StringsKt.removePrefix((String)string, (CharSequence)"Micronaut ");
            String string2 = id;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"id");
            starterAppType = new StarterAppType(string2, title);
            collection.add(starterAppType);
        }
        List types = (List)destination$iv$iv;
        Pattern descriptionLinkPattern = Pattern.compile(" \\((http[s]?://[^\\s]+)\\)");
        Iterable $this$flatMap$iv = types;
        boolean $i$f$flatMap = false;
        Iterable $i$f$mapTo22 = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            StarterAppType it = (StarterAppType)element$iv$iv;
            boolean bl = false;
            String string = it.getId();
            Pattern pattern = descriptionLinkPattern;
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"descriptionLinkPattern");
            Iterable list$iv$iv = this.loadFeatures(serverUrl, string, pattern);
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List dependencyCategories = (List)destination$iv$iv2;
        JsonObject versionsJson = WebStarterModuleBuilder.loadJsonData$default((WebStarterModuleBuilder)this, (String)(StringsKt.removeSuffix((String)serverUrl, (CharSequence)"/") + "/versions"), null, (int)2, null).getAsJsonObject();
        Object object = versionsJson.get("versions");
        if (object == null || (object = object.getAsJsonObject()) == null || (object = object.get("micronaut.version")) == null || (object = object.getAsString()) == null) {
            throw (Throwable)new IOException("Unable to read Micronaut version");
        }
        Object version = object;
        WebStarterServerOptions options = new WebStarterServerOptions(CollectionsKt.listOf((Object)new WebStarterFrameworkVersion((String)version, (String)version, true)), dependencyCategories);
        options.putUserData(WebStarterSettings.getSERVER_APPLICATION_TYPES(), (Object)types);
        JsonElement jsonElement5 = optionsJson.get("jdkVersion");
        Object jdkConfigObject = jsonElement5 != null ? jsonElement5.getAsJsonObject() : null;
        JsonObject jsonObject = jdkConfigObject;
        JsonArray jsonArray = jsonObject != null && (jsonObject = jsonObject.get("options")) != null ? jsonObject.getAsJsonArray() : (jdkNodes = null);
        if (jdkNodes != null) {
            String defaultOptionName;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv2 = (Iterable)jdkNodes;
            boolean $i$f$map2 = false;
            Iterable bl = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                Object object2 = (JsonElement)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl2 = false;
                void v12 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"it");
                JsonObject jdkObject = v12.getAsJsonObject();
                JsonElement jsonElement6 = jdkObject.get("name");
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement6, (String)"jdkObject.get(\"name\")");
                String id = jsonElement6.getAsString();
                JsonElement jsonElement7 = jdkObject.get("label");
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement7, (String)"jdkObject.get(\"label\")");
                String title = jsonElement7.getAsString();
                String string = id;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"id");
                String string3 = title;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"title");
                starterAppType = new StarterLanguageLevel(string, string3, StringsKt.removePrefix((String)id, (CharSequence)"JDK_"));
                collection.add(starterAppType);
            }
            List languageLevels = (List)destination$iv$iv3;
            options.putUserData(WebStarterSettings.getSERVER_LANGUAGE_LEVELS_KEY(), (Object)languageLevels);
            JsonElement jsonElement8 = jdkConfigObject.get("defaultOption");
            String string = jsonElement8 != null && (jsonElement8 = jsonElement8.getAsJsonObject()) != null && (jsonElement8 = jsonElement8.get("name")) != null ? jsonElement8.getAsString() : (defaultOptionName = null);
            if (defaultOptionName != null) {
                Object object3;
                block8: {
                    Iterable iterable2 = languageLevels;
                    boolean bl3 = false;
                    Iterable iterable3 = iterable2;
                    boolean bl4 = false;
                    for (Object object2 : iterable3) {
                        StarterLanguageLevel it = (StarterLanguageLevel)object2;
                        boolean bl5 = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)defaultOptionName)) continue;
                        object3 = object2;
                        break block8;
                    }
                    object3 = null;
                }
                StarterLanguageLevel defaultLanguageLevel = (StarterLanguageLevel)object3;
                options.putUserData(WebStarterSettings.getSERVER_LANGUAGE_LEVEL_KEY(), (Object)defaultLanguageLevel);
            }
        }
        return options;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<WebStarterDependencyCategory> loadFeatures(String serverUrl, String appTypeId, Pattern descriptionLinkPattern) {
        JsonObject featuresRoot = WebStarterModuleBuilder.loadJsonData$default((WebStarterModuleBuilder)this, (String)(StringsKt.removeSuffix((String)serverUrl, (CharSequence)"/") + "/application-types/" + appTypeId + "/features"), null, (int)2, null).getAsJsonObject();
        boolean bl = false;
        Map categories = new LinkedHashMap();
        JsonElement jsonElement = featuresRoot.get("features");
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"featuresRoot.get(\"features\")");
        Iterator iterator = jsonElement.getAsJsonArray().iterator();
        while (iterator.hasNext()) {
            List list;
            Object object;
            String key$iv;
            void $this$getOrPut$iv;
            JsonElement jsonElement2;
            JsonElement jsonElement3 = jsonElement2 = (JsonElement)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement3, (String)"jsonElement");
            JsonObject featureElement = jsonElement3.getAsJsonObject();
            JsonElement jsonElement4 = featureElement.get("category");
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement4, (String)"featureElement.get(\"category\")");
            String categoryName = jsonElement4.getAsString();
            Map map = categories;
            Intrinsics.checkNotNullExpressionValue((Object)categoryName, (String)"categoryName");
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                MicronautFeatureCategory answer$iv = new MicronautFeatureCategory(appTypeId, categoryName, null, 4, null);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            MicronautFeatureCategory category = (MicronautFeatureCategory)((Object)object);
            JsonElement jsonElement5 = featureElement.get("name");
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement5, (String)"featureElement.get(\"name\")");
            String id = jsonElement5.getAsString();
            JsonElement jsonElement6 = featureElement.get("title");
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement6, (String)"featureElement.get(\"title\")");
            String title = jsonElement6.getAsString();
            JsonElement jsonElement7 = featureElement.get("description");
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement7, (String)"featureElement.get(\"description\")");
            String description = jsonElement7.getAsString();
            Matcher matcher = descriptionLinkPattern.matcher(description);
            if (matcher.find()) {
                StringBuilder stringBuilder = new StringBuilder();
                String string = description;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"description");
                String string2 = string;
                int n = 0;
                int n2 = matcher.start();
                boolean bl3 = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n, n2);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                StringBuilder stringBuilder2 = stringBuilder.append(string4);
                string2 = description;
                n = matcher.end();
                n2 = 0;
                String string5 = string2.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                description = stringBuilder2.append(string5).toString();
                String string6 = matcher.group(1);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"matcher.group(1)");
                list = CollectionsKt.listOf((Object)new LibraryLink(LibraryLinkType.WEBSITE, string6, null, 4, null));
            } else {
                list = CollectionsKt.emptyList();
            }
            List links = list;
            List<WebStarterDependency> list2 = category.getFeatures();
            String string = id;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"id");
            String string7 = title;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"title");
            list2.add(new WebStarterDependency(string, string7, description, links, false, false, 48, null));
        }
        Iterable $this$sortedBy$iv = categories.values();
        boolean $i$f$sortedBy = false;
        boolean bl4 = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(this){
            final /* synthetic */ MicronautModuleBuilder this$0;
            {
                this.this$0 = micronautModuleBuilder;
            }

            public final int compare(T a, T b) {
                boolean bl = false;
                MicronautFeatureCategory it = (MicronautFeatureCategory)((Object)a);
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(MicronautModuleBuilder.access$getCategoryPriority(this.this$0, it));
                it = (MicronautFeatureCategory)((Object)b);
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = MicronautModuleBuilder.access$getCategoryPriority(this.this$0, it);
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        });
    }

    @NotNull
    protected Url composeGeneratorUrl(@NotNull String serverUrl, @NotNull WebStarterContext starterContext) {
        Intrinsics.checkNotNullParameter((Object)serverUrl, (String)"serverUrl");
        Intrinsics.checkNotNullParameter((Object)starterContext, (String)"starterContext");
        return this.composeEndpointUrl(starterContext, serverUrl, "create");
    }

    private final Url composeEndpointUrl(WebStarterContext starterContext, String serverUrl, String endpoint) {
        String basePackage = this.suggestBasePackage(starterContext.getGroup(), starterContext.getArtifact());
        StringBuilder stringBuilder = new StringBuilder().append(StringsKt.removeSuffix((String)serverUrl, (CharSequence)"/")).append('/').append(endpoint).append('/');
        StarterAppType starterAppType = starterContext.getApplicationType();
        Intrinsics.checkNotNull((Object)starterAppType);
        Url url = Urls.newFromEncoded((String)stringBuilder.append(starterAppType.getId()).append("/").append(basePackage).toString());
        String lang = starterContext.getLanguage().getId();
        StarterProjectType starterProjectType = starterContext.getProjectType();
        Intrinsics.checkNotNull((Object)starterProjectType);
        String projectType = starterProjectType.getId();
        if (Intrinsics.areEqual((Object)projectType, (Object)"GRADLE") && Intrinsics.areEqual((Object)lang, (Object)"KOTLIN")) {
            projectType = "GRADLE_KOTLIN";
        }
        Pair[] pairArray = new Pair[4];
        pairArray[0] = TuplesKt.to((Object)"build", (Object)projectType);
        StarterTestRunner starterTestRunner = starterContext.getTestFramework();
        Intrinsics.checkNotNull((Object)starterTestRunner);
        pairArray[1] = TuplesKt.to((Object)"test", (Object)starterTestRunner.getId());
        pairArray[2] = TuplesKt.to((Object)"lang", (Object)lang);
        StarterLanguageLevel starterLanguageLevel = starterContext.getLanguageLevel();
        Intrinsics.checkNotNull((Object)starterLanguageLevel);
        pairArray[3] = TuplesKt.to((Object)"javaVersion", (Object)starterLanguageLevel.getId());
        Url url2 = url.addParameters(MapsKt.mapOf((Pair[])pairArray));
        Intrinsics.checkNotNullExpressionValue((Object)url2, (String)"url.addParameters(mapOf(\u2026languageLevel!!.id\n    ))");
        url = url2;
        Collection collection = starterContext.getDependencies();
        boolean bl = false;
        if (!collection.isEmpty()) {
            String features2 = CollectionsKt.joinToString$default((Iterable)starterContext.getDependencies(), (CharSequence)",", null, null, (int)0, null, (Function1)composeEndpointUrl.features.1.INSTANCE, (int)30, null);
            Url url3 = url.addParameters(MapsKt.mapOf((Pair)TuplesKt.to((Object)"features", (Object)features2)));
            Intrinsics.checkNotNullExpressionValue((Object)url3, (String)"url.addParameters(mapOf(\"features\" to features))");
            url = url3;
        }
        return url;
    }

    private final String suggestBasePackage(String group, String artifact) {
        String string = group;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String groupPrefix2 = CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)string3, (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null), (CharSequence)".", null, null, (int)0, null, (Function1)suggestBasePackage.groupPrefix.1.INSTANCE, (int)30, null);
        return groupPrefix2 + '.' + this.sanitizeArtifact(artifact);
    }

    private final String sanitizeArtifact(String input) {
        String string = FileUtil.sanitizeFileName((String)input, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtil.sanitizeFileName(input, false)");
        String fileName = string;
        CharSequence charSequence = fileName;
        Regex regex = this.INVALID_ARTIFACT_SYMBOL_PATTERN;
        String string2 = "_";
        boolean bl = false;
        charSequence = regex.replace(charSequence, string2);
        boolean bl2 = false;
        CharSequence charSequence2 = charSequence;
        if (charSequence2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = ((String)charSequence2).toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        return string3;
    }

    protected void extractGeneratorResult(@NotNull File tempZipFile, @NotNull File contentEntryDir) {
        Intrinsics.checkNotNullParameter((Object)tempZipFile, (String)"tempZipFile");
        Intrinsics.checkNotNullParameter((Object)contentEntryDir, (String)"contentEntryDir");
        WebStarterSettings.unzipSubfolder((File)tempZipFile, (File)contentEntryDir);
    }

    @NotNull
    protected WebStarterLibrariesStep createLibrariesStep(@NotNull WebStarterContextProvider contextProvider) {
        Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"contextProvider");
        return new WebStarterLibrariesStep(this, contextProvider, contextProvider){
            final /* synthetic */ MicronautModuleBuilder this$0;
            final /* synthetic */ WebStarterContextProvider $contextProvider;

            protected boolean validateWithServer(@NotNull ProgressIndicator progressIndicator) {
                Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
                progressIndicator.setText(MicronautBundle.message("micronaut.starter.message.validating.dependencies", new Object[0]));
                WebStarterSettings.addStarterNetworkDelay();
                try {
                    ValidationResult result = MicronautModuleBuilder.access$validateOptions(this.this$0);
                    if (result.getMessage() != null) {
                        progressIndicator.checkCanceled();
                        this.showError(result.getMessage());
                        return false;
                    }
                }
                catch (IOException e) {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(MicronautModuleBuilder.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                    logger.info((Throwable)e);
                    String string = JavaStartersBundle.message((String)"error.text.with.error.content", (Object[])new Object[]{e.getMessage()});
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JavaStartersBundle.messa\u2026rror.content\", e.message)");
                    this.showError(string);
                }
                return true;
            }

            private final void showError(String error) {
                ApplicationManager.getApplication().invokeLater(new Runnable(error){
                    final /* synthetic */ String $error;

                    public final void run() {
                        Messages.showErrorDialog((String)JavaStartersBundle.message((String)"error.text.with.error.content", (Object[])new Object[]{this.$error}), (String)MicronautBundle.message("micronaut.starter.message.validation.title", new Object[0]));
                    }
                    {
                        this.$error = string;
                    }
                }, this.getModalityState(), this.getDisposed());
            }
            {
                this.this$0 = this$0;
                this.$contextProvider = $captured_local_variable$1;
                super($super_call_param$2);
            }
        };
    }

    @RequiresBackgroundThread
    private final ValidationResult validateOptions() {
        Url url = this.composeEndpointUrl(this.getStarterContext(), this.getStarterContext().getServerUrl(), "preview");
        Object object = HttpRequests.request((String)url.toExternalForm()).userAgent(this.getUserAgent()).connectTimeout(10000).throwStatusCodeException(false).isReadResponseOnError(true).connect((HttpRequests.RequestProcessor)validateOptions.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"HttpRequests.request(url\u2026ror\"))\n        }\n      })");
        return (ValidationResult)object;
    }

    private final int getCategoryPriority(MicronautFeatureCategory category) {
        int n;
        switch (category.getTitle()) {
            case "Server": {
                n = 0;
                break;
            }
            case "Client": {
                n = 1;
                break;
            }
            case "Database": {
                n = 2;
                break;
            }
            case "Validation": {
                n = 3;
                break;
            }
            case "Logging": {
                n = 4;
                break;
            }
            case "Security": {
                n = 5;
                break;
            }
            case "Management": {
                n = 6;
                break;
            }
            case "Messaging": {
                n = 7;
                break;
            }
            case "Reactive": {
                n = 8;
                break;
            }
            case "View Rendering": {
                n = 9;
                break;
            }
            default: {
                n = 100;
            }
        }
        return n;
    }

    public static final /* synthetic */ int access$getCategoryPriority(MicronautModuleBuilder $this, MicronautFeatureCategory category) {
        return $this.getCategoryPriority(category);
    }

    public static final /* synthetic */ ValidationResult access$validateOptions(MicronautModuleBuilder $this) {
        return $this.validateOptions();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/micronaut/starter/MicronautModuleBuilder$ValidationResult;", "", "message", "", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "intellij.micronaut"})
    public static final class ValidationResult {
        @Nullable
        private final String message;

        @Nullable
        public final String getMessage() {
            return this.message;
        }

        public ValidationResult(@Nullable String message) {
            this.message = message;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/intellij/micronaut/starter/MicronautModuleBuilder$MicronautFeatureCategory;", "Lcom/intellij/ide/starters/remote/WebStarterDependencyCategory;", "appTypeId", "", "title", "features", "", "Lcom/intellij/ide/starters/remote/WebStarterDependency;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getFeatures", "()Ljava/util/List;", "isAvailable", "", "starterContext", "Lcom/intellij/ide/starters/remote/WebStarterContext;", "intellij.micronaut"})
    private static final class MicronautFeatureCategory
    extends WebStarterDependencyCategory {
        private final String appTypeId;
        @NotNull
        private final List<WebStarterDependency> features;

        public boolean isAvailable(@NotNull WebStarterContext starterContext) {
            Intrinsics.checkNotNullParameter((Object)starterContext, (String)"starterContext");
            StarterAppType starterAppType = starterContext.getApplicationType();
            return Intrinsics.areEqual((Object)(starterAppType != null ? starterAppType.getId() : null), (Object)this.appTypeId);
        }

        @NotNull
        public final List<WebStarterDependency> getFeatures() {
            return this.features;
        }

        public MicronautFeatureCategory(@NotNull String appTypeId, @NotNull String title, @NotNull List<WebStarterDependency> features2) {
            Intrinsics.checkNotNullParameter((Object)appTypeId, (String)"appTypeId");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(features2, (String)"features");
            super(title, features2);
            this.appTypeId = appTypeId;
            this.features = features2;
        }

        public /* synthetic */ MicronautFeatureCategory(String string, String string2, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                boolean bl = false;
                list = new ArrayList();
            }
            this(string, string2, list);
        }
    }
}

