/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.run.gradle;

import com.intellij.micronaut.run.MnRunConfigurationService;
import com.intellij.micronaut.run.gradle.MnGradleProjectResolverExtension;
import com.intellij.micronaut.settings.MicronautSettings;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.BooleanFunction;
import java.util.Collection;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0006H\u0016J\u001e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\bH\u0002J6\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\b0\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/micronaut/run/gradle/MnGradleProjectDataService;", "Lcom/intellij/openapi/externalSystem/service/project/manage/AbstractProjectDataService;", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "Ljava/lang/Void;", "()V", "getTargetDataKey", "Lcom/intellij/openapi/externalSystem/model/Key;", "getTargetModuleNode", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "node", "onSuccessImport", "", "imported", "", "projectData", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "project", "Lcom/intellij/openapi/project/Project;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModelsProvider;", "intellij.micronaut"})
public final class MnGradleProjectDataService
extends AbstractProjectDataService<ModuleData, Void> {
    @NotNull
    public Key<ModuleData> getTargetDataKey() {
        Key key = ProjectKeys.MODULE;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"ProjectKeys.MODULE");
        return key;
    }

    public void onSuccessImport(@NotNull Collection<? extends DataNode<ModuleData>> imported, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModelsProvider modelsProvider) {
        Intrinsics.checkNotNullParameter(imported, (String)"imported");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modelsProvider, (String)"modelsProvider");
        if (projectData == null) {
            return;
        }
        MicronautSettings settings = MicronautSettings.Companion.getInstance(project);
        if (!settings.getAutoCreateRunConfiguration()) {
            return;
        }
        for (DataNode<ModuleData> dataNode : imported) {
            String mainClassName;
            Module module;
            if ((String)dataNode.getCopyableUserData(MnGradleProjectResolverExtension.Companion.getMN_MAIN_CLASS_NAME_KEY()) == null) {
                continue;
            }
            DataNode<? extends ModuleData> targetModuleNode = this.getTargetModuleNode(dataNode);
            if (modelsProvider.findIdeModule((ModuleData)targetModuleNode.getData()) == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)module, (String)"modelsProvider.findIdeMo\u2026uleNode.data) ?: continue");
            MnRunConfigurationService.Companion.getInstance(project).createRunConfiguration(module, new Supplier(mainClassName){
                final /* synthetic */ String $mainClassName;

                @Nullable
                public final String get() {
                    return this.$mainClassName;
                }
                {
                    this.$mainClassName = string;
                }
            });
        }
    }

    private final DataNode<? extends ModuleData> getTargetModuleNode(DataNode<ModuleData> node) {
        StringBuilder stringBuilder = new StringBuilder();
        Object object = node.getData();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"node.data");
        String mainSourceSetModuleId = stringBuilder.append(((ModuleData)object).getId()).append(":main").toString();
        DataNode<ModuleData> dataNode = ExternalSystemApiUtil.find(node, (Key)GradleSourceSetData.KEY, (BooleanFunction)new BooleanFunction(mainSourceSetModuleId){
            final /* synthetic */ String $mainSourceSetModuleId;

            public final boolean fun(DataNode<GradleSourceSetData> it) {
                DataNode<GradleSourceSetData> dataNode = it;
                Intrinsics.checkNotNullExpressionValue(dataNode, (String)"it");
                Object object = dataNode.getData();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.data");
                return Intrinsics.areEqual((Object)this.$mainSourceSetModuleId, (Object)((GradleSourceSetData)object).getId());
            }
            {
                this.$mainSourceSetModuleId = string;
            }
        });
        if (dataNode == null) {
            dataNode = node;
        }
        return dataNode;
    }
}

