/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.run;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.micronaut.run.MnRunConfiguration;
import com.intellij.micronaut.run.MnRunConfigurationType;
import com.intellij.micronaut.run.MnServerConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0010\u0010\n\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\u000bJ\b\u0010\r\u001a\u00020\u0007H\u0016J\"\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0010\u0010\n\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\u000bH\u0002J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\fH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/micronaut/run/MnRunConfigurationService;", "Lcom/intellij/openapi/Disposable;", "()V", "executorService", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "createRunConfiguration", "", "module", "Lcom/intellij/openapi/module/Module;", "applicationClassSupplier", "Ljava/util/function/Supplier;", "", "dispose", "doCreateRunConfiguration", "applicationClass", "hasMnRunConfiguration", "", "Companion", "intellij.micronaut"})
public final class MnRunConfigurationService
implements Disposable {
    private final ExecutorService executorService;
    @NotNull
    private static final Key<MnServerConfiguration> SERVER_CONFIGURATION_KEY;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    public final void createRunConfiguration(@NotNull Module module, @Nullable Supplier<String> applicationClassSupplier) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            ApplicationManager.getApplication().runReadAction(new Runnable(this, module, applicationClassSupplier){
                final /* synthetic */ MnRunConfigurationService this$0;
                final /* synthetic */ Module $module;
                final /* synthetic */ Supplier $applicationClassSupplier;

                public final void run() {
                    MnRunConfigurationService.access$doCreateRunConfiguration(this.this$0, this.$module, this.$applicationClassSupplier);
                }
                {
                    this.this$0 = mnRunConfigurationService;
                    this.$module = module;
                    this.$applicationClassSupplier = supplier2;
                }
            });
            return;
        }
        ReadAction.nonBlocking((Runnable)new Runnable(this, module, applicationClassSupplier){
            final /* synthetic */ MnRunConfigurationService this$0;
            final /* synthetic */ Module $module;
            final /* synthetic */ Supplier $applicationClassSupplier;

            public final void run() {
                MnRunConfigurationService.access$doCreateRunConfiguration(this.this$0, this.$module, this.$applicationClassSupplier);
            }
            {
                this.this$0 = mnRunConfigurationService;
                this.$module = module;
                this.$applicationClassSupplier = supplier2;
            }
        }).inSmartMode(module.getProject()).expireWith((Disposable)this).expireWith((Disposable)module).coalesceBy(new Object[]{MnRunConfigurationService.class, module}).submit((Executor)this.executorService);
    }

    private final void doCreateRunConfiguration(Module module, Supplier<String> applicationClassSupplier) {
        Supplier<String> supplier2 = applicationClassSupplier;
        if (supplier2 == null || (supplier2 = supplier2.get()) == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)supplier2, (String)"applicationClassSupplier?.get() ?: return");
        Supplier<String> applicationClass = supplier2;
        if (JavaExecutionUtil.findMainClass((Project)module.getProject(), (String)((Object)applicationClass), (GlobalSearchScope)module.getModuleScope(false)) == null) {
            return;
        }
        if (!this.hasMnRunConfiguration(module, (String)((Object)applicationClass))) {
            this.doCreateRunConfiguration(module, (String)((Object)applicationClass));
        }
    }

    private final boolean hasMnRunConfiguration(Module module, String applicationClass) {
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
        List list = ContainerUtil.findAll((Collection)RunManager.Companion.getInstance(project).getConfigurationsList((ConfigurationType)MnRunConfigurationType.Companion.getInstance()), MnRunConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ContainerUtil.findAll(\n \u2026onfiguration::class.java)");
        List allConfigs = list;
        Iterator iterator = allConfigs.iterator();
        while (iterator.hasNext()) {
            Module configModule;
            MnRunConfiguration config;
            MnRunConfiguration mnRunConfiguration = config = (MnRunConfiguration)((Object)iterator.next());
            Intrinsics.checkNotNullExpressionValue((Object)((Object)mnRunConfiguration), (String)"config");
            if (!Intrinsics.areEqual((Object)applicationClass, (Object)mnRunConfiguration.getRunClass())) continue;
            JavaRunConfigurationModule javaRunConfigurationModule = (JavaRunConfigurationModule)config.getConfigurationModule();
            Intrinsics.checkNotNullExpressionValue((Object)javaRunConfigurationModule, (String)"config.configurationModule");
            if (javaRunConfigurationModule.getModule() == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)configModule, (String)"config.configurationModule.module ?: continue");
            if (Intrinsics.areEqual((Object)configModule, (Object)module)) {
                return true;
            }
            HashSet dependentModules = new HashSet();
            ModuleUtilCore.collectModulesDependsOn((Module)module, (Set)dependentModules);
            if (!dependentModules.contains(configModule)) continue;
            return true;
        }
        return false;
    }

    public void dispose() {
        this.executorService.shutdownNow();
    }

    private final void doCreateRunConfiguration(Module module, String applicationClass) {
        try {
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
            RunManager runManager = RunManager.Companion.getInstance(project);
            RunnerAndConfigurationSettings settings = runManager.createConfiguration("", MnRunConfigurationType.Companion.getInstance().getConfigurationFactories()[0]);
            RunConfiguration runConfiguration = settings.getConfiguration();
            if (runConfiguration == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.micronaut.run.MnRunConfiguration");
            }
            MnRunConfiguration newRunConfig = (MnRunConfiguration)runConfiguration;
            newRunConfig.setModule(module);
            newRunConfig.setMainClassName(applicationClass);
            settings.setName(newRunConfig.suggestedName());
            runManager.setUniqueNameIfNeeded(settings);
            runManager.addConfiguration(settings);
            if (runManager.getAllSettings().size() == 1) {
                runManager.setSelectedConfiguration(settings);
            }
        }
        catch (ProcessCanceledException e) {
            throw (Throwable)e;
        }
        catch (Throwable t) {
            LOG.error("Error creating Micronaut run configuration for module " + module.getName(), t);
        }
    }

    public MnRunConfigurationService() {
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)(MnRunConfigurationService.class.getSimpleName() + " Pool"), (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"AppExecutorUtil.createBo\u2026.simpleName + \" Pool\", 1)");
        this.executorService = executorService;
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"MICRONAUT_SERVER_CONFIGURATION");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<MnServerConfi\u2026UT_SERVER_CONFIGURATION\")");
        SERVER_CONFIGURATION_KEY = key;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MnRunConfigurationService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$doCreateRunConfiguration(MnRunConfigurationService $this, Module module, Supplier applicationClassSupplier) {
        $this.doCreateRunConfiguration(module, applicationClassSupplier);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0006\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/micronaut/run/MnRunConfigurationService$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "SERVER_CONFIGURATION_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/micronaut/run/MnServerConfiguration;", "kotlin.jvm.PlatformType", "getSERVER_CONFIGURATION_KEY", "()Lcom/intellij/openapi/util/Key;", "getInstance", "Lcom/intellij/micronaut/run/MnRunConfigurationService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.micronaut"})
    public static final class Companion {
        @NotNull
        public final Key<MnServerConfiguration> getSERVER_CONFIGURATION_KEY() {
            return SERVER_CONFIGURATION_KEY;
        }

        @NotNull
        public final MnRunConfigurationService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(MnRunConfigurationService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.getService(MnRun\u2026ationService::class.java)");
            return (MnRunConfigurationService)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

