/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.application.ApplicationCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.micronaut.MicronautUtils;
import com.intellij.micronaut.config.MnConfigValueSearcher;
import com.intellij.micronaut.run.MnRunConfiguration;
import com.intellij.micronaut.run.MnRunConfigurationService;
import com.intellij.micronaut.run.MnServerConfiguration;
import com.intellij.microservices.http.request.NavigatorHttpRequest;
import com.intellij.microservices.utils.PortBindingNotificationPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.panels.NonOpaquePanel;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J0\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u001c\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001a\u0010!\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u0012H\u0002J\u001a\u0010#\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u0012H\u0002J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00120%2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010&\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\b2\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020*H\u0014J\u0018\u0010+\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010'\u001a\u00020(H\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/micronaut/run/MnCommandLineState;", "Lcom/intellij/execution/application/ApplicationCommandLineState;", "Lcom/intellij/micronaut/run/MnRunConfiguration;", "configuration", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "(Lcom/intellij/micronaut/run/MnRunConfiguration;Lcom/intellij/execution/runners/ExecutionEnvironment;)V", "resolvedEnvironment", "Lcom/intellij/execution/target/TargetEnvironment;", "serverConfiguration", "Lcom/intellij/micronaut/run/MnServerConfiguration;", "addPortBindingPanel", "", "console", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "applicationUrl", "", "applicationPort", "", "resolvedPort", "execute", "Lcom/intellij/execution/ExecutionResult;", "executor", "Lcom/intellij/execution/Executor;", "runner", "Lcom/intellij/execution/runners/ProgramRunner;", "exposeServerHttpPort", "javaParams", "Lcom/intellij/execution/configurations/JavaParameters;", "request", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "findPropertyValue", "propertyKey", "findPropertyValueInConfigs", "getActiveEnvironments", "", "handleCreatedTargetEnvironment", "targetProgressIndicator", "Lcom/intellij/execution/target/TargetProgressIndicator;", "isProvidedScopeIncluded", "", "prepareTargetEnvironmentRequest", "intellij.micronaut"})
public final class MnCommandLineState
extends ApplicationCommandLineState<MnRunConfiguration> {
    private TargetEnvironment resolvedEnvironment;
    private volatile MnServerConfiguration serverConfiguration;

    protected boolean isProvidedScopeIncluded() {
        return ((MnRunConfiguration)this.myConfiguration).getIncludeProvidedScope();
    }

    public void prepareTargetEnvironmentRequest(@NotNull TargetEnvironmentRequest request2, @NotNull TargetProgressIndicator targetProgressIndicator) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)targetProgressIndicator, (String)"targetProgressIndicator");
        JavaParameters javaParameters = this.getJavaParameters();
        Intrinsics.checkNotNullExpressionValue((Object)javaParameters, (String)"javaParameters");
        this.exposeServerHttpPort(javaParameters, request2);
        super.prepareTargetEnvironmentRequest(request2, targetProgressIndicator);
    }

    @NotNull
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner<?> runner) throws ExecutionException {
        Map portsMap;
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(runner, (String)"runner");
        ExecutionResult executionResult = super.execute(executor, runner);
        Intrinsics.checkNotNullExpressionValue((Object)executionResult, (String)"super.execute(executor, runner)");
        ExecutionResult result = executionResult;
        MnServerConfiguration mnServerConfiguration = this.serverConfiguration;
        if (mnServerConfiguration == null) {
            return result;
        }
        int resolvedServerPort = mnServerConfiguration.getServerPort();
        TargetEnvironment targetEnvironment = this.resolvedEnvironment;
        Map map = portsMap = targetEnvironment != null ? targetEnvironment.getTargetPortBindings() : null;
        if (portsMap != null) {
            Object v4;
            block6: {
                Iterable $this$firstOrNull$iv = portsMap.entrySet();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Map.Entry it = (Map.Entry)element$iv;
                    boolean bl = false;
                    if (!(((TargetEnvironment.TargetPortBinding)it.getKey()).getTarget() == resolvedServerPort)) continue;
                    v4 = element$iv;
                    break block6;
                }
                v4 = null;
            }
            Object var12_13 = v4;
            Object object = var12_13;
            resolvedServerPort = object != null && (object = (Integer)object.getValue()) != null ? (Integer)object : resolvedServerPort;
        }
        MnServerConfiguration mnServerConfiguration2 = this.serverConfiguration;
        Intrinsics.checkNotNull((Object)mnServerConfiguration2);
        MnServerConfiguration resolvedConfiguration = new MnServerConfiguration(resolvedServerPort, mnServerConfiguration2.getSslEnabled());
        result.getProcessHandler().putUserData(MnRunConfigurationService.Companion.getSERVER_CONFIGURATION_KEY(), (Object)resolvedConfiguration);
        MnServerConfiguration mnServerConfiguration3 = this.serverConfiguration;
        Intrinsics.checkNotNull((Object)mnServerConfiguration3);
        if (resolvedServerPort != mnServerConfiguration3.getServerPort()) {
            ExecutionConsole executionConsole = result.getExecutionConsole();
            if (!(executionConsole instanceof ConsoleViewImpl)) {
                executionConsole = null;
            }
            ConsoleViewImpl consoleViewImpl = (ConsoleViewImpl)executionConsole;
            if (consoleViewImpl == null) {
                return result;
            }
            ConsoleViewImpl console = consoleViewImpl;
            ProcessHandler processHandler = result.getProcessHandler();
            Intrinsics.checkNotNullExpressionValue((Object)processHandler, (String)"result.processHandler");
            String string = resolvedConfiguration.getApplicationUrl();
            MnServerConfiguration mnServerConfiguration4 = this.serverConfiguration;
            Intrinsics.checkNotNull((Object)mnServerConfiguration4);
            this.addPortBindingPanel(console, processHandler, string, mnServerConfiguration4.getServerPort(), resolvedServerPort);
        }
        return result;
    }

    private final void addPortBindingPanel(ConsoleViewImpl console, ProcessHandler processHandler, String applicationUrl, int applicationPort, int resolvedPort) {
        ApplicationManager.getApplication().invokeLater(new Runnable(this, applicationUrl, applicationPort, resolvedPort, processHandler, console){
            final /* synthetic */ MnCommandLineState this$0;
            final /* synthetic */ String $applicationUrl;
            final /* synthetic */ int $applicationPort;
            final /* synthetic */ int $resolvedPort;
            final /* synthetic */ ProcessHandler $processHandler;
            final /* synthetic */ ConsoleViewImpl $console;

            public final void run() {
                NavigatorHttpRequest request2 = new NavigatorHttpRequest(this.$applicationUrl, "GET", CollectionsKt.emptyList(), CollectionsKt.emptyList());
                MnRunConfiguration mnRunConfiguration = MnCommandLineState.access$getMyConfiguration$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)mnRunConfiguration), (String)"myConfiguration");
                Project project = mnRunConfiguration.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myConfiguration.project");
                MnRunConfiguration mnRunConfiguration2 = MnCommandLineState.access$getMyConfiguration$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)mnRunConfiguration2), (String)"myConfiguration");
                String string = mnRunConfiguration2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"myConfiguration.name");
                PortBindingNotificationPanel panel2 = new PortBindingNotificationPanel(project, request2, string, this.$applicationPort, this.$resolvedPort);
                panel2.registerProcessListener(this.$processHandler, (Disposable)this.$console);
                NonOpaquePanel wrapper = new NonOpaquePanel((JComponent)panel2);
                wrapper.setBorder(IdeBorderFactory.createBorder((int)8));
                this.$console.addNotificationComponent((JComponent)wrapper);
            }
            {
                this.this$0 = mnCommandLineState;
                this.$applicationUrl = string;
                this.$applicationPort = n;
                this.$resolvedPort = n2;
                this.$processHandler = processHandler;
                this.$console = consoleViewImpl;
            }
        }, new Condition(console){
            final /* synthetic */ ConsoleViewImpl $console;

            public final boolean value(Object it) {
                return Disposer.isDisposed((Disposable)((Disposable)this.$console));
            }
            {
                this.$console = consoleViewImpl;
            }
        });
    }

    public void handleCreatedTargetEnvironment(@NotNull TargetEnvironment environment, @NotNull TargetProgressIndicator targetProgressIndicator) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)targetProgressIndicator, (String)"targetProgressIndicator");
        super.handleCreatedTargetEnvironment(environment, targetProgressIndicator);
        this.resolvedEnvironment = environment;
    }

    private final void exposeServerHttpPort(JavaParameters javaParams, TargetEnvironmentRequest request2) {
        int n;
        boolean bl;
        Boolean hasMicronautHttpServer2 = (Boolean)ReadAction.compute((ThrowableComputable)new ThrowableComputable(this){
            final /* synthetic */ MnCommandLineState this$0;

            public final Boolean compute() {
                MnRunConfiguration mnRunConfiguration = MnCommandLineState.access$getMyConfiguration$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)mnRunConfiguration), (String)"myConfiguration");
                JavaRunConfigurationModule javaRunConfigurationModule = (JavaRunConfigurationModule)mnRunConfiguration.getConfigurationModule();
                Intrinsics.checkNotNullExpressionValue((Object)javaRunConfigurationModule, (String)"myConfiguration.configurationModule");
                return MicronautUtils.hasMicronautHttpServer(javaRunConfigurationModule.getModule());
            }
            {
                this.this$0 = mnCommandLineState;
            }
        });
        if (!hasMicronautHttpServer2.booleanValue()) {
            return;
        }
        String string = this.findPropertyValue(javaParams, "micronaut.ssl.enabled");
        if (string != null) {
            String string2 = string;
            boolean bl2 = false;
            bl = Boolean.parseBoolean(string2);
        } else {
            bl = false;
        }
        boolean sslEnabled = bl;
        String portProperty = null;
        int defaultPort = 0;
        if (sslEnabled) {
            portProperty = "micronaut.ssl.port";
            defaultPort = 8443;
        } else {
            portProperty = "micronaut.server.port";
            defaultPort = 8080;
        }
        try {
            int n2;
            String string3 = this.findPropertyValue(javaParams, portProperty);
            if (string3 != null) {
                String string4 = string3;
                boolean bl3 = false;
                n2 = Integer.parseInt(string4);
            } else {
                n2 = defaultPort;
            }
            n = n2;
        }
        catch (NumberFormatException e) {
            n = defaultPort;
        }
        int serverPort = n;
        this.serverConfiguration = new MnServerConfiguration(serverPort, sslEnabled);
        if (!(request2 instanceof LocalTargetEnvironmentRequest)) {
            request2.getTargetPortBindings().add(new TargetEnvironment.TargetPortBinding(null, serverPort));
        }
    }

    private final String findPropertyValue(JavaParameters javaParams, String propertyKey) {
        String fromVmOptions = javaParams.getVMParametersList().getPropertyValue(propertyKey);
        if (fromVmOptions != null) {
            CharSequence charSequence = fromVmOptions;
            boolean bl = false;
            if (!StringsKt.isBlank((CharSequence)charSequence)) {
                return fromVmOptions;
            }
        }
        return (String)ReadAction.compute((ThrowableComputable)new ThrowableComputable(this, javaParams, propertyKey){
            final /* synthetic */ MnCommandLineState this$0;
            final /* synthetic */ JavaParameters $javaParams;
            final /* synthetic */ String $propertyKey;

            public final String compute() {
                return MnCommandLineState.access$findPropertyValueInConfigs(this.this$0, this.$javaParams, this.$propertyKey);
            }
            {
                this.this$0 = mnCommandLineState;
                this.$javaParams = javaParameters;
                this.$propertyKey = string;
            }
        });
    }

    private final String findPropertyValueInConfigs(JavaParameters javaParams, String propertyKey) {
        Set<String> environments = this.getActiveEnvironments(javaParams);
        RunConfigurationBase runConfigurationBase = this.myConfiguration;
        Intrinsics.checkNotNullExpressionValue((Object)runConfigurationBase, (String)"myConfiguration");
        JavaRunConfigurationModule javaRunConfigurationModule = (JavaRunConfigurationModule)((MnRunConfiguration)runConfigurationBase).getConfigurationModule();
        Intrinsics.checkNotNullExpressionValue((Object)javaRunConfigurationModule, (String)"myConfiguration.configurationModule");
        Module module = javaRunConfigurationModule.getModule();
        if (module == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"myConfiguration.configur\u2026ule.module ?: return null");
        Module module2 = module;
        MnConfigValueSearcher searcher = new MnConfigValueSearcher(module2, false, propertyKey, true, environments);
        String value = searcher.findValueText();
        CharSequence charSequence = value;
        boolean bl = false;
        boolean bl2 = false;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? null : value;
    }

    private final Set<String> getActiveEnvironments(JavaParameters javaParams) {
        Object object = javaParams.getVMParametersList().getPropertyValue("micronaut.environments");
        if (object == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (char[])new char[]{','}, (boolean)false, (int)0, (int)6, null)) == null || (object = CollectionsKt.toSet((Iterable)((Iterable)object))) == null) {
            object = SetsKt.emptySet();
        }
        return object;
    }

    public MnCommandLineState(@NotNull MnRunConfiguration configuration, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        super((ModuleBasedConfiguration)configuration, environment);
    }

    public static final /* synthetic */ MnRunConfiguration access$getMyConfiguration$p(MnCommandLineState $this) {
        return (MnRunConfiguration)$this.myConfiguration;
    }

    public static final /* synthetic */ String access$findPropertyValueInConfigs(MnCommandLineState $this, JavaParameters javaParams, String propertyKey) {
        return $this.findPropertyValueInConfigs(javaParams, propertyKey);
    }
}

