/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider.websocket;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.JavaLibraryUtils;
import com.intellij.micronaut.jam.websocket.MnWebSocketConstants;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.StringPattern;
import com.intellij.patterns.uast.UExpressionPattern;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a-\u0010\u0000\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00020\u00012\u0010\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u0006\u0012\u0002\b\u00030\u0005H\u0000\u00a2\u0006\u0002\u0010\u0007\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0016\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u00a8\u0006\u0015"}, d2={"getWebSocketPropertyPatterns", "", "Lcom/intellij/patterns/ElementPattern;", "Lorg/jetbrains/uast/UElement;", "injection", "Lcom/intellij/patterns/uast/UExpressionPattern;", "Lorg/jetbrains/uast/UExpression;", "(Lcom/intellij/patterns/uast/UExpressionPattern;)[Lcom/intellij/patterns/ElementPattern;", "hasWebSocketImplicitUsage", "", "element", "Lcom/intellij/psi/PsiElement;", "hasWebSocketLibrary", "module", "Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/Project;", "isMappedWebSocketMethod", "Lcom/intellij/psi/PsiMethod;", "containingClass", "Lcom/intellij/psi/PsiClass;", "intellij.micronaut"})
public final class MnWebSocketUtilsKt {
    public static final boolean isMappedWebSocketMethod(@NotNull PsiMethod element, @NotNull PsiClass containingClass) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)containingClass, (String)"containingClass");
        return !element.isConstructor() && !element.hasModifierProperty("abstract") && !element.hasModifierProperty("static") && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), (Collection)MnWebSocketConstants.getWEBSOCKET_MAPPING_ANNOTATIONS(), (int)0) && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)containingClass), (Collection)MnWebSocketConstants.getWEBSOCKET_BEANS_ANNOTATIONS(), (int)0);
    }

    public static final boolean hasWebSocketLibrary(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JavaLibraryUtils.hasLibraryClass((Project)project, (String)"io.micronaut.websocket.annotation.ServerWebSocket");
    }

    public static final boolean hasWebSocketLibrary(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return JavaLibraryUtils.hasLibraryClass((Module)module, (String)"io.micronaut.websocket.annotation.ServerWebSocket");
    }

    public static final boolean hasWebSocketImplicitUsage(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof PsiClass) {
            return ((PsiClass)element).getQualifiedName() != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), (Collection)MnWebSocketConstants.getWEBSOCKET_BEANS_ANNOTATIONS(), (int)0);
        }
        if (element instanceof PsiMethod) {
            PsiModifierList psiModifierList = ((PsiMethod)element).getModifierList();
            Intrinsics.checkNotNullExpressionValue((Object)psiModifierList, (String)"element.modifierList");
            PsiAnnotation[] psiAnnotationArray = psiModifierList.getAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray, (String)"element.modifierList.annotations");
            PsiAnnotation[] psiAnnotationArray2 = psiAnnotationArray;
            boolean bl = false;
            PsiAnnotation[] psiAnnotationArray3 = psiAnnotationArray2;
            boolean bl2 = false;
            if (!(psiAnnotationArray3.length == 0)) {
                PsiClass containingClass = ((PsiMethod)element).getContainingClass();
                return containingClass != null && containingClass.getQualifiedName() != null && MnWebSocketUtilsKt.isMappedWebSocketMethod((PsiMethod)element, containingClass);
            }
        }
        return false;
    }

    @NotNull
    public static final ElementPattern<? extends UElement>[] getWebSocketPropertyPatterns(@NotNull UExpressionPattern<UExpression, ?> injection) {
        Intrinsics.checkNotNullParameter(injection, (String)"injection");
        StringPattern stringPattern = StandardPatterns.string().oneOf(new String[]{"value", "uri"});
        Intrinsics.checkNotNullExpressionValue((Object)stringPattern, (String)"StandardPatterns.string().oneOf(\"value\", \"uri\")");
        StringPattern valueOrUri = stringPattern;
        return new ElementPattern[]{(ElementPattern)injection.annotationParams(CollectionsKt.listOf((Object[])new String[]{"io.micronaut.websocket.annotation.ClientWebSocket", "io.micronaut.websocket.annotation.ServerWebSocket"}), (ElementPattern)valueOrUri)};
    }
}

