/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider.websocket;

import com.intellij.ide.presentation.Presentation;
import com.intellij.micronaut.jam.http.MnHttpUrlPathSpecification;
import com.intellij.micronaut.jam.websocket.MnServerWebSocket;
import com.intellij.micronaut.jam.websocket.MnWebSocket;
import com.intellij.micronaut.jam.websocket.MnWebSocketModel;
import com.intellij.micronaut.provider.websocket.MnWebSocketTargetInfo;
import com.intellij.micronaut.provider.websocket.MnWebSocketUrlResolver;
import com.intellij.micronaut.provider.websocket.MnWebSocketUtilsKt;
import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.UrlConstants;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlResolveRequest;
import com.intellij.microservices.url.UrlResolver;
import com.intellij.microservices.url.UrlResolverFactory;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(typeName="Micronaut WebSocket", icon="AllIcons.Webreferences.WebSocket")
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/intellij/micronaut/provider/websocket/MnWebSocketUrlResolver;", "Lcom/intellij/microservices/url/UrlResolver;", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "authorityHints", "", "Lcom/intellij/microservices/url/Authority$Exact;", "getAuthorityHints", "()Ljava/util/List;", "supportedSchemes", "", "getSupportedSchemes", "getVariants", "", "Lcom/intellij/microservices/url/UrlTargetInfo;", "resolve", "request", "Lcom/intellij/microservices/url/UrlResolveRequest;", "Factory", "intellij.micronaut"})
public final class MnWebSocketUrlResolver
implements UrlResolver {
    @NotNull
    private final List<Authority.Exact> authorityHints;
    @NotNull
    private final List<String> supportedSchemes;
    private final Project myProject;

    @NotNull
    public List<Authority.Exact> getAuthorityHints() {
        return this.authorityHints;
    }

    @NotNull
    public List<String> getSupportedSchemes() {
        return this.supportedSchemes;
    }

    @NotNull
    public Iterable<UrlTargetInfo> resolve(@NotNull UrlResolveRequest request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMap((Sequence)UrlPath.Companion.combinations(request2.getPath()), (Function1)((Function1)new Function1<UrlPath, Sequence<? extends MnWebSocketTargetInfo<MnServerWebSocket>>>(this){
            final /* synthetic */ MnWebSocketUrlResolver this$0;

            @NotNull
            public final Sequence<MnWebSocketTargetInfo<MnServerWebSocket>> invoke(@NotNull UrlPath path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Sequence<MnServerWebSocket> sequence = MnWebSocketModel.resolveUrl(MnWebSocketUrlResolver.access$getMyProject$p(this.this$0), path);
                Intrinsics.checkNotNullExpressionValue(sequence, (String)"MnWebSocketModel.resolveUrl(myProject, path)");
                return SequencesKt.map(sequence, (Function1)((Function1)new Function1<MnServerWebSocket, MnWebSocketTargetInfo<MnServerWebSocket>>(this){
                    final /* synthetic */ resolve.1 this$0;

                    @NotNull
                    public final MnWebSocketTargetInfo<MnServerWebSocket> invoke(MnServerWebSocket resolved) {
                        MnServerWebSocket mnServerWebSocket = resolved;
                        Intrinsics.checkNotNullExpressionValue((Object)mnServerWebSocket, (String)"resolved");
                        UrlPath urlPath = MnHttpUrlPathSpecification.INSTANCE.parsePath(mnServerWebSocket.getResourceValue());
                        return new MnWebSocketTargetInfo<MnWebSocket>(this.this$0.this$0.getSupportedSchemes(), urlPath, resolved);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = mnWebSocketUrlResolver;
                super(1);
            }
        })));
    }

    @NotNull
    public Iterable<UrlTargetInfo> getVariants() {
        List<MnServerWebSocket> list = MnWebSocketModel.getServers(this.myProject);
        Intrinsics.checkNotNullExpressionValue(list, (String)"MnWebSocketModel.getServers(myProject)");
        return SequencesKt.asIterable((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)((Function1)new Function1<MnServerWebSocket, MnWebSocketTargetInfo<MnServerWebSocket>>(this){
            final /* synthetic */ MnWebSocketUrlResolver this$0;

            @NotNull
            public final MnWebSocketTargetInfo<MnServerWebSocket> invoke(MnServerWebSocket server) {
                MnServerWebSocket mnServerWebSocket = server;
                Intrinsics.checkNotNullExpressionValue((Object)mnServerWebSocket, (String)"server");
                UrlPath urlPath = MnHttpUrlPathSpecification.INSTANCE.parsePath(mnServerWebSocket.getResourceValue());
                return new MnWebSocketTargetInfo<MnWebSocket>(this.this$0.getSupportedSchemes(), urlPath, server);
            }
            {
                this.this$0 = mnWebSocketUrlResolver;
                super(1);
            }
        })));
    }

    public MnWebSocketUrlResolver(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
        List list = Collections.emptyList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"emptyList()");
        this.authorityHints = list;
        this.supportedSchemes = UrlConstants.WS_SCHEMES;
    }

    public static final /* synthetic */ Project access$getMyProject$p(MnWebSocketUrlResolver $this) {
        return $this.myProject;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/micronaut/provider/websocket/MnWebSocketUrlResolver$Factory;", "Lcom/intellij/microservices/url/UrlResolverFactory;", "()V", "forProject", "Lcom/intellij/microservices/url/UrlResolver;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.micronaut"})
    public static final class Factory
    implements UrlResolverFactory {
        @Nullable
        public UrlResolver forProject(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (!MnWebSocketUtilsKt.hasWebSocketLibrary(project)) {
                return null;
            }
            return new MnWebSocketUrlResolver(project);
        }
    }
}

