/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider.websocket;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.micronaut.MicronautBundle;
import com.intellij.micronaut.provider.base.MnLineMarkerProvider;
import com.intellij.micronaut.provider.websocket.MnWebSocketUtilsKt;
import com.intellij.micronaut.utils.MnLineMarkerBuilder;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import icons.JavaUltimateIcons;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UMethod;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0014\u0010\u0007\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bH\u0014J2\u0010\u000b\u001a\u00020\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\r2\u0012\u0010\u0007\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\t0\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/micronaut/provider/websocket/MnWebSocketLineMarkers;", "Lcom/intellij/micronaut/provider/base/MnLineMarkerProvider;", "()V", "annotateMethod", "", "uMethod", "Lorg/jetbrains/uast/UMethod;", "result", "", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerInfo;", "Lcom/intellij/psi/PsiElement;", "collectNavigationMarkers", "elements", "", "forNavigation", "", "getIcon", "Ljavax/swing/Icon;", "getName", "", "intellij.micronaut"})
public final class MnWebSocketLineMarkers
extends MnLineMarkerProvider {
    @Nullable
    public Icon getIcon() {
        return JavaUltimateIcons.Cdi.Gutter.Publisher;
    }

    @Nullable
    public String getName() {
        return MicronautBundle.message("micronaut.websocket.markers", new Object[0]);
    }

    public void collectNavigationMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, boolean forNavigation) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter(elements, (String)"elements");
                Intrinsics.checkNotNullParameter(result, (String)"result");
                PsiElement psiElement = (PsiElement)CollectionsKt.firstOrNull(elements);
                if (psiElement == null) break block2;
                Project project = psiElement.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"psiElement.project");
                if (MnWebSocketUtilsKt.hasWebSocketLibrary(project)) break block3;
            }
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    @Override
    protected void annotateMethod(@NotNull UMethod uMethod, @NotNull Collection<? super RelatedItemLineMarkerInfo<PsiElement>> result) {
        Intrinsics.checkNotNullParameter((Object)uMethod, (String)"uMethod");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        PsiElement psiElement = UElementKt.getSourcePsiElement((UElement)uMethod.getUastAnchor());
        if (psiElement == null) {
            return;
        }
        PsiElement identifier = psiElement;
        PsiMethod psiMethod = uMethod.getJavaPsi();
        PsiClass psiClass = psiMethod.getContainingClass();
        if (psiClass == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"psiMethod.containingClass ?: return");
        PsiClass containingClass = psiClass;
        if (MnWebSocketUtilsKt.isMappedWebSocketMethod(psiMethod, containingClass)) {
            Icon icon = JavaUltimateIcons.Cdi.Gutter.Publisher;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"JavaUltimateIcons.Cdi.Gutter.Publisher");
            RelatedItemLineMarkerInfo relatedItemLineMarkerInfo = MnLineMarkerBuilder.INSTANCE.create(icon).setTargets((Collection)CollectionsKt.emptyList()).setTooltipText(MicronautBundle.message("micronaut.websocket.method.tooltip.text", new Object[0])).setAlignment(GutterIconRenderer.Alignment.LEFT).createLineMarkerInfo(identifier);
            Intrinsics.checkNotNullExpressionValue((Object)relatedItemLineMarkerInfo, (String)"MnLineMarkerBuilder.crea\u2026ineMarkerInfo(identifier)");
            result.add((RelatedItemLineMarkerInfo<PsiElement>)relatedItemLineMarkerInfo);
        }
    }
}

