/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider.mq;

import com.intellij.micronaut.provider.mq.MnMqUtilsKt;
import com.intellij.micronaut.provider.mq.MnRabbitModel;
import com.intellij.microservices.mq.MQResolver;
import com.intellij.microservices.mq.MQResolverFactory;
import com.intellij.microservices.mq.MQTargetInfo;
import com.intellij.microservices.mq.MQType;
import com.intellij.microservices.mq.MQTypes;
import com.intellij.microservices.mq.NamedMQType;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/micronaut/provider/mq/MnRabbitResolverFactory;", "Lcom/intellij/microservices/mq/MQResolverFactory;", "()V", "forProject", "", "Lcom/intellij/microservices/mq/MQResolver;", "project", "Lcom/intellij/openapi/project/Project;", "MnRabbitResolver", "intellij.micronaut"})
public final class MnRabbitResolverFactory
implements MQResolverFactory {
    @NotNull
    public List<MQResolver> forProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!MnMqUtilsKt.hasMnRabbitInProject(project)) {
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.listOf((Object)new MnRabbitResolver(project));
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/intellij/micronaut/provider/mq/MnRabbitResolverFactory$MnRabbitResolver;", "Lcom/intellij/microservices/mq/MQResolver;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "supportedTypes", "", "Lcom/intellij/microservices/mq/MQType;", "getSupportedTypes", "()Ljava/util/List;", "getVariants", "", "Lcom/intellij/microservices/mq/MQTargetInfo;", "typeHint", "intellij.micronaut"})
    private static final class MnRabbitResolver
    implements MQResolver {
        @NotNull
        private final List<MQType> supportedTypes;
        private final Project project;

        @NotNull
        public List<MQType> getSupportedTypes() {
            return this.supportedTypes;
        }

        @NotNull
        public Iterable<MQTargetInfo> getVariants(@NotNull MQType typeHint) {
            Intrinsics.checkNotNullParameter((Object)typeHint, (String)"typeHint");
            return MQTypes.RABBIT_MQ_EXCHANGE_TYPE.isCompatibleWith(typeHint) ? MnRabbitModel.INSTANCE.getExchanges(this.project) : (MQTypes.RABBIT_MQ_QUEUE_TYPE.isCompatibleWith(typeHint) ? MnRabbitModel.INSTANCE.getQueues(this.project) : (Iterable<MQTargetInfo>)CollectionsKt.emptyList());
        }

        public MnRabbitResolver(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
            this.supportedTypes = CollectionsKt.listOf((Object[])new NamedMQType[]{MQTypes.RABBIT_MQ_EXCHANGE_TYPE, MQTypes.RABBIT_MQ_QUEUE_TYPE});
        }
    }
}

