/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider.mq;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.MergeableLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.jam.JamService;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.micronaut.MicronautBundle;
import com.intellij.micronaut.jam.mq.MnMqConstants;
import com.intellij.micronaut.jam.mq.MnMqMethodElement;
import com.intellij.micronaut.jam.mq.MnSendTo;
import com.intellij.micronaut.jam.mq.kafka.MnKafkaClient;
import com.intellij.micronaut.jam.mq.kafka.MnKafkaListener;
import com.intellij.micronaut.jam.mq.kafka.MnKafkaTopic;
import com.intellij.micronaut.jam.mq.rabbitmq.MnRabbitQueue;
import com.intellij.micronaut.provider.base.MnLineMarkerProvider;
import com.intellij.micronaut.provider.beans.MicronautBeanUtilsKt;
import com.intellij.micronaut.provider.mq.MnMqLineMarkerProvider;
import com.intellij.micronaut.provider.mq.MnMqUtilsKt;
import com.intellij.micronaut.utils.MnLineMarkerBuilder;
import com.intellij.microservices.mq.MQDestinationAnchor;
import com.intellij.microservices.mq.gutters.MQLineMarkerActionsProvider;
import com.intellij.microservices.utils.UsagesNavigationGutterIconBuilder;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullFactory;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.semantic.SemService;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import icons.MicroservicesIcons;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UMethod;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0003\u0014\u0015\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0014\u0010\u0007\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bH\u0014J2\u0010\u000b\u001a\u00020\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\r2\u0012\u0010\u0007\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\t0\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/micronaut/provider/mq/MnMqLineMarkerProvider;", "Lcom/intellij/micronaut/provider/base/MnLineMarkerProvider;", "()V", "annotateMethod", "", "uMethod", "Lorg/jetbrains/uast/UMethod;", "result", "", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerInfo;", "Lcom/intellij/psi/PsiElement;", "collectNavigationMarkers", "elements", "", "forNavigation", "", "getIcon", "Ljavax/swing/Icon;", "getName", "", "Companion", "MnMqLineMarkerInfo", "MnMqLineMarkerProviderHelper", "intellij.micronaut"})
public final class MnMqLineMarkerProvider
extends MnLineMarkerProvider {
    private static final NotNullFunction<MQDestinationAnchor, Collection<PsiElement>> MQ_CONVERTER;
    @NotNull
    public static final Companion Companion;

    public void collectNavigationMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, boolean forNavigation) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        PsiElement psiElement = (PsiElement)CollectionsKt.firstOrNull(elements);
        if (psiElement == null) {
            return;
        }
        PsiElement psiElement2 = psiElement;
        Project project = psiElement2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"psiElement.project");
        if (!MnMqUtilsKt.hasMnKafkaInProject(project)) {
            Project project2 = psiElement2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"psiElement.project");
            if (!MnMqUtilsKt.hasMnRabbitInProject(project2)) {
                return;
            }
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = MicroservicesIcons.Gutter.MessageQueueReceiver;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"MicroservicesIcons.Gutter.MessageQueueReceiver");
        return icon;
    }

    @NotNull
    public String getName() {
        return MicronautBundle.message("micronaut.mq.line.markers.name", new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void annotateMethod(@NotNull UMethod uMethod, @NotNull Collection<? super RelatedItemLineMarkerInfo<PsiElement>> result) {
        void destination$iv;
        void $this$flatMapTo$iv;
        Sequence $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)uMethod, (String)"uMethod");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        PsiElement psiElement = UElementKt.getSourcePsiElement((UElement)uMethod.getUastAnchor());
        if (psiElement == null) {
            return;
        }
        PsiElement anchor = psiElement;
        PsiMethod psiMethod = uMethod.getJavaPsi();
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass == null || psiMethod.hasModifier(JvmModifier.PRIVATE) || psiMethod.hasModifier(JvmModifier.STATIC) || psiMethod.isConstructor() || !MicronautBeanUtilsKt.isBeanMappedClass(containingClass)) {
            return;
        }
        SemService semService = SemService.getSemService((Project)psiMethod.getProject());
        List list = AnnotationUtil.findAllAnnotations((PsiModifierListOwner)((PsiModifierListOwner)psiMethod), (Collection)MnMqConstants.getMN_MESSAGING_METHOD_ANNOTATIONS(), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"AnnotationUtil.findAllAn\u2026METHOD_ANNOTATIONS, true)");
        Iterable iterable = list;
        boolean $i$f$mapNotNull = false;
        void var10_10 = $this$mapNotNull$iv;
        Collection destination$iv$iv322 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            MnMqMethodElement mnMqMethodElement;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            PsiAnnotation it = (PsiAnnotation)element$iv$iv;
            boolean bl2 = false;
            if ((MnMqMethodElement)semService.getSemElement(MnMqMethodElement.MN_MQ_METHOD_ELEMENT_SEM_KEY, (PsiElement)it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            MnMqMethodElement it$iv$iv = mnMqMethodElement;
            boolean bl5 = false;
            destination$iv$iv322.add(it$iv$iv);
        }
        Sequence relatedItems = CollectionsKt.asSequence((Iterable)((List)destination$iv$iv322));
        JamService jamService = JamService.getJamService((Project)psiMethod.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)jamService, (String)"JamService.getJamService(psiMethod.project)");
        MnMqLineMarkerProviderHelper helper = new MnMqLineMarkerProviderHelper(anchor, psiMethod, containingClass, jamService);
        $this$mapNotNullTo$iv$iv = relatedItems;
        boolean destination$iv$iv322 = false;
        Collection destination$iv$iv322 = new LinkedHashSet();
        boolean $i$f$flatMapIterableTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            MnMqMethodElement it = (MnMqMethodElement)element$iv;
            boolean bl = false;
            MnMqMethodElement mnMqMethodElement = it;
            Intrinsics.checkNotNullExpressionValue((Object)mnMqMethodElement, (String)"it");
            Iterable list$iv = mnMqMethodElement.getDestinations();
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        Set allDestinations = (Set)destination$iv;
        for (MQLineMarkerActionsProvider actionsProvider : MQLineMarkerActionsProvider.Companion.getInstances()) {
            for (MQLineMarkerActionsProvider.Action action : actionsProvider.getActions((Collection)allDestinations, anchor)) {
                result.add(new MnMqLineMarkerInfo(Companion.createExternalContributedActionMarker(anchor, action)));
            }
        }
        helper.addLineMarkerInfo((Sequence<? extends MnMqMethodElement>)relatedItems, true, result);
        helper.addLineMarkerInfo((Sequence<? extends MnMqMethodElement>)relatedItems, false, result);
    }

    static {
        Companion = new Companion(null);
        MQ_CONVERTER = Companion.MQ_CONVERTER.1.INSTANCE;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/micronaut/provider/mq/MnMqLineMarkerProvider$MnMqLineMarkerInfo;", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerInfo;", "Lcom/intellij/psi/PsiElement;", "gutter", "(Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerInfo;)V", "canMergeWith", "", "info", "Lcom/intellij/codeInsight/daemon/MergeableLineMarkerInfo;", "getElementPresentation", "", "element", "intellij.micronaut"})
    private static final class MnMqLineMarkerInfo
    extends RelatedItemLineMarkerInfo<PsiElement> {
        public boolean canMergeWith(@NotNull MergeableLineMarkerInfo<?> info) {
            Intrinsics.checkNotNullParameter(info, (String)"info");
            return info instanceof MnMqLineMarkerInfo;
        }

        @NotNull
        public String getElementPresentation(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            String string = this.getLineMarkerTooltip();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineMarkerTooltip");
            return string;
        }

        public MnMqLineMarkerInfo(final @NotNull RelatedItemLineMarkerInfo<PsiElement> gutter) {
            Intrinsics.checkNotNullParameter(gutter, (String)"gutter");
            PsiElement psiElement = gutter.getElement();
            Intrinsics.checkNotNull((Object)psiElement);
            PsiElement psiElement2 = gutter.getElement();
            Intrinsics.checkNotNull((Object)psiElement2);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"gutter.element!!");
            TextRange textRange = psiElement2.getTextRange();
            Icon icon = gutter.getIcon();
            Function function = new Function(){

                public final String fun(PsiElement it) {
                    return gutter.getLineMarkerTooltip();
                }
            };
            GutterIconNavigationHandler gutterIconNavigationHandler = gutter.getNavigationHandler();
            GutterIconRenderer gutterIconRenderer = gutter.createGutterRenderer();
            Intrinsics.checkNotNullExpressionValue((Object)gutterIconRenderer, (String)"gutter.createGutterRenderer()");
            super(psiElement, textRange, icon, function, gutterIconNavigationHandler, gutterIconRenderer.getAlignment(), new NotNullFactory(){

                @NotNull
                public final Collection<? extends GotoRelatedItem> create() {
                    return gutter.createGotoRelatedItems();
                }
            });
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ2\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020\u000e2\u0014\u0010!\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\u00030#0\"R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000fR\u0014\u0010\u0011\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\u0013\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000fR\u0014\u0010\u0014\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006$"}, d2={"Lcom/intellij/micronaut/provider/mq/MnMqLineMarkerProvider$MnMqLineMarkerProviderHelper;", "", "anchor", "Lcom/intellij/psi/PsiElement;", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "psiClass", "Lcom/intellij/psi/PsiClass;", "jamService", "Lcom/intellij/jam/JamService;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiMethod;Lcom/intellij/psi/PsiClass;Lcom/intellij/jam/JamService;)V", "getAnchor", "()Lcom/intellij/psi/PsiElement;", "isKafkaListener", "", "()Z", "isKafkaPublisher", "isKafkaSendToPublisher", "isListener", "isPublisher", "isRabbitListener", "getJamService", "()Lcom/intellij/jam/JamService;", "getPsiClass", "()Lcom/intellij/psi/PsiClass;", "getPsiMethod", "()Lcom/intellij/psi/PsiMethod;", "addLineMarkerInfo", "", "relatedItems", "Lkotlin/sequences/Sequence;", "Lcom/intellij/micronaut/jam/mq/MnMqMethodElement;", "shouldBeListener", "result", "", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerInfo;", "intellij.micronaut"})
    private static final class MnMqLineMarkerProviderHelper {
        @NotNull
        private final PsiElement anchor;
        @NotNull
        private final PsiMethod psiMethod;
        @NotNull
        private final PsiClass psiClass;
        @NotNull
        private final JamService jamService;

        public final boolean isListener() {
            return this.isKafkaListener() || this.isRabbitListener();
        }

        public final boolean isPublisher() {
            return this.isKafkaPublisher() || this.isKafkaSendToPublisher();
        }

        private final boolean isKafkaListener() {
            return MnKafkaListener.META.getJamElement((PsiModifierListOwner)this.psiClass) != null && this.jamService.getJamElement(MnKafkaTopic.MN_KAFKA_TOPIC_SEM_KEY, (PsiElement)this.psiMethod) != null;
        }

        private final boolean isRabbitListener() {
            return MnRabbitQueue.getJamElement(this.psiMethod) != null;
        }

        private final boolean isKafkaPublisher() {
            return MnKafkaClient.META.getJamElement((PsiModifierListOwner)this.psiClass) != null && this.jamService.getJamElement(MnKafkaTopic.MN_KAFKA_TOPIC_SEM_KEY, (PsiElement)this.psiMethod) != null;
        }

        private final boolean isKafkaSendToPublisher() {
            return MnKafkaListener.META.getJamElement((PsiModifierListOwner)this.psiClass) != null && this.jamService.getJamElement(MnSendTo.MN_MQ_METHOD_ELEMENT_SEM_KEY, (PsiElement)this.psiMethod) != null;
        }

        public final void addLineMarkerInfo(@NotNull Sequence<? extends MnMqMethodElement> relatedItems, boolean shouldBeListener, @NotNull Collection<? super RelatedItemLineMarkerInfo<PsiElement>> result) {
            Icon icon;
            Intrinsics.checkNotNullParameter(relatedItems, (String)"relatedItems");
            Intrinsics.checkNotNullParameter(result, (String)"result");
            if (shouldBeListener && this.isListener()) {
                icon = MicroservicesIcons.Gutter.MessageQueueReceiver;
            } else if (!shouldBeListener && this.isPublisher()) {
                icon = AllIcons.Webreferences.MessageQueue;
            } else {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"when {\n        shouldBeL\u2026   else -> return\n      }");
            Icon icon2 = icon;
            List list = SequencesKt.toList((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.filter(relatedItems, (Function1)((Function1)new Function1<MnMqMethodElement, Boolean>(shouldBeListener){
                final /* synthetic */ boolean $shouldBeListener;

                public final boolean invoke(@NotNull MnMqMethodElement it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it.isListener() == this.$shouldBeListener;
                }
                {
                    this.$shouldBeListener = bl;
                    super(1);
                }
            })), (Function1)addLineMarkerInfo.items.2.INSTANCE));
            boolean bl = false;
            boolean bl2 = false;
            List it = list;
            boolean bl3 = false;
            Collection collection = it;
            boolean bl4 = false;
            List list2 = !collection.isEmpty() ? list : null;
            if (list2 == null) {
                return;
            }
            List items2 = list2;
            NavigationGutterIconBuilder navigationGutterIconBuilder = UsagesNavigationGutterIconBuilder.Companion.create(icon2, MQ_CONVERTER).setTargets((Collection)items2);
            Intrinsics.checkNotNullExpressionValue((Object)navigationGutterIconBuilder, (String)"UsagesNavigationGutterIc\u2026       .setTargets(items)");
            NavigationGutterIconBuilder builder = navigationGutterIconBuilder;
            if (items2.size() == 1) {
                builder.setTooltipText(MicronautBundle.message("micronaut.mq.line.markers.tooltip.single", ((MQDestinationAnchor)CollectionsKt.first((List)items2)).getDestination().getName()));
            } else {
                builder.setTooltipText(MicronautBundle.message("micronaut.mq.line.markers.tooltip", new Object[0]));
                builder.setPopupTitle(MicronautBundle.message("micronaut.mq.line.markers.popupTitle", new Object[0]));
            }
            RelatedItemLineMarkerInfo relatedItemLineMarkerInfo = builder.createLineMarkerInfo(this.anchor);
            Intrinsics.checkNotNullExpressionValue((Object)relatedItemLineMarkerInfo, (String)"builder.createLineMarkerInfo(anchor)");
            result.add(new MnMqLineMarkerInfo((RelatedItemLineMarkerInfo<PsiElement>)relatedItemLineMarkerInfo));
        }

        @NotNull
        public final PsiElement getAnchor() {
            return this.anchor;
        }

        @NotNull
        public final PsiMethod getPsiMethod() {
            return this.psiMethod;
        }

        @NotNull
        public final PsiClass getPsiClass() {
            return this.psiClass;
        }

        @NotNull
        public final JamService getJamService() {
            return this.jamService;
        }

        public MnMqLineMarkerProviderHelper(@NotNull PsiElement anchor, @NotNull PsiMethod psiMethod, @NotNull PsiClass psiClass, @NotNull JamService jamService) {
            Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
            Intrinsics.checkNotNullParameter((Object)psiMethod, (String)"psiMethod");
            Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
            Intrinsics.checkNotNullParameter((Object)jamService, (String)"jamService");
            this.anchor = anchor;
            this.psiMethod = psiMethod;
            this.psiClass = psiClass;
            this.jamService = jamService;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fR \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/micronaut/provider/mq/MnMqLineMarkerProvider$Companion;", "", "()V", "MQ_CONVERTER", "Lcom/intellij/util/NotNullFunction;", "Lcom/intellij/microservices/mq/MQDestinationAnchor;", "", "Lcom/intellij/psi/PsiElement;", "createExternalContributedActionMarker", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerInfo;", "anchor", "lineMarkerAction", "Lcom/intellij/microservices/mq/gutters/MQLineMarkerActionsProvider$Action;", "intellij.micronaut"})
    public static final class Companion {
        @NotNull
        public final RelatedItemLineMarkerInfo<PsiElement> createExternalContributedActionMarker(@NotNull PsiElement anchor, @NotNull MQLineMarkerActionsProvider.Action lineMarkerAction) {
            Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
            Intrinsics.checkNotNullParameter((Object)lineMarkerAction, (String)"lineMarkerAction");
            MnLineMarkerBuilder.CustomNavigationGutterIconBuilder<PsiElement> this_$iv = MnLineMarkerBuilder.INSTANCE.createCustomNavigationBuilder(lineMarkerAction.getLineMarkerIcon());
            boolean $i$f$setNavigationHandler = false;
            MnLineMarkerBuilder.CustomNavigationGutterIconBuilder<PsiElement> customNavigationGutterIconBuilder = this_$iv;
            boolean bl = false;
            boolean bl2 = false;
            MnLineMarkerBuilder.CustomNavigationGutterIconBuilder<PsiElement> it$iv = customNavigationGutterIconBuilder;
            boolean bl3 = false;
            MnLineMarkerBuilder.CustomNavigationGutterIconBuilder.access$setNavigationHandler$p(this_$iv, new GutterIconNavigationHandler(this_$iv, lineMarkerAction){
                final /* synthetic */ MnLineMarkerBuilder.CustomNavigationGutterIconBuilder this$0;
                final /* synthetic */ MQLineMarkerActionsProvider.Action $lineMarkerAction$inlined;
                {
                    this.this$0 = customNavigationGutterIconBuilder;
                    this.$lineMarkerAction$inlined = action;
                }

                public final void navigate(MouseEvent event, PsiElement element) {
                    MouseEvent mouseEvent = event;
                    Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"event");
                    PsiElement psiElement = element;
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element");
                    PsiElement psiElement2 = psiElement;
                    MouseEvent e = mouseEvent;
                    boolean bl = false;
                    this.$lineMarkerAction$inlined.getAction().actionPerformed(AnActionEvent.createFromInputEvent((InputEvent)e, (String)"", null, (DataContext)DataManager.getInstance().getDataContext(e.getComponent())));
                }
            });
            RelatedItemLineMarkerInfo relatedItemLineMarkerInfo = customNavigationGutterIconBuilder.setAlignment(GutterIconRenderer.Alignment.LEFT).setTooltipText(lineMarkerAction.getLineMarkerTooltipText()).setTargets((Collection)CollectionsKt.emptyList()).createLineMarkerInfo(anchor);
            Intrinsics.checkNotNullExpressionValue((Object)relatedItemLineMarkerInfo, (String)"MnLineMarkerBuilder\n    \u2026ateLineMarkerInfo(anchor)");
            return relatedItemLineMarkerInfo;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

