/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider.management;

import com.intellij.ide.presentation.Presentation;
import com.intellij.micronaut.jam.http.MnHttpUrlPathSpecification;
import com.intellij.micronaut.jam.management.MnManagementMethod;
import com.intellij.micronaut.jam.management.MnManagementModel;
import com.intellij.micronaut.provider.management.MnManagementUrlResolver;
import com.intellij.micronaut.provider.management.MnManagementUrlTargetInfo;
import com.intellij.micronaut.provider.management.MnManagementUtils;
import com.intellij.microservices.url.HttpUrlResolver;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlResolveRequest;
import com.intellij.microservices.url.UrlResolver;
import com.intellij.microservices.url.UrlResolverFactory;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(typeName="Micronaut Management", icon="JavaUltimateIcons.Web.RequestMapping")
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/micronaut/provider/management/MnManagementUrlResolver;", "Lcom/intellij/microservices/url/HttpUrlResolver;", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getVariants", "", "Lcom/intellij/microservices/url/UrlTargetInfo;", "resolve", "request", "Lcom/intellij/microservices/url/UrlResolveRequest;", "Factory", "intellij.micronaut"})
public final class MnManagementUrlResolver
extends HttpUrlResolver {
    private final Project myProject;

    @NotNull
    public Iterable<UrlTargetInfo> resolve(@NotNull UrlResolveRequest request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMap((Sequence)UrlPath.Companion.combinations(request2.getPath()), (Function1)((Function1)new Function1<UrlPath, Sequence<? extends MnManagementUrlTargetInfo>>(this){
            final /* synthetic */ MnManagementUrlResolver this$0;

            @NotNull
            public final Sequence<MnManagementUrlTargetInfo> invoke(@NotNull UrlPath path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Sequence<MnManagementMethod> sequence = MnManagementModel.resolveUrl(MnManagementUrlResolver.access$getMyProject$p(this.this$0), path);
                Intrinsics.checkNotNullExpressionValue(sequence, (String)"MnManagementModel.resolveUrl(myProject, path)");
                return SequencesKt.map(sequence, (Function1)((Function1)new Function1<MnManagementMethod, MnManagementUrlTargetInfo>(this){
                    final /* synthetic */ resolve.1 this$0;

                    @NotNull
                    public final MnManagementUrlTargetInfo invoke(MnManagementMethod resolved) {
                        MnManagementMethod mnManagementMethod = resolved;
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)mnManagementMethod), (String)"resolved");
                        UrlPath urlPath = MnHttpUrlPathSpecification.INSTANCE.parsePath(MnManagementUtils.getManagementResourcePath(mnManagementMethod));
                        return new MnManagementUrlTargetInfo(this.this$0.this$0.getSupportedSchemes(), urlPath, resolved);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = mnManagementUrlResolver;
                super(1);
            }
        })));
    }

    @NotNull
    public Iterable<UrlTargetInfo> getVariants() {
        Sequence<MnManagementMethod> sequence = MnManagementModel.getEndpointMethods(this.myProject);
        Intrinsics.checkNotNullExpressionValue(sequence, (String)"MnManagementModel.getEndpointMethods(myProject)");
        return SequencesKt.asIterable((Sequence)SequencesKt.map(sequence, (Function1)((Function1)new Function1<MnManagementMethod, MnManagementUrlTargetInfo>(this){
            final /* synthetic */ MnManagementUrlResolver this$0;

            @NotNull
            public final MnManagementUrlTargetInfo invoke(MnManagementMethod mapping) {
                MnManagementMethod mnManagementMethod = mapping;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)mnManagementMethod), (String)"mapping");
                UrlPath urlPath = MnHttpUrlPathSpecification.INSTANCE.parsePath(MnManagementUtils.getManagementResourcePath(mnManagementMethod));
                return new MnManagementUrlTargetInfo(this.this$0.getSupportedSchemes(), urlPath, mapping);
            }
            {
                this.this$0 = mnManagementUrlResolver;
                super(1);
            }
        })));
    }

    public MnManagementUrlResolver(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
    }

    public static final /* synthetic */ Project access$getMyProject$p(MnManagementUrlResolver $this) {
        return $this.myProject;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/micronaut/provider/management/MnManagementUrlResolver$Factory;", "Lcom/intellij/microservices/url/UrlResolverFactory;", "()V", "forProject", "Lcom/intellij/microservices/url/UrlResolver;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.micronaut"})
    public static final class Factory
    implements UrlResolverFactory {
        @Nullable
        public UrlResolver forProject(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (!MnManagementUtils.hasManagementLibrary(project)) {
                return null;
            }
            return (UrlResolver)new MnManagementUrlResolver(project);
        }
    }
}

