/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider.management;

import com.intellij.micronaut.MicronautBundle;
import com.intellij.micronaut.MicronautIcons;
import com.intellij.micronaut.jam.http.MnHttpUrlPathSpecification;
import com.intellij.micronaut.jam.management.MnManagementEndpoint;
import com.intellij.micronaut.jam.management.MnManagementMethod;
import com.intellij.micronaut.jam.management.MnManagementModel;
import com.intellij.micronaut.provider.management.MnManagementFramework;
import com.intellij.micronaut.provider.management.MnManagementUrlTargetInfo;
import com.intellij.micronaut.provider.management.MnManagementUtils;
import com.intellij.microservices.cache.SourceTestLibSearcher;
import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointTypes;
import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.FrameworkPresentation;
import com.intellij.microservices.endpoints.ModuleEndpointsFilter;
import com.intellij.microservices.endpoints.presentation.HttpMethodPresentation;
import com.intellij.microservices.uast.url.UastUrlAttributeUtils;
import com.intellij.microservices.url.UrlConstants;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.microservices.utils.EndpointsViewUtils;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.ValueKey;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.uast.UastModificationTracker;
import icons.JavaUltimateIcons;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\"\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030\u00102\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010%\u001a\u00020&2\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0003H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006'"}, d2={"Lcom/intellij/micronaut/provider/management/MnManagementFramework;", "Lcom/intellij/microservices/endpoints/EndpointsProvider;", "Lcom/intellij/micronaut/jam/management/MnManagementEndpoint;", "Lcom/intellij/micronaut/jam/management/MnManagementMethod;", "()V", "endpointType", "Lcom/intellij/microservices/endpoints/EndpointType;", "getEndpointType", "()Lcom/intellij/microservices/endpoints/EndpointType;", "endpointsSearcher", "Lcom/intellij/microservices/cache/SourceTestLibSearcher;", "presentation", "Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getPresentation", "()Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "createEndpointData", "", "Lcom/intellij/microservices/url/UrlTargetInfo;", "methodMapping", "getEndpointData", "", "group", "endpoint", "dataId", "", "getEndpointGroups", "project", "Lcom/intellij/openapi/project/Project;", "filter", "Lcom/intellij/microservices/endpoints/EndpointsFilter;", "getEndpointPresentation", "Lcom/intellij/navigation/ItemPresentation;", "getEndpoints", "getModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "getStatus", "Lcom/intellij/microservices/endpoints/EndpointsProvider$Status;", "isValidEndpoint", "", "intellij.micronaut"})
public final class MnManagementFramework
implements EndpointsProvider<MnManagementEndpoint, MnManagementMethod> {
    private final SourceTestLibSearcher<MnManagementEndpoint> endpointsSearcher = new SourceTestLibSearcher("MN_MANAGEMENT_ENDPOINTS", (Function2)endpointsSearcher.1.INSTANCE);
    @NotNull
    private final FrameworkPresentation presentation = new FrameworkPresentation("Micronaut-Management", MicronautBundle.message("micronaut.management.framework.title", new Object[0]), MicronautIcons.MicronautLogo);

    @NotNull
    public EndpointType getEndpointType() {
        return EndpointTypes.HTTP_SERVER_TYPE;
    }

    @NotNull
    public FrameworkPresentation getPresentation() {
        return this.presentation;
    }

    @NotNull
    public EndpointsProvider.Status getStatus(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return MnManagementUtils.hasManagementLibrary(project) ? EndpointsProvider.Status.HAS_ENDPOINTS : EndpointsProvider.Status.UNAVAILABLE;
    }

    @NotNull
    public Iterable<MnManagementEndpoint> getEndpointGroups(@NotNull Project project, @NotNull EndpointsFilter filter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        if (!(filter instanceof ModuleEndpointsFilter)) {
            return CollectionsKt.emptyList();
        }
        return this.endpointsSearcher.iterable(((ModuleEndpointsFilter)filter).getModule(), ((ModuleEndpointsFilter)filter).getFromTests(), ((ModuleEndpointsFilter)filter).getFromLibraries());
    }

    @NotNull
    public Iterable<MnManagementMethod> getEndpoints(@NotNull MnManagementEndpoint group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        List<MnManagementMethod> list = MnManagementModel.getManagementMethods(group.getPsiElement());
        Intrinsics.checkNotNullExpressionValue(list, (String)"MnManagementModel.getMan\u2026Methods(group.psiElement)");
        return list;
    }

    @NotNull
    public ItemPresentation getEndpointPresentation(@NotNull MnManagementEndpoint group, @NotNull MnManagementMethod endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)((Object)endpoint), (String)"endpoint");
        String string = MnManagementUtils.getManagementResourcePath(endpoint);
        String string2 = endpoint.getHttpMethod();
        PsiClass psiClass = group.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"group.psiElement");
        return (ItemPresentation)new HttpMethodPresentation(string, string2, psiClass.getName(), JavaUltimateIcons.Web.RequestMapping, (TextAttributesKey)(UastUrlAttributeUtils.isUastDeclarationDeprecated((PsiElement)((PsiElement)endpoint.getPsiElement())) ? CodeInsightColors.DEPRECATED_ATTRIBUTES : null));
    }

    @Nullable
    public Object getEndpointData(@NotNull MnManagementEndpoint group, @NotNull MnManagementMethod endpoint, @NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)((Object)endpoint), (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        ValueKey.BeforeIf beforeIf = ValueKey.match((String)dataId).ifEq((ValueKey)EndpointsProvider.URL_TARGET_INFO).thenGet(new Supplier(this, endpoint){
            final /* synthetic */ MnManagementFramework this$0;
            final /* synthetic */ MnManagementMethod $endpoint;

            public final Iterable<UrlTargetInfo> get() {
                return MnManagementFramework.access$createEndpointData(this.this$0, this.$endpoint);
            }
            {
                this.this$0 = mnManagementFramework;
                this.$endpoint = mnManagementMethod;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)beforeIf, (String)"ValueKey.match(dataId)\n \u2026eEndpointData(endpoint) }");
        return EndpointsViewUtils.orCheckCommonEndpointKeys((ValueKey.BeforeIf)beforeIf, (PsiElement)((PsiElement)endpoint.getPsiElement()));
    }

    private final Iterable<UrlTargetInfo> createEndpointData(MnManagementMethod methodMapping) {
        UrlPath urlPath = MnHttpUrlPathSpecification.INSTANCE.parsePath(MnManagementUtils.getManagementResourcePath(methodMapping));
        return CollectionsKt.listOf((Object)new MnManagementUrlTargetInfo(UrlConstants.HTTP_SCHEMES, urlPath, methodMapping));
    }

    public boolean isValidEndpoint(@NotNull MnManagementEndpoint group, @NotNull MnManagementMethod endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)((Object)endpoint), (String)"endpoint");
        return endpoint.isValid();
    }

    @NotNull
    public ModificationTracker getModificationTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (ModificationTracker)UastModificationTracker.Companion.getInstance(project);
    }

    public static final /* synthetic */ Iterable access$createEndpointData(MnManagementFramework $this, MnManagementMethod methodMapping) {
        return $this.createEndpointData(methodMapping);
    }
}

