/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider.http;

import com.intellij.micronaut.jam.http.MnHttpConstants;
import com.intellij.micronaut.provider.http.MnHttpUtils;
import com.intellij.microservices.utils.pathVariables.PathVariableRegexInjector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.uast.UExpressionPattern;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.util.ProcessingContext;
import com.intellij.util.text.PlaceholderTextRanges;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnnotationUtils;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0014J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0014\u0010\u000e\u001a\u00020\u000b2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0014\u00a8\u0006\u0013"}, d2={"Lcom/intellij/micronaut/provider/http/MnPathVariableRegexInjector;", "Lcom/intellij/microservices/utils/pathVariables/PathVariableRegexInjector;", "()V", "getIgnoredRanges", "", "Lcom/intellij/openapi/util/TextRange;", "text", "", "getPattern", "Lcom/intellij/patterns/uast/UExpressionPattern;", "isSupportedProject", "", "project", "Lcom/intellij/openapi/project/Project;", "validateRangeValue", "rangeValue", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "Holder", "intellij.micronaut"})
public final class MnPathVariableRegexInjector
extends PathVariableRegexInjector {
    @NotNull
    protected UExpressionPattern<?, ?> getPattern() {
        return Holder.INSTANCE.getPATTERN();
    }

    protected boolean validateRangeValue(@NotNull StringBuilder rangeValue) {
        Intrinsics.checkNotNullParameter((Object)rangeValue, (String)"rangeValue");
        Regex regex = Holder.INSTANCE.getDIGITS_CONSTRAINT_REGEX();
        String string = rangeValue.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"rangeValue.toString()");
        return !regex.matches((CharSequence)string);
    }

    protected boolean isSupportedProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return MnHttpUtils.hasHttpServerLibrary(project);
    }

    @NotNull
    protected Collection<TextRange> getIgnoredRanges(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Set set = PlaceholderTextRanges.getPlaceholderRanges((String)text, (String)"${", (String)"}");
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"PlaceholderTextRanges.ge\u2026rRanges(text, \"\\${\", \"}\")");
        return set;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0019\u0010\u0007\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/micronaut/provider/http/MnPathVariableRegexInjector$Holder;", "", "()V", "DIGITS_CONSTRAINT_REGEX", "Lkotlin/text/Regex;", "getDIGITS_CONSTRAINT_REGEX", "()Lkotlin/text/Regex;", "PATTERN", "Lcom/intellij/patterns/uast/UExpressionPattern;", "getPATTERN", "()Lcom/intellij/patterns/uast/UExpressionPattern;", "intellij.micronaut"})
    private static final class Holder {
        @NotNull
        private static final UExpressionPattern<?, ?> PATTERN;
        @NotNull
        private static final Regex DIGITS_CONSTRAINT_REGEX;
        @NotNull
        public static final Holder INSTANCE;

        @NotNull
        public final UExpressionPattern<?, ?> getPATTERN() {
            return PATTERN;
        }

        @NotNull
        public final Regex getDIGITS_CONSTRAINT_REGEX() {
            return DIGITS_CONSTRAINT_REGEX;
        }

        private Holder() {
        }

        static {
            Holder holder;
            INSTANCE = holder = new Holder();
            ObjectPattern objectPattern = UastPatterns.uExpression().with((PatternCondition)new PatternCondition<UExpression>("mnAnnotationParam"){

                /*
                 * WARNING - void declaration
                 */
                public boolean accepts(@NotNull UExpression uElement, @Nullable ProcessingContext context) {
                    void uAnnotation;
                    Intrinsics.checkNotNullParameter((Object)uElement, (String)"uElement");
                    Pair pair = UAnnotationUtils.getContainingUAnnotationEntry((UElement)((UElement)uElement));
                    if (pair == null) {
                        return false;
                    }
                    Pair pair2 = pair;
                    UAnnotation uAnnotation2 = (UAnnotation)pair2.component1();
                    String uParamName = (String)pair2.component2();
                    String string = uParamName;
                    if (string == null) {
                        string = "value";
                    }
                    String paramName = string;
                    String qualifiedName = uAnnotation.getQualifiedName();
                    if (CollectionsKt.contains((Iterable)MnHttpConstants.getMN_HTTP_MAPPING_METHODS(), (Object)qualifiedName)) {
                        return Intrinsics.areEqual((Object)paramName, (Object)"value") || Intrinsics.areEqual((Object)paramName, (Object)"uri");
                    }
                    if (Intrinsics.areEqual((Object)qualifiedName, (Object)"io.micronaut.http.annotation.Controller") || Intrinsics.areEqual((Object)qualifiedName, (Object)"io.micronaut.websocket.annotation.ServerWebSocket") || Intrinsics.areEqual((Object)qualifiedName, (Object)"io.micronaut.websocket.annotation.ClientWebSocket") || Intrinsics.areEqual((Object)qualifiedName, (Object)"io.micronaut.http.annotation.UriMapping") || Intrinsics.areEqual((Object)qualifiedName, (Object)"io.micronaut.http.annotation.HttpMethodMapping")) {
                        return Intrinsics.areEqual((Object)paramName, (Object)"value");
                    }
                    return false;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)objectPattern, (String)"uExpression().with(objec\u2026 false\n        }\n      })");
            PATTERN = (UExpressionPattern)objectPattern;
            DIGITS_CONSTRAINT_REGEX = new Regex("\\s*[0-9]+\\s*");
        }
    }
}

