/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider.http;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.micronaut.MicronautBundle;
import com.intellij.micronaut.jam.beans.MnStereotypeElement;
import com.intellij.micronaut.jam.http.MnController;
import com.intellij.micronaut.jam.http.mapping.MnHttpMethodMapping;
import com.intellij.micronaut.provider.base.MnLineMarkerProvider;
import com.intellij.micronaut.provider.beans.MicronautBeanUtilsKt;
import com.intellij.micronaut.provider.http.MnHttpNavigationProvider;
import com.intellij.micronaut.provider.http.MnHttpUtils;
import com.intellij.micronaut.utils.MnLineMarkerBuilder;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import icons.JavaUltimateIcons;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UMethod;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0014\u0010\u0007\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bH\u0014J2\u0010\u000b\u001a\u00020\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\r2\u0012\u0010\u0007\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\t0\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/micronaut/provider/http/MnHttpLineMarkers;", "Lcom/intellij/micronaut/provider/base/MnLineMarkerProvider;", "()V", "annotateMethod", "", "uMethod", "Lorg/jetbrains/uast/UMethod;", "result", "", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerInfo;", "Lcom/intellij/psi/PsiElement;", "collectNavigationMarkers", "elements", "", "forNavigation", "", "getIcon", "Ljavax/swing/Icon;", "getName", "", "Companion", "intellij.micronaut"})
public final class MnHttpLineMarkers
extends MnLineMarkerProvider {
    private static final ExtensionPointName<MnHttpNavigationProvider> EP_NAME;
    @NotNull
    public static final Companion Companion;

    public void collectNavigationMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, boolean forNavigation) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter(elements, (String)"elements");
                Intrinsics.checkNotNullParameter(result, (String)"result");
                PsiElement psiElement = (PsiElement)CollectionsKt.firstOrNull(elements);
                if (psiElement == null) break block2;
                Project project = psiElement.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"psiElement.project");
                if (MnHttpUtils.hasHttpServerLibrary(project)) break block3;
                Project project2 = psiElement.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"psiElement.project");
                if (MnHttpUtils.hasHttpClientLibrary(project2)) break block3;
            }
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    @Nullable
    public Icon getIcon() {
        return JavaUltimateIcons.Web.Gutter.RequestMapping;
    }

    @Nullable
    public String getName() {
        return MicronautBundle.message("micronaut.http.markers", new Object[0]);
    }

    @Override
    protected void annotateMethod(@NotNull UMethod uMethod, @NotNull Collection<? super RelatedItemLineMarkerInfo<PsiElement>> result) {
        RelatedItemLineMarkerInfo relatedItemLineMarkerInfo;
        Intrinsics.checkNotNullParameter((Object)uMethod, (String)"uMethod");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        PsiElement psiElement = UElementKt.getSourcePsiElement((UElement)uMethod.getUastAnchor());
        if (psiElement == null) {
            return;
        }
        PsiElement identifier = psiElement;
        PsiMethod psiMethod = uMethod.getJavaPsi();
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass == null || psiMethod.hasModifierProperty("private") || psiMethod.hasModifierProperty("static") || psiMethod.isConstructor() || !MicronautBeanUtilsKt.isBeanMappedClass(containingClass)) {
            return;
        }
        MnStereotypeElement mnStereotypeElement = MnHttpUtils.getHttpMappingsHolder(containingClass);
        if (mnStereotypeElement == null) {
            return;
        }
        MnStereotypeElement mappingsHolder = mnStereotypeElement;
        if (mappingsHolder instanceof MnController && psiMethod.hasModifierProperty("abstract")) {
            return;
        }
        MnHttpMethodMapping mnHttpMethodMapping = MnHttpUtils.getHttpMapping(psiMethod);
        if (mnHttpMethodMapping == null) {
            return;
        }
        MnHttpMethodMapping mapping = mnHttpMethodMapping;
        String urlMapping = MnHttpUtils.getHttpResourcePath(mapping, psiMethod.getContainingClass());
        MnHttpNavigationProvider.MnHttpNavigationInfo customNavigationInfo = Companion.getNavigationInfo(mapping);
        if (urlMapping != null && customNavigationInfo != null) {
            Icon icon = JavaUltimateIcons.Web.Gutter.RequestMapping;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"JavaUltimateIcons.Web.Gutter.RequestMapping");
            RelatedItemLineMarkerInfo relatedItemLineMarkerInfo2 = MnLineMarkerBuilder.INSTANCE.createCustomNavigationBuilder(icon).addGotoRelatedItems(customNavigationInfo.getRelatedItems()).setNavigationHandler(customNavigationInfo.getNavigationHandler()).setAlignment(GutterIconRenderer.Alignment.LEFT).setTooltipText(customNavigationInfo.getTooltip()).setTargets((Collection)CollectionsKt.emptyList()).createLineMarkerInfo(identifier);
            relatedItemLineMarkerInfo = relatedItemLineMarkerInfo2;
            Intrinsics.checkNotNullExpressionValue((Object)relatedItemLineMarkerInfo2, (String)"MnLineMarkerBuilder\n    \u2026ineMarkerInfo(identifier)");
        } else {
            String toolTip = urlMapping == null ? MicronautBundle.message("micronaut.http.method.mapping.tooltip.text", new Object[0]) : (mapping.getHttpMethod() != null ? '[' + mapping.getHttpMethod() + "] " + urlMapping : urlMapping);
            Icon icon = JavaUltimateIcons.Web.Gutter.RequestMapping;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"JavaUltimateIcons.Web.Gutter.RequestMapping");
            relatedItemLineMarkerInfo = this.marker(identifier, icon, toolTip);
        }
        RelatedItemLineMarkerInfo marker = relatedItemLineMarkerInfo;
        result.add((RelatedItemLineMarkerInfo<PsiElement>)marker);
    }

    static {
        Companion = new Companion(null);
        ExtensionPointName extensionPointName = ExtensionPointName.create((String)"com.intellij.micronaut.httpNavigationProvider");
        Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"ExtensionPointName.creat\u2026.httpNavigationProvider\")");
        EP_NAME = extensionPointName;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bR!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/micronaut/provider/http/MnHttpLineMarkers$Companion;", "", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/micronaut/provider/http/MnHttpNavigationProvider;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getNavigationInfo", "Lcom/intellij/micronaut/provider/http/MnHttpNavigationProvider$MnHttpNavigationInfo;", "mnHttpMethodMapping", "Lcom/intellij/micronaut/jam/http/mapping/MnHttpMethodMapping;", "intellij.micronaut"})
    public static final class Companion {
        @Nullable
        public final MnHttpNavigationProvider.MnHttpNavigationInfo getNavigationInfo(@NotNull MnHttpMethodMapping mnHttpMethodMapping) {
            Intrinsics.checkNotNullParameter((Object)mnHttpMethodMapping, (String)"mnHttpMethodMapping");
            List list = EP_NAME.getExtensionList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"EP_NAME.extensionList");
            return (MnHttpNavigationProvider.MnHttpNavigationInfo)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)((Function1)new Function1<MnHttpNavigationProvider, MnHttpNavigationProvider.MnHttpNavigationInfo>(mnHttpMethodMapping){
                final /* synthetic */ MnHttpMethodMapping $mnHttpMethodMapping;

                @Nullable
                public final MnHttpNavigationProvider.MnHttpNavigationInfo invoke(MnHttpNavigationProvider it) {
                    return it.getGutterNavigationInfo(this.$mnHttpMethodMapping);
                }
                {
                    this.$mnHttpMethodMapping = mnHttpMethodMapping;
                    super(1);
                }
            })));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

