/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider.beans;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.jam.JamService;
import com.intellij.micronaut.MicronautBundle;
import com.intellij.micronaut.MicronautUtils;
import com.intellij.micronaut.jam.beans.JamPsiMemberMicronautBean;
import com.intellij.micronaut.jam.beans.JamPsiMethodMicronautBean;
import com.intellij.micronaut.jam.beans.MnBeanDefinition;
import com.intellij.micronaut.jam.beans.MnBeansModel;
import com.intellij.micronaut.jam.beans.MnFactory;
import com.intellij.micronaut.jam.beans.MnInject;
import com.intellij.micronaut.jam.beans.MnInjectionPoint;
import com.intellij.micronaut.jam.beans.MnStereotypeElement;
import com.intellij.micronaut.provider.base.MnLineMarkerProvider;
import com.intellij.micronaut.provider.beans.MicronautBeanUtilsKt;
import com.intellij.micronaut.utils.MnLineMarkerBuilder;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import icons.JavaUltimateIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotationUtils;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UFieldEx;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0014\u0010\t\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\b0\u000b0\nH\u0002J&\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0014\u0010\t\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\b0\u000b0\nH\u0014J&\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0014\u0010\t\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\b0\u000b0\nH\u0014J&\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0014\u0010\t\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\b0\u000b0\nH\u0014J&\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0014\u0010\t\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\b0\u000b0\nH\u0014J2\u0010\u0018\u001a\u00020\u00042\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u001a2\u0012\u0010\t\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u000b0\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\u001e2\u0006\u0010\"\u001a\u00020\u0006H\u0002J\n\u0010#\u001a\u0004\u0018\u00010$H\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u001f\u001a\u00020 H\u0002J\n\u0010'\u001a\u0004\u0018\u00010(H\u0016J\u0010\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020+H\u0002\u00a8\u0006,"}, d2={"Lcom/intellij/micronaut/provider/beans/MnBeansLineMarkers;", "Lcom/intellij/micronaut/provider/base/MnLineMarkerProvider;", "()V", "addAutowiredMarker", "", "psiInjectedElement", "Lcom/intellij/psi/PsiModifierListOwner;", "identifier", "Lcom/intellij/psi/PsiElement;", "result", "", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerInfo;", "annotateClass", "uClass", "Lorg/jetbrains/uast/UClass;", "annotateField", "uField", "Lorg/jetbrains/uast/UFieldEx;", "annotateMethod", "uMethod", "Lorg/jetbrains/uast/UMethod;", "annotateMethodParameter", "uParameter", "Lorg/jetbrains/uast/UParameter;", "collectNavigationMarkers", "elements", "", "forNavigation", "", "findAutowiredCandidates", "", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "findAutowiredDependencies", "psiElement", "getIcon", "Ljavax/swing/Icon;", "getMethodBeanJam", "Lcom/intellij/micronaut/jam/beans/JamPsiMethodMicronautBean;", "getName", "", "isFactoryClass", "containingClass", "Lcom/intellij/psi/PsiClass;", "intellij.micronaut"})
public final class MnBeansLineMarkers
extends MnLineMarkerProvider {
    @Nullable
    public String getName() {
        return MicronautBundle.message("micronaut.bean.markers", new Object[0]);
    }

    @Nullable
    public Icon getIcon() {
        return JavaUltimateIcons.Cdi.Gutter.Bean;
    }

    public void collectNavigationMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, boolean forNavigation) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter(elements, (String)"elements");
                Intrinsics.checkNotNullParameter(result, (String)"result");
                PsiElement psiElement = (PsiElement)CollectionsKt.firstOrNull(elements);
                if (psiElement == null) break block2;
                Project project = psiElement.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"psiElement.project");
                if (MicronautUtils.hasMicronautLibrary(project)) break block3;
            }
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    @Override
    protected void annotateClass(@NotNull UClass uClass, @NotNull Collection<? super RelatedItemLineMarkerInfo<PsiElement>> result) {
        Intrinsics.checkNotNullParameter((Object)uClass, (String)"uClass");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        PsiElement psiElement = UElementKt.getSourcePsiElement((UElement)uClass.getUastAnchor());
        if (psiElement == null) {
            return;
        }
        PsiElement identifier = psiElement;
        PsiClass psiClass = uClass.getJavaPsi();
        JamPsiMemberMicronautBean<?> jamPsiMemberMicronautBean = MicronautBeanUtilsKt.getBeanMapping(psiClass);
        if (jamPsiMemberMicronautBean == null) {
            return;
        }
        JamPsiMemberMicronautBean<?> beanJamElement = jamPsiMemberMicronautBean;
        if (beanJamElement instanceof MnStereotypeElement) {
            Icon icon = ((MnStereotypeElement)beanJamElement).getBeanIcon();
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"beanJamElement.beanIcon");
            String string = ((MnStereotypeElement)beanJamElement).getBeanDescription();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"beanJamElement.beanDescription");
            result.add((RelatedItemLineMarkerInfo<PsiElement>)this.marker(identifier, icon, string));
        } else {
            Icon icon = JavaUltimateIcons.Cdi.Gutter.Bean;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"JavaUltimateIcons.Cdi.Gutter.Bean");
            result.add((RelatedItemLineMarkerInfo<PsiElement>)this.marker(identifier, icon, MicronautBundle.message("micronaut.bean.class.tooltip.text", new Object[0])));
        }
    }

    @Override
    protected void annotateMethod(@NotNull UMethod uMethod, @NotNull Collection<? super RelatedItemLineMarkerInfo<PsiElement>> result) {
        JamPsiMethodMicronautBean methodBean;
        Intrinsics.checkNotNullParameter((Object)uMethod, (String)"uMethod");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        PsiMethod psiMethod = uMethod.getJavaPsi();
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass == null || psiMethod.isConstructor() || psiMethod.hasModifierProperty("static") || psiMethod.hasModifierProperty("abstract") || !MicronautBeanUtilsKt.isBeanMappedClass(containingClass)) {
            return;
        }
        if (psiMethod.getReturnType() instanceof PsiClassType && (methodBean = this.getMethodBeanJam(psiMethod)) != null && this.isFactoryClass(containingClass)) {
            PsiElement psiElement = UAnnotationUtils.getNameElement((UElement)UastContextKt.toUElement((PsiElement)((PsiElement)methodBean.getAnnotation())));
            if (psiElement == null) {
                return;
            }
            PsiElement psiAnnotationIdentifier = psiElement;
            if (ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)psiMethod)) == null) {
                return;
            }
            Icon icon = JavaUltimateIcons.Cdi.Gutter.ShowAutowiredCandidates;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"JavaUltimateIcons.Cdi.Gu\u2026r.ShowAutowiredCandidates");
            NavigationGutterIconBuilder navigationGutterIconBuilder = MnLineMarkerBuilder.INSTANCE.create(icon).setAlignment(GutterIconRenderer.Alignment.LEFT).setPopupTitle(MicronautBundle.message("micronaut.candidates.popup.title", new Object[0])).setEmptyPopupText(MicronautBundle.message("micronaut.candidates.popup.empty", new Object[0])).setTargets(this.findAutowiredCandidates(psiMethod)).setTooltipText(MicronautBundle.message("micronaut.show.candidates.tooltip.text", new Object[0]));
            Intrinsics.checkNotNullExpressionValue((Object)navigationGutterIconBuilder, (String)"MnLineMarkerBuilder.crea\u2026andidates.tooltip.text\"))");
            NavigationGutterIconBuilder builder = navigationGutterIconBuilder;
            RelatedItemLineMarkerInfo relatedItemLineMarkerInfo = builder.createLineMarkerInfo(psiAnnotationIdentifier);
            Intrinsics.checkNotNullExpressionValue((Object)relatedItemLineMarkerInfo, (String)"builder.createLineMarker\u2026(psiAnnotationIdentifier)");
            result.add((RelatedItemLineMarkerInfo<PsiElement>)relatedItemLineMarkerInfo);
        }
    }

    @Override
    protected void annotateMethodParameter(@NotNull UParameter uParameter, @NotNull Collection<? super RelatedItemLineMarkerInfo<PsiElement>> result) {
        Intrinsics.checkNotNullParameter((Object)uParameter, (String)"uParameter");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        UElement uElement = uParameter.getUastParent();
        if (uElement == null) {
            return;
        }
        UElement parent = uElement;
        if (!(parent instanceof UMethod)) {
            return;
        }
        PsiElement psiParameter = uParameter.getJavaPsi();
        if (!(psiParameter instanceof PsiParameter)) {
            return;
        }
        PsiMethod psiMethod = ((UMethod)parent).getJavaPsi();
        PsiClass containingClass = psiMethod.getContainingClass();
        PsiElement psiElement = UElementKt.getSourcePsiElement((UElement)uParameter.getUastAnchor());
        if (psiElement == null) {
            return;
        }
        PsiElement identifier = psiElement;
        if (containingClass == null || psiMethod.hasModifierProperty("static") || psiMethod.hasModifierProperty("abstract") || !MicronautBeanUtilsKt.isBeanMappedClass(containingClass) || ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)psiMethod)) == null) {
            return;
        }
        if (psiMethod.isConstructor() || MnInject.METHOD_META.getJamElement((PsiModifierListOwner)psiMethod) != null || this.getMethodBeanJam(psiMethod) != null && this.isFactoryClass(containingClass)) {
            this.addAutowiredMarker((PsiModifierListOwner)psiParameter, identifier, result);
        }
    }

    @Override
    protected void annotateField(@NotNull UFieldEx uField, @NotNull Collection<? super RelatedItemLineMarkerInfo<PsiElement>> result) {
        Intrinsics.checkNotNullParameter((Object)uField, (String)"uField");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        PsiElement psiElement = UElementKt.getSourcePsiElement((UElement)uField.getUastAnchor());
        if (psiElement == null) {
            return;
        }
        PsiElement identifier = psiElement;
        PsiField psiField = uField.getJavaPsi();
        PsiClass containingClass = psiField.getContainingClass();
        if (containingClass == null || !MicronautBeanUtilsKt.isBeanMappedClass(containingClass) || ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)psiField)) == null) {
            return;
        }
        if (MnInject.FIELD_META.getJamElement((PsiModifierListOwner)psiField) != null) {
            this.addAutowiredMarker((PsiModifierListOwner)psiField, identifier, result);
        }
    }

    private final void addAutowiredMarker(PsiModifierListOwner psiInjectedElement, PsiElement identifier, Collection<? super RelatedItemLineMarkerInfo<PsiElement>> result) {
        Icon icon = JavaUltimateIcons.Cdi.Gutter.ShowAutowiredDependencies;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"JavaUltimateIcons.Cdi.Gu\u2026ShowAutowiredDependencies");
        NavigationGutterIconBuilder navigationGutterIconBuilder = MnLineMarkerBuilder.INSTANCE.create(icon).setAlignment(GutterIconRenderer.Alignment.LEFT).setPopupTitle(MicronautBundle.message("micronaut.inject.popup.title", new Object[0])).setEmptyPopupText(MicronautBundle.message("micronaut.inject.popup.empty", new Object[0])).setTargets(this.findAutowiredDependencies(psiInjectedElement)).setTooltipText(MicronautBundle.message("micronaut.show.dependencies.tooltip.text", new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)navigationGutterIconBuilder, (String)"MnLineMarkerBuilder.crea\u2026endencies.tooltip.text\"))");
        NavigationGutterIconBuilder builder = navigationGutterIconBuilder;
        RelatedItemLineMarkerInfo relatedItemLineMarkerInfo = builder.createLineMarkerInfo(identifier);
        Intrinsics.checkNotNullExpressionValue((Object)relatedItemLineMarkerInfo, (String)"builder.createLineMarkerInfo(identifier)");
        result.add((RelatedItemLineMarkerInfo<PsiElement>)relatedItemLineMarkerInfo);
    }

    private final boolean isFactoryClass(PsiClass containingClass) {
        return MnFactory.META.getJamElement((PsiModifierListOwner)containingClass) != null;
    }

    private final JamPsiMethodMicronautBean getMethodBeanJam(PsiMethod psiMethod) {
        JamService jamService = JamService.getJamService((Project)psiMethod.getProject());
        JamPsiMemberMicronautBean beanJam = (JamPsiMemberMicronautBean)jamService.getJamElement(JamPsiMemberMicronautBean.PSI_MEMBER_BEAN_JAM_KEY, (PsiElement)psiMethod);
        JamPsiMemberMicronautBean jamPsiMemberMicronautBean = beanJam;
        if (!(jamPsiMemberMicronautBean instanceof JamPsiMethodMicronautBean)) {
            jamPsiMemberMicronautBean = null;
        }
        return (JamPsiMethodMicronautBean)jamPsiMemberMicronautBean;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<PsiElement> findAutowiredDependencies(PsiModifierListOwner psiElement) {
        void $this$mapTo$iv$iv;
        Collection<MnBeanDefinition> collection = MnBeansModel.findAutowiredDependencies(new MnInjectionPoint(psiElement));
        Intrinsics.checkNotNullExpressionValue(collection, (String)"MnBeansModel.findAutowir\u2026jectionPoint(psiElement))");
        Collection<MnBeanDefinition> dependencies = collection;
        Iterable $this$map$iv = dependencies;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MnBeanDefinition mnBeanDefinition = (MnBeanDefinition)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
            PsiElement psiElement2 = v1.getDefiningPsiElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"it.definingPsiElement");
            PsiElement psiElement3 = psiElement2.getNavigationElement();
            collection2.add(psiElement3);
        }
        return CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<PsiElement> findAutowiredCandidates(PsiMethod psiMethod) {
        void $this$mapTo$iv$iv;
        JamService jamService = JamService.getJamService((Project)psiMethod.getProject());
        JamPsiMemberMicronautBean beanDefinition = (JamPsiMemberMicronautBean)jamService.getJamElement(JamPsiMemberMicronautBean.PSI_MEMBER_BEAN_JAM_KEY, (PsiElement)psiMethod);
        Collection<MnInjectionPoint> collection = MnBeansModel.findAutowiredCandidates(beanDefinition);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"MnBeansModel.findAutowir\u2026andidates(beanDefinition)");
        Collection<MnInjectionPoint> candidates = collection;
        Iterable $this$map$iv = candidates;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MnInjectionPoint mnInjectionPoint = (MnInjectionPoint)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
            PsiModifierListOwner psiModifierListOwner = v1.getOwner();
            Intrinsics.checkNotNullExpressionValue((Object)psiModifierListOwner, (String)"it.owner");
            PsiElement psiElement = psiModifierListOwner.getNavigationElement();
            collection2.add(psiElement);
        }
        return CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
    }
}

