/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider.base;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.micronaut.utils.MnLineMarkerBuilder;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UFieldEx;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b \u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0014\u0010\u0007\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bH\u0014J&\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0014\u0010\u0007\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bH\u0014J&\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0014\u0010\u0007\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bH\u0014J&\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0014\u0010\u0007\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bH\u0014J&\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0014\u0010\u0007\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bH\u0014J$\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\n2\u0012\u0010\u0007\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\t0\bH\u0014J(\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0001\u0010\u001d\u001a\u00020\u001eH\u0004\u00a8\u0006\u001f"}, d2={"Lcom/intellij/micronaut/provider/base/MnLineMarkerProvider;", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerProvider;", "()V", "annotateClass", "", "uClass", "Lorg/jetbrains/uast/UClass;", "result", "", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerInfo;", "Lcom/intellij/psi/PsiElement;", "annotateField", "uField", "Lorg/jetbrains/uast/UFieldEx;", "annotateMethod", "uMethod", "Lorg/jetbrains/uast/UMethod;", "annotateMethodCall", "uMethodCall", "Lorg/jetbrains/uast/UCallExpression;", "annotateMethodParameter", "uParameter", "Lorg/jetbrains/uast/UParameter;", "collectNavigationMarkers", "element", "marker", "identifier", "icon", "Ljavax/swing/Icon;", "tooltipText", "", "intellij.micronaut"})
public abstract class MnLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    protected void collectNavigationMarkers(@NotNull PsiElement element, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        UElement uParent = UastUtils.getUParentForIdentifier((PsiElement)element);
        if (uParent instanceof UClass) {
            this.annotateClass((UClass)uParent, result);
        } else if (uParent instanceof UMethod) {
            this.annotateMethod((UMethod)uParent, result);
        } else if (uParent instanceof UParameter) {
            if (uParent.getUastParent() instanceof UMethod) {
                this.annotateMethodParameter((UParameter)uParent, result);
            }
        } else if (uParent instanceof UFieldEx) {
            this.annotateField((UFieldEx)uParent, result);
        } else {
            UCallExpression uCallExpression;
            PsiElement $this$toUElementOfType$iv = element;
            boolean $i$f$toUElementOfType = false;
            UCallExpression uCallExpression2 = uCallExpression = (UCallExpression)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UCallExpression.class);
            if (Intrinsics.areEqual((Object)(uCallExpression2 != null ? uCallExpression2.getKind() : null), (Object)UastCallKind.METHOD_CALL)) {
                this.annotateMethodCall(uCallExpression, result);
            }
        }
    }

    protected void annotateClass(@NotNull UClass uClass, @NotNull Collection<? super RelatedItemLineMarkerInfo<PsiElement>> result) {
        Intrinsics.checkNotNullParameter((Object)uClass, (String)"uClass");
        Intrinsics.checkNotNullParameter(result, (String)"result");
    }

    protected void annotateMethod(@NotNull UMethod uMethod, @NotNull Collection<? super RelatedItemLineMarkerInfo<PsiElement>> result) {
        Intrinsics.checkNotNullParameter((Object)uMethod, (String)"uMethod");
        Intrinsics.checkNotNullParameter(result, (String)"result");
    }

    protected void annotateMethodParameter(@NotNull UParameter uParameter, @NotNull Collection<? super RelatedItemLineMarkerInfo<PsiElement>> result) {
        Intrinsics.checkNotNullParameter((Object)uParameter, (String)"uParameter");
        Intrinsics.checkNotNullParameter(result, (String)"result");
    }

    protected void annotateField(@NotNull UFieldEx uField, @NotNull Collection<? super RelatedItemLineMarkerInfo<PsiElement>> result) {
        Intrinsics.checkNotNullParameter((Object)uField, (String)"uField");
        Intrinsics.checkNotNullParameter(result, (String)"result");
    }

    protected void annotateMethodCall(@NotNull UCallExpression uMethodCall, @NotNull Collection<? super RelatedItemLineMarkerInfo<PsiElement>> result) {
        Intrinsics.checkNotNullParameter((Object)uMethodCall, (String)"uMethodCall");
        Intrinsics.checkNotNullParameter(result, (String)"result");
    }

    @NotNull
    protected final RelatedItemLineMarkerInfo<PsiElement> marker(@NotNull PsiElement identifier, @NotNull Icon icon, @NlsContexts.Tooltip @NotNull String tooltipText) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)tooltipText, (String)"tooltipText");
        RelatedItemLineMarkerInfo relatedItemLineMarkerInfo = MnLineMarkerBuilder.INSTANCE.create(icon).setAlignment(GutterIconRenderer.Alignment.LEFT).setTooltipText(tooltipText).setTargets((Collection)CollectionsKt.emptyList()).createLineMarkerInfo(identifier);
        Intrinsics.checkNotNullExpressionValue((Object)relatedItemLineMarkerInfo, (String)"MnLineMarkerBuilder.crea\u2026ineMarkerInfo(identifier)");
        return relatedItemLineMarkerInfo;
    }
}

