/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.jam.http;

import com.intellij.jam.JamConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamAnnotationArchetype;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.micronaut.MicronautBundle;
import com.intellij.micronaut.jam.beans.MnSingleton;
import com.intellij.micronaut.jam.http.MnHttpUrlPathSpecification;
import com.intellij.microservices.uast.url.UrlPathReferenceJamConverter;
import com.intellij.microservices.url.FrameworkUrlPathSpecification;
import com.intellij.microservices.url.UrlConstants;
import com.intellij.microservices.url.inlay.PsiElementUrlPathInlayHint;
import com.intellij.microservices.url.inlay.UrlPathInlayHint;
import com.intellij.microservices.url.inlay.UrlPathInlayHintsProviderSemElement;
import com.intellij.microservices.url.references.SchemeReference;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.microservices.url.references.UrlPathReference;
import com.intellij.microservices.utils.UrlMappingBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.semantic.SemKey;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastUtils;

public class MnClient
extends MnSingleton
implements UrlPathInlayHintsProviderSemElement {
    private static final JamStringAttributeMeta.Single<String> VALUE_META = JamAttributeMeta.singleString((String)"value", (JamConverter)new MnClientUrlPathReferenceJamConverter());
    private static final JamStringAttributeMeta.Single<String> ID_META = JamAttributeMeta.singleString((String)"id");
    private static final JamStringAttributeMeta.Single<String> PATH_META = JamAttributeMeta.singleString((String)"path", (JamConverter)new UrlPathReferenceJamConverter((FrameworkUrlPathSpecification)MnHttpUrlPathSpecification.INSTANCE, false));
    private static final JamAnnotationMeta ANNOTATION_META = new JamAnnotationMeta("io.micronaut.http.client.annotation.Client", new JamAnnotationArchetype().addAttribute(VALUE_META).addAttribute(ID_META).addAttribute(PATH_META));
    public static final SemKey<MnClient> CLIENT_JAM_KEY = SINGLETON_JAM_KEY.subKey("MnClient", new SemKey[]{INLAY_HINT_SEM_KEY});
    public static final JamClassMeta<MnClient> META = new JamClassMeta(null, MnClient.class, CLIENT_JAM_KEY).addAnnotation(ANNOTATION_META);
    private final PsiElementRef<PsiAnnotation> myPsiAnnotation;

    public MnClient(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            MnClient.$$$reportNull$$$0(0);
        }
        super(psiClass);
        this.myPsiAnnotation = ANNOTATION_META.getAnnotationRef((PsiModifierListOwner)psiClass);
    }

    public String getValue() {
        return (String)VALUE_META.getJam(this.myPsiAnnotation).getValue();
    }

    public String getId() {
        return (String)ID_META.getJam(this.myPsiAnnotation).getValue();
    }

    public String getPath() {
        return (String)PATH_META.getJam(this.myPsiAnnotation).getValue();
    }

    @Nullable
    public String getResourceValue() {
        String value = this.getValue();
        if (StringUtil.isEmpty((String)value) || ValueType.fromValue(value) == ValueType.SERVICE_ID) {
            value = this.getPath();
        }
        return value;
    }

    @Nullable
    public String getFullResourceValue() {
        String path;
        String value = this.getValue();
        if ((StringUtil.isEmpty((String)value) || ValueType.fromValue(value) == ValueType.SERVICE_ID) && StringUtil.isNotEmpty((String)(path = this.getPath()))) {
            String id = this.getId();
            UrlMappingBuilder builder = StringUtil.isNotEmpty((String)id) ? new UrlMappingBuilder(id) : (StringUtil.isNotEmpty((String)value) ? new UrlMappingBuilder(value) : new UrlMappingBuilder());
            builder.appendSegment(path);
            return builder.build();
        }
        return value;
    }

    @NotNull
    public Project getProject() {
        Project project = this.getPsiElement().getProject();
        if (project == null) {
            MnClient.$$$reportNull$$$0(1);
        }
        return project;
    }

    @Override
    public String getBeanDescription() {
        return MicronautBundle.message("micronaut.http.client.class.tooltip.text", new Object[0]);
    }

    @NotNull
    public List<UrlPathInlayHint> getInlayHints() {
        String value = this.getValue();
        PsiAnnotationMemberValue resultPsiElement = StringUtil.isEmpty((String)value) || ValueType.fromValue(value) == ValueType.SERVICE_ID ? PATH_META.getJam(this.myPsiAnnotation).getPsiElement() : VALUE_META.getJam(this.myPsiAnnotation).getPsiElement();
        UrlPathContext context = MnHttpUrlPathSpecification.INSTANCE.getUrlPathContext((PsiElement)this.getPsiElement());
        if (resultPsiElement != null) {
            List<PsiElementUrlPathInlayHint> list = List.of(new PsiElementUrlPathInlayHint((PsiElement)resultPsiElement, context));
            if (list == null) {
                MnClient.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<UrlPathInlayHint> list = List.of();
        if (list == null) {
            MnClient.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/micronaut/jam/http/MnClient";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/micronaut/jam/http/MnClient";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInlayHints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MnClientUrlPathReferenceJamConverter
    extends JamConverter<String> {
        private MnClientUrlPathReferenceJamConverter() {
        }

        @NotNull
        private static UrlPathReferenceJamConverter getDelegate(boolean injectFullUrl) {
            return new UrlPathReferenceJamConverter((FrameworkUrlPathSpecification)MnHttpUrlPathSpecification.INSTANCE, injectFullUrl);
        }

        @Nullable
        public String fromString(@Nullable String s, JamStringAttributeElement<String> context) {
            return MnClientUrlPathReferenceJamConverter.getDelegate(false).fromString(s, context);
        }

        public PsiReference @NotNull [] createReferences(@NotNull JamStringAttributeElement<String> context, @NotNull PsiLanguageInjectionHost injectionHost, @NotNull PsiElement usagePsi) {
            String value;
            if (context == null) {
                MnClientUrlPathReferenceJamConverter.$$$reportNull$$$0(0);
            }
            if (injectionHost == null) {
                MnClientUrlPathReferenceJamConverter.$$$reportNull$$$0(1);
            }
            if (usagePsi == null) {
                MnClientUrlPathReferenceJamConverter.$$$reportNull$$$0(2);
            }
            if ((value = context.getStringValue()) == null) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    MnClientUrlPathReferenceJamConverter.$$$reportNull$$$0(3);
                }
                return PsiReference.EMPTY_ARRAY;
            }
            if (ValueType.fromValue(value) == ValueType.SERVICE_ID) {
                return MnClientUrlPathReferenceJamConverter.getReferencesForUnknownValue(context, injectionHost, value);
            }
            PsiReference[] psiReferenceArray = MnClientUrlPathReferenceJamConverter.getDelegate(ValueType.fromValue(value) == ValueType.FULL_URL).createReferences(context, injectionHost, usagePsi);
            if (psiReferenceArray == null) {
                MnClientUrlPathReferenceJamConverter.$$$reportNull$$$0(4);
            }
            return psiReferenceArray;
        }

        private static PsiReference @NotNull [] getReferencesForUnknownValue(@NotNull JamStringAttributeElement<String> context, @NotNull PsiLanguageInjectionHost injectionHost, @NotNull String value) {
            PsiElement declaration;
            if (context == null) {
                MnClientUrlPathReferenceJamConverter.$$$reportNull$$$0(5);
            }
            if (injectionHost == null) {
                MnClientUrlPathReferenceJamConverter.$$$reportNull$$$0(6);
            }
            if (value == null) {
                MnClientUrlPathReferenceJamConverter.$$$reportNull$$$0(7);
            }
            if ((declaration = (PsiElement)ObjectUtils.doIfNotNull((Object)((UDeclaration)UastUtils.findContaining((PsiElement)context.getPsiElement(), UDeclaration.class)), UElement::getJavaPsi)) == null) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    MnClientUrlPathReferenceJamConverter.$$$reportNull$$$0(8);
                }
                return PsiReference.EMPTY_ARRAY;
            }
            String originalValue = value.replace("IntellijIdeaRulezzz ", "");
            SmartList result = new SmartList((Object)new SchemeReference("", UrlConstants.HTTP_SCHEMES, injectionHost, new TextRange(1, 1)));
            if (originalValue.isEmpty()) {
                result.add(new UrlPathReference(MnHttpUrlPathSpecification.INSTANCE.getUrlPathContext(declaration), (PsiElement)injectionHost, ElementManipulators.getValueTextRange((PsiElement)injectionHost), true, true));
            }
            PsiReference[] psiReferenceArray = result.toArray(PsiReference.EMPTY_ARRAY);
            if (psiReferenceArray == null) {
                MnClientUrlPathReferenceJamConverter.$$$reportNull$$$0(9);
            }
            return psiReferenceArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "injectionHost";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usagePsi";
                    break;
                }
                case 3: 
                case 4: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/micronaut/jam/http/MnClient$MnClientUrlPathReferenceJamConverter";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/micronaut/jam/http/MnClient$MnClientUrlPathReferenceJamConverter";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createReferences";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferencesForUnknownValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createReferences";
                    break;
                }
                case 3: 
                case 4: 
                case 8: 
                case 9: {
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getReferencesForUnknownValue";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static enum ValueType {
        FULL_URL,
        SERVICE_ID,
        URL_PATH;


        static ValueType fromValue(@NotNull String value) {
            if (value == null) {
                ValueType.$$$reportNull$$$0(0);
            }
            if (value.startsWith("/")) {
                return URL_PATH;
            }
            if (UrlConstants.HTTP_SCHEMES.stream().anyMatch(value::startsWith)) {
                return FULL_URL;
            }
            return SERVICE_ID;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/micronaut/jam/http/MnClient$ValueType", "fromValue"));
        }
    }
}

