/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.jam.cache;

import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.micronaut.MicronautUtils;
import com.intellij.micronaut.jam.cache.MnCacheableLineMarker;
import com.intellij.micronaut.jam.cache.model.MnCacheBaseElement;
import com.intellij.micronaut.jam.cache.model.MnCacheOperations;
import com.intellij.micronaut.jam.cache.model.MnCacheParameterConverter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.semantic.SemService;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UMethod;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J-\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/micronaut/jam/cache/MnCacheAnnotationParametersInspection;", "Lcom/intellij/codeInspection/AbstractBaseUastLocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "checkMethod", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "uMethod", "Lorg/jetbrains/uast/UMethod;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "(Lorg/jetbrains/uast/UMethod;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "checkMethodInternal", "", "checkParameters", "cache", "Lcom/intellij/micronaut/jam/cache/model/MnCacheBaseElement;", "intellij.micronaut"})
public final class MnCacheAnnotationParametersInspection
extends AbstractBaseUastLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)holder.getFile());
        if (module == null || !MicronautUtils.hasMicronautCache(module)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"PsiElementVisitor.EMPTY_VISITOR");
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly, session);
        Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"super.buildVisitor(holder, isOnTheFly, session)");
        return psiElementVisitor;
    }

    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull UMethod uMethod, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)uMethod, (String)"uMethod");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        PsiElement psiElement = uMethod.getSourcePsi();
        if (psiElement == null) {
            return null;
        }
        PsiElement psiElement2 = psiElement;
        ProblemsHolder holder = new ProblemsHolder(manager, psiElement2.getContainingFile(), isOnTheFly);
        this.checkMethodInternal(uMethod, holder);
        return holder.getResultsArray();
    }

    private final void checkMethodInternal(UMethod uMethod, ProblemsHolder holder) {
        SemService semService = SemService.getSemService((Project)holder.getProject());
        PsiElement $this$castSafelyTo$iv = uMethod.getSourcePsi();
        boolean $i$f$castSafelyTo = false;
        PsiElement psiElement = $this$castSafelyTo$iv;
        if (!(psiElement instanceof PsiMethod)) {
            psiElement = null;
        }
        PsiMethod psiMethod = (PsiMethod)psiElement;
        if (psiMethod == null) {
            return;
        }
        PsiMethod psiMethod2 = psiMethod;
        PsiAnnotation[] psiAnnotationArray = psiMethod2.getAnnotations();
        int n = psiAnnotationArray.length;
        for (int i = 0; i < n; ++i) {
            MnCacheOperations cacheOperations;
            String annoName;
            PsiAnnotation psiAnnotation;
            PsiAnnotation psiAnnotation2 = psiAnnotation = psiAnnotationArray[i];
            Intrinsics.checkNotNullExpressionValue((Object)psiAnnotation2, (String)"psiAnnotation");
            if (psiAnnotation2.getQualifiedName() == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)annoName, (String)"psiAnnotation.qualifiedName ?: continue");
            if (MnCacheableLineMarker.Companion.getCACHE_ANNOTATIONS$intellij_micronaut().keySet().contains(annoName)) {
                MnCacheBaseElement cache;
                if ((MnCacheBaseElement)semService.getSemElement(MnCacheBaseElement.CACHE_BASE_JAM_KEY, (PsiElement)psiAnnotation) == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"semService.getSemElement\u2026siAnnotation) ?: continue");
                this.checkParameters(cache, holder);
                continue;
            }
            if (!MnCacheableLineMarker.Companion.getCACHE_OPS_ANNOTATIONS$intellij_micronaut().keySet().contains(annoName)) continue;
            if ((MnCacheOperations)semService.getSemElement(MnCacheOperations.CACHE_OPS_JAM_KEY, (PsiElement)psiMethod2) == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)cacheOperations, (String)"semService.getSemElement\u2026Y, psiMethod) ?: continue");
            Iterator<? extends MnCacheBaseElement> iterator = cacheOperations.getCaches().iterator();
            while (iterator.hasNext()) {
                MnCacheBaseElement cache;
                MnCacheBaseElement mnCacheBaseElement = cache = iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)mnCacheBaseElement, (String)"cache");
                this.checkParameters(mnCacheBaseElement, holder);
            }
        }
    }

    private final void checkParameters(MnCacheBaseElement cache, ProblemsHolder holder) {
        Iterator<JamStringAttributeElement<String>> iterator = cache.getParametersElement().iterator();
        while (iterator.hasNext()) {
            TextRange range;
            PsiReference[] psiReferenceArray;
            PsiReference[] psiReferenceArray2;
            PsiReference[] paramPsiElement;
            block6: {
                JamStringAttributeElement<String> param;
                JamStringAttributeElement<String> jamStringAttributeElement = param = iterator.next();
                Intrinsics.checkNotNullExpressionValue(jamStringAttributeElement, (String)"param");
                if (jamStringAttributeElement.getPsiElement() == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)paramPsiElement, (String)"param.psiElement ?: continue");
                PsiReference[] $this$castSafelyTo$iv = paramPsiElement;
                boolean $i$f$castSafelyTo = false;
                PsiReference[] psiReferenceArray3 = $this$castSafelyTo$iv;
                if (!($this$castSafelyTo$iv instanceof PsiLanguageInjectionHost)) {
                    psiReferenceArray3 = null;
                }
                if ((psiReferenceArray2 = (PsiReference[])psiReferenceArray3) == null || (psiReferenceArray2 = psiReferenceArray2.getReferences()) == null) continue;
                $this$castSafelyTo$iv = psiReferenceArray2;
                $i$f$castSafelyTo = false;
                PsiReference[] psiReferenceArray4 = $this$castSafelyTo$iv;
                boolean bl = false;
                PsiReference[] psiReferenceArray5 = psiReferenceArray4;
                int n = psiReferenceArray5.length;
                for (int i = 0; i < n; ++i) {
                    PsiReference[] psiReferenceArray6;
                    PsiReference[] it = psiReferenceArray6 = psiReferenceArray5[i];
                    boolean bl2 = false;
                    if (!(it instanceof MnCacheParameterConverter.MnCacheParameterReference)) continue;
                    psiReferenceArray = psiReferenceArray6;
                    break block6;
                }
                psiReferenceArray = psiReferenceArray2 = null;
            }
            if (psiReferenceArray == null) {
                continue;
            }
            PsiReference[] paramReference = psiReferenceArray2;
            Intrinsics.checkNotNullExpressionValue((Object)paramReference.getRangeInElement(), (String)"paramReference.rangeInElement");
            if (range.isEmpty() && range.getStartOffset() == 1 && Intrinsics.areEqual((Object)"\"\"", (Object)paramPsiElement.getText())) {
                String message;
                Intrinsics.checkNotNullExpressionValue((Object)ProblemsHolder.unresolvedReferenceMessage((PsiReference)paramReference), (String)"ProblemsHolder.unresolve\u2026ceMessage(paramReference)");
                holder.registerProblem((PsiElement)paramPsiElement, message, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, TextRange.create((int)0, (int)2), new LocalQuickFix[0]);
                continue;
            }
            if (paramReference.resolve() != null) continue;
            holder.registerProblem((PsiReference)paramReference);
        }
    }

    public MnCacheAnnotationParametersInspection() {
        super(new Class[]{UMethod.class});
    }
}

