/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.jam.beans;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.micronaut.jam.beans.JamPsiMethodMicronautBean;
import com.intellij.micronaut.jam.beans.MnBean;
import com.intellij.micronaut.jam.beans.MnBeanDefinition;
import com.intellij.micronaut.jam.beans.MnFactory;
import com.intellij.micronaut.jam.beans.MnInject;
import com.intellij.micronaut.jam.beans.MnInjectionPoint;
import com.intellij.micronaut.jam.beans.MnMethodBean;
import com.intellij.micronaut.jam.beans.MnMethodSingleton;
import com.intellij.micronaut.jam.beans.MnSingleton;
import com.intellij.microservices.cache.ScopedCacheValueHolder;
import com.intellij.microservices.cache.ScopedCacheValueHolders;
import com.intellij.microservices.cache.SourceLibSearchProvider;
import com.intellij.microservices.cache.UastCachedSearchUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MnBeansModel {
    private static final String[] INJECTION_CONTAINER_CLASSES = new String[]{"java.util.Optional", "java.lang.Iterable", "java.util.stream.Stream", "javax.inject.Provider"};
    private static final SourceLibSearchProvider<List<MnInjectionPoint>, Module> INJECTION_CACHE_KEY = new SourceLibSearchProvider("MN_INJECTION", (project, module, scope) -> MnBeansModel.findInjectionPoints(module, scope));
    private static final SourceLibSearchProvider<List<MnBeanDefinition>, Module> BEANS_CACHE_KEY = new SourceLibSearchProvider("MN_BEANS", (project, module, scope) -> MnBeansModel.findBeans(module, scope));

    @NotNull
    public static Collection<MnBeanDefinition> findAutowiredDependencies(MnInjectionPoint injectionPoint) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)injectionPoint.getOwner());
        if (module == null) {
            List<MnBeanDefinition> list = Collections.emptyList();
            if (list == null) {
                MnBeansModel.$$$reportNull$$$0(0);
            }
            return list;
        }
        PsiType type = MnBeansModel.getInjectedInstanceType(injectionPoint.getType(), module);
        if (type == null) {
            List<MnBeanDefinition> list = Collections.emptyList();
            if (list == null) {
                MnBeansModel.$$$reportNull$$$0(1);
            }
            return list;
        }
        Collection collection = MnBeansModel.getAllBeans(module).filter(b -> {
            PsiType beanType = b.getBeanType();
            return beanType != null && type.isAssignableFrom(beanType);
        }).collect(Collectors.toList());
        if (collection == null) {
            MnBeansModel.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    public static Collection<MnInjectionPoint> findAutowiredCandidates(MnBeanDefinition beanDefinition) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)beanDefinition.getDefiningPsiElement());
        if (module == null) {
            List<MnInjectionPoint> list = Collections.emptyList();
            if (list == null) {
                MnBeansModel.$$$reportNull$$$0(3);
            }
            return list;
        }
        PsiType beanType = beanDefinition.getBeanType();
        if (beanType == null) {
            List<MnInjectionPoint> list = Collections.emptyList();
            if (list == null) {
                MnBeansModel.$$$reportNull$$$0(4);
            }
            return list;
        }
        Collection collection = MnBeansModel.getAllInjectionPoints(module).filter(p -> {
            PsiType injectionType = MnBeansModel.getInjectedInstanceType(p.getType(), module);
            return injectionType != null && injectionType.isAssignableFrom(beanType);
        }).collect(Collectors.toList());
        if (collection == null) {
            MnBeansModel.$$$reportNull$$$0(5);
        }
        return collection;
    }

    private static Stream<MnBeanDefinition> getAllBeans(Module module) {
        return UastCachedSearchUtils.computeWithCache((ScopedCacheValueHolder)ScopedCacheValueHolders.asCacheValueHolder((Module)module), BEANS_CACHE_KEY).stream().filter(MnBeanDefinition::isValid);
    }

    private static List<MnBeanDefinition> findBeans(Module m, GlobalSearchScope scope) {
        JamService jamService = JamService.getJamService((Project)m.getProject());
        HashSet<MnBeanDefinition> definitions = new HashSet<MnBeanDefinition>(MnBeansModel.findAnnotatedBeans(m, scope));
        List factories = jamService.getJamClassElements(MnFactory.META, "io.micronaut.context.annotation.Factory", scope);
        for (MnFactory factory2 : factories) {
            List methodBeans = jamService.getAnnotatedMembersList(factory2.getPsiElement(), 10, new JamMemberMeta[]{MnMethodBean.META, MnMethodSingleton.META});
            definitions.addAll(methodBeans);
        }
        return new ArrayList<MnBeanDefinition>(definitions);
    }

    private static Collection<MnBeanDefinition> findAnnotatedBeans(Module module, GlobalSearchScope scope) {
        JamService jamService = JamService.getJamService((Project)module.getProject());
        Collection singletonAnnotations = (Collection)MnSingleton.getSingletonAnnotations().fun((Object)module);
        Stream singletons = singletonAnnotations.stream().flatMap(annotation -> jamService.getJamClassElements(MnSingleton.SINGLETON_JAM_KEY, annotation, scope).stream());
        Collection<String> beanAnnotations = MnBean.getBeanAnnotations(module);
        Stream beans = beanAnnotations.stream().flatMap(annotation -> jamService.getJamClassElements(MnBean.BEAN_JAM_KEY, annotation, scope).stream());
        return Stream.concat(singletons, beans).collect(Collectors.toSet());
    }

    @NotNull
    private static Stream<MnInjectionPoint> getAllInjectionPoints(Module module) {
        Stream<MnInjectionPoint> stream = UastCachedSearchUtils.computeWithCache((ScopedCacheValueHolder)ScopedCacheValueHolders.asCacheValueHolder((Module)module), INJECTION_CACHE_KEY).stream().filter(MnInjectionPoint::isValid);
        if (stream == null) {
            MnBeansModel.$$$reportNull$$$0(6);
        }
        return stream;
    }

    private static List<MnInjectionPoint> findInjectionPoints(Module module, GlobalSearchScope scope) {
        LinkedHashSet injects = new LinkedHashSet();
        MnBeansModel.findInjects(module.getProject(), scope).forEach(inject -> {
            PsiModifierListOwner element = inject.getPsiElement();
            if (element instanceof PsiField) {
                injects.add(new MnInjectionPoint(element));
            } else if (element instanceof PsiMethod) {
                PsiParameter[] parameters;
                PsiMethod psiMethod = (PsiMethod)element;
                for (PsiParameter parameter : parameters = psiMethod.getParameterList().getParameters()) {
                    injects.add(new MnInjectionPoint((PsiModifierListOwner)parameter));
                }
            }
        });
        MnBeansModel.findInjectedFactoryMethods(module.getProject(), scope).forEach(factoryMethod -> {
            PsiParameter[] parameters;
            PsiMethod psiMethod = (PsiMethod)factoryMethod.getPsiElement();
            for (PsiParameter parameter : parameters = psiMethod.getParameterList().getParameters()) {
                if (AnnotationUtil.isAnnotated((PsiModifierListOwner)parameter, (String)"io.micronaut.context.annotation.Value", (int)0)) continue;
                injects.add(new MnInjectionPoint((PsiModifierListOwner)parameter));
            }
        });
        MnBeansModel.findInjectedConstructors(module, scope).forEach(constructor -> {
            PsiParameter[] parameters;
            for (PsiParameter parameter : parameters = constructor.getParameterList().getParameters()) {
                if (AnnotationUtil.isAnnotated((PsiModifierListOwner)parameter, (String)"io.micronaut.context.annotation.Value", (int)0)) continue;
                injects.add(new MnInjectionPoint((PsiModifierListOwner)parameter));
            }
        });
        return new ArrayList<MnInjectionPoint>(injects);
    }

    private static Stream<MnInject> findInjects(Project project, GlobalSearchScope scope) {
        JamService jamService = JamService.getJamService((Project)project);
        Stream fields = jamService.getJamFieldElements(MnInject.FIELD_META, "javax.inject.Inject", scope).stream();
        Stream methods = jamService.getJamMethodElements(MnInject.METHOD_META, "javax.inject.Inject", scope).stream();
        return Stream.concat(fields, methods);
    }

    private static Stream<JamPsiMethodMicronautBean> findInjectedFactoryMethods(Project project, GlobalSearchScope scope) {
        JamService jamService = JamService.getJamService((Project)project);
        List factories = jamService.getJamClassElements(MnFactory.META, "io.micronaut.context.annotation.Factory", scope);
        return factories.stream().flatMap(factory2 -> {
            List methodBeans = jamService.getAnnotatedMembersList(factory2.getPsiElement(), 10, new JamMemberMeta[]{MnMethodBean.META, MnMethodSingleton.META});
            return methodBeans.stream().filter(m -> ((PsiMethod)m.getPsiElement()).getParameterList().getParametersCount() > 0);
        });
    }

    private static Stream<PsiMethod> findInjectedConstructors(Module module, GlobalSearchScope scope) {
        Collection<MnBeanDefinition> beans = MnBeansModel.findAnnotatedBeans(module, scope);
        return beans.stream().map(b -> b.getBeanType()).filter(t -> t instanceof PsiClassType).map(ct -> ((PsiClassType)ct).resolve()).filter(c -> c != null).distinct().flatMap(b -> {
            PsiMethod[] constructors;
            for (PsiMethod c2 : constructors = b.getConstructors()) {
                if (c2.getParameterList().getParametersCount() <= 0 || !AnnotationUtil.isAnnotated((PsiModifierListOwner)c2, (String)"javax.inject.Inject", (int)0)) continue;
                return Stream.of(c2);
            }
            return Arrays.stream(constructors).filter(c -> c.getParameterList().getParametersCount() > 0 && c.hasModifierProperty("public"));
        });
    }

    @Nullable
    private static PsiType getInjectedInstanceType(@Nullable PsiType injectionPointType, Module module) {
        PsiType[] parameters;
        if (injectionPointType == null) {
            return null;
        }
        if (injectionPointType instanceof PsiArrayType) {
            return ((PsiArrayType)injectionPointType).getComponentType();
        }
        if (injectionPointType instanceof PsiClassType && (parameters = ((PsiClassType)injectionPointType).getParameters()).length == 1) {
            for (PsiType containerType : MnBeansModel.getInjectedContainerClasses(module)) {
                if (!containerType.isValid() || !containerType.isAssignableFrom(injectionPointType)) continue;
                return parameters[0];
            }
        }
        return injectionPointType;
    }

    private static Collection<PsiType> getInjectedContainerClasses(Module module) {
        CachedValuesManager cacheManager = CachedValuesManager.getManager((Project)module.getProject());
        return (Collection)cacheManager.getCachedValue((UserDataHolder)module, () -> {
            ArrayList<PsiClassType> psiClasses = new ArrayList<PsiClassType>(INJECTION_CONTAINER_CLASSES.length);
            GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)module.getProject());
            for (String containerClassName : INJECTION_CONTAINER_CLASSES) {
                PsiClass containerClass = javaPsiFacade.findClass(containerClassName, scope);
                if (containerClass == null) continue;
                psiClasses.add(javaPsiFacade.getElementFactory().createType(containerClass));
            }
            return CachedValueProvider.Result.create(psiClasses, (Object[])new Object[]{ProjectRootManager.getInstance((Project)module.getProject())});
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/micronaut/jam/beans/MnBeansModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findAutowiredDependencies";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findAutowiredCandidates";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllInjectionPoints";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

