/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.events;

import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.lang.jvm.JvmClassKind;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmParameter;
import com.intellij.micronaut.events.EventSubscription;
import com.intellij.micronaut.events.PublishEventPoint;
import com.intellij.micronaut.jam.beans.MnEventListener;
import com.intellij.micronaut.jam.beans.MnTransactionalEventListener;
import com.intellij.micronaut.provider.beans.MicronautBeanUtilsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.semantic.SemService;
import com.intellij.uast.UastModificationTracker;
import com.intellij.util.Query;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u001a\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a#\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u0013\u001a\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u001a\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u00a8\u0006\u001e"}, d2={"fillPublishPoints", "", "publishMethod", "Lcom/intellij/psi/PsiMethod;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "collector", "", "Lcom/intellij/micronaut/events/PublishEventPoint;", "getEventListeners", "", "Lcom/intellij/micronaut/events/EventSubscription;", "module", "Lcom/intellij/openapi/module/Module;", "eventType", "Lcom/intellij/psi/PsiType;", "getEventPublishPoints", "getPublishMethods", "", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/psi/search/GlobalSearchScope;)[Lcom/intellij/psi/PsiMethod;", "hasSuperClassEventListener", "", "psiClass", "Lcom/intellij/psi/PsiClass;", "isEventClass", "isEventListenerMethod", "psiMethod", "isPublishEventExpression", "uMethodCall", "Lorg/jetbrains/uast/UCallExpression;", "intellij.micronaut"})
public final class MnEventUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<PublishEventPoint> getEventPublishPoints(@NotNull Module module, @NotNull PsiType eventType) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)eventType, (String)"eventType");
        Iterable $this$filter$iv = MnEventUtilsKt.getEventPublishPoints(module);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PublishEventPoint p = (PublishEventPoint)element$iv$iv;
            boolean bl = false;
            PsiType pointType = p.getEventType();
            if (!(pointType != null && eventType.isAssignableFrom(pointType))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<EventSubscription> getEventListeners(@NotNull Module module, @NotNull PsiType eventType) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)eventType, (String)"eventType");
        Iterable $this$filter$iv = MnEventUtilsKt.getEventListeners(module);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            EventSubscription l = (EventSubscription)element$iv$iv;
            boolean bl = false;
            PsiType handlerType = l.getEventType();
            if (!(handlerType != null && eventType.isAssignableFrom(handlerType))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final boolean isPublishEventExpression(@NotNull UCallExpression uMethodCall) {
        PsiMethod psiMethod;
        Intrinsics.checkNotNullParameter((Object)uMethodCall, (String)"uMethodCall");
        if (Intrinsics.areEqual((Object)uMethodCall.getMethodName(), (Object)"publishEvent") && (psiMethod = uMethodCall.resolve()) != null) {
            PsiClass targetClass = psiMethod.getContainingClass();
            return targetClass != null && InheritanceUtil.isInheritor((PsiClass)targetClass, (String)"io.micronaut.context.event.ApplicationEventPublisher");
        }
        return false;
    }

    public static final boolean isEventListenerMethod(@NotNull PsiMethod psiMethod) {
        Intrinsics.checkNotNullParameter((Object)psiMethod, (String)"psiMethod");
        PsiParameterList psiParameterList = psiMethod.getParameterList();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterList, (String)"psiMethod.parameterList");
        if (psiParameterList.getParametersCount() == 1) {
            PsiParameterList psiParameterList2 = psiMethod.getParameterList();
            Intrinsics.checkNotNullExpressionValue((Object)psiParameterList2, (String)"psiMethod.parameterList");
            PsiParameter psiParameter = psiParameterList2.getParameters()[0];
            Intrinsics.checkNotNullExpressionValue((Object)psiParameter, (String)"psiMethod.parameterList.parameters[0]");
            if (psiParameter.getType() instanceof PsiClassType) {
                PsiClass containingClass;
                MnEventListener mnListener = (MnEventListener)SemService.getSemService((Project)psiMethod.getProject()).getSemElement(MnEventListener.LISTENER_JAM_KEY, (PsiElement)psiMethod);
                if (mnListener != null && !psiMethod.hasModifier(JvmModifier.PRIVATE)) {
                    return true;
                }
                if (Intrinsics.areEqual((Object)psiMethod.getName(), (Object)"onApplicationEvent") && (containingClass = psiMethod.getContainingClass()) != null && MnEventUtilsKt.hasSuperClassEventListener(containingClass)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static final boolean isEventClass(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        return psiClass.getClassKind() == JvmClassKind.CLASS && !psiClass.hasModifier(JvmModifier.ABSTRACT) && InheritanceUtil.isInheritor((PsiClass)psiClass, (boolean)true, (String)"io.micronaut.context.event.ApplicationEvent");
    }

    private static final boolean hasSuperClassEventListener(PsiClass psiClass) {
        return psiClass.getQualifiedName() != null && InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"io.micronaut.context.event.ApplicationEventListener");
    }

    private static final Collection<PublishEventPoint> getEventPublishPoints(Module module) {
        CachedValuesManager cacheManager = CachedValuesManager.getManager((Project)module.getProject());
        Object object = cacheManager.getCachedValue((UserDataHolder)module, new CachedValueProvider(module){
            final /* synthetic */ Module $module;

            @Nullable
            public final CachedValueProvider.Result<SmartList<PublishEventPoint>> compute() {
                PsiMethod[] publishMethods;
                GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.$module);
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"moduleWithDependenciesAndLibrariesScope(module)");
                GlobalSearchScope scope = globalSearchScope;
                SmartList points = new SmartList();
                for (PsiMethod publishMethod : publishMethods = MnEventUtilsKt.access$getPublishMethods(this.$module, scope)) {
                    MnEventUtilsKt.access$fillPublishPoints(publishMethod, scope, (List)points);
                }
                Object[] objectArray = new Object[1];
                Project project = this.$module.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
                objectArray[0] = UastModificationTracker.Companion.getInstance(project);
                return CachedValueProvider.Result.create((Object)points, (Object[])objectArray);
            }
            {
                this.$module = module;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cacheManager.getCachedVa\u2026ance(module.project))\n  }");
        return (Collection)object;
    }

    private static final PsiMethod[] getPublishMethods(Module module, GlobalSearchScope scope) {
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)module.getProject());
        PsiClass psiClass = javaPsiFacade.findClass("io.micronaut.context.event.ApplicationEventPublisher", scope);
        if (psiClass == null) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiMethod.EMPTY_ARRAY, (String)"PsiMethod.EMPTY_ARRAY");
            return PsiMethod.EMPTY_ARRAY;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"javaPsiFacade.findClass(\u2026urn PsiMethod.EMPTY_ARRAY");
        PsiClass publisherClass = psiClass;
        PsiMethod[] psiMethodArray = publisherClass.findMethodsByName("publishEvent", false);
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"publisherClass.findMetho\u2026LISH_EVENT_METHOD, false)");
        return psiMethodArray;
    }

    private static final void fillPublishPoints(PsiMethod publishMethod, GlobalSearchScope scope, List<PublishEventPoint> collector) {
        Query entries = MethodReferencesSearch.search((PsiMethod)publishMethod, (SearchScope)((SearchScope)scope), (boolean)true);
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            PsiReference reference;
            PsiReference psiReference = reference = (PsiReference)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)psiReference, (String)"reference");
            PsiElement $this$getUastParentOfType$iv = psiReference.getElement();
            boolean strict$iv = false;
            boolean $i$f$getUastParentOfType = false;
            UCallExpression expression = (UCallExpression)UastContextKt.getUastParentOfType((PsiElement)$this$getUastParentOfType$iv, UCallExpression.class, (boolean)strict$iv);
            if (expression == null || expression.getValueArgumentCount() != 1) continue;
            UExpression arg = (UExpression)expression.getValueArguments().get(0);
            collector.add(new PublishEventPoint(arg));
        }
    }

    private static final Collection<EventSubscription> getEventListeners(Module module) {
        Object object = CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, new CachedValueProvider(module){
            final /* synthetic */ Module $module;

            @Nullable
            public final CachedValueProvider.Result<ArrayList<EventSubscription>> compute() {
                GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.$module);
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"moduleWithDependenciesAndLibrariesScope(module)");
                GlobalSearchScope scope = globalSearchScope;
                JamService jamService = JamService.getJamService((Project)this.$module.getProject());
                List list = ContainerUtil.concat((List)jamService.getJamMethodElements((JamMemberMeta)MnEventListener.META, "io.micronaut.runtime.event.annotation.EventListener", scope), (List)jamService.getJamMethodElements((JamMemberMeta)MnTransactionalEventListener.META, "io.micronaut.transaction.annotation.TransactionalEventListener", scope));
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ContainerUtil.concat(\n  \u2026_LISTENER, scope)\n      )");
                List listenerElements = list;
                ArrayList<EventSubscription> listeners = new ArrayList<EventSubscription>(listenerElements.size());
                Iterator<E> iterator = listenerElements.iterator();
                while (iterator.hasNext()) {
                    MnEventListener element;
                    MnEventListener mnEventListener = element = (MnEventListener)iterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)mnEventListener, (String)"element");
                    PsiMethod psiMethod = mnEventListener.getPsiElement();
                    Intrinsics.checkNotNullExpressionValue((Object)psiMethod, (String)"element.psiElement");
                    listeners.add(new EventSubscription(psiMethod));
                }
                JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)this.$module.getProject());
                PsiClass listenerInterface = javaPsiFacade.findClass("io.micronaut.context.event.ApplicationEventListener", scope);
                if (listenerInterface != null) {
                    Query query = ClassInheritorsSearch.search((PsiClass)listenerInterface, (SearchScope)((SearchScope)scope), (boolean)true, (boolean)true, (boolean)false);
                    Intrinsics.checkNotNullExpressionValue((Object)query, (String)"ClassInheritorsSearch.se\u2026scope, true, true, false)");
                    Query entries = query;
                    for (PsiClass entry : entries) {
                        PsiMethod[] onEventMethods;
                        if (!MicronautBeanUtilsKt.isBeanMappedClass(entry)) continue;
                        PsiMethod[] psiMethodArray = onEventMethods = entry.findMethodsByName("onApplicationEvent", false);
                        int n = psiMethodArray.length;
                        for (int i = 0; i < n; ++i) {
                            PsiMethod method;
                            PsiMethod psiMethod = method = psiMethodArray[i];
                            Intrinsics.checkNotNullExpressionValue((Object)psiMethod, (String)"method");
                            PsiParameterList psiParameterList = psiMethod.getParameterList();
                            Intrinsics.checkNotNullExpressionValue((Object)psiParameterList, (String)"method.parameterList");
                            if (psiParameterList.getParametersCount() != 1) continue;
                            JvmParameter jvmParameter = method.getParameters()[0];
                            Intrinsics.checkNotNullExpressionValue((Object)jvmParameter, (String)"method.parameters[0]");
                            if (!(jvmParameter.getType() instanceof PsiClassType)) continue;
                            listeners.add(new EventSubscription(method));
                        }
                    }
                }
                Object[] objectArray = new Object[2];
                Project project = this.$module.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
                objectArray[0] = UastModificationTracker.Companion.getInstance(project);
                objectArray[1] = ProjectRootManager.getInstance((Project)this.$module.getProject());
                return CachedValueProvider.Result.create(listeners, (Object[])objectArray);
            }
            {
                this.$module = module;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"CachedValuesManager.getM\u2026ance(module.project))\n  }");
        return (Collection)object;
    }

    public static final /* synthetic */ PsiMethod[] access$getPublishMethods(Module module, GlobalSearchScope scope) {
        return MnEventUtilsKt.getPublishMethods(module, scope);
    }

    public static final /* synthetic */ void access$fillPublishPoints(PsiMethod publishMethod, GlobalSearchScope scope, List collector) {
        MnEventUtilsKt.fillPublishPoints(publishMethod, scope, collector);
    }
}

