/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.data.ql;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.model.common.persistence.JpaAnnotationConstants;
import com.intellij.jpa.DefaultQlModel;
import com.intellij.jpa.ql.QlFile;
import com.intellij.jpa.ql.model.QlModel;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.micronaut.data.MicronautDataUtil;
import com.intellij.micronaut.data.ql.MicronautDataDomainModel;
import com.intellij.micronaut.data.ql.language.MicronautDataQLLanguage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.sql.psi.SqlLanguage;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kotlin.Pair;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotationUtils;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.expressions.UStringConcatenationsFacade;

final class MicronautDataQLInjector
implements MultiHostInjector {
    public static final Set<String> QUERY_ANNOTATIONS = Set.of("io.micronaut.data.annotation.Query");

    MicronautDataQLInjector() {
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<PsiElement>> list = Collections.singletonList(PsiElement.class);
        if (list == null) {
            MicronautDataQLInjector.$$$reportNull$$$0(0);
        }
        return list;
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        UStringConcatenationsFacade concatenationsFacade;
        if (registrar == null) {
            MicronautDataQLInjector.$$$reportNull$$$0(1);
        }
        if (context == null) {
            MicronautDataQLInjector.$$$reportNull$$$0(2);
        }
        if ((concatenationsFacade = UStringConcatenationsFacade.create((PsiElement)context)) == null) {
            return;
        }
        if (!concatenationsFacade.getUastOperands().iterator().hasNext()) {
            return;
        }
        Project project = context.getProject();
        if (!MicronautDataUtil.hasMicronautDataSupport(project)) {
            return;
        }
        Sequence hosts = concatenationsFacade.getPsiLanguageInjectionHosts();
        PsiLanguageInjectionHost theFirstHost = (PsiLanguageInjectionHost)SequencesKt.firstOrNull((Sequence)hosts);
        if (theFirstHost != null && this.isQueryAnnotationHost((PsiElement)theFirstHost)) {
            Language languageToInject = MicronautDataQLInjector.getLanguageToInject(theFirstHost);
            registrar.startInjecting(languageToInject);
            for (PsiLanguageInjectionHost host : SequencesKt.asIterable((Sequence)hosts)) {
                registrar.addPlace(null, null, host, ElementManipulators.getValueTextRange((PsiElement)host));
            }
            registrar.doneInjecting();
            theFirstHost.putUserData(QlFile.PERSISTENCE_MODEL_KEY, (Object)MicronautDataQLInjector.getQlModel((PsiElement)theFirstHost));
        }
    }

    public boolean isQueryAnnotationHost(@NotNull PsiElement host) {
        String annotationParamName;
        Pair annotationEntry;
        if (host == null) {
            MicronautDataQLInjector.$$$reportNull$$$0(3);
        }
        if (host instanceof PsiLanguageInjectionHost && (annotationEntry = UAnnotationUtils.getContainingAnnotationEntry((UElement)UastContextKt.toUElement((PsiElement)host))) != null && ((annotationParamName = (String)annotationEntry.getSecond()) == null || "value".equals(annotationParamName) || "countQuery".equals(annotationParamName))) {
            PsiAnnotation annotation = (PsiAnnotation)annotationEntry.getFirst();
            return !annotation.getProject().isDefault() && MicronautDataQLInjector.isQueryAnnotation(annotation);
        }
        return false;
    }

    private static boolean isQueryAnnotation(@NotNull PsiAnnotation psiAnnotation) {
        String name;
        if (psiAnnotation == null) {
            MicronautDataQLInjector.$$$reportNull$$$0(4);
        }
        return (name = psiAnnotation.getQualifiedName()) != null && QUERY_ANNOTATIONS.contains(name);
    }

    private static Language getLanguageToInject(PsiLanguageInjectionHost host) {
        return MicronautDataQLInjector.isNativeQuery(host) ? SqlLanguage.INSTANCE : MicronautDataQLLanguage.INSTANCE;
    }

    private static boolean isNativeQuery(PsiLanguageInjectionHost host) {
        UElement uHost = UastContextKt.toUElement((PsiElement)host);
        Pair annotationEntry = UAnnotationUtils.getContainingAnnotationEntry((UElement)uHost);
        if (annotationEntry == null) {
            return false;
        }
        UClass declaredInClass = (UClass)UastUtils.findContaining((PsiElement)host, UClass.class);
        if (declaredInClass != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)declaredInClass.getJavaPsi(), (String)"io.micronaut.data.jdbc.annotation.JdbcRepository", (int)0)) {
            return true;
        }
        PsiAnnotation annotation = (PsiAnnotation)annotationEntry.getFirst();
        if (annotation.getProject().isDefault()) {
            return false;
        }
        PsiAnnotationMemberValue nativeQueryMemberValue = annotation.findAttributeValue("nativeQuery");
        if (nativeQueryMemberValue == null) {
            return false;
        }
        Boolean value = (Boolean)JamCommonUtil.getObjectValue((PsiElement)nativeQueryMemberValue, Boolean.class);
        return value != null && value != false;
    }

    @NotNull
    private static QlModel getQlModel(PsiElement host) {
        PsiClass domainClass;
        PsiElement originalElement = host.getOriginalElement();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)originalElement);
        MicronautDataDomainModel model = new MicronautDataDomainModel(originalElement);
        if (module != null && JpaUtil.getJpaFacet((Module)module) != null && (domainClass = model.getDomainClass(originalElement)) != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)domainClass, (String)JpaAnnotationConstants.ENTITY_ANNO.fqn(module), (int)1)) {
            return new DefaultQlModel(false, module);
        }
        MicronautDataDomainModel micronautDataDomainModel = model;
        if (micronautDataDomainModel == null) {
            MicronautDataQLInjector.$$$reportNull$$$0(5);
        }
        return micronautDataDomainModel;
    }

    static {
        MicronautDataQLLanguage.INSTANCE.getDisplayName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/micronaut/data/ql/MicronautDataQLInjector";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/micronaut/data/ql/MicronautDataQLInjector";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getQlModel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInject";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isQueryAnnotationHost";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isQueryAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

