/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.data.parser;

import com.intellij.jpa.frameworks.data.util.parser.PartTree;
import com.intellij.jpa.frameworks.data.util.parser.PartTreeParserContext;
import com.intellij.jpa.frameworks.data.util.parser.PartTypes;
import com.intellij.micronaut.data.parser.MicronautPartTypes;
import com.intellij.micronaut.data.parser.MicronautProjection;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MicronautPartTreeParserContext
implements PartTreeParserContext {
    private static final MicronautPartTypes TYPES = new MicronautPartTypes();
    private static final String KEYWORD_TEMPLATE = "(%s)(?=(\\p{Lu}|\\P{InBASIC_LATIN}))";
    private static final String QUERY_PATTERN = "find|search|query|get|read|retrieve";
    private static final String COUNT_PATTERN = "count";
    private static final String EXISTS_PATTERN = "exists";
    private static final String UPDATE_DELETE_PATTERN = "delete|remove|update";
    public static final List<String> COUNT_PROJECTION_PREDICATES = List.of("Max", "Min", "Avg", "Sum");
    public static final List<String> PROJECTION_PREDICATES = List.of("Distinct", "Max", "Min", "Avg", "Sum");
    private final Pattern PREFIX_TEMPLATE = Pattern.compile("^(find|search|query|get|read|retrieve|count|exists|delete|remove|update)((\\p{Lu}.*?))??By");

    public static MicronautPartTreeParserContext create() {
        return new MicronautPartTreeParserContext();
    }

    public PartTypes types() {
        return TYPES;
    }

    public String keywordTemplate() {
        return KEYWORD_TEMPLATE;
    }

    public String queryPattern() {
        return QUERY_PATTERN;
    }

    public String countPattern() {
        return COUNT_PATTERN;
    }

    public String existsPattern() {
        return EXISTS_PATTERN;
    }

    public String deleteUpdatePattern() {
        return UPDATE_DELETE_PATTERN;
    }

    public Pattern prefixTemplate() {
        return this.PREFIX_TEMPLATE;
    }

    @Nullable
    public static MicronautProjection extractProjection(PartTree.Subject subject) {
        String subjectExpression = subject.getExpression();
        for (String prefix : MicronautPartTreeParserContext.getQueryMethodPrefixes()) {
            String projectionExpression;
            if (!subjectExpression.startsWith(prefix) || !subjectExpression.endsWith("By") || !StringUtil.isNotEmpty((String)(projectionExpression = subjectExpression.substring(prefix.length(), subjectExpression.length() - 2)))) continue;
            return new MicronautProjection(projectionExpression);
        }
        return null;
    }

    @NotNull
    public static List<String> getQueryMethodPrefixes() {
        List<String> list = Arrays.asList(QUERY_PATTERN.split("\\|"));
        if (list == null) {
            MicronautPartTreeParserContext.$$$reportNull$$$0(0);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/micronaut/data/parser/MicronautPartTreeParserContext", "getQueryMethodPrefixes"));
    }
}

