/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.data.inspections;

import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.micronaut.data.MicronautDataUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UMethod;

public abstract class MicronautDataRepositoriesInspection
extends AbstractBaseUastLocalInspectionTool {
    protected MicronautDataRepositoriesInspection() {
        super(new Class[]{UClass.class});
    }

    @NotNull
    public final PsiElementVisitor buildVisitor(ProblemsHolder holder, boolean isOnTheFly) {
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)holder.getFile());
        if (module == null || !MicronautDataUtil.hasMicronautDataSupport(module)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                MicronautDataRepositoriesInspection.$$$reportNull$$$0(0);
            }
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly);
        if (psiElementVisitor == null) {
            MicronautDataRepositoriesInspection.$$$reportNull$$$0(1);
        }
        return psiElementVisitor;
    }

    public ProblemDescriptor @Nullable [] checkClass(@NotNull UClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiElement sourcePsi;
        if (aClass == null) {
            MicronautDataRepositoriesInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            MicronautDataRepositoriesInspection.$$$reportNull$$$0(3);
        }
        if ((sourcePsi = aClass.getSourcePsi()) == null) {
            return null;
        }
        if (!MicronautDataUtil.isRepository(aClass.getJavaPsi())) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)sourcePsi);
        if (module == null) {
            return null;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, sourcePsi.getContainingFile(), isOnTheFly);
        Pair<PsiClass, ? extends PsiType> typePair = MicronautDataUtil.substituteRepositoryTypes(aClass.getJavaPsi());
        if (typePair != null) {
            for (UMethod psiMethod : aClass.getMethods()) {
                if (!MicronautDataUtil.isQueryMethod(psiMethod.getJavaPsi())) continue;
                this.checkRepositoryMethod(holder, aClass, psiMethod, module, typePair);
            }
        }
        return holder.getResultsArray();
    }

    protected void checkRepositoryMethod(@NotNull ProblemsHolder holder, UClass repositoryClass, @NotNull UMethod psiMethod, @NotNull Module module, @NotNull Pair<PsiClass, ? extends PsiType> typePair) {
        if (holder == null) {
            MicronautDataRepositoriesInspection.$$$reportNull$$$0(4);
        }
        if (psiMethod == null) {
            MicronautDataRepositoriesInspection.$$$reportNull$$$0(5);
        }
        if (module == null) {
            MicronautDataRepositoriesInspection.$$$reportNull$$$0(6);
        }
        if (typePair == null) {
            MicronautDataRepositoriesInspection.$$$reportNull$$$0(7);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/micronaut/data/inspections/MicronautDataRepositoriesInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typePair";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/micronaut/data/inspections/MicronautDataRepositoriesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkRepositoryMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

