/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.data.completion;

import com.intellij.jpa.frameworks.data.util.completion.PartTreeCompletionContributor;
import com.intellij.jpa.frameworks.data.util.parser.PartTreeParserContext;
import com.intellij.micronaut.MicronautIcons;
import com.intellij.micronaut.data.MicronautDataUtil;
import com.intellij.micronaut.data.parser.MicronautPartTreeParserContext;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtilBase;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

final class MicronautDataCompletionContributor
extends PartTreeCompletionContributor {
    private final MicronautPartTreeParserContext myParserContext = MicronautPartTreeParserContext.create();
    private final String[] QUERY_PREDICATES = new String[]{"count", "exists", "delete", "remove", "update"};

    protected boolean isDataRepository(@NotNull PsiClass aClass) {
        if (aClass == null) {
            MicronautDataCompletionContributor.$$$reportNull$$$0(0);
        }
        return MicronautDataUtil.isRepository(aClass);
    }

    protected boolean hasDataSupported(@NotNull PsiElement element) {
        if (element == null) {
            MicronautDataCompletionContributor.$$$reportNull$$$0(1);
        }
        return MicronautDataUtil.hasMicronautDataSupport(element.getProject());
    }

    protected Set<String> getDomainClassProperties(PsiClass domainClass) {
        return MicronautDataUtil.getProperties(domainClass);
    }

    protected Pair<PsiClass, ? extends PsiType> substituteRepositoryTypes(PsiClass psi) {
        return MicronautDataUtil.substituteRepositoryTypes(psi);
    }

    protected Icon getLookupElementIcon() {
        return MicronautIcons.MicronautLogo;
    }

    protected PartTreeParserContext getPartTreeParserContext() {
        return MicronautPartTreeParserContext.create();
    }

    protected String[] getSelectQueryPredicates() {
        return this.myParserContext.queryPattern().split("\\|");
    }

    protected String[] getQueryPredicates() {
        return this.QUERY_PREDICATES;
    }

    protected void addSubjectSimpleTails(Set<String> strings, String base, @NotNull PsiClass domainClass) {
        if (domainClass == null) {
            MicronautDataCompletionContributor.$$$reportNull$$$0(2);
        }
        strings.add(base);
        MicronautDataCompletionContributor.addProjections(strings, base, domainClass);
    }

    private static void addProjections(Set<String> strings, String base, @NotNull PsiClass domainClass) {
        if (domainClass == null) {
            MicronautDataCompletionContributor.$$$reportNull$$$0(3);
        }
        Set properties = PropertyUtilBase.getAllProperties((PsiClass)domainClass, (boolean)false, (boolean)true).keySet();
        for (String property : properties) {
            strings.add(base + StringUtil.capitalize((String)property));
            if (!MicronautPartTreeParserContext.getQueryMethodPrefixes().contains(base)) continue;
            for (String predicate : MicronautPartTreeParserContext.PROJECTION_PREDICATES) {
                strings.add(base + predicate + StringUtil.capitalize((String)property));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domainClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/micronaut/data/completion/MicronautDataCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isDataRepository";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "hasDataSupported";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addSubjectSimpleTails";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addProjections";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

