/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config.yaml;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.micronaut.config.MnConfigFileContributor;
import com.intellij.micronaut.config.MnConfigValueSearcher;
import com.intellij.micronaut.config.MnMetaConfigKeyManager;
import com.intellij.microservices.config.MetaConfigKeyManager;
import com.intellij.microservices.config.yaml.ConfigYamlAccessor;
import com.intellij.microservices.config.yaml.ConfigYamlUtils;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLFileType;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00120\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/micronaut/config/yaml/MnYamlConfigFileContributor;", "Lcom/intellij/micronaut/config/MnConfigFileContributor;", "()V", "findKey", "Lcom/intellij/psi/PsiElement;", "psiFile", "Lcom/intellij/psi/PsiFile;", "key", "", "getKeyVariants", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "processConfigValues", "", "params", "Lcom/intellij/micronaut/config/MnConfigValueSearcher$MnConfigValueSearchParams;", "processor", "Lcom/intellij/util/Processor;", "Lcom/intellij/micronaut/config/MnConfigValueSearcher$MnConfigValueResult;", "intellij.micronaut"})
public final class MnYamlConfigFileContributor
extends MnConfigFileContributor {
    @Override
    @Nullable
    public PsiElement findKey(@NotNull PsiFile psiFile, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!(psiFile instanceof YAMLFile)) {
            return null;
        }
        for (YAMLDocument document : ((YAMLFile)psiFile).getDocuments()) {
            YAMLKeyValue existingKey = new ConfigYamlAccessor(document, (MetaConfigKeyManager)MnMetaConfigKeyManager.INSTANCE).findExistingKey(key);
            if (existingKey == null) continue;
            return (PsiElement)existingKey;
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<LookupElement> getKeyVariants(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        if (!(psiFile instanceof YAMLFile)) {
            return CollectionsKt.emptyList();
        }
        ArrayList<LookupElementBuilder> result = new ArrayList<LookupElementBuilder>();
        for (YAMLDocument document : ((YAMLFile)psiFile).getDocuments()) {
            ConfigYamlAccessor accessor = new ConfigYamlAccessor(document, (MetaConfigKeyManager)MnMetaConfigKeyManager.INSTANCE);
            Iterator iterator = accessor.getAllKeys().iterator();
            while (iterator.hasNext()) {
                String qualifiedKey;
                YAMLKeyValue yamlKeyValue;
                YAMLKeyValue yAMLKeyValue = yamlKeyValue = (YAMLKeyValue)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)yAMLKeyValue, (String)"yamlKeyValue");
                YAMLValue yamlValue = yAMLKeyValue.getValue();
                if (!(yamlValue instanceof YAMLScalar) && !(yamlValue instanceof YAMLSequence)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)ConfigYamlUtils.getQualifiedConfigKeyName((YAMLKeyValue)yamlKeyValue), (String)"ConfigYamlUtils.getQuali\u2026nfigKeyName(yamlKeyValue)");
                result.add(LookupElementBuilder.create((Object)yamlKeyValue, (String)qualifiedKey).withRenderer(ConfigYamlUtils.getYamlPlaceholderLookupRenderer()));
            }
        }
        return result;
    }

    @Override
    public boolean processConfigValues(@NotNull MnConfigValueSearcher.MnConfigValueSearchParams params, @NotNull Processor<? super MnConfigValueSearcher.MnConfigValueResult> processor2) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        YAMLFile yAMLFile = (YAMLFile)ObjectUtils.tryCast((Object)params.getConfigFile(), YAMLFile.class);
        if (yAMLFile == null) {
            return true;
        }
        Intrinsics.checkNotNullExpressionValue((Object)yAMLFile, (String)"ObjectUtils.tryCast(para\u2026lass.java) ?: return true");
        YAMLFile yamlFile = yAMLFile;
        String string = params.getConfigKey().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"params.configKey.name");
        String keyName = string;
        MetaConfigKeyManager.ConfigKeyNameBinder binder = MnMetaConfigKeyManager.INSTANCE.getConfigKeyNameBinder(params.getModule());
        Processor keyValueProcessor2 = new Processor(keyName, params, binder, processor2){
            final /* synthetic */ String $keyName;
            final /* synthetic */ MnConfigValueSearcher.MnConfigValueSearchParams $params;
            final /* synthetic */ MetaConfigKeyManager.ConfigKeyNameBinder $binder;
            final /* synthetic */ Processor $processor;

            public final boolean process(@NotNull YAMLKeyValue yamlKeyValue) {
                Intrinsics.checkNotNullParameter((Object)yamlKeyValue, (String)"yamlKeyValue");
                ProgressManager.checkCanceled();
                String string = ConfigYamlUtils.getQualifiedConfigKeyName((YAMLKeyValue)yamlKeyValue);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ConfigYamlUtils.getQuali\u2026nfigKeyName(yamlKeyValue)");
                String qualifiedKeyName = string;
                if (Intrinsics.areEqual((Object)qualifiedKeyName, (Object)this.$keyName) || this.$params.getCheckRelaxedNames() && this.$binder.bindsTo(this.$params.getConfigKey(), qualifiedKeyName)) {
                    PsiElement psiElement = yamlKeyValue.getKey();
                    if (psiElement == null) {
                        return true;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"yamlKeyValue.key ?: return@Processor true");
                    PsiElement keyElement = psiElement;
                    YAMLValue valueElement = yamlKeyValue.getValue();
                    if (valueElement instanceof YAMLSequence || valueElement instanceof YAMLMapping) {
                        return true;
                    }
                    return this.$processor.process((Object)new MnConfigValueSearcher.MnConfigValueResult(keyElement, (PsiElement)valueElement, yamlKeyValue.getValueText(), this.$params));
                }
                return true;
            }
            {
                this.$keyName = string;
                this.$params = mnConfigValueSearchParams;
                this.$binder = configKeyNameBinder;
                this.$processor = processor2;
            }
        };
        List list = yamlFile.getDocuments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"yamlFile.documents");
        for (YAMLDocument document : CollectionsKt.asReversedMutable((List)list)) {
            if (ConfigYamlAccessor.processAllKeysReversed((YAMLPsiElement)((YAMLPsiElement)document), (Processor)keyValueProcessor2)) continue;
            return false;
        }
        return true;
    }

    public MnYamlConfigFileContributor() {
        YAMLFileType yAMLFileType = YAMLFileType.YML;
        Intrinsics.checkNotNullExpressionValue((Object)yAMLFileType, (String)"YAMLFileType.YML");
        super((FileType)yAMLFileType);
    }
}

