/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config.properties;

import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.micronaut.config.MnConfigUtilsKt;
import com.intellij.micronaut.config.properties.MnPropertiesKeyReferenceProvider;
import com.intellij.micronaut.config.properties.MnPropertiesValueReferenceProvider;
import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.microservices.config.MetaConfigKeyReference;
import com.intellij.microservices.config.properties.ConfigKeyPathReferenceProvider;
import com.intellij.openapi.util.Condition;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.util.ProcessingContext;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/micronaut/config/properties/MnPropertiesReferenceContributor;", "Lcom/intellij/psi/PsiReferenceContributor;", "()V", "registerKeyProviders", "", "registrar", "Lcom/intellij/psi/PsiReferenceRegistrar;", "registerReferenceProviders", "Companion", "intellij.micronaut"})
public final class MnPropertiesReferenceContributor
extends PsiReferenceContributor {
    private static final PatternCondition<PsiElement> APPLICATION_PROPERTIES;
    @NotNull
    public static final Companion Companion;

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        this.registerKeyProviders(registrar);
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(PropertyValueImpl.class).with(APPLICATION_PROPERTIES), (PsiReferenceProvider)new MnPropertiesValueReferenceProvider(), 100.0);
    }

    private final void registerKeyProviders(PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(PropertyKeyImpl.class).with(APPLICATION_PROPERTIES), (PsiReferenceProvider)new MnPropertiesKeyReferenceProvider());
        registrar.registerReferenceProvider((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PropertyKeyImpl.class).with(APPLICATION_PROPERTIES)).with((PatternCondition)new PatternCondition<PropertyKeyImpl>("isMapOrIndexedKey"){

            public boolean accepts(@NotNull PropertyKeyImpl key, @NotNull ProcessingContext context) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                return MetaConfigKeyReference.findAndStoreMetaConfigKeyIfMatches((PsiElement)((PsiElement)key), (ProcessingContext)context, (Condition)MetaConfigKey.MAP_OR_INDEXED_WITHOUT_KEY_HINTS_CONDITION);
            }
        }), (PsiReferenceProvider)new ConfigKeyPathReferenceProvider());
    }

    static {
        Companion = new Companion(null);
        APPLICATION_PROPERTIES = (PatternCondition)new PatternCondition<PsiElement>("isApplicationPropertiesAndMicronaut"){

            public boolean accepts(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                PsiFile psiFile = element.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"element.containingFile");
                PsiFile psiFile2 = psiFile.getOriginalFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"element.containingFile.originalFile");
                PsiFile containingFile = psiFile2;
                return containingFile instanceof PropertiesFile && MnConfigUtilsKt.isMicronautConfigFile(containingFile);
            }
        };
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/micronaut/config/properties/MnPropertiesReferenceContributor$Companion;", "", "()V", "APPLICATION_PROPERTIES", "Lcom/intellij/patterns/PatternCondition;", "Lcom/intellij/psi/PsiElement;", "intellij.micronaut"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

