/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config.properties;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.micronaut.MicronautBundle;
import com.intellij.micronaut.MicronautUtils;
import com.intellij.micronaut.config.MnConfigUtilsKt;
import com.intellij.micronaut.config.properties.MnPropertiesUtils;
import com.intellij.microservices.config.ConfigKeyParts;
import com.intellij.microservices.config.ConfigKeyPathReference;
import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.microservices.config.MetaConfigKeyReference;
import com.intellij.microservices.config.MicroservicesConfigUtils;
import com.intellij.microservices.config.properties.IndexAccessTextProcessor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J-\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\u0012J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/micronaut/config/properties/MnPropertiesConfigInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "highlightIndexAccessExpressions", "", "propertyKey", "Lcom/intellij/lang/properties/psi/impl/PropertyKeyImpl;", "configKey", "Lcom/intellij/microservices/config/MetaConfigKey;", "intellij.micronaut"})
public final class MnPropertiesConfigInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                Project project = holder.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"holder.project");
                if (!MicronautUtils.hasMicronautLibrary(project)) break block2;
                PsiFile psiFile = holder.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"holder.file");
                if (MnConfigUtilsKt.isMicronautConfigFile(psiFile)) break block3;
            }
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"PsiElementVisitor.EMPTY_VISITOR");
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly, session);
        Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"super.buildVisitor(holder, isOnTheFly, session)");
        return psiElementVisitor;
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        if (!(file instanceof PropertiesFile)) {
            return null;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, file, isOnTheFly);
        for (IProperty property : ((PropertiesFile)file).getProperties()) {
            PropertyValueImpl valueElement;
            ConfigKeyParts keyParts;
            PropertyKeyImpl propertyKey;
            ProgressManager.checkCanceled();
            if (!(property instanceof PropertyImpl)) continue;
            if (MnPropertiesUtils.INSTANCE.getPropertyKey((PropertyImpl)property) == null) {
                continue;
            }
            MetaConfigKey configKey = MetaConfigKeyReference.getResolvedMetaConfigKey((PsiElement)((PsiElement)propertyKey));
            if (configKey == null) continue;
            if (configKey.isAccessType(Arrays.copyOf(MetaConfigKey.AccessType.MAP_GROUP, MetaConfigKey.AccessType.MAP_GROUP.length)) && ((keyParts = ConfigKeyParts.splitToParts((MetaConfigKey)configKey, (String)propertyKey.getText(), (boolean)false)) == null || keyParts.getKeyIndex() == null)) {
                holder.registerProblem((PsiElement)propertyKey, MicronautBundle.message("micronaut.inspections.config.properties.missing.map.key", new Object[0]), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
                continue;
            }
            this.highlightIndexAccessExpressions(holder, propertyKey, configKey);
            if (MetaConfigKey.MAP_OR_INDEXED_WITHOUT_KEY_HINTS_CONDITION.value((Object)configKey)) {
                for (PsiReference reference : propertyKey.getReferences()) {
                    if (!(reference instanceof ConfigKeyPathReference) || ((ConfigKeyPathReference)reference).isSoft() || reference.resolve() != null) continue;
                    holder.registerProblem(reference, ProblemsHolder.unresolvedReferenceMessage((PsiReference)reference), ProblemHighlightType.ERROR);
                }
            }
            if (MnPropertiesUtils.INSTANCE.getPropertyValue((PropertyImpl)property) == null) {
                continue;
            }
            MicroservicesConfigUtils.highlightValueReferences((PsiElement)((PsiElement)valueElement), (ProblemsHolder)holder);
        }
        return holder.getResultsArray();
    }

    private final void highlightIndexAccessExpressions(ProblemsHolder holder, PropertyKeyImpl propertyKey, MetaConfigKey configKey) {
        new IndexAccessTextProcessor(holder, propertyKey, configKey, propertyKey.getText(), configKey){
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ PropertyKeyImpl $propertyKey;
            final /* synthetic */ MetaConfigKey $configKey;

            protected void onMissingClosingBracket(int startIdx) {
                this.$holder.registerProblem((PsiElement)this.$propertyKey, MicronautBundle.message("micronaut.inspections.config.properties.missing.closing.bracket", new Object[0]), ProblemHighlightType.ERROR, TextRange.from((int)startIdx, (int)1), new LocalQuickFix[0]);
            }

            protected void onMissingIndexValue(int startIdx) {
                this.$holder.registerProblem((PsiElement)this.$propertyKey, MicronautBundle.message("micronaut.inspections.config.properties.missing.index.value", new Object[0]), ProblemHighlightType.ERROR, TextRange.from((int)startIdx, (int)2), new LocalQuickFix[0]);
            }

            protected void onBracket(int startIdx) {
            }

            protected void onIndexValue(@NotNull TextRange indexValueRange) {
                Intrinsics.checkNotNullParameter((Object)indexValueRange, (String)"indexValueRange");
            }

            protected void onIndexValueNotInteger(@NotNull TextRange indexValueRange) {
                Intrinsics.checkNotNullParameter((Object)indexValueRange, (String)"indexValueRange");
                this.$holder.registerProblem((PsiElement)this.$propertyKey, MicronautBundle.message("micronaut.inspections.config.properties.non.integer.index", new Object[0]), ProblemHighlightType.ERROR, indexValueRange, new LocalQuickFix[0]);
            }
            {
                this.$holder = $captured_local_variable$0;
                this.$propertyKey = $captured_local_variable$1;
                this.$configKey = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4);
            }
        }.process();
    }
}

