/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config.properties;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.micronaut.MicronautUtils;
import com.intellij.micronaut.config.MnConfigUtilsKt;
import com.intellij.micronaut.config.MnParametrizedConfigKey;
import com.intellij.micronaut.config.properties.MnPropertyKeyMetaConfigKeyReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/micronaut/config/properties/MnPropertiesCompletionContributor;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "()V", "fillCompletionVariants", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "ParametrizedKeyPrefixMatcher", "intellij.micronaut"})
public final class MnPropertiesCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                PsiFile psiFile = parameters.getOriginalFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"parameters.originalFile");
                PsiFile psiFile2 = psiFile;
                if (!(psiFile2 instanceof PropertiesFile)) break block4;
                Project project = ((PropertiesFile)psiFile2).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"(psiFile as PropertiesFile).project");
                if (MicronautUtils.hasMicronautLibrary(project) && MnConfigUtilsKt.isMicronautConfigFile(psiFile2)) break block5;
            }
            return;
        }
        PsiElement psiElement = parameters.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"parameters.position");
        PsiReference reference = psiElement.getContainingFile().findReferenceAt(parameters.getOffset());
        if (reference instanceof MnPropertyKeyMetaConfigKeyReference) {
            PrefixMatcher prefixMatcher = result.getPrefixMatcher();
            Intrinsics.checkNotNullExpressionValue((Object)prefixMatcher, (String)"result.prefixMatcher");
            CompletionResultSet completionResultSet = result.withPrefixMatcher((PrefixMatcher)new ParametrizedKeyPrefixMatcher(prefixMatcher));
            Intrinsics.checkNotNullExpressionValue((Object)completionResultSet, (String)"result.withPrefixMatcher\u2026er(result.prefixMatcher))");
            CompletionResultSet resultWithMatcher = completionResultSet;
            resultWithMatcher.runRemainingContributors(parameters, true);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0005H\u0016R\u0013\u0010\u0002\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/micronaut/config/properties/MnPropertiesCompletionContributor$ParametrizedKeyPrefixMatcher;", "Lcom/intellij/codeInsight/completion/PrefixMatcher;", "delegate", "(Lcom/intellij/codeInsight/completion/PrefixMatcher;)V", "prefix", "", "(Ljava/lang/String;Lcom/intellij/codeInsight/completion/PrefixMatcher;)V", "Lorg/jetbrains/annotations/NotNull;", "cloneWithPrefix", "prefixMatches", "", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "name", "intellij.micronaut"})
    private static final class ParametrizedKeyPrefixMatcher
    extends PrefixMatcher {
        private final PrefixMatcher delegate;

        public boolean prefixMatches(@NotNull LookupElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Iterator iterator = element.getAllLookupStrings().iterator();
            while (iterator.hasNext()) {
                TextRange parameterRange;
                TextRange textRange;
                MnParametrizedConfigKey parametrizedConfigKey;
                String s;
                String string = s = (String)iterator.next();
                Intrinsics.checkNotNull((Object)string);
                MnParametrizedConfigKey mnParametrizedConfigKey = parametrizedConfigKey = MnParametrizedConfigKey.Companion.getParametrizedConfigKey(string);
                if (mnParametrizedConfigKey != null) {
                    String string2 = this.getPrefix();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"prefix");
                    textRange = mnParametrizedConfigKey.getParameterRange(string2);
                } else {
                    textRange = parameterRange = null;
                }
                if (parameterRange != null) {
                    String parameter;
                    Intrinsics.checkNotNullExpressionValue((Object)parameterRange.substring(this.getPrefix()), (String)"parameterRange.substring(prefix)");
                    String convertedName = parametrizedConfigKey.getPrefix() + '.' + parameter + '.' + parametrizedConfigKey.getSuffix();
                    if (!this.delegate.prefixMatches(convertedName)) continue;
                    element.putUserData(MnPropertyKeyMetaConfigKeyReference.Companion.getPARAMETER_KEY$intellij_micronaut(), (Object)parameter);
                    return true;
                }
                if (!this.delegate.prefixMatches(s)) continue;
                return true;
            }
            return false;
        }

        public boolean prefixMatches(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.delegate.prefixMatches(name);
        }

        @NotNull
        public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            return Intrinsics.areEqual((Object)prefix, (Object)this.myPrefix) ? (PrefixMatcher)this : (PrefixMatcher)new ParametrizedKeyPrefixMatcher(prefix, this.delegate);
        }

        public ParametrizedKeyPrefixMatcher(@NotNull String prefix, @NotNull PrefixMatcher delegate) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            super(prefix);
            PrefixMatcher prefixMatcher = delegate.cloneWithPrefix(prefix);
            Intrinsics.checkNotNullExpressionValue((Object)prefixMatcher, (String)"delegate.cloneWithPrefix(prefix)");
            this.delegate = prefixMatcher;
        }

        public ParametrizedKeyPrefixMatcher(@NotNull PrefixMatcher delegate) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            String string = delegate.getPrefix();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"delegate.prefix");
            this(string, delegate);
        }
    }
}

