/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config;

import com.intellij.micronaut.config.MnConfigFileContributor;
import com.intellij.micronaut.config.MnMetaConfigKeyManager;
import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u0004\u0018\u00010\u0007J\u0016\u0010\r\u001a\u00020\u00052\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00100\u000fR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/micronaut/config/MnConfigValueSearcher;", "", "module", "Lcom/intellij/openapi/module/Module;", "includeTests", "", "configKey", "", "checkRelaxedNames", "activeEnvironments", "", "(Lcom/intellij/openapi/module/Module;ZLjava/lang/String;ZLjava/util/Set;)V", "findValueText", "process", "processor", "Lcom/intellij/util/Processor;", "Lcom/intellij/micronaut/config/MnConfigValueSearcher$MnConfigValueResult;", "MnConfigValueResult", "MnConfigValueSearchParams", "intellij.micronaut"})
public final class MnConfigValueSearcher {
    private final Module module;
    private final boolean includeTests;
    private final String configKey;
    private final boolean checkRelaxedNames;
    private final Set<String> activeEnvironments;

    @Nullable
    public final String findValueText() {
        CommonProcessors.FindFirstProcessor<MnConfigValueResult> processor2 = new CommonProcessors.FindFirstProcessor<MnConfigValueResult>(){

            protected boolean accept(@NotNull MnConfigValueResult result) {
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                return result.getValueText() != null;
            }
        };
        this.process((Processor<? super MnConfigValueResult>)((Processor)processor2));
        MnConfigValueResult mnConfigValueResult = (MnConfigValueResult)processor2.getFoundValue();
        return mnConfigValueResult != null ? mnConfigValueResult.getValueText() : null;
    }

    public final boolean process(@NotNull Processor<? super MnConfigValueResult> processor2) {
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        MetaConfigKey metaConfigKey = MnMetaConfigKeyManager.INSTANCE.findApplicationMetaConfigKey(this.module, this.configKey);
        if (metaConfigKey == null) {
            return true;
        }
        Intrinsics.checkNotNullExpressionValue((Object)metaConfigKey, (String)"MnMetaConfigKeyManager.f\u2026configKey) ?: return true");
        MetaConfigKey metaConfigKey2 = metaConfigKey;
        List<Pair<VirtualFile, MnConfigFileContributor>> configs = MnConfigFileContributor.Companion.findConfigFiles(this.module, this.includeTests, this.activeEnvironments);
        PsiManager psiManager = PsiManager.getInstance((Project)this.module.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"PsiManager.getInstance(module.project)");
        PsiManager psiManager2 = psiManager;
        for (Pair<VirtualFile, MnConfigFileContributor> config : configs) {
            PsiFile configPsiFile;
            if (psiManager2.findFile((VirtualFile)config.getFirst()) == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)configPsiFile, (String)"psiManager.findFile(config.first) ?: continue");
            MnConfigValueSearchParams params = new MnConfigValueSearchParams(this.module, configPsiFile, this.checkRelaxedNames, this.activeEnvironments, metaConfigKey2);
            if (((MnConfigFileContributor)config.getSecond()).processConfigValues(params, processor2)) continue;
            return false;
        }
        return true;
    }

    public MnConfigValueSearcher(@NotNull Module module, boolean includeTests, @NotNull String configKey, boolean checkRelaxedNames, @NotNull Set<String> activeEnvironments) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)configKey, (String)"configKey");
        Intrinsics.checkNotNullParameter(activeEnvironments, (String)"activeEnvironments");
        this.module = module;
        this.includeTests = includeTests;
        this.configKey = configKey;
        this.checkRelaxedNames = checkRelaxedNames;
        this.activeEnvironments = activeEnvironments;
    }

    public /* synthetic */ MnConfigValueSearcher(Module module, boolean bl, String string, boolean bl2, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        if ((n & 0x10) != 0) {
            set = SetsKt.emptySet();
        }
        this(module, bl, string, bl2, set);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003J\u0011\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH\u00c6\u0003J\t\u0010\u001c\u001a\u00020\fH\u00c6\u0003JC\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u00072\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020\nH\u00d6\u0001R\u0019\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006#"}, d2={"Lcom/intellij/micronaut/config/MnConfigValueSearcher$MnConfigValueSearchParams;", "", "module", "Lcom/intellij/openapi/module/Module;", "configFile", "Lcom/intellij/psi/PsiFile;", "checkRelaxedNames", "", "activeProfiles", "", "", "configKey", "Lcom/intellij/microservices/config/MetaConfigKey;", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/psi/PsiFile;ZLjava/util/Set;Lcom/intellij/microservices/config/MetaConfigKey;)V", "getActiveProfiles", "()Ljava/util/Set;", "getCheckRelaxedNames", "()Z", "getConfigFile", "()Lcom/intellij/psi/PsiFile;", "getConfigKey", "()Lcom/intellij/microservices/config/MetaConfigKey;", "getModule", "()Lcom/intellij/openapi/module/Module;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "intellij.micronaut"})
    public static final class MnConfigValueSearchParams {
        @NotNull
        private final Module module;
        @NotNull
        private final PsiFile configFile;
        private final boolean checkRelaxedNames;
        @Nullable
        private final Set<String> activeProfiles;
        @NotNull
        private final MetaConfigKey configKey;

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        @NotNull
        public final PsiFile getConfigFile() {
            return this.configFile;
        }

        public final boolean getCheckRelaxedNames() {
            return this.checkRelaxedNames;
        }

        @Nullable
        public final Set<String> getActiveProfiles() {
            return this.activeProfiles;
        }

        @NotNull
        public final MetaConfigKey getConfigKey() {
            return this.configKey;
        }

        public MnConfigValueSearchParams(@NotNull Module module, @NotNull PsiFile configFile, boolean checkRelaxedNames, @Nullable Set<String> activeProfiles, @NotNull MetaConfigKey configKey) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)configFile, (String)"configFile");
            Intrinsics.checkNotNullParameter((Object)configKey, (String)"configKey");
            this.module = module;
            this.configFile = configFile;
            this.checkRelaxedNames = checkRelaxedNames;
            this.activeProfiles = activeProfiles;
            this.configKey = configKey;
        }

        public /* synthetic */ MnConfigValueSearchParams(Module module, PsiFile psiFile, boolean bl, Set set, MetaConfigKey metaConfigKey, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = true;
            }
            this(module, psiFile, bl, set, metaConfigKey);
        }

        @NotNull
        public final Module component1() {
            return this.module;
        }

        @NotNull
        public final PsiFile component2() {
            return this.configFile;
        }

        public final boolean component3() {
            return this.checkRelaxedNames;
        }

        @Nullable
        public final Set<String> component4() {
            return this.activeProfiles;
        }

        @NotNull
        public final MetaConfigKey component5() {
            return this.configKey;
        }

        @NotNull
        public final MnConfigValueSearchParams copy(@NotNull Module module, @NotNull PsiFile configFile, boolean checkRelaxedNames, @Nullable Set<String> activeProfiles, @NotNull MetaConfigKey configKey) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)configFile, (String)"configFile");
            Intrinsics.checkNotNullParameter((Object)configKey, (String)"configKey");
            return new MnConfigValueSearchParams(module, configFile, checkRelaxedNames, activeProfiles, configKey);
        }

        public static /* synthetic */ MnConfigValueSearchParams copy$default(MnConfigValueSearchParams mnConfigValueSearchParams, Module module, PsiFile psiFile, boolean bl, Set set, MetaConfigKey metaConfigKey, int n, Object object) {
            if ((n & 1) != 0) {
                module = mnConfigValueSearchParams.module;
            }
            if ((n & 2) != 0) {
                psiFile = mnConfigValueSearchParams.configFile;
            }
            if ((n & 4) != 0) {
                bl = mnConfigValueSearchParams.checkRelaxedNames;
            }
            if ((n & 8) != 0) {
                set = mnConfigValueSearchParams.activeProfiles;
            }
            if ((n & 0x10) != 0) {
                metaConfigKey = mnConfigValueSearchParams.configKey;
            }
            return mnConfigValueSearchParams.copy(module, psiFile, bl, set, metaConfigKey);
        }

        @NotNull
        public String toString() {
            return "MnConfigValueSearchParams(module=" + this.module + ", configFile=" + this.configFile + ", checkRelaxedNames=" + this.checkRelaxedNames + ", activeProfiles=" + this.activeProfiles + ", configKey=" + this.configKey + ")";
        }

        public int hashCode() {
            Module module = this.module;
            PsiFile psiFile = this.configFile;
            int n = ((module != null ? module.hashCode() : 0) * 31 + (psiFile != null ? psiFile.hashCode() : 0)) * 31;
            int n2 = this.checkRelaxedNames ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            Set<String> set = this.activeProfiles;
            MetaConfigKey metaConfigKey = this.configKey;
            return ((n + n2) * 31 + (set != null ? ((Object)set).hashCode() : 0)) * 31 + (metaConfigKey != null ? metaConfigKey.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof MnConfigValueSearchParams)) break block3;
                    MnConfigValueSearchParams mnConfigValueSearchParams = (MnConfigValueSearchParams)object;
                    if (!Intrinsics.areEqual((Object)this.module, (Object)mnConfigValueSearchParams.module) || !Intrinsics.areEqual((Object)this.configFile, (Object)mnConfigValueSearchParams.configFile) || this.checkRelaxedNames != mnConfigValueSearchParams.checkRelaxedNames || !Intrinsics.areEqual(this.activeProfiles, mnConfigValueSearchParams.activeProfiles) || !Intrinsics.areEqual((Object)this.configKey, (Object)mnConfigValueSearchParams.configKey)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J5\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/intellij/micronaut/config/MnConfigValueSearcher$MnConfigValueResult;", "", "keyElement", "Lcom/intellij/psi/PsiElement;", "valueElement", "valueText", "", "params", "Lcom/intellij/micronaut/config/MnConfigValueSearcher$MnConfigValueSearchParams;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Ljava/lang/String;Lcom/intellij/micronaut/config/MnConfigValueSearcher$MnConfigValueSearchParams;)V", "getKeyElement", "()Lcom/intellij/psi/PsiElement;", "getParams", "()Lcom/intellij/micronaut/config/MnConfigValueSearcher$MnConfigValueSearchParams;", "getValueElement", "getValueText", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.micronaut"})
    public static final class MnConfigValueResult {
        @NotNull
        private final PsiElement keyElement;
        @Nullable
        private final PsiElement valueElement;
        @Nullable
        private final String valueText;
        @NotNull
        private final MnConfigValueSearchParams params;

        @NotNull
        public final PsiElement getKeyElement() {
            return this.keyElement;
        }

        @Nullable
        public final PsiElement getValueElement() {
            return this.valueElement;
        }

        @Nullable
        public final String getValueText() {
            return this.valueText;
        }

        @NotNull
        public final MnConfigValueSearchParams getParams() {
            return this.params;
        }

        public MnConfigValueResult(@NotNull PsiElement keyElement, @Nullable PsiElement valueElement, @Nullable String valueText, @NotNull MnConfigValueSearchParams params) {
            Intrinsics.checkNotNullParameter((Object)keyElement, (String)"keyElement");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            this.keyElement = keyElement;
            this.valueElement = valueElement;
            this.valueText = valueText;
            this.params = params;
        }

        @NotNull
        public final PsiElement component1() {
            return this.keyElement;
        }

        @Nullable
        public final PsiElement component2() {
            return this.valueElement;
        }

        @Nullable
        public final String component3() {
            return this.valueText;
        }

        @NotNull
        public final MnConfigValueSearchParams component4() {
            return this.params;
        }

        @NotNull
        public final MnConfigValueResult copy(@NotNull PsiElement keyElement, @Nullable PsiElement valueElement, @Nullable String valueText, @NotNull MnConfigValueSearchParams params) {
            Intrinsics.checkNotNullParameter((Object)keyElement, (String)"keyElement");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            return new MnConfigValueResult(keyElement, valueElement, valueText, params);
        }

        public static /* synthetic */ MnConfigValueResult copy$default(MnConfigValueResult mnConfigValueResult, PsiElement psiElement, PsiElement psiElement2, String string, MnConfigValueSearchParams mnConfigValueSearchParams, int n, Object object) {
            if ((n & 1) != 0) {
                psiElement = mnConfigValueResult.keyElement;
            }
            if ((n & 2) != 0) {
                psiElement2 = mnConfigValueResult.valueElement;
            }
            if ((n & 4) != 0) {
                string = mnConfigValueResult.valueText;
            }
            if ((n & 8) != 0) {
                mnConfigValueSearchParams = mnConfigValueResult.params;
            }
            return mnConfigValueResult.copy(psiElement, psiElement2, string, mnConfigValueSearchParams);
        }

        @NotNull
        public String toString() {
            return "MnConfigValueResult(keyElement=" + this.keyElement + ", valueElement=" + this.valueElement + ", valueText=" + this.valueText + ", params=" + this.params + ")";
        }

        public int hashCode() {
            PsiElement psiElement = this.keyElement;
            PsiElement psiElement2 = this.valueElement;
            String string = this.valueText;
            MnConfigValueSearchParams mnConfigValueSearchParams = this.params;
            return (((psiElement != null ? psiElement.hashCode() : 0) * 31 + (psiElement2 != null ? psiElement2.hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (mnConfigValueSearchParams != null ? ((Object)mnConfigValueSearchParams).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof MnConfigValueResult)) break block3;
                    MnConfigValueResult mnConfigValueResult = (MnConfigValueResult)object;
                    if (!Intrinsics.areEqual((Object)this.keyElement, (Object)mnConfigValueResult.keyElement) || !Intrinsics.areEqual((Object)this.valueElement, (Object)mnConfigValueResult.valueElement) || !Intrinsics.areEqual((Object)this.valueText, (Object)mnConfigValueResult.valueText) || !Intrinsics.areEqual((Object)this.params, (Object)mnConfigValueResult.params)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

