/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config;

import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.highlighting.HighlightedReference;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesElementFactory;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertyKeyIndex;
import com.intellij.micronaut.MicronautIcons;
import com.intellij.micronaut.config.MnConfigFileContributor;
import com.intellij.micronaut.config.MnMetaConfigKeyManager;
import com.intellij.micronaut.config.MnParametrizedConfigKey;
import com.intellij.microservices.config.ConfigPlaceholderReference;
import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004:\u0002\u001e\u001fB\u000f\b\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0002J\u0013\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016\u00a2\u0006\u0002\u0010\u0011J\u001d\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u000f2\u0006\u0010\u0014\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\u0015J&\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001bH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/micronaut/config/MnConfigPlaceholderReference;", "Lcom/intellij/psi/PsiReferenceBase$Poly;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/codeInsight/highlighting/HighlightedReference;", "Lcom/intellij/microservices/config/ConfigPlaceholderReference;", "builder", "Lcom/intellij/micronaut/config/MnConfigPlaceholderReference$Builder;", "(Lcom/intellij/micronaut/config/MnConfigPlaceholderReference$Builder;)V", "withMetaConfigKeyVariants", "", "withRandomValue", "withSystemProperties", "getSystemProperties", "Lcom/intellij/lang/properties/psi/PropertiesFile;", "getVariants", "", "", "()[Ljava/lang/Object;", "multiResolve", "Lcom/intellij/psi/ResolveResult;", "incompleteCode", "(Z)[Lcom/intellij/psi/ResolveResult;", "processKeys", "", "module", "Lcom/intellij/openapi/module/Module;", "processor", "Lcom/intellij/util/PairProcessor;", "Lcom/intellij/micronaut/config/MnConfigFileContributor;", "Lcom/intellij/psi/PsiFile;", "Builder", "Companion", "intellij.micronaut"})
public final class MnConfigPlaceholderReference
extends PsiReferenceBase.Poly<PsiElement>
implements HighlightedReference,
ConfigPlaceholderReference {
    private final boolean withRandomValue;
    private final boolean withSystemProperties;
    private final boolean withMetaConfigKeyVariants;
    private static final String RANDOM_KEY_PREFIX = "random.";
    private static final String[] RANDOM_VALUES;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray;
        IProperty systemProperty;
        String string = this.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value");
        String key = string;
        if (this.withRandomValue && StringUtil.startsWith((CharSequence)key, (CharSequence)RANDOM_KEY_PREFIX)) {
            String after = StringUtil.substringAfter((String)key, (String)RANDOM_KEY_PREFIX);
            for (String randomValue : RANDOM_VALUES) {
                if (!Intrinsics.areEqual((Object)after, (Object)randomValue)) continue;
                ResolveResult[] resolveResultArray2 = PsiElementResolveResult.createResults((PsiElement[])new PsiElement[]{this.getElement()});
                Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray2, (String)"PsiElementResolveResult.createResults(element)");
                return resolveResultArray2;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ResolveResult.EMPTY_ARRAY, (String)"ResolveResult.EMPTY_ARRAY");
            return ResolveResult.EMPTY_ARRAY;
        }
        if (this.withSystemProperties && (systemProperty = this.getSystemProperties().findPropertyByKey(key)) != null) {
            ResolveResult[] resolveResultArray3 = PsiElementResolveResult.createResults((PsiElement[])new PsiElement[]{systemProperty.getPsiElement()});
            Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray3, (String)"PsiElementResolveResult.\u2026ystemProperty.psiElement)");
            return resolveResultArray3;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
        SmartList existingKeys2 = new SmartList();
        this.processKeys(module, (PairProcessor<MnConfigFileContributor, PsiFile>)new PairProcessor(existingKeys2, key){
            final /* synthetic */ SmartList $existingKeys;
            final /* synthetic */ String $key;

            public final boolean process(@NotNull MnConfigFileContributor contributor, @NotNull PsiFile psiFile) {
                Intrinsics.checkNotNullParameter((Object)contributor, (String)"contributor");
                Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
                UtilKt.addIfNotNull((List)((List)this.$existingKeys), (Object)contributor.findKey(psiFile, this.$key));
                return true;
            }
            {
                this.$existingKeys = smartList;
                this.$key = string;
            }
        });
        Collection collection = (Collection)existingKeys2;
        boolean bl = false;
        if (!collection.isEmpty()) {
            ResolveResult[] resolveResultArray4 = PsiElementResolveResult.createResults((Collection)((Collection)existingKeys2));
            Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray4, (String)"PsiElementResolveResult.\u2026eateResults(existingKeys)");
            return resolveResultArray4;
        }
        Module module2 = module;
        if (module2 == null || (module2 = module2.getModuleContentScope()) == null) {
            Intrinsics.checkNotNullExpressionValue((Object)ResolveResult.EMPTY_ARRAY, (String)"ResolveResult.EMPTY_ARRAY");
            return ResolveResult.EMPTY_ARRAY;
        }
        Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"module?.moduleContentSco\u2026ResolveResult.EMPTY_ARRAY");
        Module contentScope = module2;
        PropertyKeyIndex propertyKeyIndex = PropertyKeyIndex.getInstance();
        PsiElement psiElement = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element");
        Project project = psiElement.getProject();
        PsiElement psiElement2 = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"element");
        Collection properties = propertyKeyIndex.get(key, project, psiElement2.getResolveScope().uniteWith((GlobalSearchScope)contentScope));
        if (properties.isEmpty()) {
            resolveResultArray = ResolveResult.EMPTY_ARRAY;
            Intrinsics.checkNotNullExpressionValue((Object)ResolveResult.EMPTY_ARRAY, (String)"ResolveResult.EMPTY_ARRAY");
        } else {
            ResolveResult[] resolveResultArray5 = PsiElementResolveResult.createResults((Collection)properties);
            resolveResultArray = resolveResultArray5;
            Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray5, (String)"PsiElementResolveResult.createResults(properties)");
        }
        return resolveResultArray;
    }

    private final PropertiesFile getSystemProperties() {
        PsiElement psiElement = this.myElement;
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"myElement");
        PropertiesFile propertiesFile = PropertiesElementFactory.getSystemProperties((Project)psiElement.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)propertiesFile, (String)"PropertiesElementFactory\u2026erties(myElement.project)");
        return propertiesFile;
    }

    @NotNull
    public Object[] getVariants() {
        List variants = new ArrayList();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
        Set existingKeys2 = new HashSet();
        this.processKeys(module, (PairProcessor<MnConfigFileContributor, PsiFile>)new PairProcessor(variants, existingKeys2){
            final /* synthetic */ List $variants;
            final /* synthetic */ Set $existingKeys;

            public final boolean process(@NotNull MnConfigFileContributor contributor, @NotNull PsiFile psiFile) {
                Intrinsics.checkNotNullParameter((Object)contributor, (String)"contributor");
                Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
                Collection<LookupElement> existingKeyVariants = contributor.getKeyVariants(psiFile);
                this.$variants.addAll(existingKeyVariants);
                for (LookupElement variant : existingKeyVariants) {
                    String string = variant.getLookupString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variant.lookupString");
                    this.$existingKeys.add(string);
                }
                return true;
            }
            {
                this.$variants = list;
                this.$existingKeys = set;
            }
        });
        if (this.withSystemProperties) {
            Iterator iterator = this.getSystemProperties().getProperties().iterator();
            while (iterator.hasNext()) {
                String key;
                IProperty property;
                IProperty iProperty = property = (IProperty)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)iProperty, (String)"property");
                if (iProperty.getKey() == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"property.key ?: continue");
                LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((Object)property, (String)key).withIcon(MicronautIcons.MicronautLogo);
                Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"LookupElementBuilder.cre\u2026onautIcons.MicronautLogo)");
                variants.add(lookupElementBuilder);
            }
        }
        if (this.withRandomValue) {
            for (String randomValue : RANDOM_VALUES) {
                String insertString = RANDOM_KEY_PREFIX + (String)randomValue;
                LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((Object)insertString, (String)insertString).withIcon(MicronautIcons.MicronautLogo);
                Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"LookupElementBuilder.cre\u2026onautIcons.MicronautLogo)");
                variants.add(lookupElementBuilder);
            }
        }
        if (this.withMetaConfigKeyVariants) {
            List<MetaConfigKey> metaConfigKeys = MnMetaConfigKeyManager.INSTANCE.getAllMetaConfigKeys(module);
            for (MetaConfigKey configKey : metaConfigKeys) {
                String name;
                Intrinsics.checkNotNullExpressionValue((Object)configKey.getName(), (String)"configKey.name");
                if (MnParametrizedConfigKey.Companion.getParametrizedConfigKey(name) != null || existingKeys2.contains(name)) continue;
                MetaConfigKey.MetaConfigKeyPresentation metaConfigKeyPresentation = configKey.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)metaConfigKeyPresentation, (String)"configKey.presentation");
                LookupElementBuilder lookupElement = metaConfigKeyPresentation.getLookupElement();
                LookupElement lookupElement2 = PrioritizedLookupElement.withPriority((LookupElement)((LookupElement)lookupElement), (double)-100.0);
                Intrinsics.checkNotNullExpressionValue((Object)lookupElement2, (String)"PrioritizedLookupElement\u2026ty(lookupElement, -100.0)");
                variants.add(lookupElement2);
            }
        }
        Object[] objectArray = ArrayUtil.toObjectArray((Collection)variants);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"ArrayUtil.toObjectArray(variants)");
        return objectArray;
    }

    /*
     * Unable to fully structure code
     */
    private final void processKeys(Module module, PairProcessor<MnConfigFileContributor, PsiFile> processor) {
        if (module == null) {
            return;
        }
        v0 = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"element");
        v1 = v0.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"element.containingFile");
        v2 = v1.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"element.containingFile.originalFile");
        containingFile = v2.getVirtualFile();
        if (containingFile == null) ** GOTO lbl-1000
        v3 = ModuleRootManager.getInstance((Module)module);
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"ModuleRootManager.getInstance(module)");
        if (v3.getFileIndex().isInTestSourceContent(containingFile)) {
            v4 = true;
        } else lbl-1000:
        // 2 sources

        {
            v4 = false;
        }
        isInTests = v4;
        v5 = PsiManager.getInstance((Project)module.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"PsiManager.getInstance(module.project)");
        psiManager = v5;
        for (MnConfigFileContributor contributor : MnConfigFileContributor.Companion.getEP_NAME().getExtensionList()) {
            for (VirtualFile virtualFile : contributor.findConfigFiles(module, isInTests)) {
                if (psiManager.findFile(virtualFile) == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"psiManager.findFile(virtualFile) ?: continue");
                if (processor.process((Object)contributor, (Object)psiFile)) continue;
                return;
            }
        }
    }

    private MnConfigPlaceholderReference(Builder builder) {
        super(builder.getElement(), builder.getRange(), builder.getSoft());
        this.withRandomValue = builder.getWithRandomValue();
        this.withSystemProperties = builder.getWithSystemProperties();
        this.withMetaConfigKeyVariants = builder.getWithMetaConfigKeyVariants();
    }

    static {
        Companion = new Companion(null);
        RANDOM_VALUES = new String[]{"port", "int", "integer", "long", "float", "shortuuid", "uuid", "uuid2"};
    }

    public /* synthetic */ MnConfigPlaceholderReference(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0016\u001a\u00020\u0017J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003J+\u0010\u001b\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u00072\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001J\u0006\u0010\u0010\u001a\u00020\u0000J\u0006\u0010\u0012\u001a\u00020\u0000J\u0006\u0010\u0014\u001a\u00020\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u001e\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u001e\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000e\u00a8\u0006\""}, d2={"Lcom/intellij/micronaut/config/MnConfigPlaceholderReference$Builder;", "", "element", "Lcom/intellij/psi/PsiElement;", "range", "Lcom/intellij/openapi/util/TextRange;", "soft", "", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;Z)V", "getElement", "()Lcom/intellij/psi/PsiElement;", "getRange", "()Lcom/intellij/openapi/util/TextRange;", "getSoft", "()Z", "<set-?>", "withMetaConfigKeyVariants", "getWithMetaConfigKeyVariants", "withRandomValue", "getWithRandomValue", "withSystemProperties", "getWithSystemProperties", "build", "Lcom/intellij/micronaut/config/MnConfigPlaceholderReference;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.micronaut"})
    public static final class Builder {
        private boolean withRandomValue;
        private boolean withSystemProperties;
        private boolean withMetaConfigKeyVariants;
        @Nullable
        private final PsiElement element;
        @Nullable
        private final TextRange range;
        private final boolean soft;

        public final boolean getWithRandomValue() {
            return this.withRandomValue;
        }

        public final boolean getWithSystemProperties() {
            return this.withSystemProperties;
        }

        public final boolean getWithMetaConfigKeyVariants() {
            return this.withMetaConfigKeyVariants;
        }

        @NotNull
        public final Builder withRandomValue() {
            this.withRandomValue = true;
            return this;
        }

        @NotNull
        public final Builder withSystemProperties() {
            this.withSystemProperties = true;
            return this;
        }

        @NotNull
        public final Builder withMetaConfigKeyVariants() {
            this.withMetaConfigKeyVariants = true;
            return this;
        }

        @NotNull
        public final MnConfigPlaceholderReference build() {
            return new MnConfigPlaceholderReference(this, null);
        }

        @Nullable
        public final PsiElement getElement() {
            return this.element;
        }

        @Nullable
        public final TextRange getRange() {
            return this.range;
        }

        public final boolean getSoft() {
            return this.soft;
        }

        public Builder(@Nullable PsiElement element, @Nullable TextRange range, boolean soft) {
            this.element = element;
            this.range = range;
            this.soft = soft;
        }

        @Nullable
        public final PsiElement component1() {
            return this.element;
        }

        @Nullable
        public final TextRange component2() {
            return this.range;
        }

        public final boolean component3() {
            return this.soft;
        }

        @NotNull
        public final Builder copy(@Nullable PsiElement element, @Nullable TextRange range, boolean soft) {
            return new Builder(element, range, soft);
        }

        public static /* synthetic */ Builder copy$default(Builder builder, PsiElement psiElement, TextRange textRange, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                psiElement = builder.element;
            }
            if ((n & 2) != 0) {
                textRange = builder.range;
            }
            if ((n & 4) != 0) {
                bl = builder.soft;
            }
            return builder.copy(psiElement, textRange, bl);
        }

        @NotNull
        public String toString() {
            return "Builder(element=" + this.element + ", range=" + this.range + ", soft=" + this.soft + ")";
        }

        public int hashCode() {
            PsiElement psiElement = this.element;
            TextRange textRange = this.range;
            int n = ((psiElement != null ? psiElement.hashCode() : 0) * 31 + (textRange != null ? textRange.hashCode() : 0)) * 31;
            int n2 = this.soft ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Builder)) break block3;
                    Builder builder = (Builder)object;
                    if (!Intrinsics.areEqual((Object)this.element, (Object)builder.element) || !Intrinsics.areEqual((Object)this.range, (Object)builder.range) || this.soft != builder.soft) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\b\u0012\u0004\b\u0007\u0010\u0002\u00a8\u0006\t"}, d2={"Lcom/intellij/micronaut/config/MnConfigPlaceholderReference$Companion;", "", "()V", "RANDOM_KEY_PREFIX", "", "RANDOM_VALUES", "", "getRANDOM_VALUES$annotations", "[Ljava/lang/String;", "intellij.micronaut"})
    public static final class Companion {
        private static /* synthetic */ void getRANDOM_VALUES$annotations() {
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

