/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config;

import com.intellij.micronaut.config.MnParametrizedConfigKey;
import com.intellij.microservices.config.ConfigKeyParts;
import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.microservices.config.MetaConfigKeyManager;
import com.intellij.microservices.config.RelaxedNames;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import java.util.function.BiPredicate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J$\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\bH\u0016J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/micronaut/config/MnConfigKeyNameBinder;", "Lcom/intellij/microservices/config/MetaConfigKeyManager$ConfigKeyNameBinder;", "()V", "bindsTo", "", "key", "Lcom/intellij/microservices/config/MetaConfigKey;", "configKeyText", "", "bindsToKeyProperty", "keyProperty", "matches", "keyName", "matchesFirstChar", "matchesPart", "keyPart", "text", "matchesPrefix", "prefixText", "toUniform", "intellij.micronaut"})
public final class MnConfigKeyNameBinder
implements MetaConfigKeyManager.ConfigKeyNameBinder {
    @NotNull
    public static final MnConfigKeyNameBinder INSTANCE;

    public boolean bindsTo(@NotNull MetaConfigKey key, @NotNull String configKeyText) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)configKeyText, (String)"configKeyText");
        String string = key.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key.name");
        if (!this.matchesFirstChar(string, configKeyText)) {
            return false;
        }
        String string2 = key.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"key.name");
        String uniformedConfigKeyText = this.toUniform(string2, configKeyText);
        boolean exactMatch = Intrinsics.areEqual((Object)key.getName(), (Object)uniformedConfigKeyText);
        if (key.isAccessType(new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.NORMAL})) {
            return exactMatch;
        }
        if (key.isAccessType(Arrays.copyOf(MetaConfigKey.AccessType.MAP_GROUP, MetaConfigKey.AccessType.MAP_GROUP.length))) {
            return exactMatch || StringUtil.startsWith((CharSequence)uniformedConfigKeyText, (CharSequence)(key.getName() + "."));
        }
        if (key.isAccessType(new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.INDEXED})) {
            if (exactMatch) {
                return true;
            }
            if (!StringUtil.containsChar((String)uniformedConfigKeyText, (char)'[')) {
                return false;
            }
            String string3 = StringUtil.substringBefore((String)uniformedConfigKeyText, (String)"[");
            Intrinsics.checkNotNull((Object)string3);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringUtil.substringBefo\u2026rmedConfigKeyText, \"[\")!!");
            String beforeIndexAccess = string3;
            String string4 = StringUtil.trimEnd((String)beforeIndexAccess, (char)'.');
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"StringUtil.trimEnd(beforeIndexAccess, '.')");
            beforeIndexAccess = string4;
            return Intrinsics.areEqual((Object)key.getName(), (Object)beforeIndexAccess);
        }
        throw (Throwable)new IllegalArgumentException("unknown access type for " + key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matchesPrefix(@NotNull MetaConfigKey key, @NotNull String prefixText) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)prefixText, (String)"prefixText");
        String string = key.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key.name");
        if (!this.matchesFirstChar(string, prefixText)) return false;
        CharSequence charSequence = key.getName();
        String string2 = key.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"key.name");
        if (!StringUtil.startsWith((CharSequence)charSequence, (CharSequence)this.toUniform(string2, prefixText))) return false;
        return true;
    }

    public boolean matchesPart(@NotNull String keyPart, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)keyPart, (String)"keyPart");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return Intrinsics.areEqual((Object)keyPart, (Object)"*") || this.matchesFirstChar(keyPart, text) && this.matches(keyPart, text);
    }

    @Nullable
    public String bindsToKeyProperty(@NotNull MetaConfigKey key, @Nullable String keyProperty, @NotNull String configKeyText) {
        String string;
        ConfigKeyParts parts;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)configKeyText, (String)"configKeyText");
        if (key.isAccessType(new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.NORMAL})) {
            return null;
        }
        String string2 = key.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"key.name");
        String keyName = string2;
        if (!this.matchesFirstChar(keyName, configKeyText)) {
            return null;
        }
        ConfigKeyParts configKeyParts = parts = ConfigKeyParts.splitToParts((MetaConfigKey)key, (String)configKeyText, (boolean)true);
        if (configKeyParts != null) {
            Function2 function2 = (Function2)new Function2<String, String, Boolean>(this){

                public final boolean invoke(@NotNull String p1, @NotNull String p2) {
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                    return MnConfigKeyNameBinder.access$matches((MnConfigKeyNameBinder)this.receiver, p1, p2);
                }
            };
            string = configKeyParts.getKeyIndexIfMatches(keyName, keyProperty, new BiPredicate(function2){
                private final /* synthetic */ Function2 function;
                {
                    this.function = function2;
                }

                public final /* synthetic */ boolean test(Object p0, Object p1) {
                    Object object = this.function.invoke(p0, p1);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invoke(...)");
                    return (Boolean)object;
                }
            });
        } else {
            string = null;
        }
        return string;
    }

    private final boolean matchesFirstChar(String keyName, String configKeyText) {
        CharSequence charSequence = configKeyText;
        boolean bl = false;
        return charSequence.length() > 0 && StringUtil.charsEqualIgnoreCase((char)keyName.charAt(0), (char)configKeyText.charAt(0));
    }

    private final String toUniform(String keyName, String configKeyText) {
        String uniformedConfigKeyText = RelaxedNames.camelCaseToHyphen((String)configKeyText);
        MnParametrizedConfigKey mnParametrizedConfigKey = MnParametrizedConfigKey.Companion.getParametrizedConfigKey(keyName);
        if (mnParametrizedConfigKey == null) {
            String string = uniformedConfigKeyText;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uniformedConfigKeyText");
            return string;
        }
        MnParametrizedConfigKey parametrizedConfigKey = mnParametrizedConfigKey;
        String string = uniformedConfigKeyText;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uniformedConfigKeyText");
        TextRange textRange = parametrizedConfigKey.getParameterRange(string);
        if (textRange == null) {
            return uniformedConfigKeyText;
        }
        TextRange parameterRange = textRange;
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = uniformedConfigKeyText;
        int n = 0;
        int n2 = parameterRange.getStartOffset();
        boolean bl = false;
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String result = stringBuilder.append(string3).append("*").toString();
        if (parameterRange.getEndOffset() == uniformedConfigKeyText.length()) {
            return result;
        }
        StringBuilder stringBuilder2 = new StringBuilder().append(result);
        string2 = uniformedConfigKeyText;
        n = parameterRange.getEndOffset();
        n2 = 0;
        String string4 = string2.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        return stringBuilder2.append(string4).toString();
    }

    private final boolean matches(String keyName, String configKeyText) {
        return Intrinsics.areEqual((Object)keyName, (Object)this.toUniform(keyName, configKeyText));
    }

    private MnConfigKeyNameBinder() {
    }

    static {
        MnConfigKeyNameBinder mnConfigKeyNameBinder;
        INSTANCE = mnConfigKeyNameBinder = new MnConfigKeyNameBinder();
    }

    public static final /* synthetic */ boolean access$matches(MnConfigKeyNameBinder $this, String keyName, String configKeyText) {
        return $this.matches(keyName, configKeyText);
    }
}

