/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.konan.debugger;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelper;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrMemberValue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtReferenceExpression;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u001d\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\u0016J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0010H\u0016J\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\fH\u0016J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0010H\u0002\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/konan/debugger/KonanDebuggerTypesHelper;", "Lcom/jetbrains/cidr/execution/debugger/evaluation/CidrDebuggerTypesHelper;", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "(Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;)V", "computeSourcePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "value", "Lcom/jetbrains/cidr/execution/debugger/evaluation/CidrMemberValue;", "createReferenceFromText", "Lcom/intellij/psi/PsiReference;", "var", "Lcom/jetbrains/cidr/execution/debugger/backend/LLValue;", "context", "Lcom/intellij/psi/PsiElement;", "dropInlinerSuffix", "", "receivedName", "isImplicitContextVariable", "", "position", "variable", "(Lcom/intellij/xdebugger/XSourcePosition;Lcom/jetbrains/cidr/execution/debugger/backend/LLValue;)Ljava/lang/Boolean;", "resolveProperty", "dynamicTypeName", "resolveToDeclaration", "tryResolveToDeclaration", "blockExpression", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "variableName", "Companion", "kotlin-ultimate.common-native"})
public final class KonanDebuggerTypesHelper
extends CidrDebuggerTypesHelper {
    @NotNull
    public static final String KONAN_NAME_FOR_THIS = "_this";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public XSourcePosition computeSourcePosition(@NotNull CidrMemberValue value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return null;
    }

    @Nullable
    public XSourcePosition resolveProperty(@NotNull CidrMemberValue value, @Nullable String dynamicTypeName) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return null;
    }

    @Nullable
    protected PsiReference createReferenceFromText(@NotNull LLValue var, @NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)var, (String)"var");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return null;
    }

    @NotNull
    public Boolean isImplicitContextVariable(@NotNull XSourcePosition position, @NotNull LLValue variable) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        return Intrinsics.areEqual((Object)variable.getName(), (Object)KONAN_NAME_FOR_THIS);
    }

    private final PsiElement tryResolveToDeclaration(KtBlockExpression blockExpression, String variableName) {
        KtReferenceExpression referenceExpression;
        KtReferenceExpression ktReferenceExpression;
        CidrDebugProcess cidrDebugProcess = this.myProcess;
        Intrinsics.checkNotNullExpressionValue((Object)cidrDebugProcess, (String)"myProcess");
        Project project = cidrDebugProcess.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProcess.project");
        KtExpression codeFragment = new KtPsiFactory(project, false).createExpressionCodeFragment(variableName, (PsiElement)blockExpression).getContentElement();
        KtExpression ktExpression = codeFragment;
        if (!(ktExpression instanceof KtReferenceExpression)) {
            ktExpression = null;
        }
        return (ktReferenceExpression = (referenceExpression = (KtReferenceExpression)ktExpression)) != null && (ktReferenceExpression = ReferenceUtilsKt.getMainReference((KtReferenceExpression)ktReferenceExpression)) != null ? ktReferenceExpression.resolve() : null;
    }

    private final String dropInlinerSuffix(String receivedName) {
        int index = StringsKt.lastIndexOf$default((CharSequence)receivedName, (char)'_', (int)0, (boolean)false, (int)6, null);
        if (index <= 0) {
            return receivedName;
        }
        CharSequence charSequence = receivedName;
        int n = index + 1;
        boolean bl = false;
        String string = charSequence;
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = string.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
        String suffix = string2;
        charSequence = suffix;
        n = 0;
        if (charSequence.length() > 0) {
            boolean bl2;
            block6: {
                CharSequence $this$all$iv = suffix;
                boolean $i$f$all = false;
                CharSequence charSequence2 = $this$all$iv;
                for (int i = 0; i < charSequence2.length(); ++i) {
                    char element$iv;
                    char it = element$iv = charSequence2.charAt(i);
                    boolean bl3 = false;
                    char c = it;
                    boolean bl4 = false;
                    if (Character.isDigit(c)) continue;
                    bl2 = false;
                    break block6;
                }
                bl2 = true;
            }
            if (bl2) {
                charSequence = receivedName;
                n = 0;
                boolean bl5 = false;
                CharSequence charSequence3 = charSequence;
                if (charSequence3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = ((String)charSequence3).substring(n, index);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                return string3;
            }
        }
        return receivedName;
    }

    @Nullable
    public PsiElement resolveToDeclaration(@Nullable XSourcePosition position, @NotNull LLValue value) {
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                if (Intrinsics.areEqual((Object)value.getName(), (Object)KONAN_NAME_FOR_THIS)) break block7;
                CidrDebugProcess cidrDebugProcess = this.myProcess;
                Intrinsics.checkNotNullExpressionValue((Object)cidrDebugProcess, (String)"myProcess");
                DumbService dumbService = DumbService.getInstance((Project)cidrDebugProcess.getProject());
                Intrinsics.checkNotNullExpressionValue((Object)dumbService, (String)"DumbService.getInstance(myProcess.project)");
                if (!dumbService.isDumb()) break block8;
            }
            return null;
        }
        XSourcePosition xSourcePosition = position;
        if (xSourcePosition == null) {
            return null;
        }
        CidrDebugProcess cidrDebugProcess = this.myProcess;
        Intrinsics.checkNotNullExpressionValue((Object)cidrDebugProcess, (String)"myProcess");
        KtBlockExpression ktBlockExpression = Companion.findBlockAtPosition(xSourcePosition, cidrDebugProcess);
        if (ktBlockExpression == null) {
            return null;
        }
        KtBlockExpression blockExpression = ktBlockExpression;
        Object[] objectArray = new String[2];
        String string = value.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value.name");
        objectArray[0] = this.dropInlinerSuffix(string);
        String string2 = value.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"value.name");
        objectArray[1] = string2;
        for (String name : CollectionsKt.listOf((Object[])objectArray)) {
            PsiElement declaration;
            if (this.tryResolveToDeclaration(blockExpression, name) == null) {
                continue;
            }
            TextRange textRange = declaration.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"declaration.textRange");
            if (textRange.getStartOffset() > position.getOffset()) continue;
            return declaration;
        }
        return null;
    }

    public KonanDebuggerTypesHelper(@NotNull CidrDebugProcess process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        super(process);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/konan/debugger/KonanDebuggerTypesHelper$Companion;", "", "()V", "KONAN_NAME_FOR_THIS", "", "findBlockAtPosition", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "kotlin-ultimate.common-native"})
    public static final class Companion {
        @Nullable
        public final KtBlockExpression findBlockAtPosition(@NotNull XSourcePosition position, @NotNull CidrDebugProcess process) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter((Object)process, (String)"process");
            return (KtBlockExpression)PsiTreeUtil.getNonStrictParentOfType((PsiElement)CidrDebuggerTypesHelper.getContextElement((XSourcePosition)position, (Project)process.getProject()), (Class[])new Class[]{KtBlockExpression.class});
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

